/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.Loggers;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStore;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.BigSegmentStoreTypes;
import com.launchdarkly.sdk.server.interfaces.BigSegmentsConfiguration;
import com.launchdarkly.shaded.com.google.common.cache.CacheBuilder;
import com.launchdarkly.shaded.com.google.common.cache.CacheLoader;
import com.launchdarkly.shaded.com.google.common.cache.LoadingCache;
import com.launchdarkly.shaded.org.apache.commons.codec.digest.DigestUtils;
import com.launchdarkly.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

class BigSegmentStoreWrapper
implements Closeable {
    private static final Logger logger = Loggers.BIG_SEGMENTS;
    private final BigSegmentStore store;
    private final Duration staleAfter;
    private final ScheduledFuture<?> pollFuture;
    private final LoadingCache<String, BigSegmentStoreTypes.Membership> cache;
    private final EventBroadcasterImpl<BigSegmentStoreStatusProvider.StatusListener, BigSegmentStoreStatusProvider.Status> statusProvider;
    private final Object statusLock = new Object();
    private BigSegmentStoreStatusProvider.Status lastStatus;

    BigSegmentStoreWrapper(BigSegmentsConfiguration config, EventBroadcasterImpl<BigSegmentStoreStatusProvider.StatusListener, BigSegmentStoreStatusProvider.Status> statusProvider, ScheduledExecutorService sharedExecutor) {
        this.store = config.getStore();
        this.staleAfter = config.getStaleAfter();
        this.statusProvider = statusProvider;
        CacheLoader<String, BigSegmentStoreTypes.Membership> loader = new CacheLoader<String, BigSegmentStoreTypes.Membership>(){

            @Override
            public BigSegmentStoreTypes.Membership load(@NonNull String key) {
                BigSegmentStoreTypes.Membership membership = BigSegmentStoreWrapper.this.queryMembership(key);
                return membership == null ? BigSegmentStoreTypes.createMembershipFromSegmentRefs(null, null) : membership;
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(config.getUserCacheSize()).expireAfterWrite(config.getUserCacheTime()).build(loader);
        this.pollFuture = sharedExecutor.scheduleAtFixedRate(this::pollStoreAndUpdateStatus, 0L, config.getStatusPollInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws IOException {
        this.pollFuture.cancel(true);
        this.cache.invalidateAll();
        this.store.close();
    }

    BigSegmentsQueryResult getUserMembership(String userKey) {
        BigSegmentsQueryResult ret = new BigSegmentsQueryResult();
        try {
            ret.membership = this.cache.get(userKey);
            ret.status = this.getStatus().isStale() ? EvaluationReason.BigSegmentsStatus.STALE : EvaluationReason.BigSegmentsStatus.HEALTHY;
        }
        catch (Exception e) {
            logger.error("Big Segment store returned error: {}", (Object)e.toString());
            logger.debug(e.toString(), (Throwable)e);
            ret.membership = null;
            ret.status = EvaluationReason.BigSegmentsStatus.STORE_ERROR;
        }
        return ret;
    }

    private BigSegmentStoreTypes.Membership queryMembership(String userKey) {
        String hash = BigSegmentStoreWrapper.hashForUserKey(userKey);
        logger.debug("Querying Big Segment state for user hash {}", (Object)hash);
        return this.store.getMembership(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigSegmentStoreStatusProvider.Status getStatus() {
        BigSegmentStoreStatusProvider.Status ret;
        Object object = this.statusLock;
        synchronized (object) {
            ret = this.lastStatus;
        }
        if (ret != null) {
            return ret;
        }
        return this.pollStoreAndUpdateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigSegmentStoreStatusProvider.Status pollStoreAndUpdateStatus() {
        BigSegmentStoreStatusProvider.Status oldStatus;
        boolean storeAvailable = false;
        boolean storeStale = false;
        logger.debug("Querying Big Segment store metadata");
        try {
            BigSegmentStoreTypes.StoreMetadata metadata = this.store.getMetadata();
            storeAvailable = true;
            storeStale = metadata == null || this.isStale(metadata.getLastUpToDate());
        }
        catch (Exception e) {
            logger.error("Big Segment store status query returned error: {}", (Object)e.toString());
            logger.debug(e.toString(), (Throwable)e);
        }
        BigSegmentStoreStatusProvider.Status newStatus = new BigSegmentStoreStatusProvider.Status(storeAvailable, storeStale);
        Object object = this.statusLock;
        synchronized (object) {
            oldStatus = this.lastStatus;
            this.lastStatus = newStatus;
        }
        if (!newStatus.equals(oldStatus)) {
            logger.debug("Big Segment store status changed from {} to {}", (Object)oldStatus, (Object)newStatus);
            this.statusProvider.broadcast(newStatus);
        }
        return newStatus;
    }

    private boolean isStale(long updateTime) {
        return this.staleAfter.minusMillis(System.currentTimeMillis() - updateTime).isNegative();
    }

    static String hashForUserKey(String userKey) {
        byte[] encodedDigest = DigestUtils.sha256(userKey.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encodedDigest);
    }

    static class BigSegmentsQueryResult {
        BigSegmentStoreTypes.Membership membership;
        EvaluationReason.BigSegmentsStatus status;

        BigSegmentsQueryResult() {
        }
    }
}

