/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater.util;

import android.app.Activity;
import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public enum PermissionUtils {
    INSTANCE;

    private String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"};

    public boolean verifyReadAndWritePermissions(@NonNull Activity activity, int requestCode) {
        int readResult = this.checkPermission(activity, "android.permission.READ_EXTERNAL_STORAGE");
        int writeResult = this.checkPermission(activity, "android.permission.WRITE_EXTERNAL_STORAGE");
        int readPhoneState = this.checkPermission(activity, "android.permission.READ_PHONE_STATE");
        if (readResult != 0 || writeResult != 0 || readPhoneState != 0) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])this.PERMISSIONS_STORAGE, (int)requestCode);
            return false;
        }
        return true;
    }

    public int checkPermission(@NonNull Activity activity, @NonNull String permission2) {
        return ActivityCompat.checkSelfPermission((Context)activity, (String)permission2);
    }

    public boolean isNotificationEnabled(Context context) {
        NotificationManager notificationManager;
        if (Build.VERSION.SDK_INT >= 26 && (notificationManager = (NotificationManager)context.getSystemService("notification")).getImportance() == 0) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            String CHECK_OP_NO_THROW = "checkOpNoThrow";
            String OP_POST_NOTIFICATION = "OP_POST_NOTIFICATION";
            AppOpsManager mAppOps = (AppOpsManager)context.getSystemService("appops");
            ApplicationInfo appInfo = context.getApplicationInfo();
            String pkg = context.getApplicationContext().getPackageName();
            int uid = appInfo.uid;
            try {
                Class<?> appOpsClass = Class.forName(AppOpsManager.class.getName());
                Method checkOpNoThrowMethod = appOpsClass.getMethod(CHECK_OP_NO_THROW, Integer.TYPE, Integer.TYPE, String.class);
                Field opPostNotificationValue = appOpsClass.getDeclaredField(OP_POST_NOTIFICATION);
                int value = (Integer)opPostNotificationValue.get(Integer.class);
                return (Integer)checkOpNoThrowMethod.invoke((Object)mAppOps, value, uid, pkg) == 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

