/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.core.importdata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.jupiter.tools.spring.test.core.importdata.DataSet;
import com.jupiter.tools.spring.test.core.importdata.Text;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonImport
implements DataSet {
    private final Text text;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Logger log;

    public JsonImport(Text text) {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.text = text;
        this.log = LoggerFactory.getLogger(JsonImport.class);
    }

    @Override
    public Map<String, List<Map<String, Object>>> read() {
        String content = this.text.read();
        try {
            return (Map)this.objectMapper.readValue(content, (TypeReference)new TypeReference<Map<String, List<Map<String, Object>>>>(){});
        }
        catch (IOException e) {
            this.log.error("Error while parsing the next JSON file: \n{}", (Object)content, (Object)e);
            throw new RuntimeException("Error when parsing the JSON text.", e);
        }
    }
}

