/*
 * Decompiled with CFR 0.152.
 */
package com.jupiter.tools.spring.test.core.importdata;

import com.jupiter.tools.spring.test.core.importdata.Text;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFile
implements Text {
    private final String fileName;
    private final Logger log = LoggerFactory.getLogger(ImportFile.class);

    public ImportFile(String fileName) {
        this.fileName = fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String read() {
        try (InputStream inputStream = this.getResourceStream();){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            this.log.error("Error while trying to read data from file: {}", (Object)this.fileName, (Object)e);
            throw new RuntimeException("Error while reading file with a DataSet", e);
        }
    }

    private InputStream getResourceStream() {
        String dataFileName = !this.fileName.startsWith("/") ? "/" + this.fileName : this.fileName;
        InputStream inputStream = this.getClass().getResourceAsStream(dataFileName);
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream("/dataset" + dataFileName);
        }
        return inputStream;
    }
}

