/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.api.details;

import com.jfrog.bintray.client.api.ObjectMapperHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"name", "values", "type"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class Attribute<T> {
    private static final Logger log = LoggerFactory.getLogger(Attribute.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="values")
    private List<T> values;
    @JsonProperty(value="type")
    private Type type;

    @SafeVarargs
    public Attribute(String name, T ... values) {
        this(name, (Type)null, Arrays.asList(values));
    }

    @SafeVarargs
    public Attribute(String name, Type type, T ... values) {
        this(name, type, Arrays.asList(values));
    }

    @JsonCreator
    public Attribute(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="values") List<T> values) {
        this.name = name;
        if (type == null) {
            type = Type.string;
        }
        this.type = type;
        this.values = values;
    }

    public static ObjectMapper getObjectMapper() {
        return ObjectMapperHelper.get();
    }

    @JsonIgnore
    public static String getJsonFromAttributeList(List<Attribute> attributeDetails) throws IOException {
        String jsonContent;
        ObjectMapper mapper = ObjectMapperHelper.get();
        try {
            jsonContent = mapper.writeValueAsString(attributeDetails);
        }
        catch (IOException e) {
            log.error("Can't process the json file: " + e.getMessage());
            throw e;
        }
        return jsonContent;
    }

    @JsonIgnore
    public static List<Attribute> getAttributeListFromJson(InputStream inputStream) throws IOException {
        List attributes;
        ObjectMapper mapper = ObjectMapperHelper.get();
        try {
            attributes = (List)mapper.readValue(inputStream, (TypeReference)new TypeReference<List<Attribute>>(){});
        }
        catch (IOException e) {
            log.error("Can't process the json file: " + e.getMessage());
            throw e;
        }
        return attributes;
    }

    public String getName() {
        return this.name;
    }

    public List<T> getValues() {
        return this.values;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!this.name.equals(attribute.name)) {
            return false;
        }
        return this.values.equals(attribute.values);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public String toString() {
        return "{Name='" + this.name + '\'' + ", Type=" + (Object)((Object)this.type) + ", Values=" + this.values + '}';
    }

    public static enum Type {
        string,
        date,
        number,
        Boolean;

    }
}

