/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.bintray.client.api;

import com.jfrog.bintray.client.api.ObjectMapperHelper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class BintrayCallException
extends HttpResponseException {
    private int statusCode;
    private String reason;
    private String message;

    public BintrayCallException(int statusCode, String reason, String message) {
        super(statusCode, reason);
        this.statusCode = statusCode;
        this.reason = reason;
        this.message = message;
    }

    public BintrayCallException(HttpResponse response) {
        int statusCode;
        String message;
        block3: {
            super(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
            message = " ";
            String entity = null;
            statusCode = response.getStatusLine().getStatusCode();
            if (response.getEntity() != null && statusCode != 405 && statusCode != 500) {
                try {
                    entity = IOUtils.toString((InputStream)response.getEntity().getContent());
                    ObjectMapper mapper = ObjectMapperHelper.get();
                    JsonNode node = mapper.readTree(entity);
                    message = node.get("message").getTextValue();
                }
                catch (IOException | NullPointerException e) {
                    if (entity == null) break block3;
                    message = entity;
                }
            }
        }
        this.statusCode = statusCode;
        this.reason = response.getStatusLine().getReasonPhrase();
        this.message = message;
    }

    public BintrayCallException(Exception e) {
        super(400, e.getMessage());
        this.statusCode = 400;
        this.reason = e.getMessage();
        this.message = e.getCause() == null ? " " : " : " + e.getCause().getMessage();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReason() {
        return this.reason;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String newMessage) {
        this.message = newMessage;
    }

    public String toString() {
        return this.statusCode + ", " + this.reason + " " + this.message;
    }
}

