/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.util;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.colors.DeviceCmyk;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.colors.WebColors;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.styledxmlparser.css.CommonCssConstants;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.exceptions.StyledXMLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CssDimensionParsingUtils {
    private static final Logger logger = LoggerFactory.getLogger(CssDimensionParsingUtils.class);

    private CssDimensionParsingUtils() {
    }

    public static Integer parseInteger(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    public static Float parseFloat(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Float.valueOf(str);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    public static Double parseDouble(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    public static float parseAngle(String angle, String defaultMetric) {
        int pos = CssDimensionParsingUtils.determinePositionBetweenValueAndUnit(angle);
        if (pos == 0) {
            if (angle == null) {
                angle = "null";
            }
            throw new StyledXMLParserException(MessageFormatUtil.format((String)"The passed value (@{0}) is not a number", (Object[])new Object[]{angle}));
        }
        float floatValue = Float.parseFloat(angle.substring(0, pos));
        String unit = angle.substring(pos);
        if (unit.startsWith("deg") || unit.equals("") && "deg".equals(defaultMetric)) {
            return (float)Math.PI * floatValue / 180.0f;
        }
        if (unit.startsWith("grad") || unit.equals("") && "grad".equals(defaultMetric)) {
            return (float)Math.PI * floatValue / 200.0f;
        }
        if (unit.startsWith("rad") || unit.equals("") && "rad".equals(defaultMetric)) {
            return floatValue;
        }
        logger.error(MessageFormatUtil.format((String)"Unknown metric angle parsed: \"{0}\".", (Object[])new Object[]{unit.equals("") ? defaultMetric : unit}));
        return floatValue;
    }

    public static float parseAngle(String angle) {
        return CssDimensionParsingUtils.parseAngle(angle, "deg");
    }

    public static int[] parseAspectRatio(String str) {
        int indexOfSlash = str.indexOf(47);
        try {
            int first = Integer.parseInt(str.substring(0, indexOfSlash));
            int second = Integer.parseInt(str.substring(indexOfSlash + 1));
            return new int[]{first, second};
        }
        catch (NullPointerException | NumberFormatException exc) {
            return null;
        }
    }

    public static float parseAbsoluteLength(String length, String defaultMetric) {
        int pos = CssDimensionParsingUtils.determinePositionBetweenValueAndUnit(length);
        if (pos == 0) {
            if (length == null) {
                length = "null";
            }
            throw new StyledXMLParserException(MessageFormatUtil.format((String)"The passed value (@{0}) is not a number", (Object[])new Object[]{length}));
        }
        double f = Double.parseDouble(length.substring(0, pos));
        String unit = length.substring(pos);
        if (unit.startsWith("pt") || unit.equals("") && defaultMetric.equals("pt")) {
            return (float)f;
        }
        if (unit.startsWith("in") || unit.equals("") && defaultMetric.equals("in")) {
            return (float)(f * 72.0);
        }
        if (unit.startsWith("cm") || unit.equals("") && defaultMetric.equals("cm")) {
            return (float)(f / 2.54 * 72.0);
        }
        if (unit.startsWith("q") || unit.equals("") && defaultMetric.equals("q")) {
            return (float)(f / 2.54 * 72.0 / 40.0);
        }
        if (unit.startsWith("mm") || unit.equals("") && defaultMetric.equals("mm")) {
            return (float)(f / 25.4 * 72.0);
        }
        if (unit.startsWith("pc") || unit.equals("") && defaultMetric.equals("pc")) {
            return (float)(f * 12.0);
        }
        if (unit.startsWith("px") || unit.equals("") && defaultMetric.equals("px")) {
            return (float)(f * 0.75);
        }
        logger.error(MessageFormatUtil.format((String)"Unknown absolute metric length parsed \"{0}\".", (Object[])new Object[]{unit.equals("") ? defaultMetric : unit}));
        return (float)f;
    }

    public static float parseAbsoluteLength(String length) {
        return CssDimensionParsingUtils.parseAbsoluteLength(length, "px");
    }

    public static float parseRelativeValue(String relativeValue, float baseValue) {
        int pos = CssDimensionParsingUtils.determinePositionBetweenValueAndUnit(relativeValue);
        if (pos == 0) {
            return 0.0f;
        }
        double f = Double.parseDouble(relativeValue.substring(0, pos));
        String unit = relativeValue.substring(pos);
        if (unit.startsWith("%")) {
            f = (double)baseValue * f / 100.0;
        } else if (unit.startsWith("em") || unit.startsWith("rem")) {
            f = (double)baseValue * f;
        } else if (unit.startsWith("ex")) {
            f = (double)baseValue * f / 2.0;
        }
        return (float)f;
    }

    public static UnitValue parseLengthValueToPt(String value, float emValue, float remValue) {
        if (CssTypesValidationUtils.isMetricValue(value) || CssTypesValidationUtils.isNumber(value)) {
            return new UnitValue(1, CssDimensionParsingUtils.parseAbsoluteLength(value));
        }
        if (value != null && value.endsWith("%")) {
            return new UnitValue(2, Float.parseFloat(value.substring(0, value.length() - 1)));
        }
        if (CssTypesValidationUtils.isRemValue(value)) {
            return new UnitValue(1, CssDimensionParsingUtils.parseRelativeValue(value, remValue));
        }
        if (CssTypesValidationUtils.isRelativeValue(value)) {
            return new UnitValue(1, CssDimensionParsingUtils.parseRelativeValue(value, emValue));
        }
        return null;
    }

    public static Float parseFlex(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).endsWith("fr") && CssTypesValidationUtils.isNumber(value = value.substring(0, value.length() - "fr".length()))) {
            return Float.valueOf(Float.parseFloat(value));
        }
        return null;
    }

    public static float parseLength(String length, float percentBaseValue, float defaultValue, float fontSize, float rootFontSize) {
        if (CssTypesValidationUtils.isPercentageValue(length)) {
            return CssDimensionParsingUtils.parseRelativeValue(length, percentBaseValue);
        }
        UnitValue unitValue = CssDimensionParsingUtils.parseLengthValueToPt(length, fontSize, rootFontSize);
        if (unitValue != null && unitValue.isPointValue()) {
            return unitValue.getValue();
        }
        return defaultValue;
    }

    public static float parseAbsoluteFontSize(String fontSizeValue, String defaultMetric) {
        if (null != fontSizeValue && CommonCssConstants.FONT_ABSOLUTE_SIZE_KEYWORDS_VALUES.containsKey(fontSizeValue)) {
            fontSizeValue = CommonCssConstants.FONT_ABSOLUTE_SIZE_KEYWORDS_VALUES.get(fontSizeValue);
        }
        try {
            return CssDimensionParsingUtils.parseAbsoluteLength(fontSizeValue, defaultMetric);
        }
        catch (StyledXMLParserException sxpe) {
            return 0.0f;
        }
    }

    public static float parseAbsoluteFontSize(String fontSizeValue) {
        return CssDimensionParsingUtils.parseAbsoluteFontSize(fontSizeValue, "px");
    }

    public static float parseRelativeFontSize(String relativeFontSizeValue, float baseValue) {
        if ("smaller".equals(relativeFontSizeValue)) {
            return (float)((double)baseValue / 1.2);
        }
        if ("larger".equals(relativeFontSizeValue)) {
            return (float)((double)baseValue * 1.2);
        }
        return CssDimensionParsingUtils.parseRelativeValue(relativeFontSizeValue, baseValue);
    }

    public static UnitValue[] parseSpecificCornerBorderRadius(String specificBorderRadius, float emValue, float remValue) {
        if (null == specificBorderRadius) {
            return null;
        }
        UnitValue[] cornerRadii = new UnitValue[2];
        String[] props = specificBorderRadius.split("\\s+");
        cornerRadii[0] = CssDimensionParsingUtils.parseLengthValueToPt(props[0], emValue, remValue);
        cornerRadii[1] = 2 == props.length ? CssDimensionParsingUtils.parseLengthValueToPt(props[1], emValue, remValue) : cornerRadii[0];
        return cornerRadii;
    }

    public static float parseResolution(String resolutionStr) {
        int pos = CssDimensionParsingUtils.determinePositionBetweenValueAndUnit(resolutionStr);
        if (pos == 0) {
            return 0.0f;
        }
        double f = Double.parseDouble(resolutionStr.substring(0, pos));
        String unit = resolutionStr.substring(pos);
        if (unit.startsWith("dpcm")) {
            f *= 2.54;
        } else if (unit.startsWith("dppx")) {
            f *= 96.0;
        } else if (!unit.startsWith("dpi")) {
            throw new StyledXMLParserException("Resolution value unit should be either dpi, dppx or dpcm!");
        }
        return (float)f;
    }

    public static TransparentColor parseColor(String colorValue) {
        DeviceRgb device = null;
        float opacity = 1.0f;
        float[] color = WebColors.getRGBAColor((String)colorValue);
        if (color == null) {
            color = WebColors.getCMYKArray((String)colorValue);
        } else {
            device = new DeviceRgb(color[0], color[1], color[2]);
            if (color.length == 4) {
                opacity = color[3];
            }
        }
        if (color == null) {
            color = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            device = new DeviceRgb(0, 0, 0);
        } else if (device == null) {
            device = new DeviceCmyk(color[0], color[1], color[2], color[3]);
            if (color.length == 5) {
                opacity = color[4];
            }
        }
        return new TransparentColor(device, opacity);
    }

    public static float[] parseRgbaColor(String colorValue) {
        float[] rgbaColor = WebColors.getRGBAColor((String)colorValue);
        if (rgbaColor == null) {
            logger.error(MessageFormatUtil.format((String)"Color \"{0}\" was not parsed. It has invalid value. Defaulting to black color.", (Object[])new Object[]{colorValue}));
            rgbaColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        }
        return rgbaColor;
    }

    public static int determinePositionBetweenValueAndUnit(String string) {
        int pos;
        if (string == null) {
            return 0;
        }
        for (pos = 0; pos < string.length() && (string.charAt(pos) == '+' || string.charAt(pos) == '-' || string.charAt(pos) == '.' || CssDimensionParsingUtils.isDigit(string.charAt(pos)) || CssDimensionParsingUtils.isExponentNotation(string, pos)); ++pos) {
        }
        return pos;
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isExponentNotation(String s, int index) {
        return index < s.length() && Character.toLowerCase(s.charAt(index)) == 'e' && (index + 1 < s.length() && CssDimensionParsingUtils.isDigit(s.charAt(index + 1)) || index + 2 < s.length() && (s.charAt(index + 1) == '-' || s.charAt(index + 1) == '+') && CssDimensionParsingUtils.isDigit(s.charAt(index + 2)));
    }
}

