/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand;

import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.BackgroundPositionShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.BackgroundShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.BorderBottomShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.BorderColorShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.BorderLeftShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.BorderRadiusShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.BorderRightShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.BorderShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.BorderStyleShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.BorderTopShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.BorderWidthShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.ColumnRuleShortHandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.ColumnsShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.FlexFlowShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.FlexShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.FontShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.GapShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.GridColumnShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.GridRowShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.GridShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.GridTemplateShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.ListStyleShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.MarginShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.MarkerShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.OutlineShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.PaddingShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.PlaceItemsShorthandResolver;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.impl.TextDecorationShorthandResolver;
import java.util.HashMap;
import java.util.Map;

public class ShorthandResolverFactory {
    private static final Map<String, IShorthandResolver> shorthandResolvers = new HashMap<String, IShorthandResolver>();

    public static IShorthandResolver getShorthandResolver(String shorthandProperty) {
        return shorthandResolvers.get(shorthandProperty);
    }

    static {
        shorthandResolvers.put("background", new BackgroundShorthandResolver());
        shorthandResolvers.put("background-position", new BackgroundPositionShorthandResolver());
        shorthandResolvers.put("border", new BorderShorthandResolver());
        shorthandResolvers.put("border-bottom", new BorderBottomShorthandResolver());
        shorthandResolvers.put("border-color", new BorderColorShorthandResolver());
        shorthandResolvers.put("border-left", new BorderLeftShorthandResolver());
        shorthandResolvers.put("border-radius", new BorderRadiusShorthandResolver());
        shorthandResolvers.put("border-right", new BorderRightShorthandResolver());
        shorthandResolvers.put("border-style", new BorderStyleShorthandResolver());
        shorthandResolvers.put("border-top", new BorderTopShorthandResolver());
        shorthandResolvers.put("border-width", new BorderWidthShorthandResolver());
        shorthandResolvers.put("font", new FontShorthandResolver());
        shorthandResolvers.put("list-style", new ListStyleShorthandResolver());
        shorthandResolvers.put("margin", new MarginShorthandResolver());
        shorthandResolvers.put("outline", new OutlineShorthandResolver());
        shorthandResolvers.put("padding", new PaddingShorthandResolver());
        shorthandResolvers.put("text-decoration", new TextDecorationShorthandResolver());
        shorthandResolvers.put("flex", new FlexShorthandResolver());
        shorthandResolvers.put("flex-flow", new FlexFlowShorthandResolver());
        shorthandResolvers.put("gap", new GapShorthandResolver("gap"));
        shorthandResolvers.put("grid-gap", new GapShorthandResolver("grid-gap"));
        shorthandResolvers.put("place-items", new PlaceItemsShorthandResolver());
        shorthandResolvers.put("columns", new ColumnsShorthandResolver());
        shorthandResolvers.put("column-rule", new ColumnRuleShortHandResolver());
        shorthandResolvers.put("grid-row", new GridRowShorthandResolver());
        shorthandResolvers.put("grid-column", new GridColumnShorthandResolver());
        shorthandResolvers.put("grid-template", new GridTemplateShorthandResolver());
        shorthandResolvers.put("grid", new GridShorthandResolver());
        shorthandResolvers.put("marker", new MarkerShorthandResolver());
    }
}

