/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.media;

import com.itextpdf.styledxmlparser.css.CssNestedAtRule;
import com.itextpdf.styledxmlparser.css.CssRuleSet;
import com.itextpdf.styledxmlparser.css.CssStatement;
import com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import com.itextpdf.styledxmlparser.css.media.MediaQuery;
import com.itextpdf.styledxmlparser.css.media.MediaQueryParser;
import com.itextpdf.styledxmlparser.node.INode;
import java.util.ArrayList;
import java.util.List;

public class CssMediaRule
extends CssNestedAtRule {
    private List<MediaQuery> mediaQueries;

    public CssMediaRule(String ruleParameters) {
        super("media", ruleParameters);
        this.mediaQueries = MediaQueryParser.parseMediaQueries(ruleParameters);
    }

    @Override
    public List<CssRuleSet> getCssRuleSets(INode element, MediaDeviceDescription deviceDescription) {
        ArrayList<CssRuleSet> result = new ArrayList<CssRuleSet>();
        for (MediaQuery mediaQuery : this.mediaQueries) {
            if (!mediaQuery.matches(deviceDescription)) continue;
            for (CssStatement childStatement : this.body) {
                result.addAll(childStatement.getCssRuleSets(element, deviceDescription));
            }
        }
        return result;
    }

    public boolean matchMediaDevice(MediaDeviceDescription deviceDescription) {
        for (MediaQuery mediaQuery : this.mediaQueries) {
            if (!mediaQuery.matches(deviceDescription)) continue;
            return true;
        }
        return false;
    }
}

