/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.properties.JustifyContent;
import com.itextpdf.layout.renderer.FlexColumnItemMainDirector;
import com.itextpdf.layout.renderer.FlexUtil;
import java.util.List;

class TopToBottomFlexItemMainDirector
extends FlexColumnItemMainDirector {
    TopToBottomFlexItemMainDirector() {
    }

    @Override
    public <T> void applyDirectionForLine(List<T> renderers) {
    }

    @Override
    public void applyJustifyContent(List<FlexUtil.FlexItemCalculationInfo> line, JustifyContent justifyContent, float freeSpace) {
        if (freeSpace < 0.0f && (JustifyContent.SPACE_AROUND == justifyContent || JustifyContent.SPACE_BETWEEN == justifyContent || JustifyContent.SPACE_EVENLY == justifyContent)) {
            return;
        }
        switch (justifyContent) {
            case END: 
            case FLEX_END: {
                line.get((int)0).yShift = freeSpace;
                break;
            }
            case CENTER: {
                line.get((int)0).yShift = freeSpace / 2.0f;
                break;
            }
            case SPACE_BETWEEN: {
                float space = freeSpace / (float)(line.size() - 1);
                for (int i = 1; i < line.size(); ++i) {
                    FlexUtil.FlexItemCalculationInfo item = line.get(i);
                    item.yShift = space;
                }
                break;
            }
            case SPACE_AROUND: {
                float space = freeSpace / (float)(line.size() * 2);
                for (int i = 0; i < line.size(); ++i) {
                    FlexUtil.FlexItemCalculationInfo item = line.get(i);
                    item.yShift = i == 0 ? space : space * 2.0f;
                }
                break;
            }
            case SPACE_EVENLY: {
                float space = freeSpace / (float)(line.size() + 1);
                for (FlexUtil.FlexItemCalculationInfo item : line) {
                    item.yShift = space;
                }
                break;
            }
        }
    }
}

