/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.xobject;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.geom.Vector;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.wmf.WmfImageData;
import com.itextpdf.kernel.pdf.canvas.wmf.WmfImageHelper;
import com.itextpdf.kernel.pdf.xobject.PdfTransparencyGroup;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;

public class PdfFormXObject
extends PdfXObject {
    protected PdfResources resources = null;

    public PdfFormXObject(Rectangle bBox) {
        super(new PdfStream());
        ((PdfStream)this.getPdfObject()).put(PdfName.Type, PdfName.XObject);
        ((PdfStream)this.getPdfObject()).put(PdfName.Subtype, PdfName.Form);
        if (bBox != null) {
            ((PdfStream)this.getPdfObject()).put(PdfName.BBox, new PdfArray(bBox));
        }
    }

    public PdfFormXObject(PdfStream pdfStream) {
        super(pdfStream);
        if (!((PdfStream)this.getPdfObject()).containsKey(PdfName.Subtype)) {
            ((PdfStream)this.getPdfObject()).put(PdfName.Subtype, PdfName.Form);
        }
    }

    public PdfFormXObject(PdfPage page) {
        this(page.getCropBox());
        ((PdfStream)this.getPdfObject()).getOutputStream().writeBytes(page.getContentBytes());
        this.resources = new PdfResources((PdfDictionary)((PdfDictionary)page.getResources().getPdfObject()).clone());
        ((PdfStream)this.getPdfObject()).put(PdfName.Resources, (PdfObject)this.resources.getPdfObject());
    }

    public PdfFormXObject(WmfImageData image, PdfDocument pdfDocument) {
        this((PdfStream)new WmfImageHelper(image).createFormXObject(pdfDocument).getPdfObject());
    }

    public static Rectangle calculateBBoxMultipliedByMatrix(PdfFormXObject form) {
        PdfArray pdfArrayBBox = ((PdfStream)form.getPdfObject()).getAsArray(PdfName.BBox);
        if (pdfArrayBBox == null) {
            throw new PdfException("PdfFormXObject has invalid BBox.");
        }
        float[] bBoxArray = pdfArrayBBox.toFloatArray();
        PdfArray pdfArrayMatrix = ((PdfStream)form.getPdfObject()).getAsArray(PdfName.Matrix);
        float[] matrixArray = pdfArrayMatrix == null ? new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f} : pdfArrayMatrix.toFloatArray();
        Matrix matrix = new Matrix(matrixArray[0], matrixArray[1], matrixArray[2], matrixArray[3], matrixArray[4], matrixArray[5]);
        Vector bBoxMin = new Vector(bBoxArray[0], bBoxArray[1], 1.0f);
        Vector bBoxMax = new Vector(bBoxArray[2], bBoxArray[3], 1.0f);
        Vector bBoxMinByMatrix = bBoxMin.cross(matrix);
        Vector bBoxMaxByMatrix = bBoxMax.cross(matrix);
        float width = bBoxMaxByMatrix.get(0) - bBoxMinByMatrix.get(0);
        float height = bBoxMaxByMatrix.get(1) - bBoxMinByMatrix.get(1);
        return new Rectangle(bBoxMinByMatrix.get(0), bBoxMinByMatrix.get(1), width, height);
    }

    public static AffineTransform calcAppearanceTransformToAnnotRect(PdfFormXObject xObject, Rectangle annotBBox) {
        Rectangle transformedRect;
        PdfArray bBox = xObject.getBBox();
        if (bBox.size() != 4) {
            bBox = new PdfArray(new Rectangle(0.0f, 0.0f));
            xObject.setBBox(bBox);
        }
        float[] xObjBBox = bBox.toFloatArray();
        PdfArray xObjMatrix = ((PdfStream)xObject.getPdfObject()).getAsArray(PdfName.Matrix);
        if (xObjMatrix != null && xObjMatrix.size() == 6) {
            Point[] xObjRectPoints = new Point[]{new Point(xObjBBox[0], xObjBBox[1]), new Point(xObjBBox[0], xObjBBox[3]), new Point(xObjBBox[2], xObjBBox[1]), new Point(xObjBBox[2], xObjBBox[3])};
            Point[] transformedAppBoxPoints = new Point[xObjRectPoints.length];
            new AffineTransform(xObjMatrix.toDoubleArray()).transform(xObjRectPoints, 0, transformedAppBoxPoints, 0, xObjRectPoints.length);
            float[] transformedRectArr = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, -3.4028235E38f, -3.4028235E38f};
            for (Point p : transformedAppBoxPoints) {
                transformedRectArr[0] = (float)Math.min((double)transformedRectArr[0], p.getX());
                transformedRectArr[1] = (float)Math.min((double)transformedRectArr[1], p.getY());
                transformedRectArr[2] = (float)Math.max((double)transformedRectArr[2], p.getX());
                transformedRectArr[3] = (float)Math.max((double)transformedRectArr[3], p.getY());
            }
            transformedRect = new Rectangle(transformedRectArr[0], transformedRectArr[1], transformedRectArr[2] - transformedRectArr[0], transformedRectArr[3] - transformedRectArr[1]);
        } else {
            transformedRect = new Rectangle(0.0f, 0.0f).setBbox(xObjBBox[0], xObjBBox[1], xObjBBox[2], xObjBBox[3]);
        }
        AffineTransform at = AffineTransform.getTranslateInstance(-transformedRect.getX(), -transformedRect.getY());
        float scaleX = transformedRect.getWidth() == 0.0f ? 1.0f : annotBBox.getWidth() / transformedRect.getWidth();
        float scaleY = transformedRect.getHeight() == 0.0f ? 1.0f : annotBBox.getHeight() / transformedRect.getHeight();
        at.preConcatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
        at.preConcatenate(AffineTransform.getTranslateInstance(annotBBox.getX(), annotBBox.getY()));
        return at;
    }

    public PdfResources getResources() {
        if (this.resources == null) {
            PdfDictionary resourcesDict = ((PdfStream)this.getPdfObject()).getAsDictionary(PdfName.Resources);
            if (resourcesDict == null) {
                resourcesDict = new PdfDictionary();
                ((PdfStream)this.getPdfObject()).put(PdfName.Resources, resourcesDict);
            }
            this.resources = new PdfResources(resourcesDict);
        }
        return this.resources;
    }

    public PdfArray getBBox() {
        return ((PdfStream)this.getPdfObject()).getAsArray(PdfName.BBox);
    }

    public PdfFormXObject setBBox(PdfArray bBox) {
        return this.put(PdfName.BBox, bBox);
    }

    public PdfFormXObject setGroup(PdfTransparencyGroup transparency) {
        return this.put(PdfName.Group, (PdfObject)transparency.getPdfObject());
    }

    @Override
    public float getWidth() {
        return this.getBBox() == null ? 0.0f : this.getBBox().getAsNumber(2).floatValue() - this.getBBox().getAsNumber(0).floatValue();
    }

    @Override
    public float getHeight() {
        return this.getBBox() == null ? 0.0f : this.getBBox().getAsNumber(3).floatValue() - this.getBBox().getAsNumber(1).floatValue();
    }

    @Override
    public void flush() {
        this.resources = null;
        if (((PdfStream)this.getPdfObject()).get(PdfName.BBox) == null) {
            throw new PdfException("Form XObject must have BBox.");
        }
        super.flush();
    }

    public PdfFormXObject setProcessColorModel(PdfName model) {
        return this.put(PdfName.PCM, model);
    }

    public PdfName getProcessColorModel() {
        return ((PdfStream)this.getPdfObject()).getAsName(PdfName.PCM);
    }

    public PdfFormXObject setSeparationColorNames(PdfArray colorNames) {
        return this.put(PdfName.SeparationColorNames, colorNames);
    }

    public PdfArray getSeparationColorNames() {
        return ((PdfStream)this.getPdfObject()).getAsArray(PdfName.SeparationColorNames);
    }

    public PdfFormXObject setTrapRegions(PdfArray regions) {
        return this.put(PdfName.TrapRegions, regions);
    }

    public PdfArray getTrapRegions() {
        return ((PdfStream)this.getPdfObject()).getAsArray(PdfName.TrapRegions);
    }

    public PdfFormXObject setTrapStyles(PdfString trapStyles) {
        return this.put(PdfName.TrapStyles, trapStyles);
    }

    public PdfString getTrapStyles() {
        return ((PdfStream)this.getPdfObject()).getAsString(PdfName.TrapStyles);
    }

    public PdfFormXObject setMarkStyle(PdfString markStyle) {
        return this.put(PdfName.MarkStyle, markStyle);
    }

    public PdfString getMarkStyle() {
        return ((PdfStream)this.getPdfObject()).getAsString(PdfName.MarkStyle);
    }

    public PdfFormXObject put(PdfName key, PdfObject value) {
        ((PdfStream)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }

    public boolean isRelativeSized() {
        return false;
    }
}

