/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfNamespace;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import java.text.MessageFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RootTagNormalizer {
    private TagStructureContext context;
    private PdfStructElem rootTagElement;
    private PdfDocument document;

    RootTagNormalizer(TagStructureContext context, PdfStructElem rootTagElement, PdfDocument document) {
        this.context = context;
        this.rootTagElement = rootTagElement;
        this.document = document;
    }

    PdfStructElem makeSingleStandardRootTag(List<IStructureNode> rootKids) {
        this.document.getStructTreeRoot().makeIndirect(this.document);
        if (this.rootTagElement == null) {
            this.createNewRootTag();
        } else {
            this.rootTagElement.makeIndirect(this.document);
            this.document.getStructTreeRoot().addKid(this.rootTagElement);
            this.ensureExistingRootTagIsDocument();
        }
        this.addStructTreeRootKidsToTheRootTag(rootKids);
        return this.rootTagElement;
    }

    private void createNewRootTag() {
        PdfNamespace docDefaultNs = this.context.getDocumentDefaultNamespace();
        IRoleMappingResolver mapping = this.context.resolveMappingToStandardOrDomainSpecificRole("Document", docDefaultNs);
        if (mapping == null || mapping.currentRoleIsStandard() && !"Document".equals(mapping.getRole())) {
            this.logCreatedRootTagHasMappingIssue(docDefaultNs, mapping);
        }
        this.rootTagElement = this.document.getStructTreeRoot().addKid(new PdfStructElem(this.document, PdfName.Document));
        if (this.context.targetTagStructureVersionIs2()) {
            this.rootTagElement.setNamespace(docDefaultNs);
            this.context.ensureNamespaceRegistered(docDefaultNs);
        }
    }

    private void ensureExistingRootTagIsDocument() {
        boolean isDocAfterResolving;
        IRoleMappingResolver mapping = this.context.getRoleMappingResolver(this.rootTagElement.getRole().getValue(), this.rootTagElement.getNamespace());
        boolean isDocBeforeResolving = mapping.currentRoleIsStandard() && "Document".equals(mapping.getRole());
        mapping = this.context.resolveMappingToStandardOrDomainSpecificRole(this.rootTagElement.getRole().getValue(), this.rootTagElement.getNamespace());
        boolean bl = isDocAfterResolving = mapping != null && mapping.currentRoleIsStandard() && "Document".equals(mapping.getRole());
        if (isDocBeforeResolving && !isDocAfterResolving) {
            this.logCreatedRootTagHasMappingIssue(this.rootTagElement.getNamespace(), mapping);
        } else if (!isDocAfterResolving) {
            this.wrapAllKidsInTag(this.rootTagElement, this.rootTagElement.getRole(), this.rootTagElement.getNamespace());
            this.rootTagElement.setRole(PdfName.Document);
            if (this.context.targetTagStructureVersionIs2()) {
                this.rootTagElement.setNamespace(this.context.getDocumentDefaultNamespace());
                this.context.ensureNamespaceRegistered(this.context.getDocumentDefaultNamespace());
            }
        }
    }

    private void addStructTreeRootKidsToTheRootTag(List<IStructureNode> rootKids) {
        int originalRootKidsIndex = 0;
        boolean isBeforeOriginalRoot = true;
        for (IStructureNode elem : rootKids) {
            boolean kidIsDocument;
            PdfStructElem kid = (PdfStructElem)elem;
            if (kid.getPdfObject() == this.rootTagElement.getPdfObject()) {
                isBeforeOriginalRoot = false;
                continue;
            }
            IRoleMappingResolver mapping = kid.getRole() == null ? null : this.context.resolveMappingToStandardOrDomainSpecificRole(kid.getRole().getValue(), this.rootTagElement.getNamespace());
            boolean bl = kidIsDocument = mapping != null && mapping.currentRoleIsStandard() && "Document".equals(mapping.getRole());
            if (kidIsDocument && kid.getNamespace() != null && this.context.targetTagStructureVersionIs2()) {
                String kidNamespaceName = kid.getNamespace().getNamespaceName();
                boolean bl2 = kidIsDocument = "http://iso.org/pdf/ssn".equals(kidNamespaceName) || "http://iso.org/pdf2/ssn".equals(kidNamespaceName);
            }
            if (isBeforeOriginalRoot) {
                this.rootTagElement.addKid(originalRootKidsIndex, kid);
                originalRootKidsIndex += kidIsDocument ? kid.getKids().size() : 1;
            } else {
                this.rootTagElement.addKid(kid);
            }
            if (!kidIsDocument) continue;
            this.removeOldRoot(kid);
        }
    }

    private void wrapAllKidsInTag(PdfStructElem parent, PdfName wrapTagRole, PdfNamespace wrapTagNs) {
        int kidsNum = parent.getKids().size();
        TagTreePointer tagPointer = new TagTreePointer(parent, this.document);
        tagPointer.addTag(0, wrapTagRole.getValue());
        if (this.context.targetTagStructureVersionIs2()) {
            tagPointer.getProperties().setNamespace(wrapTagNs);
        }
        TagTreePointer newParentOfKids = new TagTreePointer(tagPointer);
        tagPointer.moveToParent();
        for (int i = 0; i < kidsNum; ++i) {
            tagPointer.relocateKid(1, newParentOfKids);
        }
    }

    private void removeOldRoot(PdfStructElem oldRoot) {
        new TagTreePointer(oldRoot, this.document).removeTag();
    }

    private void logCreatedRootTagHasMappingIssue(PdfNamespace rootTagOriginalNs, IRoleMappingResolver mapping) {
        String origRootTagNs = "";
        if (rootTagOriginalNs != null && rootTagOriginalNs.getNamespaceName() != null) {
            origRootTagNs = " in \"" + rootTagOriginalNs.getNamespaceName() + "\" namespace";
        }
        String mappingRole = " to ";
        if (mapping != null) {
            mappingRole = mappingRole + "\"" + mapping.getRole() + "\"";
            if (mapping.getNamespace() != null && !"http://iso.org/pdf/ssn".equals(mapping.getNamespace().getNamespaceName())) {
                mappingRole = mappingRole + " in \"" + mapping.getNamespace().getNamespaceName() + "\" namespace";
            }
        } else {
            mappingRole = mappingRole + "not standard role";
        }
        Logger logger = LoggerFactory.getLogger(RootTagNormalizer.class);
        logger.warn(MessageFormat.format("Created root tag has role mapping: \"/Document\" role{0} is mapped{1}. Resulting tag structure might have invalid root tag.", origRootTagNs, mappingRole));
    }
}

