/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.filters;

import com.itextpdf.io.codec.brotli.dec.BrotliInputStream;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.MemoryLimitsAwareFilter;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.filters.FlateDecodeFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BrotliFilter
extends MemoryLimitsAwareFilter {
    private static final int DEFAULT_INTERNAL_BUFFER_SIZE = 16384;
    private static final int DEFAULT_BUFFER_SIZE = 65536;

    @Override
    public byte[] decode(byte[] b, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) {
        try {
            int len;
            BrotliInputStream brotliInput;
            PdfStream brotliDictionary = BrotliFilter.getBrotliDictionaryStream(decodeParams);
            byte[] buffer = new byte[65536];
            ByteArrayInputStream input = new ByteArrayInputStream(b);
            ByteArrayOutputStream output = this.enableMemoryLimitsAwareHandler(streamDictionary);
            if (brotliDictionary != null) {
                brotliInput = new BrotliInputStream((InputStream)input, 16384);
                brotliInput.attachDictionaryChunk(brotliDictionary.getBytes());
            } else {
                brotliInput = new BrotliInputStream((InputStream)input);
            }
            while ((len = brotliInput.read(buffer, 0, buffer.length)) > 0) {
                output.write(buffer, 0, len);
            }
            brotliInput.close();
            return FlateDecodeFilter.decodePredictor(output.toByteArray(), decodeParams);
        }
        catch (IOException e) {
            throw new PdfException("Failed to decode Brotli stream.", e);
        }
    }

    private static PdfStream getBrotliDictionaryStream(PdfObject decodeParams) {
        if (!(decodeParams instanceof PdfDictionary)) {
            return null;
        }
        PdfDictionary dict = (PdfDictionary)decodeParams;
        PdfObject brotliDecompressionDictionary = dict.get(PdfName.D);
        if (brotliDecompressionDictionary instanceof PdfStream) {
            return (PdfStream)brotliDecompressionDictionary;
        }
        if (brotliDecompressionDictionary != null) {
            throw new PdfException("Brotli dictionary is not a stream.");
        }
        return null;
    }
}

