/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.draw;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.draw.ILineDrawer;

public class SolidLine
implements ILineDrawer {
    private float lineWidth = 1.0f;
    private Color color = ColorConstants.BLACK;

    public SolidLine() {
    }

    public SolidLine(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    public void draw(PdfCanvas canvas, Rectangle drawArea) {
        canvas.saveState().setStrokeColor(this.color).setLineWidth(this.lineWidth).moveTo(drawArea.getX(), drawArea.getY() + this.lineWidth / 2.0f).lineTo(drawArea.getX() + drawArea.getWidth(), drawArea.getY() + this.lineWidth / 2.0f).stroke().restoreState();
    }

    @Override
    public float getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }
}

