/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.navigation.PdfDestination;
import com.itextpdf.kernel.validation.context.PdfDestinationAdditionContext;
import java.util.ArrayList;
import java.util.List;

public class PdfOutline {
    public static final int FLAG_ITALIC = 1;
    public static final int FLAG_BOLD = 2;
    private List<PdfOutline> children = new ArrayList<PdfOutline>();
    private String title;
    private PdfDictionary content;
    private PdfDestination destination;
    private PdfOutline parent;
    private PdfDocument pdfDoc;

    PdfOutline(String title, PdfDictionary content, PdfDocument pdfDocument) {
        this.title = title;
        this.content = content;
        this.pdfDoc = pdfDocument;
    }

    PdfOutline(String title, PdfDictionary content, PdfOutline parent) {
        this.title = title;
        this.content = content;
        this.parent = parent;
        this.pdfDoc = parent.pdfDoc;
        content.makeIndirect(parent.pdfDoc);
    }

    PdfOutline(PdfDocument doc) {
        this.content = new PdfDictionary();
        this.content.put(PdfName.Type, PdfName.Outlines);
        this.pdfDoc = doc;
        this.content.makeIndirect(doc);
        doc.getCatalog().addRootOutline(this);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.content.put(PdfName.Title, new PdfString(title, "UnicodeBig"));
    }

    public void setColor(Color color) {
        this.content.put(PdfName.C, new PdfArray(color.getColorValue()));
    }

    public Color getColor() {
        PdfArray colorArray = this.content.getAsArray(PdfName.C);
        if (colorArray == null) {
            return null;
        }
        return Color.makeColor(PdfColorSpace.makeColorSpace(PdfName.DeviceRGB), colorArray.toFloatArray());
    }

    public void setStyle(int style) {
        if (style == 2 || style == 1) {
            this.content.put(PdfName.F, new PdfNumber(style));
        }
    }

    public Integer getStyle() {
        return this.content.getAsInt(PdfName.F);
    }

    public PdfDictionary getContent() {
        return this.content;
    }

    public List<PdfOutline> getAllChildren() {
        return this.children;
    }

    public PdfOutline getParent() {
        return this.parent;
    }

    public PdfDestination getDestination() {
        return this.destination;
    }

    public void addDestination(PdfDestination destination) {
        this.setDestination(destination);
        this.content.put(PdfName.Dest, (PdfObject)destination.getPdfObject());
    }

    public void addAction(PdfAction action) {
        PdfName actionType = ((PdfDictionary)action.getPdfObject()).getAsName(PdfName.S);
        if (PdfName.GoTo.equals(actionType)) {
            this.pdfDoc.checkIsoConformance(new PdfDestinationAdditionContext(action));
            PdfObject structureDestinationObject = ((PdfDictionary)action.getPdfObject()).get(PdfName.SD);
            if (structureDestinationObject != null) {
                this.setDestination(PdfDestination.makeDestination(structureDestinationObject));
            } else if (((PdfDictionary)action.getPdfObject()).get(PdfName.D) != null) {
                this.setDestination(PdfDestination.makeDestination(((PdfDictionary)action.getPdfObject()).get(PdfName.D)));
            }
        }
        this.content.put(PdfName.A, (PdfObject)action.getPdfObject());
    }

    public void setOpen(boolean open) {
        if (!open) {
            this.content.put(PdfName.Count, new PdfNumber(-1));
        } else if (this.children.size() > 0) {
            this.content.put(PdfName.Count, new PdfNumber(this.children.size()));
        } else {
            this.content.remove(PdfName.Count);
        }
    }

    public boolean isOpen() {
        Integer count = this.content.getAsInt(PdfName.Count);
        return count == null || count >= 0;
    }

    public PdfOutline addOutline(String title, int position) {
        PdfNumber count;
        if (position == -1) {
            position = this.children.size();
        }
        PdfDictionary dictionary = new PdfDictionary();
        PdfOutline outline = new PdfOutline(title, dictionary, this);
        dictionary.put(PdfName.Title, new PdfString(title, "UnicodeBig"));
        dictionary.put(PdfName.Parent, this.content);
        if (this.children.size() > 0) {
            if (position != 0) {
                PdfDictionary prevContent = this.children.get(position - 1).getContent();
                dictionary.put(PdfName.Prev, prevContent);
                prevContent.put(PdfName.Next, dictionary);
            }
            if (position != this.children.size()) {
                PdfDictionary nextContent = this.children.get(position).getContent();
                dictionary.put(PdfName.Next, nextContent);
                nextContent.put(PdfName.Prev, dictionary);
            }
        }
        if (position == 0) {
            this.content.put(PdfName.First, dictionary);
        }
        if (position == this.children.size()) {
            this.content.put(PdfName.Last, dictionary);
        }
        if ((count = this.content.getAsNumber(PdfName.Count)) == null || count.getValue() != -1.0) {
            this.content.put(PdfName.Count, new PdfNumber(this.children.size() + 1));
        }
        this.children.add(position, outline);
        return outline;
    }

    public PdfOutline addOutline(String title) {
        return this.addOutline(title, -1);
    }

    public PdfOutline addOutline(PdfOutline outline) {
        PdfOutline newOutline = this.addOutline(outline.getTitle());
        newOutline.addDestination(outline.getDestination());
        List<PdfOutline> children = outline.getAllChildren();
        for (PdfOutline child : children) {
            newOutline.addOutline(child);
        }
        return newOutline;
    }

    public void removeOutline() {
        if (!this.pdfDoc.hasOutlines() || this.isOutlineRoot()) {
            this.pdfDoc.getCatalog().remove(PdfName.Outlines);
            return;
        }
        PdfOutline parent = this.parent;
        List<PdfOutline> parentChildren = parent.children;
        PdfDictionary parentContent = parent.content;
        parentChildren.remove(this);
        if (parentChildren.isEmpty()) {
            parentContent.remove(PdfName.Count);
            if (parent.isOutlineRoot()) {
                this.pdfDoc.getCatalog().remove(PdfName.Outlines);
                return;
            }
        }
        int count = this.content.getAsInt(PdfName.Count) == null ? 0 : Math.abs(this.content.getAsInt(PdfName.Count));
        PdfOutline.updateCount(parent, ++count);
        if (parentChildren.isEmpty()) {
            parentContent.remove(PdfName.First);
            parentContent.remove(PdfName.Last);
            return;
        }
        parentContent.put(PdfName.First, parentChildren.get((int)0).content);
        parentContent.put(PdfName.Last, parentChildren.get((int)(parentChildren.size() - 1)).content);
        PdfDictionary next = this.content.getAsDictionary(PdfName.Next);
        PdfDictionary prev = this.content.getAsDictionary(PdfName.Prev);
        if (prev != null) {
            if (next != null) {
                prev.put(PdfName.Next, next);
                next.put(PdfName.Prev, prev);
            } else {
                prev.remove(PdfName.Next);
            }
        } else if (next != null) {
            next.remove(PdfName.Prev);
        }
    }

    void clear() {
        this.children.clear();
    }

    void setDestination(PdfDestination destination) {
        this.destination = destination;
    }

    private PdfDictionary getOutlineRoot() {
        if (!this.pdfDoc.hasOutlines()) {
            return null;
        }
        return ((PdfDictionary)this.pdfDoc.getCatalog().getPdfObject()).getAsDictionary(PdfName.Outlines);
    }

    private boolean isOutlineRoot() {
        PdfDictionary outlineRoot = this.getOutlineRoot();
        return outlineRoot == this.content;
    }

    private static void updateCount(PdfOutline outline, int amountOfRemovedOutlines) {
        if (outline == null) {
            return;
        }
        if (outline.content.getAsInt(PdfName.Count) != null) {
            int currentCount = outline.content.getAsInt(PdfName.Count);
            currentCount = currentCount > 0 ? (currentCount -= amountOfRemovedOutlines) : (currentCount += amountOfRemovedOutlines);
            outline.content.put(PdfName.Count, new PdfNumber(currentCount));
        }
        PdfOutline.updateCount(outline.parent, amountOfRemovedOutlines);
    }
}

