/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.kernel.crypto.IDecryptor;
import com.itextpdf.kernel.crypto.OutputStreamEncryption;
import com.itextpdf.kernel.crypto.securityhandler.PubKeySecurityHandler;
import com.itextpdf.kernel.crypto.securityhandler.PubSecHandlerUsingAes128;
import com.itextpdf.kernel.crypto.securityhandler.PubSecHandlerUsingAes256;
import com.itextpdf.kernel.crypto.securityhandler.PubSecHandlerUsingAesGcm;
import com.itextpdf.kernel.crypto.securityhandler.PubSecHandlerUsingStandard128;
import com.itextpdf.kernel.crypto.securityhandler.PubSecHandlerUsingStandard40;
import com.itextpdf.kernel.crypto.securityhandler.SecurityHandler;
import com.itextpdf.kernel.crypto.securityhandler.StandardHandlerUsingAes128;
import com.itextpdf.kernel.crypto.securityhandler.StandardHandlerUsingAes256;
import com.itextpdf.kernel.crypto.securityhandler.StandardHandlerUsingAesGcm;
import com.itextpdf.kernel.crypto.securityhandler.StandardHandlerUsingStandard128;
import com.itextpdf.kernel.crypto.securityhandler.StandardHandlerUsingStandard40;
import com.itextpdf.kernel.crypto.securityhandler.StandardSecurityHandler;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.mac.AbstractMacIntegrityProtector;
import com.itextpdf.kernel.mac.IMacContainerLocator;
import com.itextpdf.kernel.mac.MacValidationException;
import com.itextpdf.kernel.pdf.EncryptionProperties;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDeveloperExtension;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.VersionConforming;
import com.itextpdf.kernel.security.IExternalDecryptionProcess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.cert.Certificate;

public class PdfEncryption
extends PdfObjectWrapper<PdfDictionary> {
    private static final int STANDARD_ENCRYPTION_40 = 2;
    private static final int STANDARD_ENCRYPTION_128 = 3;
    private static final int AES_128 = 4;
    private static final int AES_256 = 5;
    private static final int AES_GCM = 6;
    private static final int DEFAULT_KEY_LENGTH = 40;
    private static final int MAC_ENABLED = -4097;
    private static final int MAC_DISABLED = 4096;
    private static long seq = SystemUtil.getTimeBasedSeed();
    private int cryptoMode;
    private Integer permissions;
    private boolean encryptMetadata;
    private boolean embeddedFilesOnly;
    private byte[] documentId;
    private SecurityHandler securityHandler;
    private AbstractMacIntegrityProtector macContainer;

    public PdfEncryption(byte[] userPassword, byte[] ownerPassword, int permissions, int encryptionType, byte[] documentId, PdfVersion version, AbstractMacIntegrityProtector macContainer) {
        super(new PdfDictionary());
        this.macContainer = macContainer;
        this.documentId = documentId;
        if (version != null && version.compareTo(PdfVersion.PDF_2_0) >= 0) {
            permissions = PdfEncryption.fixAccessibilityPermissionPdf20(permissions);
        }
        permissions = this.configureAccessibilityPermissionsForMac(permissions);
        int revision = this.setCryptoMode(encryptionType);
        switch (revision) {
            case 2: {
                StandardHandlerUsingStandard40 handlerStd40 = new StandardHandlerUsingStandard40((PdfDictionary)this.getPdfObject(), userPassword, ownerPassword, permissions, this.encryptMetadata, this.embeddedFilesOnly, documentId);
                this.permissions = handlerStd40.getPermissions();
                this.securityHandler = handlerStd40;
                break;
            }
            case 3: {
                StandardHandlerUsingStandard128 handlerStd128 = new StandardHandlerUsingStandard128((PdfDictionary)this.getPdfObject(), userPassword, ownerPassword, permissions, this.encryptMetadata, this.embeddedFilesOnly, documentId);
                this.permissions = handlerStd128.getPermissions();
                this.securityHandler = handlerStd128;
                break;
            }
            case 4: {
                StandardHandlerUsingAes128 handlerAes128 = new StandardHandlerUsingAes128((PdfDictionary)this.getPdfObject(), userPassword, ownerPassword, permissions, this.encryptMetadata, this.embeddedFilesOnly, documentId);
                this.permissions = handlerAes128.getPermissions();
                this.securityHandler = handlerAes128;
                break;
            }
            case 5: {
                StandardHandlerUsingAes256 handlerAes256 = new StandardHandlerUsingAes256((PdfDictionary)this.getPdfObject(), userPassword, ownerPassword, permissions, this.encryptMetadata, this.embeddedFilesOnly, version);
                this.permissions = handlerAes256.getPermissions();
                this.securityHandler = handlerAes256;
                break;
            }
            case 6: {
                StandardHandlerUsingAesGcm handlerAesGcm = new StandardHandlerUsingAesGcm((PdfDictionary)this.getPdfObject(), userPassword, ownerPassword, permissions, this.encryptMetadata, this.embeddedFilesOnly);
                this.permissions = handlerAesGcm.getPermissions();
                this.securityHandler = handlerAesGcm;
            }
        }
    }

    public PdfEncryption(Certificate[] certs, int[] permissions, int encryptionType, PdfVersion version, AbstractMacIntegrityProtector macContainer) {
        super(new PdfDictionary());
        this.macContainer = macContainer;
        for (int i = 0; i < permissions.length; ++i) {
            if (version != null && version.compareTo(PdfVersion.PDF_2_0) >= 0) {
                permissions[i] = PdfEncryption.fixAccessibilityPermissionPdf20(permissions[i]);
            }
            permissions[i] = this.configureAccessibilityPermissionsForMac(permissions[i]);
        }
        int revision = this.setCryptoMode(encryptionType);
        switch (revision) {
            case 2: {
                this.securityHandler = new PubSecHandlerUsingStandard40((PdfDictionary)this.getPdfObject(), certs, permissions, this.encryptMetadata, this.embeddedFilesOnly);
                break;
            }
            case 3: {
                this.securityHandler = new PubSecHandlerUsingStandard128((PdfDictionary)this.getPdfObject(), certs, permissions, this.encryptMetadata, this.embeddedFilesOnly);
                break;
            }
            case 4: {
                this.securityHandler = new PubSecHandlerUsingAes128((PdfDictionary)this.getPdfObject(), certs, permissions, this.encryptMetadata, this.embeddedFilesOnly);
                break;
            }
            case 5: {
                this.securityHandler = new PubSecHandlerUsingAes256((PdfDictionary)this.getPdfObject(), certs, permissions, this.encryptMetadata, this.embeddedFilesOnly);
                break;
            }
            case 6: {
                this.securityHandler = new PubSecHandlerUsingAesGcm((PdfDictionary)this.getPdfObject(), certs, permissions, this.encryptMetadata, this.embeddedFilesOnly);
            }
        }
    }

    public PdfEncryption(PdfDictionary pdfDict, byte[] password, byte[] documentId) {
        super(pdfDict);
        this.setForbidRelease();
        this.documentId = documentId;
        int revision = this.readAndSetCryptoModeForStdHandler(pdfDict);
        switch (revision) {
            case 2: {
                StandardHandlerUsingStandard40 handlerStd40 = new StandardHandlerUsingStandard40((PdfDictionary)this.getPdfObject(), password, documentId, this.encryptMetadata);
                this.permissions = handlerStd40.getPermissions();
                this.securityHandler = handlerStd40;
                break;
            }
            case 3: {
                StandardHandlerUsingStandard128 handlerStd128 = new StandardHandlerUsingStandard128((PdfDictionary)this.getPdfObject(), password, documentId, this.encryptMetadata);
                this.permissions = handlerStd128.getPermissions();
                this.securityHandler = handlerStd128;
                break;
            }
            case 4: {
                StandardHandlerUsingAes128 handlerAes128 = new StandardHandlerUsingAes128((PdfDictionary)this.getPdfObject(), password, documentId, this.encryptMetadata);
                this.permissions = handlerAes128.getPermissions();
                this.securityHandler = handlerAes128;
                break;
            }
            case 5: {
                StandardHandlerUsingAes256 aes256Handler = new StandardHandlerUsingAes256((PdfDictionary)this.getPdfObject(), password);
                this.permissions = aes256Handler.getPermissions();
                this.encryptMetadata = aes256Handler.isEncryptMetadata();
                this.securityHandler = aes256Handler;
                break;
            }
            case 6: {
                StandardHandlerUsingAesGcm aesGcmHandler = new StandardHandlerUsingAesGcm((PdfDictionary)this.getPdfObject(), password);
                this.permissions = aesGcmHandler.getPermissions();
                this.encryptMetadata = aesGcmHandler.isEncryptMetadata();
                this.securityHandler = aesGcmHandler;
            }
        }
    }

    public PdfEncryption(PdfDictionary pdfDict, Key certificateKey, Certificate certificate, String certificateKeyProvider, IExternalDecryptionProcess externalDecryptionProcess) {
        super(pdfDict);
        this.setForbidRelease();
        int revision = this.readAndSetCryptoModeForPubSecHandler(pdfDict);
        switch (revision) {
            case 2: {
                this.securityHandler = new PubSecHandlerUsingStandard40((PdfDictionary)this.getPdfObject(), certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, this.encryptMetadata);
                break;
            }
            case 3: {
                this.securityHandler = new PubSecHandlerUsingStandard128((PdfDictionary)this.getPdfObject(), certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, this.encryptMetadata);
                break;
            }
            case 4: {
                this.securityHandler = new PubSecHandlerUsingAes128((PdfDictionary)this.getPdfObject(), certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, this.encryptMetadata);
                break;
            }
            case 5: {
                this.securityHandler = new PubSecHandlerUsingAes256((PdfDictionary)this.getPdfObject(), certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, this.encryptMetadata);
                break;
            }
            case 6: {
                this.securityHandler = new PubSecHandlerUsingAesGcm((PdfDictionary)this.getPdfObject(), certificateKey, certificate, certificateKeyProvider, externalDecryptionProcess, this.encryptMetadata);
            }
        }
    }

    public static byte[] generateNewDocumentId() {
        MessageDigest sha512;
        try {
            sha512 = MessageDigest.getInstance("SHA-512");
        }
        catch (Exception e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
        long time = SystemUtil.getTimeBasedSeed();
        long mem = SystemUtil.getFreeMemory();
        String s = time + "+" + mem + "+" + seq++;
        return sha512.digest(s.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static PdfObject createInfoId(byte[] id, boolean modified) {
        if (modified) {
            return PdfEncryption.createInfoId(id, PdfEncryption.generateNewDocumentId(), false);
        }
        return PdfEncryption.createInfoId(id, id, false);
    }

    public static PdfObject createInfoId(byte[] firstId, byte[] secondId, boolean preserveEncryption) {
        if (!preserveEncryption) {
            if (firstId.length < 16) {
                firstId = PdfEncryption.padByteArrayTo16(firstId);
            }
            if (secondId.length < 16) {
                secondId = PdfEncryption.padByteArrayTo16(secondId);
            }
        }
        ByteBuffer buf = new ByteBuffer(90);
        buf.append(91).append(60);
        for (byte value : firstId) {
            buf.appendHex(value);
        }
        buf.append(62).append(60);
        for (byte b : secondId) {
            buf.appendHex(b);
        }
        buf.append(62).append(93);
        return new PdfLiteral(buf.toByteArray());
    }

    private static byte[] padByteArrayTo16(byte[] documentId) {
        byte[] paddingBytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        System.arraycopy(documentId, 0, paddingBytes, 0, documentId.length);
        return paddingBytes;
    }

    public Integer getPermissions() {
        return this.permissions;
    }

    public int getCryptoMode() {
        return this.cryptoMode;
    }

    public int getEncryptionAlgorithm() {
        return this.cryptoMode & 7;
    }

    public boolean isMetadataEncrypted() {
        return this.encryptMetadata;
    }

    public boolean isEmbeddedFilesOnly() {
        return this.embeddedFilesOnly;
    }

    public byte[] getDocumentId() {
        return this.documentId;
    }

    public void setHashKeyForNextObject(int objNumber, int objGeneration) {
        this.securityHandler.setHashKeyForNextObject(objNumber, objGeneration);
    }

    public OutputStreamEncryption getEncryptionStream(OutputStream os) {
        return this.securityHandler.getEncryptionStream(os);
    }

    public byte[] encryptByteArray(byte[] b) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        OutputStreamEncryption ose = this.getEncryptionStream(ba);
        try {
            ose.write(b);
        }
        catch (IOException e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
        ose.finish();
        return ba.toByteArray();
    }

    public byte[] decryptByteArray(byte[] b) {
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            IDecryptor dec = this.securityHandler.getDecryptor();
            byte[] b2 = dec.update(b, 0, b.length);
            if (b2 != null) {
                ba.write(b2);
            }
            if ((b2 = dec.finish()) != null) {
                ba.write(b2);
            }
            return ba.toByteArray();
        }
        catch (IOException e) {
            throw new PdfException("PdfEncryption exception.", e);
        }
    }

    public boolean isOpenedWithFullPermission() {
        if (this.securityHandler instanceof PubKeySecurityHandler) {
            return true;
        }
        if (this.securityHandler instanceof StandardSecurityHandler) {
            return ((StandardSecurityHandler)this.securityHandler).isUsedOwnerPassword();
        }
        return true;
    }

    public byte[] computeUserPassword(byte[] ownerPassword) {
        byte[] userPassword = null;
        if (this.securityHandler instanceof StandardHandlerUsingStandard40) {
            userPassword = ((StandardHandlerUsingStandard40)this.securityHandler).computeUserPassword(ownerPassword, (PdfDictionary)this.getPdfObject());
        }
        return userPassword;
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private void setKeyLength(int keyLength) {
        if (keyLength != 40) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Length, new PdfNumber(keyLength));
        }
    }

    private int setCryptoMode(int mode) {
        return this.setCryptoMode(mode, 0);
    }

    private int setCryptoMode(int mode, int length) {
        int revision;
        this.cryptoMode = mode;
        this.encryptMetadata = (mode & 8) != 8;
        this.embeddedFilesOnly = (mode & 0x18) == 24;
        switch (mode &= 7) {
            case 0: {
                this.encryptMetadata = true;
                this.embeddedFilesOnly = false;
                this.setKeyLength(40);
                revision = 2;
                break;
            }
            case 1: {
                if (length > 0) {
                    this.setKeyLength(length);
                } else {
                    this.setKeyLength(128);
                }
                revision = 3;
                break;
            }
            case 2: {
                this.setKeyLength(128);
                revision = 4;
                break;
            }
            case 3: {
                this.setKeyLength(256);
                revision = 5;
                break;
            }
            case 4: {
                this.setKeyLength(256);
                revision = 6;
                break;
            }
            default: {
                throw new PdfException("No valid encryption mode.");
            }
        }
        return revision;
    }

    private int readAndSetCryptoModeForStdHandler(PdfDictionary encDict) {
        int cryptoMode;
        int length = 0;
        PdfNumber rValue = encDict.getAsNumber(PdfName.R);
        if (rValue == null) {
            throw new PdfException("Illegal R value.");
        }
        int revision = rValue.intValue();
        boolean embeddedFilesOnlyMode = PdfEncryption.readEmbeddedFilesOnlyFromEncryptDictionary(encDict);
        switch (revision) {
            case 2: {
                cryptoMode = 0;
                break;
            }
            case 3: {
                PdfNumber lengthValue = encDict.getAsNumber(PdfName.Length);
                int n = length = lengthValue == null ? 40 : lengthValue.intValue();
                if (length > 128 || length < 40 || length % 8 != 0) {
                    throw new PdfException("Illegal length value.");
                }
                cryptoMode = 1;
                break;
            }
            case 4: {
                PdfDictionary dic = (PdfDictionary)encDict.get(PdfName.CF);
                if (dic == null) {
                    throw new PdfException("/CF not found (encryption)");
                }
                if ((dic = (PdfDictionary)dic.get(PdfName.StdCF)) == null) {
                    throw new PdfException("/StdCF not found (encryption)");
                }
                if (PdfName.V2.equals(dic.get(PdfName.CFM))) {
                    cryptoMode = 1;
                } else if (PdfName.AESV2.equals(dic.get(PdfName.CFM))) {
                    cryptoMode = 2;
                } else {
                    throw new PdfException("No compatible encryption found.");
                }
                PdfBoolean em = encDict.getAsBoolean(PdfName.EncryptMetadata);
                if (em != null && !em.getValue()) {
                    cryptoMode |= 8;
                }
                if (!embeddedFilesOnlyMode) break;
                cryptoMode |= 0x18;
                break;
            }
            case 5: 
            case 6: {
                cryptoMode = 3;
                PdfBoolean em5 = encDict.getAsBoolean(PdfName.EncryptMetadata);
                if (em5 != null && !em5.getValue()) {
                    cryptoMode |= 8;
                }
                if (!embeddedFilesOnlyMode) break;
                cryptoMode |= 0x18;
                break;
            }
            case 7: {
                PdfDictionary cfDic = encDict.getAsDictionary(PdfName.CF);
                if (cfDic == null) {
                    throw new PdfException("/CF not found (encryption)");
                }
                if ((cfDic = (PdfDictionary)cfDic.get(PdfName.StdCF)) == null) {
                    throw new PdfException("/StdCF not found (encryption)");
                }
                if (!PdfName.AESV4.equals(cfDic.get(PdfName.CFM))) {
                    throw new PdfException("No compatible encryption found.");
                }
                cryptoMode = 4;
                length = 256;
                PdfBoolean em7 = encDict.getAsBoolean(PdfName.EncryptMetadata);
                if (em7 != null && !em7.getValue()) {
                    cryptoMode |= 8;
                }
                if (!embeddedFilesOnlyMode) break;
                cryptoMode |= 0x18;
                break;
            }
            default: {
                throw new PdfException("Unknown encryption type R == {0}.").setMessageParams(rValue);
            }
        }
        revision = this.setCryptoMode(cryptoMode, length);
        return revision;
    }

    private int readAndSetCryptoModeForPubSecHandler(PdfDictionary encDict) {
        int length;
        int cryptoMode;
        PdfNumber vValue = encDict.getAsNumber(PdfName.V);
        if (vValue == null) {
            throw new PdfException("Illegal V value.");
        }
        int v = vValue.intValue();
        boolean embeddedFilesOnlyMode = PdfEncryption.readEmbeddedFilesOnlyFromEncryptDictionary(encDict);
        switch (v) {
            case 1: {
                cryptoMode = 0;
                length = 40;
                break;
            }
            case 2: {
                PdfNumber lengthValue = encDict.getAsNumber(PdfName.Length);
                int n = length = lengthValue == null ? 40 : lengthValue.intValue();
                if (length > 128 || length < 40 || length % 8 != 0) {
                    throw new PdfException("Illegal length value.");
                }
                cryptoMode = 1;
                break;
            }
            case 4: 
            case 5: {
                PdfDictionary dic = encDict.getAsDictionary(PdfName.CF);
                if (dic == null) {
                    throw new PdfException("/CF not found (encryption)");
                }
                if ((dic = (PdfDictionary)dic.get(PdfName.DefaultCryptFilter)) == null) {
                    throw new PdfException("/DefaultCryptFilter not found (encryption).");
                }
                if (PdfName.V2.equals(dic.get(PdfName.CFM))) {
                    cryptoMode = 1;
                    length = 128;
                } else if (PdfName.AESV2.equals(dic.get(PdfName.CFM))) {
                    cryptoMode = 2;
                    length = 128;
                } else if (PdfName.AESV3.equals(dic.get(PdfName.CFM))) {
                    cryptoMode = 3;
                    length = 256;
                } else {
                    throw new PdfException("No compatible encryption found.");
                }
                PdfBoolean em = dic.getAsBoolean(PdfName.EncryptMetadata);
                if (em != null && !em.getValue()) {
                    cryptoMode |= 8;
                }
                if (!embeddedFilesOnlyMode) break;
                cryptoMode |= 0x18;
                break;
            }
            case 6: {
                PdfDictionary cfDic = encDict.getAsDictionary(PdfName.CF);
                if (cfDic == null) {
                    throw new PdfException("/CF not found (encryption)");
                }
                if ((cfDic = (PdfDictionary)cfDic.get(PdfName.DefaultCryptFilter)) == null) {
                    throw new PdfException("/DefaultCryptFilter not found (encryption).");
                }
                if (!PdfName.AESV4.equals(cfDic.get(PdfName.CFM))) {
                    throw new PdfException("No compatible encryption found.");
                }
                cryptoMode = 4;
                length = 256;
                PdfBoolean encrM = cfDic.getAsBoolean(PdfName.EncryptMetadata);
                if (encrM != null && !encrM.getValue()) {
                    cryptoMode |= 8;
                }
                if (!embeddedFilesOnlyMode) break;
                cryptoMode |= 0x18;
                break;
            }
            default: {
                throw new PdfException("Unknown encryption type V == {0}.", vValue);
            }
        }
        return this.setCryptoMode(cryptoMode, length);
    }

    private int configureAccessibilityPermissionsForMac(int permissions) {
        if (this.macContainer == null) {
            return permissions | 0x1000;
        }
        return permissions & 0xFFFFEFFF;
    }

    static boolean readEmbeddedFilesOnlyFromEncryptDictionary(PdfDictionary encDict) {
        boolean encryptStrings;
        PdfName embeddedFilesFilter = encDict.getAsName(PdfName.EFF);
        boolean encryptEmbeddedFiles = !PdfName.Identity.equals(embeddedFilesFilter) && embeddedFilesFilter != null;
        boolean encryptStreams = !PdfName.Identity.equals(encDict.getAsName(PdfName.StmF));
        boolean bl = encryptStrings = !PdfName.Identity.equals(encDict.getAsName(PdfName.StrF));
        if (encryptStreams || encryptStrings || !encryptEmbeddedFiles) {
            return false;
        }
        PdfDictionary cfDictionary = encDict.getAsDictionary(PdfName.CF);
        if (cfDictionary != null) {
            return cfDictionary.getAsDictionary(embeddedFilesFilter) != null;
        }
        return false;
    }

    private static int fixAccessibilityPermissionPdf20(int permissions) {
        return permissions | 0x200;
    }

    void checkEncryptionRequirements(PdfDocument document) {
        int encryption;
        if (this.macContainer != null) {
            if (document.getPdfVersion() == null || document.getPdfVersion().compareTo(PdfVersion.PDF_2_0) < 0) {
                throw new PdfException("MAC integrity protection is only supported for PDF 2.0 or higher.");
            }
            if (((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.V) != null && ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.V).intValue() < 5) {
                throw new PdfException("MAC integrity protection is only supported for encryption algorithms of version 5 or higher.");
            }
        }
        if ((encryption = this.getEncryptionAlgorithm()) < 3) {
            VersionConforming.validatePdfVersionForDeprecatedFeatureLogWarn(document, PdfVersion.PDF_2_0, "Encryption algorithms STANDARD_ENCRYPTION_40, STANDARD_ENCRYPTION_128 and ENCRYPTION_AES_128 (see com.itextpdf.kernel.pdf.EncryptionConstants) are deprecated in PDF 2.0. It is highly recommended not to use it.");
        } else if (encryption == 3) {
            PdfNumber r = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.R);
            if (r != null && r.intValue() == 5) {
                VersionConforming.validatePdfVersionForDeprecatedFeatureLogWarn(document, PdfVersion.PDF_2_0, "It seems that PDF 1.7 document encrypted with AES256 was updated to PDF 2.0 version and StampingProperties#preserveEncryption flag was set: encryption shall be updated via WriterProperties#setStandardEncryption method. Standard security handler was found with revision 5, which is deprecated and shall not be used in PDF 2.0 documents.");
            }
        } else if (encryption == 4) {
            VersionConforming.validatePdfVersionForNotSupportedFeatureLogError(document, PdfVersion.PDF_2_0, "Advanced Encryption Standard-Galois/Counter Mode (AES-GCM) encryption algorithm is supported starting from PDF 2.0.");
        }
    }

    void configureEncryptionParametersFromWriter(PdfDocument document) {
        if (this.macContainer != null) {
            this.macContainer.setFileEncryptionKey(this.securityHandler.getMkey().length == 0 ? this.securityHandler.getNextObjectKey() : this.securityHandler.getMkey());
            ((IMacContainerLocator)document.getDiContainer().getInstance(IMacContainerLocator.class)).locateMacContainer(this.macContainer);
            document.getCatalog().addDeveloperExtension(PdfDeveloperExtension.ISO_32004);
            PdfString kdfSalt = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.KDFSalt);
            if (kdfSalt == null) {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.KDFSalt, new PdfString(this.macContainer.getKdfSalt()).setHexWriting(true));
                ((PdfDictionary)this.getPdfObject()).setModified();
            }
        } else {
            document.getCatalog().removeDeveloperExtension(PdfDeveloperExtension.ISO_32004);
        }
        if (this.getEncryptionAlgorithm() == 4) {
            document.getCatalog().addDeveloperExtension(PdfDeveloperExtension.ISO_32003);
        } else {
            document.getCatalog().removeDeveloperExtension(PdfDeveloperExtension.ISO_32003);
        }
    }

    AbstractMacIntegrityProtector getMacContainer() {
        return this.macContainer;
    }

    void configureEncryptionParametersFromReader(PdfDocument document, PdfDictionary trailer) {
        PdfVersion sourceVersion;
        PdfVersion destVersion = sourceVersion = document.getReader().headerPdfVersion;
        if (document.getWriter() != null && document.getWriter().getProperties().pdfVersion != null) {
            destVersion = document.getWriter().getProperties().pdfVersion;
        }
        try {
            if (trailer.getAsDictionary(PdfName.AuthCode) != null) {
                this.macContainer = ((IMacContainerLocator)document.getDiContainer().getInstance(IMacContainerLocator.class)).createMacIntegrityProtector(document, trailer.getAsDictionary(PdfName.AuthCode));
                this.macContainer.setFileEncryptionKey(this.securityHandler.getMkey().length == 0 ? this.securityHandler.getNextObjectKey() : this.securityHandler.getMkey());
                PdfString kdfSalt = ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.KDFSalt);
                if (kdfSalt != null) {
                    this.macContainer.setKdfSalt(kdfSalt.getValueBytes());
                }
                this.macContainer.validateMacToken();
                if (document.properties.disableMac && !document.properties.appendMode && this.securityHandler instanceof StandardSecurityHandler) {
                    this.macContainer = null;
                    this.updateMacPermission();
                }
            } else {
                if (PdfVersion.PDF_2_0.compareTo(destVersion) <= 0 && this.permissions != null && (this.permissions & 0x1000) == 0) {
                    throw new MacValidationException("Permissions bit 13 is set to zero, which indicates that MAC integrity protection is enabled. However MAC container wasn't found.");
                }
                if (!document.properties.disableMac && !document.properties.appendMode && this.securityHandler instanceof StandardSecurityHandler) {
                    PdfNumber vValue = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.V);
                    if (vValue == null) {
                        throw new PdfException("Illegal V value.");
                    }
                    int v = vValue.intValue();
                    if (PdfVersion.PDF_2_0.compareTo(destVersion) <= 0 && PdfVersion.PDF_2_0.compareTo(sourceVersion) <= 0 && v >= 5) {
                        this.macContainer = ((IMacContainerLocator)document.getDiContainer().getInstance(IMacContainerLocator.class)).createMacIntegrityProtector(document, EncryptionProperties.DEFAULT_MAC_PROPERTIES);
                        this.updateMacPermission();
                    }
                }
            }
        }
        catch (MacValidationException exception) {
            ((IMacContainerLocator)document.getDiContainer().getInstance(IMacContainerLocator.class)).handleMacValidationError(exception);
        }
    }

    private void updateMacPermission() {
        if (this.permissions != null) {
            this.permissions = this.configureAccessibilityPermissionsForMac(this.permissions);
            if (this.securityHandler instanceof StandardSecurityHandler) {
                ((StandardSecurityHandler)this.securityHandler).setPermissions(this.permissions, (PdfDictionary)this.getPdfObject());
            }
        }
    }
}

