/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class PdfDictionaryEntrySet
extends AbstractSet<Map.Entry<PdfName, PdfObject>> {
    private final Set<Map.Entry<PdfName, PdfObject>> set;

    PdfDictionaryEntrySet(Set<Map.Entry<PdfName, PdfObject>> set) {
        this.set = set;
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o) || super.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o) || super.remove(o);
    }

    @Override
    public Iterator<Map.Entry<PdfName, PdfObject>> iterator() {
        return new DirectIterator(this.set.iterator());
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    private static class DirectEntry
    implements Map.Entry<PdfName, PdfObject> {
        Map.Entry<PdfName, PdfObject> entry;

        DirectEntry(Map.Entry<PdfName, PdfObject> entry) {
            this.entry = entry;
        }

        @Override
        public PdfName getKey() {
            return this.entry.getKey();
        }

        @Override
        public PdfObject getValue() {
            PdfObject obj = this.entry.getValue();
            if (obj != null && obj.isIndirectReference()) {
                obj = ((PdfIndirectReference)obj).getRefersTo(true);
            }
            return obj;
        }

        @Override
        public PdfObject setValue(PdfObject value) {
            return this.entry.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            PdfName k1 = this.getKey();
            Object k2 = e.getKey();
            if (k1 != null && ((Object)k1).equals(k2)) {
                PdfObject v1 = this.getValue();
                Object v2 = e.getValue();
                if (v1 != null && v1.equals(v2)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
        }
    }

    private static class DirectIterator
    implements Iterator<Map.Entry<PdfName, PdfObject>> {
        Iterator<Map.Entry<PdfName, PdfObject>> parentIterator;

        public DirectIterator(Iterator<Map.Entry<PdfName, PdfObject>> parentIterator) {
            this.parentIterator = parentIterator;
        }

        @Override
        public boolean hasNext() {
            return this.parentIterator.hasNext();
        }

        @Override
        public Map.Entry<PdfName, PdfObject> next() {
            return new DirectEntry(this.parentIterator.next());
        }

        @Override
        public void remove() {
            this.parentIterator.remove();
        }
    }
}

