/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.numbering;

public class AlphabetNumbering {
    public static String toAlphabetNumber(int number, char[] alphabet) {
        if (number < 1) {
            throw new IllegalArgumentException("The parameter must be a positive integer");
        }
        int cardinality = alphabet.length;
        --number;
        int bytes = 1;
        long start = 0L;
        long symbols = cardinality;
        while ((long)number >= symbols + start) {
            ++bytes;
            start += symbols;
            symbols *= (long)cardinality;
        }
        long c = (long)number - start;
        char[] value = new char[bytes];
        while (bytes > 0) {
            value[--bytes] = alphabet[(int)(c % (long)cardinality)];
            c /= (long)cardinality;
        }
        return new String(value);
    }
}

