/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public final class UrlUtil {
    private static final int DEFAULT_CONNECT_TIMEOUT = 300000;
    private static final int DEFAULT_READ_TIMEOUT = 300000;

    private UrlUtil() {
    }

    public static URL toURL(String filename) throws MalformedURLException {
        URL url;
        try {
            url = new URL(filename);
        }
        catch (MalformedURLException e) {
            url = new File(filename).toURI().toURL();
        }
        return url;
    }

    public static URI toNormalizedURI(String filename) {
        return UrlUtil.toNormalizedURI(new File(filename));
    }

    public static URI toNormalizedURI(File file) {
        return file.toURI().normalize();
    }

    public static String toAbsoluteURI(URI uri) {
        return uri.toString();
    }

    public static InputStream openStream(URL url) throws IOException {
        return url.openStream();
    }

    public static String getFileUriString(String filename) throws MalformedURLException {
        return new File(filename).toURI().toURL().toExternalForm();
    }

    public static String getNormalizedFileUriString(String filename) {
        return "file://" + UrlUtil.toNormalizedURI(filename).getPath();
    }

    public static InputStream getInputStreamOfFinalConnection(URL initialUrl) throws IOException {
        return UrlUtil.getInputStreamOfFinalConnection(initialUrl, 300000, 300000);
    }

    public static InputStream getInputStreamOfFinalConnection(URL initialUrl, int connectTimeout, int readTimeout) throws IOException {
        return UrlUtil.getInputStreamOfFinalConnection(initialUrl, connectTimeout, readTimeout, null);
    }

    public static InputStream getInputStreamOfFinalConnection(URL initialUrl, int connectTimeout, int readTimeout, SSLContext sslContext) throws IOException {
        URLConnection finalConnection = UrlUtil.getFinalConnection(initialUrl, connectTimeout, readTimeout, sslContext);
        return finalConnection.getInputStream();
    }

    static URLConnection getFinalConnection(URL initialUrl, int connectTimeout, int readTimeout, SSLContext sslContext) throws IOException {
        URL nextUrl = initialUrl;
        URLConnection connection = null;
        while (nextUrl != null) {
            connection = nextUrl.openConnection();
            if (sslContext != null && connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(sslContext.getSocketFactory());
            }
            connection.setConnectTimeout(connectTimeout);
            connection.setReadTimeout(readTimeout);
            String location = connection.getHeaderField("location");
            nextUrl = location == null ? null : new URL(location);
            if (nextUrl == null) continue;
            connection.getInputStream().close();
        }
        return connection;
    }
}

