/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.io.font.CFFFontSubset;
import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.GidAwareGlyph;
import com.itextpdf.io.font.OpenTypeParser;
import com.itextpdf.io.font.TrueTypeFontMerger;
import com.itextpdf.io.font.constants.TrueTypeCodePages;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphPositioningTableReader;
import com.itextpdf.io.font.otf.GlyphSubstitutionTableReader;
import com.itextpdf.io.font.otf.OpenTypeGdefTableReader;
import com.itextpdf.io.util.IntHashtable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;

public class TrueTypeFont
extends FontProgram {
    private OpenTypeParser fontParser;
    protected int[][] bBoxes;
    protected boolean isVertical;
    private GlyphSubstitutionTableReader gsubTable;
    private GlyphPositioningTableReader gposTable;
    private OpenTypeGdefTableReader gdefTable;
    protected IntHashtable kerning = new IntHashtable();
    private byte[] fontStreamBytes;

    private TrueTypeFont(OpenTypeParser fontParser) throws IOException {
        this.fontParser = fontParser;
        this.fontParser.loadTables(true);
        this.initializeFontProperties();
    }

    protected TrueTypeFont() {
        this.fontNames = new FontNames();
    }

    public TrueTypeFont(String path) throws IOException {
        this(new OpenTypeParser(path));
    }

    public TrueTypeFont(byte[] ttf) throws IOException {
        this(new OpenTypeParser(ttf));
    }

    public TrueTypeFont(byte[] ttf, boolean isLenientMode) throws IOException {
        this(new OpenTypeParser(ttf, isLenientMode));
    }

    TrueTypeFont(String ttcPath, int ttcIndex) throws IOException {
        this(new OpenTypeParser(ttcPath, ttcIndex));
    }

    TrueTypeFont(byte[] ttc, int ttcIndex) throws IOException {
        this(new OpenTypeParser(ttc, ttcIndex));
    }

    @Override
    public boolean hasKernPairs() {
        return this.kerning.size() > 0;
    }

    @Override
    public int getKerning(Glyph first, Glyph second) {
        if (first == null || second == null) {
            return 0;
        }
        return this.kerning.get((first.getCode() << 16) + second.getCode());
    }

    public boolean isCff() {
        return this.fontParser.isCff();
    }

    public Map<Integer, int[]> getActiveCmap() {
        OpenTypeParser.CmapTable cmaps = this.fontParser.getCmapTable();
        if (cmaps.cmap310 != null) {
            return cmaps.cmap310;
        }
        if (!cmaps.fontSpecific && cmaps.cmap31 != null) {
            return cmaps.cmap31;
        }
        if (cmaps.fontSpecific && cmaps.cmap10 != null) {
            return cmaps.cmap10;
        }
        if (cmaps.cmap31 != null) {
            return cmaps.cmap31;
        }
        return cmaps.cmap10;
    }

    public byte[] getFontStreamBytes() {
        if (this.fontStreamBytes != null) {
            return this.fontStreamBytes;
        }
        try {
            this.fontStreamBytes = this.fontParser.isCff() ? this.fontParser.readCffFont() : this.fontParser.getFullFont();
        }
        catch (IOException e) {
            this.fontStreamBytes = null;
            throw new com.itextpdf.io.exceptions.IOException("I/O exception.", e);
        }
        return this.fontStreamBytes;
    }

    @Override
    public int getPdfFontFlags() {
        int flags = 0;
        if (this.fontMetrics.isFixedPitch()) {
            flags |= 1;
        }
        flags |= this.isFontSpecific() ? 4 : 32;
        if (this.fontNames.isItalic()) {
            flags |= 0x40;
        }
        if (this.fontNames.isBold() || this.fontNames.getFontWeight() > 500) {
            flags |= 0x40000;
        }
        return flags;
    }

    public int getDirectoryOffset() {
        return this.fontParser.directoryOffset;
    }

    public GlyphSubstitutionTableReader getGsubTable() {
        return this.gsubTable;
    }

    public GlyphPositioningTableReader getGposTable() {
        return this.gposTable;
    }

    public OpenTypeGdefTableReader getGdefTable() {
        return this.gdefTable;
    }

    public byte[] getSubset(Set<Integer> glyphs, boolean subsetTables) {
        return (byte[])this.subset(glyphs, subsetTables).getSecond();
    }

    public Tuple2<Integer, byte[]> subset(Set<Integer> glyphs, boolean subsetTables) {
        try {
            return this.fontParser.getSubset(glyphs, subsetTables);
        }
        catch (IOException e) {
            throw new com.itextpdf.io.exceptions.IOException("I/O exception.", e);
        }
    }

    @Deprecated
    public static byte[] merge(Map<TrueTypeFont, Set<Integer>> toMerge, String fontName) {
        return TrueTypeFont.merge(toMerge, fontName, true);
    }

    public static byte[] merge(Map<TrueTypeFont, Set<Integer>> toMerge, String fontName, boolean isCmapCheckRequired) {
        try {
            LinkedHashMap<OpenTypeParser, Set<Integer>> toMergeWithParsers = new LinkedHashMap<OpenTypeParser, Set<Integer>>();
            for (Map.Entry<TrueTypeFont, Set<Integer>> entry : toMerge.entrySet()) {
                toMergeWithParsers.put(entry.getKey().fontParser, entry.getValue());
            }
            TrueTypeFontMerger trueTypeFontMerger = new TrueTypeFontMerger(fontName, toMergeWithParsers, isCmapCheckRequired);
            return (byte[])trueTypeFontMerger.process().getSecond();
        }
        catch (IOException e) {
            throw new com.itextpdf.io.exceptions.IOException("I/O exception.", e);
        }
    }

    public Set<Integer> mapGlyphsCidsToGids(Set<Integer> glyphs) {
        return glyphs.stream().map(i -> {
            Glyph usedGlyph = this.getGlyphByCode((int)i);
            if (usedGlyph instanceof GidAwareGlyph) {
                return ((GidAwareGlyph)usedGlyph).getGid();
            }
            return i;
        }).collect(Collectors.toSet());
    }

    public boolean isCmapPresent(int platformID, int encodingID) {
        OpenTypeParser.CmapTable cmaps = this.fontParser.getCmapTable();
        if (cmaps == null) {
            return false;
        }
        return cmaps.cmapEncodings.contains(new Tuple2((Object)platformID, (Object)encodingID));
    }

    public int getNumberOfCmaps() {
        OpenTypeParser.CmapTable cmaps = this.fontParser.getCmapTable();
        if (cmaps == null) {
            return 0;
        }
        return cmaps.cmapEncodings.size();
    }

    protected void readGdefTable() throws IOException {
        int[] gdef = this.fontParser.tables.get("GDEF");
        this.gdefTable = gdef != null ? new OpenTypeGdefTableReader(this.fontParser.raf, gdef[0]) : new OpenTypeGdefTableReader(this.fontParser.raf, 0);
        this.gdefTable.readTable();
    }

    protected void readGsubTable() throws IOException {
        int[] gsub = this.fontParser.tables.get("GSUB");
        if (gsub != null) {
            this.gsubTable = new GlyphSubstitutionTableReader(this.fontParser.raf, gsub[0], this.gdefTable, this.codeToGlyph, this.fontMetrics.getUnitsPerEm());
        }
    }

    protected void readGposTable() throws IOException {
        int[] gpos = this.fontParser.tables.get("GPOS");
        if (gpos != null) {
            this.gposTable = new GlyphPositioningTableReader(this.fontParser.raf, gpos[0], this.gdefTable, this.codeToGlyph, this.fontMetrics.getUnitsPerEm());
        }
    }

    private void initializeFontProperties() throws IOException {
        String[][] ttfUniqueId;
        OpenTypeParser.HeaderTable head = this.fontParser.getHeadTable();
        OpenTypeParser.HorizontalHeader hhea = this.fontParser.getHheaTable();
        OpenTypeParser.WindowsMetrics os_2 = this.fontParser.getOs_2Table();
        OpenTypeParser.PostTable post = this.fontParser.getPostTable();
        this.isFontSpecific = this.fontParser.getCmapTable().fontSpecific;
        this.kerning = this.fontParser.readKerning(head.unitsPerEm);
        this.bBoxes = this.fontParser.readBbox(head.unitsPerEm);
        this.fontNames = this.fontParser.getFontNames();
        this.fontMetrics.setUnitsPerEm(head.unitsPerEm);
        this.fontMetrics.updateBbox(head.xMin, head.yMin, head.xMax, head.yMax);
        this.fontMetrics.setNumberOfGlyphs(this.fontParser.readNumGlyphs());
        this.fontMetrics.setGlyphWidths(this.fontParser.getGlyphWidthsByIndex());
        this.fontMetrics.setTypoAscender(os_2.sTypoAscender);
        this.fontMetrics.setTypoDescender(os_2.sTypoDescender);
        this.fontMetrics.setCapHeight(os_2.sCapHeight);
        this.fontMetrics.setXHeight(os_2.sxHeight);
        this.fontMetrics.setItalicAngle(post.italicAngle);
        this.fontMetrics.setAscender(hhea.Ascender);
        this.fontMetrics.setDescender(hhea.Descender);
        this.fontMetrics.setLineGap(hhea.LineGap);
        this.fontMetrics.setWinAscender(os_2.usWinAscent);
        this.fontMetrics.setWinDescender(os_2.usWinDescent);
        this.fontMetrics.setAdvanceWidthMax(hhea.advanceWidthMax);
        this.fontMetrics.setUnderlinePosition((post.underlinePosition - post.underlineThickness) / 2);
        this.fontMetrics.setUnderlineThickness(post.underlineThickness);
        this.fontMetrics.setStrikeoutPosition(os_2.yStrikeoutPosition);
        this.fontMetrics.setStrikeoutSize(os_2.yStrikeoutSize);
        this.fontMetrics.setSubscriptOffset(-os_2.ySubscriptYOffset);
        this.fontMetrics.setSubscriptSize(os_2.ySubscriptYSize);
        this.fontMetrics.setSuperscriptOffset(os_2.ySuperscriptYOffset);
        this.fontMetrics.setSuperscriptSize(os_2.ySuperscriptYSize);
        this.fontMetrics.setIsFixedPitch(post.isFixedPitch);
        String[][] ttfVersion = this.fontNames.getNames(5);
        if (ttfVersion != null) {
            this.fontIdentification.setTtfVersion(ttfVersion[0][3]);
        }
        if ((ttfUniqueId = this.fontNames.getNames(3)) != null) {
            this.fontIdentification.setTtfVersion(ttfUniqueId[0][3]);
        }
        byte[] pdfPanose = new byte[12];
        pdfPanose[1] = (byte)os_2.sFamilyClass;
        pdfPanose[0] = (byte)(os_2.sFamilyClass >> 8);
        System.arraycopy(os_2.panose, 0, pdfPanose, 2, 10);
        this.fontIdentification.setPanose(pdfPanose);
        Map<Integer, int[]> cmap = this.getActiveCmap();
        int[] glyphWidths = this.fontParser.getGlyphWidthsByIndex();
        int numOfGlyphs = this.fontMetrics.getNumberOfGlyphs();
        this.unicodeToGlyph = new LinkedHashMap(cmap.size());
        this.codeToGlyph = new LinkedHashMap(numOfGlyphs);
        this.avgWidth = 0;
        CFFFontSubset cffFontSubset = null;
        if (this.isCff()) {
            cffFontSubset = new CFFFontSubset(this.getFontStreamBytes());
        }
        for (int charCode : cmap.keySet()) {
            Glyph glyph;
            int cid;
            int[] glyphBBox;
            int index = cmap.get(charCode)[0];
            if (index >= numOfGlyphs) continue;
            int[] nArray = glyphBBox = this.bBoxes != null && index < this.bBoxes.length ? this.bBoxes[index] : null;
            if (cffFontSubset != null && cffFontSubset.isCID()) {
                cid = cffFontSubset.getCidForGlyphId(index);
                GidAwareGlyph cffGlyph = new GidAwareGlyph(cid, glyphWidths[index], charCode, glyphBBox);
                cffGlyph.setGid(index);
                glyph = cffGlyph;
            } else {
                cid = index;
                glyph = new Glyph(cid, glyphWidths[index], charCode, glyphBBox);
            }
            this.unicodeToGlyph.put(charCode, glyph);
            if (!this.codeToGlyph.containsKey(cid)) {
                this.codeToGlyph.put(cid, glyph);
            }
            this.avgWidth += glyph.getWidth();
        }
        this.fixSpaceIssue();
        for (int index = 0; index < glyphWidths.length; ++index) {
            if (this.codeToGlyph.containsKey(index)) continue;
            Glyph glyph = new Glyph(index, glyphWidths[index], -1);
            this.codeToGlyph.put(index, glyph);
            this.avgWidth += glyph.getWidth();
        }
        if (!this.codeToGlyph.isEmpty()) {
            this.avgWidth /= this.codeToGlyph.size();
        }
        this.readGdefTable();
        this.readGsubTable();
        this.readGposTable();
        this.isVertical = false;
    }

    public String[] getCodePagesSupported() {
        long cp = ((long)this.fontParser.getOs_2Table().ulCodePageRange2 << 32) + ((long)this.fontParser.getOs_2Table().ulCodePageRange1 & 0xFFFFFFFFL);
        int count = 0;
        long bit = 1L;
        for (int k = 0; k < 64; ++k) {
            if ((cp & bit) != 0L && TrueTypeCodePages.get(k) != null) {
                ++count;
            }
            bit <<= 1;
        }
        String[] ret = new String[count];
        count = 0;
        bit = 1L;
        for (int k = 0; k < 64; ++k) {
            if ((cp & bit) != 0L && TrueTypeCodePages.get(k) != null) {
                ret[count++] = TrueTypeCodePages.get(k);
            }
            bit <<= 1;
        }
        return ret;
    }

    @Override
    public boolean isBuiltWith(String fontProgram) {
        return Objects.equals(this.fontParser.fileName, fontProgram);
    }

    public void close() throws IOException {
        if (this.fontParser != null) {
            this.fontParser.close();
        }
        this.fontParser = null;
    }

    public void updateUsedGlyphs(SortedSet<Integer> usedGlyphs, boolean subset, List<int[]> subsetRanges) {
        int[] compactRange = TrueTypeFont.toCompactRange(subsetRanges, subset);
        Set<Integer> missingGlyphs = TrueTypeFont.getMissingGlyphs(compactRange);
        for (Integer glyphId : missingGlyphs) {
            if (this.getGlyphByCode(glyphId) == null) continue;
            usedGlyphs.add((int)glyphId);
        }
    }

    public void updateUsedGlyphs(Map<Integer, Glyph> usedGlyphs, boolean subset, List<int[]> subsetRanges) {
        int[] compactRange = TrueTypeFont.toCompactRange(subsetRanges, subset);
        Set<Integer> missingGlyphs = TrueTypeFont.getMissingGlyphs(compactRange);
        for (Integer glyphId : missingGlyphs) {
            Glyph glyph = this.getGlyphByCode(glyphId);
            if (glyph == null || usedGlyphs.containsKey((int)glyphId)) continue;
            usedGlyphs.put((int)glyphId, glyph);
        }
    }

    private static int[] toCompactRange(List<int[]> ranges, boolean subset) {
        if (ranges == null) {
            if (subset) {
                return new int[0];
            }
            return new int[]{0, 65535};
        }
        ArrayList<int[]> simp = new ArrayList<int[]>();
        for (int[] range : ranges) {
            for (int j = 0; j < range.length; j += 2) {
                simp.add(new int[]{Math.max(0, Math.min(range[j], range[j + 1])), Math.min(65535, Math.max(range[j], range[j + 1]))});
            }
        }
        for (int k1 = 0; k1 < simp.size() - 1; ++k1) {
            for (int k2 = k1 + 1; k2 < simp.size(); ++k2) {
                int[] r2;
                int[] r1 = (int[])simp.get(k1);
                if ((r1[0] < (r2 = (int[])simp.get(k2))[0] || r1[0] > r2[1]) && (r1[1] < r2[0] || r1[0] > r2[1])) continue;
                r1[0] = Math.min(r1[0], r2[0]);
                r1[1] = Math.max(r1[1], r2[1]);
                simp.remove(k2);
                --k2;
            }
        }
        int[] s = new int[simp.size() * 2];
        for (int k = 0; k < simp.size(); ++k) {
            int[] r = (int[])simp.get(k);
            s[k * 2] = r[0];
            s[k * 2 + 1] = r[1];
        }
        return s;
    }

    private static Set<Integer> getMissingGlyphs(int[] compactRange) {
        HashSet<Integer> missingGlyphs = new HashSet<Integer>();
        for (int k = 0; k < compactRange.length; k += 2) {
            int from = compactRange[k];
            int to = compactRange[k + 1];
            for (int glyphId = from; glyphId <= to; ++glyphId) {
                missingGlyphs.add(glyphId);
            }
        }
        return missingGlyphs;
    }
}

