/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.codec.brotli.dec;

import com.itextpdf.io.codec.brotli.dec.Utils;
import java.nio.ByteBuffer;

final class Transform {
    static final int NUM_RFC_TRANSFORMS = 121;
    static final Transforms RFC_TRANSFORMS = new Transforms(121, 167, 50);
    private static final int OMIT_FIRST_LAST_LIMIT = 9;
    private static final int IDENTITY = 0;
    private static final int OMIT_LAST_BASE = 0;
    private static final int UPPERCASE_FIRST = 10;
    private static final int UPPERCASE_ALL = 11;
    private static final int OMIT_FIRST_BASE = 11;
    private static final int SHIFT_FIRST = 21;
    private static final int SHIFT_ALL = 22;
    private static final String PREFIX_SUFFIX_SRC = "# #s #, #e #.# the #.com/#\u00c2\u00a0# of # and # in # to #\"#\">#\n#]# for # a # that #. # with #'# from # by #. The # on # as # is #ing #\n\t#:#ed #(# at #ly #=\"# of the #. This #,# not #er #al #='#ful #ive #less #est #ize #ous #";
    private static final String TRANSFORMS_SRC = "     !! ! ,  *!  &!  \" !  ) *   * -  ! # !  #!*!  +  ,$ !  -  %  .  / #   0  1 .  \"   2  3!*   4%  ! # /   5  6  7  8 0  1 &   $   9 +   :  ;  < '  !=  >  ?! 4  @ 4  2  &   A *# (   B  C& ) %  ) !*# *-% A +! *.  D! %'  & E *6  F  G% ! *A *%  H! D  I!+!  J!+   K +- *4! A  L!*4  M  N +6  O!*% +.! K *G  P +%(  ! G *D +D  Q +# *K!*G!+D!+# +G +A +4!+% +K!+4!*D!+K!*K";

    Transform() {
    }

    private static void unpackTransforms(byte[] prefixSuffix, int[] prefixSuffixHeads, int[] transforms, String prefixSuffixSrc, String transformsSrc) {
        int i;
        int[] prefixSuffixBytes = Utils.toUtf8Runes(prefixSuffixSrc);
        int n = prefixSuffixBytes.length;
        int index = 1;
        int j = 0;
        for (i = 0; i < n; ++i) {
            int c = prefixSuffixBytes[i];
            if (c == 35) {
                prefixSuffixHeads[index++] = j;
                continue;
            }
            prefixSuffix[j++] = (byte)c;
        }
        for (i = 0; i < 363; ++i) {
            transforms[i] = transformsSrc.charAt(i) - 32;
        }
    }

    static int transformDictionaryWord(byte[] dst, int dstOffset, ByteBuffer src, int srcOffset, int wordLen, Transforms transforms, int transformIndex) {
        int offset = dstOffset;
        int[] triplets = transforms.triplets;
        byte[] prefixSuffixStorage = transforms.prefixSuffixStorage;
        int[] prefixSuffixHeads = transforms.prefixSuffixHeads;
        int transformOffset = 3 * transformIndex;
        int prefixIdx = triplets[transformOffset];
        int transformType = triplets[transformOffset + 1];
        int suffixIdx = triplets[transformOffset + 2];
        int prefix = prefixSuffixHeads[prefixIdx];
        int prefixEnd = prefixSuffixHeads[prefixIdx + 1];
        int suffix = prefixSuffixHeads[suffixIdx];
        int suffixEnd = prefixSuffixHeads[suffixIdx + 1];
        int omitFirst = transformType - 11;
        int omitLast = transformType - 0;
        if (omitFirst < 1 || omitFirst > 9) {
            omitFirst = 0;
        }
        if (omitLast < 1 || omitLast > 9) {
            omitLast = 0;
        }
        while (prefix != prefixEnd) {
            dst[offset++] = prefixSuffixStorage[prefix++];
        }
        int len = wordLen;
        if (omitFirst > len) {
            omitFirst = len;
        }
        int dictOffset = srcOffset + omitFirst;
        len -= omitFirst;
        for (int i = len -= omitLast; i > 0; --i) {
            dst[offset++] = src.get(dictOffset++);
        }
        if (transformType == 10 || transformType == 11) {
            int uppercaseOffset = offset - len;
            if (transformType == 10) {
                len = 1;
            }
            while (len > 0) {
                int c0 = dst[uppercaseOffset] & 0xFF;
                if (c0 < 192) {
                    if (c0 >= 97 && c0 <= 122) {
                        dst[uppercaseOffset] = (byte)(dst[uppercaseOffset] ^ 0x20);
                    }
                    ++uppercaseOffset;
                    --len;
                    continue;
                }
                if (c0 < 224) {
                    dst[uppercaseOffset + 1] = (byte)(dst[uppercaseOffset + 1] ^ 0x20);
                    uppercaseOffset += 2;
                    len -= 2;
                    continue;
                }
                dst[uppercaseOffset + 2] = (byte)(dst[uppercaseOffset + 2] ^ 5);
                uppercaseOffset += 3;
                len -= 3;
            }
        } else if (transformType == 21 || transformType == 22) {
            int shiftOffset = offset - len;
            short param = transforms.params[transformIndex];
            int scalar = (param & Short.MAX_VALUE) + (0x1000000 - (param & 0x8000));
            while (len > 0) {
                int step = 1;
                int c0 = dst[shiftOffset] & 0xFF;
                if (c0 < 128) {
                    dst[shiftOffset] = (byte)((scalar += c0) & 0x7F);
                } else if (c0 >= 192) {
                    byte c2;
                    byte c1;
                    if (c0 < 224) {
                        if (len >= 2) {
                            c1 = dst[shiftOffset + 1];
                            dst[shiftOffset] = (byte)(0xC0 | (scalar += c1 & 0x3F | (c0 & 0x1F) << 6) >> 6 & 0x1F);
                            dst[shiftOffset + 1] = (byte)(c1 & 0xC0 | scalar & 0x3F);
                            step = 2;
                        } else {
                            step = len;
                        }
                    } else if (c0 < 240) {
                        if (len >= 3) {
                            c1 = dst[shiftOffset + 1];
                            c2 = dst[shiftOffset + 2];
                            dst[shiftOffset] = (byte)(0xE0 | (scalar += c2 & 0x3F | (c1 & 0x3F) << 6 | (c0 & 0xF) << 12) >> 12 & 0xF);
                            dst[shiftOffset + 1] = (byte)(c1 & 0xC0 | scalar >> 6 & 0x3F);
                            dst[shiftOffset + 2] = (byte)(c2 & 0xC0 | scalar & 0x3F);
                            step = 3;
                        } else {
                            step = len;
                        }
                    } else if (c0 < 248) {
                        if (len >= 4) {
                            c1 = dst[shiftOffset + 1];
                            c2 = dst[shiftOffset + 2];
                            byte c3 = dst[shiftOffset + 3];
                            dst[shiftOffset] = (byte)(0xF0 | (scalar += c3 & 0x3F | (c2 & 0x3F) << 6 | (c1 & 0x3F) << 12 | (c0 & 7) << 18) >> 18 & 7);
                            dst[shiftOffset + 1] = (byte)(c1 & 0xC0 | scalar >> 12 & 0x3F);
                            dst[shiftOffset + 2] = (byte)(c2 & 0xC0 | scalar >> 6 & 0x3F);
                            dst[shiftOffset + 3] = (byte)(c3 & 0xC0 | scalar & 0x3F);
                            step = 4;
                        } else {
                            step = len;
                        }
                    }
                }
                shiftOffset += step;
                len -= step;
                if (transformType != 21) continue;
                len = 0;
            }
        }
        while (suffix != suffixEnd) {
            dst[offset++] = prefixSuffixStorage[suffix++];
        }
        return offset - dstOffset;
    }

    static {
        Transform.unpackTransforms(Transform.RFC_TRANSFORMS.prefixSuffixStorage, Transform.RFC_TRANSFORMS.prefixSuffixHeads, Transform.RFC_TRANSFORMS.triplets, PREFIX_SUFFIX_SRC, TRANSFORMS_SRC);
    }

    static final class Transforms {
        final int numTransforms;
        final int[] triplets;
        final byte[] prefixSuffixStorage;
        final int[] prefixSuffixHeads;
        final short[] params;

        Transforms(int numTransforms, int prefixSuffixLen, int prefixSuffixCount) {
            this.numTransforms = numTransforms;
            this.triplets = new int[numTransforms * 3];
            this.params = new short[numTransforms];
            this.prefixSuffixStorage = new byte[prefixSuffixLen];
            this.prefixSuffixHeads = new int[prefixSuffixCount + 1];
        }
    }
}

