/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.codec.brotli.dec;

import com.itextpdf.io.codec.brotli.dec.BitReader;
import com.itextpdf.io.codec.brotli.dec.Context;
import com.itextpdf.io.codec.brotli.dec.Dictionary;
import com.itextpdf.io.codec.brotli.dec.Huffman;
import com.itextpdf.io.codec.brotli.dec.State;
import com.itextpdf.io.codec.brotli.dec.Transform;
import com.itextpdf.io.codec.brotli.dec.Utils;
import java.nio.ByteBuffer;

final class Decode {
    static final int MIN_LARGE_WINDOW_BITS = 10;
    static final int MAX_LARGE_WINDOW_BITS = 30;
    private static final int UNINITIALIZED = 0;
    private static final int INITIALIZED = 1;
    private static final int BLOCK_START = 2;
    private static final int COMPRESSED_BLOCK_START = 3;
    private static final int MAIN_LOOP = 4;
    private static final int READ_METADATA = 5;
    private static final int COPY_UNCOMPRESSED = 6;
    private static final int INSERT_LOOP = 7;
    private static final int COPY_LOOP = 8;
    private static final int USE_DICTIONARY = 9;
    private static final int FINISHED = 10;
    private static final int CLOSED = 11;
    private static final int INIT_WRITE = 12;
    private static final int WRITE = 13;
    private static final int COPY_FROM_COMPOUND_DICTIONARY = 14;
    private static final int DEFAULT_CODE_LENGTH = 8;
    private static final int CODE_LENGTH_REPEAT_CODE = 16;
    private static final int NUM_LITERAL_CODES = 256;
    private static final int NUM_COMMAND_CODES = 704;
    private static final int NUM_BLOCK_LENGTH_CODES = 26;
    private static final int LITERAL_CONTEXT_BITS = 6;
    private static final int DISTANCE_CONTEXT_BITS = 2;
    private static final int CD_BLOCK_MAP_BITS = 8;
    private static final int HUFFMAN_TABLE_BITS = 8;
    private static final int HUFFMAN_TABLE_MASK = 255;
    static final int[] MAX_HUFFMAN_TABLE_SIZE = new int[]{256, 402, 436, 468, 500, 534, 566, 598, 630, 662, 694, 726, 758, 790, 822, 854, 886, 920, 952, 984, 1016, 1048, 1080};
    private static final int HUFFMAN_TABLE_SIZE_26 = 396;
    private static final int HUFFMAN_TABLE_SIZE_258 = 632;
    private static final int CODE_LENGTH_CODES = 18;
    private static final int[] CODE_LENGTH_CODE_ORDER = new int[]{1, 2, 3, 4, 0, 5, 17, 6, 16, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int NUM_DISTANCE_SHORT_CODES = 16;
    private static final int[] DISTANCE_SHORT_CODE_INDEX_OFFSET = new int[]{0, 3, 2, 1, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3};
    private static final int[] DISTANCE_SHORT_CODE_VALUE_OFFSET = new int[]{0, 0, 0, 0, -1, 1, -2, 2, -3, 3, -1, 1, -2, 2, -3, 3};
    private static final int[] FIXED_TABLE = new int[]{131072, 131076, 131075, 196610, 131072, 131076, 131075, 262145, 131072, 131076, 131075, 196610, 131072, 131076, 131075, 262149};
    static final int MAX_TRANSFORMED_WORD_LENGTH = 37;
    private static final int MAX_DISTANCE_BITS = 24;
    private static final int MAX_LARGE_WINDOW_DISTANCE_BITS = 62;
    private static final int MAX_ALLOWED_DISTANCE = 0x7FFFFFFC;
    static final int[] BLOCK_LENGTH_OFFSET = new int[]{1, 5, 9, 13, 17, 25, 33, 41, 49, 65, 81, 97, 113, 145, 177, 209, 241, 305, 369, 497, 753, 1265, 2289, 4337, 8433, 16625};
    static final int[] BLOCK_LENGTH_N_BITS = new int[]{2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 24};
    static final short[] INSERT_LENGTH_N_BITS = new short[]{0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 12, 14, 24};
    static final short[] COPY_LENGTH_N_BITS = new short[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 24};
    static final short[] CMD_LOOKUP = new short[2816];

    Decode() {
    }

    private static int log2floor(int i) {
        int result = -1;
        int v = i;
        for (int step = 16; step > 0; step >>= 1) {
            int next = v >> step;
            if (next == 0) continue;
            result += step;
            v = next;
        }
        return result + v;
    }

    private static int calculateDistanceAlphabetSize(int npostfix, int ndirect, int maxndistbits) {
        return 16 + ndirect + 2 * (maxndistbits << npostfix);
    }

    private static int calculateDistanceAlphabetLimit(State s, int maxDistance, int npostfix, int ndirect) {
        if (maxDistance < ndirect + (2 << npostfix)) {
            return Utils.makeError(s, -23);
        }
        int offset = (maxDistance - ndirect >> npostfix) + 4;
        int ndistbits = Decode.log2floor(offset) - 1;
        int group = ndistbits - 1 << 1 | offset >> ndistbits & 1;
        return (group - 1 << npostfix) + (1 << npostfix) + ndirect + 16;
    }

    private static void unpackCommandLookupTable(short[] cmdLookup) {
        int[] insertLengthOffsets = new int[24];
        int[] copyLengthOffsets = new int[24];
        copyLengthOffsets[0] = 2;
        for (int i = 0; i < 23; ++i) {
            insertLengthOffsets[i + 1] = insertLengthOffsets[i] + (1 << INSERT_LENGTH_N_BITS[i]);
            copyLengthOffsets[i + 1] = copyLengthOffsets[i] + (1 << COPY_LENGTH_N_BITS[i]);
        }
        for (int cmdCode = 0; cmdCode < 704; ++cmdCode) {
            int rangeIdx = cmdCode >> 6;
            int distanceContextOffset = -4;
            if (rangeIdx >= 2) {
                rangeIdx -= 2;
                distanceContextOffset = 0;
            }
            int insertCode = (170064 >> rangeIdx * 2 & 3) << 3 | cmdCode >> 3 & 7;
            int copyCode = (156228 >> rangeIdx * 2 & 3) << 3 | cmdCode & 7;
            int copyLengthOffset = copyLengthOffsets[copyCode];
            int distanceContext = distanceContextOffset + Utils.min(copyLengthOffset, 5) - 2;
            int index = cmdCode * 4;
            cmdLookup[index + 0] = (short)(INSERT_LENGTH_N_BITS[insertCode] | COPY_LENGTH_N_BITS[copyCode] << 8);
            cmdLookup[index + 1] = (short)insertLengthOffsets[insertCode];
            cmdLookup[index + 2] = (short)copyLengthOffsets[copyCode];
            cmdLookup[index + 3] = (short)distanceContext;
        }
    }

    private static int decodeWindowBits(State s) {
        int largeWindowEnabled = s.isLargeWindow;
        s.isLargeWindow = 0;
        BitReader.fillBitWindow(s);
        if (BitReader.readFewBits(s, 1) == 0) {
            return 16;
        }
        int n = BitReader.readFewBits(s, 3);
        if (n != 0) {
            return 17 + n;
        }
        n = BitReader.readFewBits(s, 3);
        if (n != 0) {
            if (n == 1) {
                if (largeWindowEnabled == 0) {
                    return -1;
                }
                s.isLargeWindow = 1;
                if (BitReader.readFewBits(s, 1) == 1) {
                    return -1;
                }
                n = BitReader.readFewBits(s, 6);
                if (n < 10 || n > 30) {
                    return -1;
                }
                return n;
            }
            return 8 + n;
        }
        return 17;
    }

    static int enableEagerOutput(State s) {
        if (s.runningState != 1) {
            return Utils.makeError(s, -24);
        }
        s.isEager = 1;
        return 0;
    }

    static int enableLargeWindow(State s) {
        if (s.runningState != 1) {
            return Utils.makeError(s, -24);
        }
        s.isLargeWindow = 1;
        return 0;
    }

    static int attachDictionaryChunk(State s, byte[] data) {
        if (s.runningState != 1) {
            return Utils.makeError(s, -24);
        }
        if (s.cdNumChunks == 0) {
            s.cdChunks = new byte[16][];
            s.cdChunkOffsets = new int[16];
            s.cdBlockBits = -1;
        }
        if (s.cdNumChunks == 15) {
            return Utils.makeError(s, -27);
        }
        s.cdChunks[s.cdNumChunks] = data;
        ++s.cdNumChunks;
        s.cdTotalSize += data.length;
        s.cdChunkOffsets[s.cdNumChunks] = s.cdTotalSize;
        return 0;
    }

    static int initState(State s) {
        if (s.runningState != 0) {
            return Utils.makeError(s, -26);
        }
        s.blockTrees = new int[3091];
        s.blockTrees[0] = 7;
        s.distRbIdx = 3;
        int result = Decode.calculateDistanceAlphabetLimit(s, 0x7FFFFFFC, 3, 120);
        if (result < 0) {
            return result;
        }
        int maxDistanceAlphabetLimit = result;
        s.distExtraBits = new byte[maxDistanceAlphabetLimit];
        s.distOffset = new int[maxDistanceAlphabetLimit];
        result = BitReader.initBitReader(s);
        if (result < 0) {
            return result;
        }
        s.runningState = 1;
        return 0;
    }

    static int close(State s) {
        if (s.runningState == 0) {
            return Utils.makeError(s, -25);
        }
        if (s.runningState > 0) {
            s.runningState = 11;
        }
        return 0;
    }

    private static int decodeVarLenUnsignedByte(State s) {
        BitReader.fillBitWindow(s);
        if (BitReader.readFewBits(s, 1) != 0) {
            int n = BitReader.readFewBits(s, 3);
            if (n == 0) {
                return 1;
            }
            return BitReader.readFewBits(s, n) + (1 << n);
        }
        return 0;
    }

    private static int decodeMetaBlockLength(State s) {
        BitReader.fillBitWindow(s);
        s.inputEnd = BitReader.readFewBits(s, 1);
        s.metaBlockLength = 0;
        s.isUncompressed = 0;
        s.isMetadata = 0;
        if (s.inputEnd != 0 && BitReader.readFewBits(s, 1) != 0) {
            return 0;
        }
        int sizeNibbles = BitReader.readFewBits(s, 2) + 4;
        if (sizeNibbles == 7) {
            s.isMetadata = 1;
            if (BitReader.readFewBits(s, 1) != 0) {
                return Utils.makeError(s, -6);
            }
            int sizeBytes = BitReader.readFewBits(s, 2);
            if (sizeBytes == 0) {
                return 0;
            }
            for (int i = 0; i < sizeBytes; ++i) {
                BitReader.fillBitWindow(s);
                int bits = BitReader.readFewBits(s, 8);
                if (bits == 0 && i + 1 == sizeBytes && sizeBytes > 1) {
                    return Utils.makeError(s, -8);
                }
                s.metaBlockLength += bits << i * 8;
            }
        } else {
            for (int i = 0; i < sizeNibbles; ++i) {
                BitReader.fillBitWindow(s);
                int bits = BitReader.readFewBits(s, 4);
                if (bits == 0 && i + 1 == sizeNibbles && sizeNibbles > 4) {
                    return Utils.makeError(s, -8);
                }
                s.metaBlockLength += bits << i * 4;
            }
        }
        ++s.metaBlockLength;
        if (s.inputEnd == 0) {
            s.isUncompressed = BitReader.readFewBits(s, 1);
        }
        return 0;
    }

    private static int readSymbol(int[] tableGroup, int tableIdx, State s) {
        int offset = tableGroup[tableIdx];
        int v = BitReader.peekBits(s);
        int bits = tableGroup[offset += v & 0xFF] >> 16;
        int sym = tableGroup[offset] & 0xFFFF;
        if (bits <= 8) {
            s.bitOffset += bits;
            return sym;
        }
        offset += sym;
        int mask = (1 << bits) - 1;
        s.bitOffset += (tableGroup[offset += Utils.shr32(v & mask, 8)] >> 16) + 8;
        return tableGroup[offset] & 0xFFFF;
    }

    private static int readBlockLength(int[] tableGroup, int tableIdx, State s) {
        BitReader.fillBitWindow(s);
        int code = Decode.readSymbol(tableGroup, tableIdx, s);
        int n = BLOCK_LENGTH_N_BITS[code];
        BitReader.fillBitWindow(s);
        return BLOCK_LENGTH_OFFSET[code] + BitReader.readBits(s, n);
    }

    private static void moveToFront(int[] v, int index) {
        int i;
        int value = v[i];
        for (i = index; i > 0; --i) {
            v[i] = v[i - 1];
        }
        v[0] = value;
    }

    private static void inverseMoveToFrontTransform(byte[] v, int vLen) {
        int i;
        int[] mtf = new int[256];
        for (i = 0; i < 256; ++i) {
            mtf[i] = i;
        }
        for (i = 0; i < vLen; ++i) {
            int index = v[i] & 0xFF;
            v[i] = (byte)mtf[index];
            if (index == 0) continue;
            Decode.moveToFront(mtf, index);
        }
    }

    private static int readHuffmanCodeLengths(int[] codeLengthCodeLengths, int numSymbols, int[] codeLengths, State s) {
        int symbol = 0;
        int prevCodeLen = 8;
        int repeat = 0;
        int repeatCodeLen = 0;
        int space = 32768;
        int[] table = new int[33];
        int tableIdx = table.length - 1;
        Huffman.buildHuffmanTable(table, tableIdx, 5, codeLengthCodeLengths, 18);
        while (symbol < numSymbols && space > 0) {
            int result;
            if (s.halfOffset > BitReader.HALF_WATERLINE && (result = BitReader.readMoreInput(s)) < 0) {
                return result;
            }
            BitReader.fillBitWindow(s);
            int p = BitReader.peekBits(s) & 0x1F;
            s.bitOffset += table[p] >> 16;
            int codeLen = table[p] & 0xFFFF;
            if (codeLen < 16) {
                repeat = 0;
                codeLengths[symbol++] = codeLen;
                if (codeLen == 0) continue;
                prevCodeLen = codeLen;
                space -= 32768 >> codeLen;
                continue;
            }
            int extraBits = codeLen - 14;
            int newLen = 0;
            if (codeLen == 16) {
                newLen = prevCodeLen;
            }
            if (repeatCodeLen != newLen) {
                repeat = 0;
                repeatCodeLen = newLen;
            }
            int oldRepeat = repeat;
            if (repeat > 0) {
                repeat -= 2;
                repeat <<= extraBits;
            }
            BitReader.fillBitWindow(s);
            int repeatDelta = (repeat += BitReader.readFewBits(s, extraBits) + 3) - oldRepeat;
            if (symbol + repeatDelta > numSymbols) {
                return Utils.makeError(s, -2);
            }
            for (int i = 0; i < repeatDelta; ++i) {
                codeLengths[symbol++] = repeatCodeLen;
            }
            if (repeatCodeLen == 0) continue;
            space -= repeatDelta << 15 - repeatCodeLen;
        }
        if (space != 0) {
            return Utils.makeError(s, -18);
        }
        Utils.fillIntsWithZeroes(codeLengths, symbol, numSymbols);
        return 0;
    }

    private static int checkDupes(State s, int[] symbols, int length) {
        for (int i = 0; i < length - 1; ++i) {
            for (int j = i + 1; j < length; ++j) {
                if (symbols[i] != symbols[j]) continue;
                return Utils.makeError(s, -7);
            }
        }
        return 0;
    }

    private static int readSimpleHuffmanCode(int alphabetSizeMax, int alphabetSizeLimit, int[] tableGroup, int tableIdx, State s) {
        int[] codeLengths = new int[alphabetSizeLimit];
        int[] symbols = new int[4];
        int maxBits = 1 + Decode.log2floor(alphabetSizeMax - 1);
        int numSymbols = BitReader.readFewBits(s, 2) + 1;
        for (int i = 0; i < numSymbols; ++i) {
            BitReader.fillBitWindow(s);
            int symbol = BitReader.readFewBits(s, maxBits);
            if (symbol >= alphabetSizeLimit) {
                return Utils.makeError(s, -15);
            }
            symbols[i] = symbol;
        }
        int result = Decode.checkDupes(s, symbols, numSymbols);
        if (result < 0) {
            return result;
        }
        int histogramId = numSymbols;
        if (numSymbols == 4) {
            histogramId += BitReader.readFewBits(s, 1);
        }
        switch (histogramId) {
            case 1: {
                codeLengths[symbols[0]] = 1;
                break;
            }
            case 2: {
                codeLengths[symbols[0]] = 1;
                codeLengths[symbols[1]] = 1;
                break;
            }
            case 3: {
                codeLengths[symbols[0]] = 1;
                codeLengths[symbols[1]] = 2;
                codeLengths[symbols[2]] = 2;
                break;
            }
            case 4: {
                codeLengths[symbols[0]] = 2;
                codeLengths[symbols[1]] = 2;
                codeLengths[symbols[2]] = 2;
                codeLengths[symbols[3]] = 2;
                break;
            }
            case 5: {
                codeLengths[symbols[0]] = 1;
                codeLengths[symbols[1]] = 2;
                codeLengths[symbols[2]] = 3;
                codeLengths[symbols[3]] = 3;
                break;
            }
        }
        return Huffman.buildHuffmanTable(tableGroup, tableIdx, 8, codeLengths, alphabetSizeLimit);
    }

    private static int readComplexHuffmanCode(int alphabetSizeLimit, int skip, int[] tableGroup, int tableIdx, State s) {
        int[] codeLengths = new int[alphabetSizeLimit];
        int[] codeLengthCodeLengths = new int[18];
        int space = 32;
        int numCodes = 0;
        for (int i = skip; i < 18; ++i) {
            int v;
            int codeLenIdx = CODE_LENGTH_CODE_ORDER[i];
            BitReader.fillBitWindow(s);
            int p = BitReader.peekBits(s) & 0xF;
            s.bitOffset += FIXED_TABLE[p] >> 16;
            codeLengthCodeLengths[codeLenIdx] = v = FIXED_TABLE[p] & 0xFFFF;
            if (v == 0) continue;
            ++numCodes;
            if ((space -= 32 >> v) <= 0) break;
        }
        if (space != 0 && numCodes != 1) {
            return Utils.makeError(s, -4);
        }
        int result = Decode.readHuffmanCodeLengths(codeLengthCodeLengths, alphabetSizeLimit, codeLengths, s);
        if (result < 0) {
            return result;
        }
        return Huffman.buildHuffmanTable(tableGroup, tableIdx, 8, codeLengths, alphabetSizeLimit);
    }

    private static int readHuffmanCode(int alphabetSizeMax, int alphabetSizeLimit, int[] tableGroup, int tableIdx, State s) {
        int result;
        if (s.halfOffset > BitReader.HALF_WATERLINE && (result = BitReader.readMoreInput(s)) < 0) {
            return result;
        }
        BitReader.fillBitWindow(s);
        int simpleCodeOrSkip = BitReader.readFewBits(s, 2);
        if (simpleCodeOrSkip == 1) {
            return Decode.readSimpleHuffmanCode(alphabetSizeMax, alphabetSizeLimit, tableGroup, tableIdx, s);
        }
        return Decode.readComplexHuffmanCode(alphabetSizeLimit, simpleCodeOrSkip, tableGroup, tableIdx, s);
    }

    private static int decodeContextMap(int contextMapSize, byte[] contextMap, State s) {
        int tableIdx;
        int tableSize;
        int[] table;
        int alphabetSize;
        int result;
        if (s.halfOffset > BitReader.HALF_WATERLINE && (result = BitReader.readMoreInput(s)) < 0) {
            return result;
        }
        int numTrees = Decode.decodeVarLenUnsignedByte(s) + 1;
        if (numTrees == 1) {
            Utils.fillBytesWithZeroes(contextMap, 0, contextMapSize);
            return numTrees;
        }
        BitReader.fillBitWindow(s);
        int useRleForZeros = BitReader.readFewBits(s, 1);
        int maxRunLengthPrefix = 0;
        if (useRleForZeros != 0) {
            maxRunLengthPrefix = BitReader.readFewBits(s, 4) + 1;
        }
        if ((result = Decode.readHuffmanCode(alphabetSize = numTrees + maxRunLengthPrefix, alphabetSize, table = new int[(tableSize = MAX_HUFFMAN_TABLE_SIZE[alphabetSize + 31 >> 5]) + 1], tableIdx = table.length - 1, s)) < 0) {
            return result;
        }
        int i = 0;
        while (i < contextMapSize) {
            if (s.halfOffset > BitReader.HALF_WATERLINE && (result = BitReader.readMoreInput(s)) < 0) {
                return result;
            }
            BitReader.fillBitWindow(s);
            int code = Decode.readSymbol(table, tableIdx, s);
            if (code == 0) {
                contextMap[i] = 0;
                ++i;
                continue;
            }
            if (code <= maxRunLengthPrefix) {
                BitReader.fillBitWindow(s);
                for (int reps = (1 << code) + BitReader.readFewBits(s, code); reps != 0; --reps) {
                    if (i >= contextMapSize) {
                        return Utils.makeError(s, -3);
                    }
                    contextMap[i] = 0;
                    ++i;
                }
                continue;
            }
            contextMap[i] = (byte)(code - maxRunLengthPrefix);
            ++i;
        }
        BitReader.fillBitWindow(s);
        if (BitReader.readFewBits(s, 1) == 1) {
            Decode.inverseMoveToFrontTransform(contextMap, contextMapSize);
        }
        return numTrees;
    }

    private static int decodeBlockTypeAndLength(State s, int treeType, int numBlockTypes) {
        int[] ringBuffers = s.rings;
        int offset = 4 + treeType * 2;
        BitReader.fillBitWindow(s);
        int blockType = Decode.readSymbol(s.blockTrees, 2 * treeType, s);
        int result = Decode.readBlockLength(s.blockTrees, 2 * treeType + 1, s);
        blockType = blockType == 1 ? ringBuffers[offset + 1] + 1 : (blockType == 0 ? ringBuffers[offset] : (blockType -= 2));
        if (blockType >= numBlockTypes) {
            blockType -= numBlockTypes;
        }
        ringBuffers[offset] = ringBuffers[offset + 1];
        ringBuffers[offset + 1] = blockType;
        return result;
    }

    private static void decodeLiteralBlockSwitch(State s) {
        s.literalBlockLength = Decode.decodeBlockTypeAndLength(s, 0, s.numLiteralBlockTypes);
        int literalBlockType = s.rings[5];
        s.contextMapSlice = literalBlockType << 6;
        s.literalTreeIdx = s.contextMap[s.contextMapSlice] & 0xFF;
        byte contextMode = s.contextModes[literalBlockType];
        s.contextLookupOffset1 = contextMode << 9;
        s.contextLookupOffset2 = s.contextLookupOffset1 + 256;
    }

    private static void decodeCommandBlockSwitch(State s) {
        s.commandBlockLength = Decode.decodeBlockTypeAndLength(s, 1, s.numCommandBlockTypes);
        s.commandTreeIdx = s.rings[7];
    }

    private static void decodeDistanceBlockSwitch(State s) {
        s.distanceBlockLength = Decode.decodeBlockTypeAndLength(s, 2, s.numDistanceBlockTypes);
        s.distContextMapSlice = s.rings[9] << 2;
    }

    private static void maybeReallocateRingBuffer(State s) {
        int newSize = s.maxRingBufferSize;
        if (newSize > s.expectedTotalSize) {
            int minimalNewSize = s.expectedTotalSize;
            while (newSize >> 1 > minimalNewSize) {
                newSize >>= 1;
            }
            if (s.inputEnd == 0 && newSize < 16384 && s.maxRingBufferSize >= 16384) {
                newSize = 16384;
            }
        }
        if (newSize <= s.ringBufferSize) {
            return;
        }
        int ringBufferSizeWithSlack = newSize + 37;
        byte[] newBuffer = new byte[ringBufferSizeWithSlack];
        byte[] oldBuffer = s.ringBuffer;
        if (oldBuffer.length != 0) {
            Utils.copyBytes(newBuffer, 0, oldBuffer, 0, s.ringBufferSize);
        }
        s.ringBuffer = newBuffer;
        s.ringBufferSize = newSize;
    }

    private static int readNextMetablockHeader(State s) {
        int result;
        if (s.inputEnd != 0) {
            s.nextRunningState = 10;
            s.runningState = 12;
            return 0;
        }
        s.literalTreeGroup = new int[0];
        s.commandTreeGroup = new int[0];
        s.distanceTreeGroup = new int[0];
        if (s.halfOffset > BitReader.HALF_WATERLINE && (result = BitReader.readMoreInput(s)) < 0) {
            return result;
        }
        result = Decode.decodeMetaBlockLength(s);
        if (result < 0) {
            return result;
        }
        if (s.metaBlockLength == 0 && s.isMetadata == 0) {
            return 0;
        }
        if (s.isUncompressed != 0 || s.isMetadata != 0) {
            result = BitReader.jumpToByteBoundary(s);
            if (result < 0) {
                return result;
            }
            s.runningState = s.isMetadata == 0 ? 6 : 5;
        } else {
            s.runningState = 3;
        }
        if (s.isMetadata != 0) {
            return 0;
        }
        s.expectedTotalSize += s.metaBlockLength;
        if (s.expectedTotalSize > 0x40000000) {
            s.expectedTotalSize = 0x40000000;
        }
        if (s.ringBufferSize < s.maxRingBufferSize) {
            Decode.maybeReallocateRingBuffer(s);
        }
        return 0;
    }

    private static int readMetablockPartition(State s, int treeType, int numBlockTypes) {
        int offset = s.blockTrees[2 * treeType];
        if (numBlockTypes <= 1) {
            s.blockTrees[2 * treeType + 1] = offset;
            s.blockTrees[2 * treeType + 2] = offset;
            return 0x10000000;
        }
        int blockTypeAlphabetSize = numBlockTypes + 2;
        int result = Decode.readHuffmanCode(blockTypeAlphabetSize, blockTypeAlphabetSize, s.blockTrees, 2 * treeType, s);
        if (result < 0) {
            return result;
        }
        s.blockTrees[2 * treeType + 1] = offset += result;
        int blockLengthAlphabetSize = 26;
        result = Decode.readHuffmanCode(26, 26, s.blockTrees, 2 * treeType + 1, s);
        if (result < 0) {
            return result;
        }
        s.blockTrees[2 * treeType + 2] = offset += result;
        return Decode.readBlockLength(s.blockTrees, 2 * treeType + 1, s);
    }

    private static void calculateDistanceLut(State s, int alphabetSizeLimit) {
        byte[] distExtraBits = s.distExtraBits;
        int[] distOffset = s.distOffset;
        int npostfix = s.distancePostfixBits;
        int ndirect = s.numDirectDistanceCodes;
        int postfix = 1 << npostfix;
        int bits = 1;
        int half = 0;
        int i = 16;
        for (int j = 0; j < ndirect; ++j) {
            distExtraBits[i] = 0;
            distOffset[i] = j + 1;
            ++i;
        }
        while (i < alphabetSizeLimit) {
            int base = ndirect + ((2 + half << bits) - 4 << npostfix) + 1;
            for (int j = 0; j < postfix; ++j) {
                distExtraBits[i] = (byte)bits;
                distOffset[i] = base + j;
                ++i;
            }
            bits += half;
            half ^= 1;
        }
    }

    private static int readMetablockHuffmanCodesAndContextMaps(State s) {
        int distanceAlphabetSizeMax;
        s.numLiteralBlockTypes = Decode.decodeVarLenUnsignedByte(s) + 1;
        int result = Decode.readMetablockPartition(s, 0, s.numLiteralBlockTypes);
        if (result < 0) {
            return result;
        }
        s.literalBlockLength = result;
        s.numCommandBlockTypes = Decode.decodeVarLenUnsignedByte(s) + 1;
        result = Decode.readMetablockPartition(s, 1, s.numCommandBlockTypes);
        if (result < 0) {
            return result;
        }
        s.commandBlockLength = result;
        s.numDistanceBlockTypes = Decode.decodeVarLenUnsignedByte(s) + 1;
        result = Decode.readMetablockPartition(s, 2, s.numDistanceBlockTypes);
        if (result < 0) {
            return result;
        }
        s.distanceBlockLength = result;
        if (s.halfOffset > BitReader.HALF_WATERLINE && (result = BitReader.readMoreInput(s)) < 0) {
            return result;
        }
        BitReader.fillBitWindow(s);
        s.distancePostfixBits = BitReader.readFewBits(s, 2);
        s.numDirectDistanceCodes = BitReader.readFewBits(s, 4) << s.distancePostfixBits;
        s.contextModes = new byte[s.numLiteralBlockTypes];
        int i = 0;
        while (i < s.numLiteralBlockTypes) {
            int limit = Utils.min(i + 96, s.numLiteralBlockTypes);
            while (i < limit) {
                BitReader.fillBitWindow(s);
                s.contextModes[i] = (byte)BitReader.readFewBits(s, 2);
                ++i;
            }
            if (s.halfOffset <= BitReader.HALF_WATERLINE || (result = BitReader.readMoreInput(s)) >= 0) continue;
            return result;
        }
        int contextMapLength = s.numLiteralBlockTypes << 6;
        s.contextMap = new byte[contextMapLength];
        result = Decode.decodeContextMap(contextMapLength, s.contextMap, s);
        if (result < 0) {
            return result;
        }
        int numLiteralTrees = result;
        s.trivialLiteralContext = 1;
        for (int j = 0; j < contextMapLength; ++j) {
            if (s.contextMap[j] == j >> 6) continue;
            s.trivialLiteralContext = 0;
            break;
        }
        s.distContextMap = new byte[s.numDistanceBlockTypes << 2];
        result = Decode.decodeContextMap(s.numDistanceBlockTypes << 2, s.distContextMap, s);
        if (result < 0) {
            return result;
        }
        int numDistTrees = result;
        s.literalTreeGroup = new int[Decode.huffmanTreeGroupAllocSize(256, numLiteralTrees)];
        result = Decode.decodeHuffmanTreeGroup(256, 256, numLiteralTrees, s, s.literalTreeGroup);
        if (result < 0) {
            return result;
        }
        s.commandTreeGroup = new int[Decode.huffmanTreeGroupAllocSize(704, s.numCommandBlockTypes)];
        result = Decode.decodeHuffmanTreeGroup(704, 704, s.numCommandBlockTypes, s, s.commandTreeGroup);
        if (result < 0) {
            return result;
        }
        int distanceAlphabetSizeLimit = distanceAlphabetSizeMax = Decode.calculateDistanceAlphabetSize(s.distancePostfixBits, s.numDirectDistanceCodes, 24);
        if (s.isLargeWindow == 1) {
            distanceAlphabetSizeMax = Decode.calculateDistanceAlphabetSize(s.distancePostfixBits, s.numDirectDistanceCodes, 62);
            result = Decode.calculateDistanceAlphabetLimit(s, 0x7FFFFFFC, s.distancePostfixBits, s.numDirectDistanceCodes);
            if (result < 0) {
                return result;
            }
            distanceAlphabetSizeLimit = result;
        }
        s.distanceTreeGroup = new int[Decode.huffmanTreeGroupAllocSize(distanceAlphabetSizeLimit, numDistTrees)];
        result = Decode.decodeHuffmanTreeGroup(distanceAlphabetSizeMax, distanceAlphabetSizeLimit, numDistTrees, s, s.distanceTreeGroup);
        if (result < 0) {
            return result;
        }
        Decode.calculateDistanceLut(s, distanceAlphabetSizeLimit);
        s.contextMapSlice = 0;
        s.distContextMapSlice = 0;
        s.contextLookupOffset1 = s.contextModes[0] * 512;
        s.contextLookupOffset2 = s.contextLookupOffset1 + 256;
        s.literalTreeIdx = 0;
        s.commandTreeIdx = 0;
        s.rings[4] = 1;
        s.rings[5] = 0;
        s.rings[6] = 1;
        s.rings[7] = 0;
        s.rings[8] = 1;
        s.rings[9] = 0;
        return 0;
    }

    private static int copyUncompressedData(State s) {
        byte[] ringBuffer = s.ringBuffer;
        if (s.metaBlockLength <= 0) {
            int result = BitReader.reload(s);
            if (result < 0) {
                return result;
            }
            s.runningState = 2;
            return 0;
        }
        int chunkLength = Utils.min(s.ringBufferSize - s.pos, s.metaBlockLength);
        int result = BitReader.copyRawBytes(s, ringBuffer, s.pos, chunkLength);
        if (result < 0) {
            return result;
        }
        s.metaBlockLength -= chunkLength;
        s.pos += chunkLength;
        if (s.pos == s.ringBufferSize) {
            s.nextRunningState = 6;
            s.runningState = 12;
            return 0;
        }
        result = BitReader.reload(s);
        if (result < 0) {
            return result;
        }
        s.runningState = 2;
        return 0;
    }

    private static int writeRingBuffer(State s) {
        int toWrite = Utils.min(s.outputLength - s.outputUsed, s.ringBufferBytesReady - s.ringBufferBytesWritten);
        if (toWrite != 0) {
            Utils.copyBytes(s.output, s.outputOffset + s.outputUsed, s.ringBuffer, s.ringBufferBytesWritten, s.ringBufferBytesWritten + toWrite);
            s.outputUsed += toWrite;
            s.ringBufferBytesWritten += toWrite;
        }
        if (s.outputUsed < s.outputLength) {
            return 0;
        }
        return 2;
    }

    private static int huffmanTreeGroupAllocSize(int alphabetSizeLimit, int n) {
        int maxTableSize = MAX_HUFFMAN_TABLE_SIZE[alphabetSizeLimit + 31 >> 5];
        return n + n * maxTableSize;
    }

    private static int decodeHuffmanTreeGroup(int alphabetSizeMax, int alphabetSizeLimit, int n, State s, int[] group) {
        int next = n;
        for (int i = 0; i < n; ++i) {
            group[i] = next;
            int result = Decode.readHuffmanCode(alphabetSizeMax, alphabetSizeLimit, group, i, s);
            if (result < 0) {
                return result;
            }
            next += result;
        }
        return 0;
    }

    private static int calculateFence(State s) {
        int result = s.ringBufferSize;
        if (s.isEager != 0) {
            result = Utils.min(result, s.ringBufferBytesWritten + s.outputLength - s.outputUsed);
        }
        return result;
    }

    private static int doUseDictionary(State s, int fence) {
        if (s.distance > 0x7FFFFFFC) {
            return Utils.makeError(s, -9);
        }
        int address = s.distance - s.maxDistance - 1 - s.cdTotalSize;
        if (address < 0) {
            int result = Decode.initializeCompoundDictionaryCopy(s, -address - 1, s.copyLength);
            if (result < 0) {
                return result;
            }
            s.runningState = 14;
        } else {
            ByteBuffer dictionaryData = Dictionary.getData();
            int wordLength = s.copyLength;
            if (wordLength > 31) {
                return Utils.makeError(s, -9);
            }
            int shift = Dictionary.sizeBits[wordLength];
            if (shift == 0) {
                return Utils.makeError(s, -9);
            }
            int offset = Dictionary.offsets[wordLength];
            int mask = (1 << shift) - 1;
            int wordIdx = address & mask;
            int transformIdx = address >> shift;
            offset += wordIdx * wordLength;
            Transform.Transforms transforms = Transform.RFC_TRANSFORMS;
            if (transformIdx >= transforms.numTransforms) {
                return Utils.makeError(s, -9);
            }
            int len = Transform.transformDictionaryWord(s.ringBuffer, s.pos, dictionaryData, offset, wordLength, transforms, transformIdx);
            s.pos += len;
            s.metaBlockLength -= len;
            if (s.pos >= fence) {
                s.nextRunningState = 4;
                s.runningState = 12;
                return 0;
            }
            s.runningState = 4;
        }
        return 0;
    }

    private static void initializeCompoundDictionary(State s) {
        s.cdBlockMap = new byte[256];
        int blockBits = 8;
        while (s.cdTotalSize - 1 >> blockBits != 0) {
            ++blockBits;
        }
        s.cdBlockBits = blockBits -= 8;
        int index = 0;
        for (int cursor = 0; cursor < s.cdTotalSize; cursor += 1 << blockBits) {
            while (s.cdChunkOffsets[index + 1] < cursor) {
                ++index;
            }
            s.cdBlockMap[cursor >> blockBits] = (byte)index;
        }
    }

    private static int initializeCompoundDictionaryCopy(State s, int address, int length) {
        if (s.cdBlockBits == -1) {
            Decode.initializeCompoundDictionary(s);
        }
        int index = s.cdBlockMap[address >> s.cdBlockBits];
        while (address >= s.cdChunkOffsets[index + 1]) {
            ++index;
        }
        if (s.cdTotalSize > address + length) {
            return Utils.makeError(s, -9);
        }
        s.distRbIdx = s.distRbIdx + 1 & 3;
        s.rings[s.distRbIdx] = s.distance;
        s.metaBlockLength -= length;
        s.cdBrIndex = index;
        s.cdBrOffset = address - s.cdChunkOffsets[index];
        s.cdBrLength = length;
        s.cdBrCopied = 0;
        return 0;
    }

    private static int copyFromCompoundDictionary(State s, int fence) {
        int pos;
        int origPos = pos = s.pos;
        while (s.cdBrLength != s.cdBrCopied) {
            int space = fence - pos;
            int length = s.cdBrLength - s.cdBrCopied;
            int chunkLength = s.cdChunkOffsets[s.cdBrIndex + 1] - s.cdChunkOffsets[s.cdBrIndex];
            int remChunkLength = chunkLength - s.cdBrOffset;
            if (length > remChunkLength) {
                length = remChunkLength;
            }
            if (length > space) {
                length = space;
            }
            Utils.copyBytes(s.ringBuffer, pos, s.cdChunks[s.cdBrIndex], s.cdBrOffset, s.cdBrOffset + length);
            pos += length;
            s.cdBrOffset += length;
            s.cdBrCopied += length;
            if (length == remChunkLength) {
                ++s.cdBrIndex;
                s.cdBrOffset = 0;
            }
            if (pos < fence) continue;
            break;
        }
        return pos - origPos;
    }

    /*
     * Unable to fully structure code
     */
    static int decompress(State s) {
        if (s.runningState == 0) {
            return Utils.makeError(s, -25);
        }
        if (s.runningState < 0) {
            return Utils.makeError(s, -28);
        }
        if (s.runningState == 11) {
            return Utils.makeError(s, -22);
        }
        if (s.runningState == 1) {
            windowBits = Decode.decodeWindowBits(s);
            if (windowBits == -1) {
                return Utils.makeError(s, -11);
            }
            s.maxRingBufferSize = 1 << windowBits;
            s.maxBackwardDistance = s.maxRingBufferSize - 16;
            s.runningState = 2;
        }
        fence = Decode.calculateFence(s);
        ringBufferMask = s.ringBufferSize - 1;
        ringBuffer = s.ringBuffer;
        block13: while (s.runningState != 10) {
            switch (s.runningState) {
                case 2: {
                    if (s.metaBlockLength < 0) {
                        return Utils.makeError(s, -10);
                    }
                    result = Decode.readNextMetablockHeader(s);
                    if (result < 0) {
                        return result;
                    }
                    fence = Decode.calculateFence(s);
                    ringBufferMask = s.ringBufferSize - 1;
                    ringBuffer = s.ringBuffer;
                    continue block13;
                }
                case 3: {
                    result = Decode.readMetablockHuffmanCodesAndContextMaps(s);
                    if (result < 0) {
                        return result;
                    }
                    s.runningState = 4;
                    continue block13;
                }
                case 4: {
                    if (s.metaBlockLength <= 0) {
                        s.runningState = 2;
                        continue block13;
                    }
                    if (s.halfOffset > BitReader.HALF_WATERLINE && (result = BitReader.readMoreInput(s)) < 0) {
                        return result;
                    }
                    if (s.commandBlockLength == 0) {
                        Decode.decodeCommandBlockSwitch(s);
                    }
                    --s.commandBlockLength;
                    BitReader.fillBitWindow(s);
                    cmdCode = Decode.readSymbol(s.commandTreeGroup, s.commandTreeIdx, s) << 2;
                    insertAndCopyExtraBits = Decode.CMD_LOOKUP[cmdCode];
                    insertLengthOffset = Decode.CMD_LOOKUP[cmdCode + 1];
                    copyLengthOffset = Decode.CMD_LOOKUP[cmdCode + 2];
                    s.distanceCode = Decode.CMD_LOOKUP[cmdCode + 3];
                    BitReader.fillBitWindow(s);
                    insertLengthExtraBits = insertAndCopyExtraBits & 255;
                    s.insertLength = insertLengthOffset + BitReader.readBits(s, insertLengthExtraBits);
                    BitReader.fillBitWindow(s);
                    copyLengthExtraBits = insertAndCopyExtraBits >> 8;
                    s.copyLength = copyLengthOffset + BitReader.readBits(s, copyLengthExtraBits);
                    s.j = 0;
                    s.runningState = 7;
                    continue block13;
                }
                case 7: {
                    if (s.trivialLiteralContext == 0) ** GOTO lbl76
                    while (s.j < s.insertLength) {
                        if (s.halfOffset > BitReader.HALF_WATERLINE && (result = BitReader.readMoreInput(s)) < 0) {
                            return result;
                        }
                        if (s.literalBlockLength == 0) {
                            Decode.decodeLiteralBlockSwitch(s);
                        }
                        --s.literalBlockLength;
                        BitReader.fillBitWindow(s);
                        ringBuffer[s.pos] = (byte)Decode.readSymbol(s.literalTreeGroup, s.literalTreeIdx, s);
                        ++s.pos;
                        ++s.j;
                        if (s.pos < fence) continue;
                        s.nextRunningState = 7;
                        s.runningState = 12;
                        ** GOTO lbl96
                    }
                    ** GOTO lbl96
lbl76:
                    // 1 sources

                    prevByte1 = ringBuffer[s.pos - 1 & ringBufferMask] & 255;
                    prevByte2 = ringBuffer[s.pos - 2 & ringBufferMask] & 255;
                    while (s.j < s.insertLength) {
                        if (s.halfOffset > BitReader.HALF_WATERLINE && (result = BitReader.readMoreInput(s)) < 0) {
                            return result;
                        }
                        if (s.literalBlockLength == 0) {
                            Decode.decodeLiteralBlockSwitch(s);
                        }
                        literalContext = Context.LOOKUP[s.contextLookupOffset1 + prevByte1] | Context.LOOKUP[s.contextLookupOffset2 + prevByte2];
                        literalTreeIdx = s.contextMap[s.contextMapSlice + literalContext] & 255;
                        --s.literalBlockLength;
                        prevByte2 = prevByte1;
                        BitReader.fillBitWindow(s);
                        prevByte1 = Decode.readSymbol(s.literalTreeGroup, literalTreeIdx, s);
                        ringBuffer[s.pos] = (byte)prevByte1;
                        ++s.pos;
                        ++s.j;
                        if (s.pos < fence) continue;
                        s.nextRunningState = 7;
                        s.runningState = 12;
                        break;
                    }
lbl96:
                    // 4 sources

                    if (s.runningState != 7) continue block13;
                    s.metaBlockLength -= s.insertLength;
                    if (s.metaBlockLength <= 0) {
                        s.runningState = 4;
                        continue block13;
                    }
                    distanceCode = s.distanceCode;
                    if (distanceCode < 0) {
                        s.distance = s.rings[s.distRbIdx];
                    } else {
                        if (s.halfOffset > BitReader.HALF_WATERLINE && (result = BitReader.readMoreInput(s)) < 0) {
                            return result;
                        }
                        if (s.distanceBlockLength == 0) {
                            Decode.decodeDistanceBlockSwitch(s);
                        }
                        --s.distanceBlockLength;
                        BitReader.fillBitWindow(s);
                        distTreeIdx = s.distContextMap[s.distContextMapSlice + distanceCode] & 255;
                        distanceCode = Decode.readSymbol(s.distanceTreeGroup, distTreeIdx, s);
                        if (distanceCode < 16) {
                            index = s.distRbIdx + Decode.DISTANCE_SHORT_CODE_INDEX_OFFSET[distanceCode] & 3;
                            s.distance = s.rings[index] + Decode.DISTANCE_SHORT_CODE_VALUE_OFFSET[distanceCode];
                            if (s.distance < 0) {
                                return Utils.makeError(s, -12);
                            }
                        } else {
                            extraBits = s.distExtraBits[distanceCode];
                            if (s.bitOffset + extraBits <= BitReader.BITNESS) {
                                bits = BitReader.readFewBits(s, extraBits);
                            } else {
                                BitReader.fillBitWindow(s);
                                bits = BitReader.readBits(s, extraBits);
                            }
                            s.distance = s.distOffset[distanceCode] + (bits << s.distancePostfixBits);
                        }
                    }
                    s.maxDistance = s.maxDistance != s.maxBackwardDistance && s.pos < s.maxBackwardDistance ? s.pos : s.maxBackwardDistance;
                    if (s.distance > s.maxDistance) {
                        s.runningState = 9;
                        continue block13;
                    }
                    if (distanceCode > 0) {
                        s.distRbIdx = s.distRbIdx + 1 & 3;
                        s.rings[s.distRbIdx] = s.distance;
                    }
                    if (s.copyLength > s.metaBlockLength) {
                        return Utils.makeError(s, -9);
                    }
                    s.j = 0;
                    s.runningState = 8;
                    continue block13;
                }
                case 8: {
                    src = s.pos - s.distance & ringBufferMask;
                    dst = s.pos;
                    copyLength = s.copyLength - s.j;
                    srcEnd = src + copyLength;
                    dstEnd = dst + copyLength;
                    if (srcEnd < ringBufferMask && dstEnd < ringBufferMask) {
                        if (copyLength < 12 || srcEnd > dst && dstEnd > src) {
                            numQuads = copyLength + 3 >> 2;
                            for (k = 0; k < numQuads; ++k) {
                                ringBuffer[dst++] = ringBuffer[src++];
                                ringBuffer[dst++] = ringBuffer[src++];
                                ringBuffer[dst++] = ringBuffer[src++];
                                ringBuffer[dst++] = ringBuffer[src++];
                            }
                        } else {
                            Utils.copyBytesWithin(ringBuffer, dst, src, srcEnd);
                        }
                        s.j += copyLength;
                        s.metaBlockLength -= copyLength;
                        s.pos += copyLength;
                    } else {
                        while (s.j < s.copyLength) {
                            ringBuffer[s.pos] = ringBuffer[s.pos - s.distance & ringBufferMask];
                            --s.metaBlockLength;
                            ++s.pos;
                            ++s.j;
                            if (s.pos < fence) continue;
                            s.nextRunningState = 8;
                            s.runningState = 12;
                            break;
                        }
                    }
                    if (s.runningState != 8) continue block13;
                    s.runningState = 4;
                    continue block13;
                }
                case 9: {
                    result = Decode.doUseDictionary(s, fence);
                    if (result >= 0) continue block13;
                    return result;
                }
                case 14: {
                    s.pos += Decode.copyFromCompoundDictionary(s, fence);
                    if (s.pos >= fence) {
                        s.nextRunningState = 14;
                        s.runningState = 12;
                        return 2;
                    }
                    s.runningState = 4;
                    continue block13;
                }
                case 5: {
                    while (s.metaBlockLength > 0) {
                        if (s.halfOffset > BitReader.HALF_WATERLINE && (result = BitReader.readMoreInput(s)) < 0) {
                            return result;
                        }
                        BitReader.fillBitWindow(s);
                        BitReader.readFewBits(s, 8);
                        --s.metaBlockLength;
                    }
                    s.runningState = 2;
                    continue block13;
                }
                case 6: {
                    result = Decode.copyUncompressedData(s);
                    if (result >= 0) continue block13;
                    return result;
                }
                case 12: {
                    s.ringBufferBytesReady = Utils.min(s.pos, s.ringBufferSize);
                    s.runningState = 13;
                    continue block13;
                }
                case 13: {
                    result = Decode.writeRingBuffer(s);
                    if (result != 0) {
                        return result;
                    }
                    if (s.pos >= s.maxBackwardDistance) {
                        s.maxDistance = s.maxBackwardDistance;
                    }
                    if (s.pos >= s.ringBufferSize) {
                        if (s.pos > s.ringBufferSize) {
                            Utils.copyBytesWithin(ringBuffer, 0, s.ringBufferSize, s.pos);
                        }
                        s.pos &= ringBufferMask;
                        s.ringBufferBytesWritten = 0;
                    }
                    s.runningState = s.nextRunningState;
                    continue block13;
                }
            }
            return Utils.makeError(s, -28);
        }
        if (s.runningState != 10) {
            return Utils.makeError(s, -29);
        }
        if (s.metaBlockLength < 0) {
            return Utils.makeError(s, -10);
        }
        result = BitReader.jumpToByteBoundary(s);
        if (result != 0) {
            return result;
        }
        result = BitReader.checkHealth(s, 1);
        if (result != 0) {
            return result;
        }
        return 1;
    }

    static {
        Decode.unpackCommandLookupTable(CMD_LOOKUP);
    }
}

