/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.form.element.Button;
import com.itextpdf.forms.form.element.CheckBox;
import com.itextpdf.forms.form.element.InputField;
import com.itextpdf.forms.form.element.Radio;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.PlaceholderTagWorker;
import com.itextpdf.html2pdf.attach.util.AlternateDescriptionResolver;
import com.itextpdf.html2pdf.html.AttributeConstants;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputTagWorker
implements ITagWorker,
IDisplayAware {
    private static final Pattern NUMBER_INPUT_ALLOWED_VALUES = Pattern.compile("^(((-?[0-9]+)(\\.[0-9]+)?)|(-?\\.[0-9]+))$");
    private static int radioNameIdx = 0;
    private IElement formElement;
    private String display;

    public InputTagWorker(IElementNode element, ProcessorContext context) {
        String lang = element.getAttribute("lang");
        String inputType = element.getAttribute("type");
        if (!AttributeConstants.INPUT_TYPE_VALUES.contains(inputType)) {
            if (null != inputType && 0 != inputType.length()) {
                Logger logger = LoggerFactory.getLogger(InputTagWorker.class);
                logger.warn(MessageFormatUtil.format((String)"Input type {0} is invalid. The default text type will be used instead.", (Object[])new Object[]{inputType}));
            }
            inputType = "text";
        }
        String value = element.getAttribute("value");
        String name = context.getFormFieldNameResolver().resolveFormName(element.getAttribute("name"));
        if (inputType == null || "text".equals(inputType) || "email".equals(inputType) || "password".equals(inputType) || "number".equals(inputType)) {
            Integer size = CssDimensionParsingUtils.parseInteger((String)element.getAttribute("size"));
            this.formElement = new InputField(name);
            this.formElement.deleteOwnProperty(105);
            value = InputTagWorker.preprocessInputValue(value, inputType);
            String placeholder = element.getAttribute("placeholder");
            if (null != placeholder) {
                Paragraph paragraph = placeholder.isEmpty() ? new Paragraph() : (placeholder.trim().isEmpty() ? new Paragraph("\u00a0") : new Paragraph(placeholder));
                ((InputField)this.formElement).setPlaceholder((Paragraph)paragraph.setMargin(0.0f));
            }
            this.formElement.setProperty(0x200003, (Object)value);
            this.formElement.setProperty(0x200002, (Object)size);
            if ("password".equals(inputType)) {
                this.formElement.setProperty(0x200004, (Object)true);
            }
        } else if ("submit".equals(inputType) || "button".equals(inputType)) {
            this.formElement = new Button(name).setSingleLineValue(value);
        } else if ("checkbox".equals(inputType)) {
            CheckBox cb = new CheckBox(name);
            String checked = element.getAttribute("checked");
            float widthWithBordersOnTheInside = 9.75f;
            float defaultBorderWith = 0.75f;
            cb.setSize(9.75f);
            cb.setBorder((Border)new SolidBorder(ColorConstants.DARK_GRAY, 0.75f));
            cb.setBackgroundColor(ColorConstants.WHITE);
            cb.setChecked(checked != null);
            this.formElement = cb;
        } else if ("radio".equals(inputType)) {
            String radioGroupName = element.getAttribute("name");
            if (radioGroupName == null || radioGroupName.isEmpty()) {
                radioGroupName = "radio" + ++radioNameIdx;
            }
            Radio radio = new Radio(name, radioGroupName);
            SolidBorder border = new SolidBorder(1.0f);
            border.setColor(ColorConstants.LIGHT_GRAY);
            radio.setBorder((Border)border);
            String checked = element.getAttribute("checked");
            if (null != checked) {
                context.getRadioCheckResolver().checkField(radioGroupName, radio);
                radio.setChecked(true);
            }
            this.formElement = radio;
        } else {
            Logger logger = LoggerFactory.getLogger(InputTagWorker.class);
            logger.error(MessageFormatUtil.format((String)"Input type {0} is not supported", (Object[])new Object[]{inputType}));
        }
        if (this.formElement != null) {
            this.formElement.setProperty(0x200001, (Object)(!context.isCreateAcroForm() ? 1 : 0));
            ((IAccessibleElement)this.formElement).getAccessibilityProperties().setLanguage(lang);
            this.formElement.setProperty(0x20000F, (Object)context.getConformance());
            ((AlternateDescriptionResolver)context.getDIContainer().getInstance(AlternateDescriptionResolver.class)).resolve((IAccessibleElement)this.formElement, element);
        }
        this.display = element.getStyles() != null ? (String)element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        return false;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        return childTagWorker instanceof PlaceholderTagWorker && null != ((InputField)this.formElement).getPlaceholder();
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.formElement;
    }

    static String preprocessInputValue(String value, String inputType) {
        if ("number".equals(inputType) && value != null && !NUMBER_INPUT_ALLOWED_VALUES.matcher(value).matches()) {
            value = "";
        }
        return value;
    }
}

