/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.AnonymousInlineBox;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.List;
import com.itextpdf.layout.element.ListItem;
import com.itextpdf.layout.element.MulticolContainer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.node.IElementNode;

public class UlOlTagWorker
implements ITagWorker {
    private List list = new List().setListSymbol("");
    protected MulticolContainer multicolContainer;
    private WaitingInlineElementsHelper inlineHelper;

    public UlOlTagWorker(IElementNode element, ProcessorContext context) {
        Integer startValue;
        if (element.getStyles().get("column-count") != null || element.getStyles().containsKey("column-width")) {
            this.multicolContainer = new MulticolContainer();
            this.multicolContainer.add((IBlockElement)this.list);
        }
        if (element.getAttribute("start") != null && (startValue = CssDimensionParsingUtils.parseInteger((String)element.getAttribute("start"))) != null) {
            this.list.setItemStartIndex(startValue.intValue());
        }
        this.inlineHelper = new WaitingInlineElementsHelper((String)element.getStyles().get("white-space"), (String)element.getStyles().get("text-transform"));
        AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)this.list, element);
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.processUnlabeledListItem();
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        IPropertyContainer child = childTagWorker.getElementResult();
        if (child instanceof ILeafElement) {
            this.inlineHelper.add((ILeafElement)child);
            return true;
        }
        if (childTagWorker instanceof SpanTagWorker) {
            boolean allChildrenProcessed = true;
            for (IPropertyContainer propertyContainer : ((SpanTagWorker)childTagWorker).getAllElements()) {
                if (propertyContainer instanceof ILeafElement) {
                    this.inlineHelper.add((ILeafElement)propertyContainer);
                    continue;
                }
                if (propertyContainer instanceof IBlockElement && "inline-block".equals(((SpanTagWorker)childTagWorker).getElementDisplay(propertyContainer))) {
                    this.inlineHelper.add((IBlockElement)propertyContainer);
                    continue;
                }
                allChildrenProcessed = this.addBlockChild(propertyContainer) && allChildrenProcessed;
            }
            return allChildrenProcessed;
        }
        if (childTagWorker instanceof IDisplayAware && "inline-block".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay()) && childTagWorker.getElementResult() instanceof IBlockElement) {
            this.inlineHelper.add((IBlockElement)childTagWorker.getElementResult());
            return true;
        }
        return this.addBlockChild(child);
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.multicolContainer == null ? this.list : this.multicolContainer;
    }

    private void processUnlabeledListItem() {
        AnonymousInlineBox ab = new AnonymousInlineBox();
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)ab);
        if (ab.getChildren().isEmpty()) {
            return;
        }
        this.addUnlabeledListItem((IBlockElement)ab);
    }

    private void addUnlabeledListItem(IBlockElement item) {
        ListItem li = new ListItem();
        li.add(item);
        li.setProperty(37, null);
        this.list.add(li);
    }

    private boolean addBlockChild(IPropertyContainer child) {
        this.processUnlabeledListItem();
        if (child instanceof ListItem) {
            this.list.add((ListItem)child);
            return true;
        }
        if (child instanceof IBlockElement) {
            this.addUnlabeledListItem((IBlockElement)child);
            return true;
        }
        return false;
    }
}

