/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.TextLayoutResult;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FormFieldValueNonTrimmingTextRenderer
extends TextRenderer {
    private boolean callTrimFirst = false;

    public FormFieldValueNonTrimmingTextRenderer(Text textElement) {
        super(textElement);
    }

    public IRenderer getNextRenderer() {
        return new FormFieldValueNonTrimmingTextRenderer((Text)this.getModelElement());
    }

    public LayoutResult layout(LayoutContext layoutContext) {
        LayoutResult baseLayoutResult = super.layout(layoutContext);
        if (baseLayoutResult instanceof TextLayoutResult && baseLayoutResult.getOverflowRenderer() instanceof FormFieldValueNonTrimmingTextRenderer && !((TextLayoutResult)baseLayoutResult).isSplitForcedByNewline()) {
            ((FormFieldValueNonTrimmingTextRenderer)baseLayoutResult.getOverflowRenderer()).setCallTrimFirst();
        }
        return baseLayoutResult;
    }

    public void trimFirst() {
        if (this.callTrimFirst) {
            super.trimFirst();
        }
    }

    protected TextRenderer createCopy(GlyphLine gl, PdfFont font) {
        if (FormFieldValueNonTrimmingTextRenderer.class != ((Object)((Object)this)).getClass()) {
            Logger logger = LoggerFactory.getLogger(FormFieldValueNonTrimmingTextRenderer.class);
            logger.error(MessageFormatUtil.format((String)"While processing an instance of TextRenderer, iText uses createCopy() to create glyph lines of specific fonts, which represent its parts. So if one extends TextRenderer, one should override createCopy, otherwise if FontSelector related logic is triggered, copies of this TextRenderer will have the default behavior rather than the custom one.", (Object[])new Object[0]));
        }
        FormFieldValueNonTrimmingTextRenderer copy = new FormFieldValueNonTrimmingTextRenderer((Text)this.modelElement);
        copy.setProcessedGlyphLineAndFont(gl, font);
        return copy;
    }

    private void setCallTrimFirst() {
        this.callTrimFirst = true;
    }
}

