/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.barcodes;

import com.itextpdf.barcodes.Barcode2D;
import com.itextpdf.barcodes.dmcode.DmParams;
import com.itextpdf.barcodes.dmcode.Placement;
import com.itextpdf.barcodes.dmcode.ReedSolomon;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class BarcodeDataMatrix
extends Barcode2D {
    public static final int DM_NO_ERROR = 0;
    public static final int DM_ERROR_TEXT_TOO_BIG = 1;
    public static final int DM_ERROR_INVALID_SQUARE = 3;
    public static final int DM_ERROR_EXTENSION = 5;
    public static final int DM_AUTO = 0;
    public static final int DM_ASCII = 1;
    public static final int DM_C40 = 2;
    public static final int DM_TEXT = 3;
    public static final int DM_B256 = 4;
    public static final int DM_X12 = 5;
    public static final int DM_EDIFACT = 6;
    public static final int DM_RAW = 7;
    public static final int DM_EXTENSION = 32;
    public static final int DM_TEST = 64;
    public static final String DEFAULT_DATA_MATRIX_ENCODING = "iso-8859-1";
    private static final byte LATCH_B256 = -25;
    private static final byte LATCH_EDIFACT = -16;
    private static final byte LATCH_X12 = -18;
    private static final byte LATCH_TEXT = -17;
    private static final byte LATCH_C40 = -26;
    private static final byte UNLATCH = -2;
    private static final byte EXTENDED_ASCII = -21;
    private static final byte PADDING = -127;
    private String encoding;
    private static final DmParams[] dmSizes = new DmParams[]{new DmParams(10, 10, 10, 10, 3, 3, 5), new DmParams(12, 12, 12, 12, 5, 5, 7), new DmParams(8, 18, 8, 18, 5, 5, 7), new DmParams(14, 14, 14, 14, 8, 8, 10), new DmParams(8, 32, 8, 16, 10, 10, 11), new DmParams(16, 16, 16, 16, 12, 12, 12), new DmParams(12, 26, 12, 26, 16, 16, 14), new DmParams(18, 18, 18, 18, 18, 18, 14), new DmParams(20, 20, 20, 20, 22, 22, 18), new DmParams(12, 36, 12, 18, 22, 22, 18), new DmParams(22, 22, 22, 22, 30, 30, 20), new DmParams(16, 36, 16, 18, 32, 32, 24), new DmParams(24, 24, 24, 24, 36, 36, 24), new DmParams(26, 26, 26, 26, 44, 44, 28), new DmParams(16, 48, 16, 24, 49, 49, 28), new DmParams(32, 32, 16, 16, 62, 62, 36), new DmParams(36, 36, 18, 18, 86, 86, 42), new DmParams(40, 40, 20, 20, 114, 114, 48), new DmParams(44, 44, 22, 22, 144, 144, 56), new DmParams(48, 48, 24, 24, 174, 174, 68), new DmParams(52, 52, 26, 26, 204, 102, 42), new DmParams(64, 64, 16, 16, 280, 140, 56), new DmParams(72, 72, 18, 18, 368, 92, 36), new DmParams(80, 80, 20, 20, 456, 114, 48), new DmParams(88, 88, 22, 22, 576, 144, 56), new DmParams(96, 96, 24, 24, 696, 174, 68), new DmParams(104, 104, 26, 26, 816, 136, 56), new DmParams(120, 120, 20, 20, 1050, 175, 68), new DmParams(132, 132, 22, 22, 1304, 163, 62), new DmParams(144, 144, 24, 24, 1558, 156, 62)};
    private static final String X12 = "\r*> 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private int extOut;
    private short[] place;
    private byte[] image;
    private int height;
    private int width;
    private int ws;
    private int options;
    private int[][] f;
    private int[][] switchMode;

    public BarcodeDataMatrix() {
        this.encoding = DEFAULT_DATA_MATRIX_ENCODING;
    }

    public BarcodeDataMatrix(String code) {
        this.encoding = DEFAULT_DATA_MATRIX_ENCODING;
        this.setCode(code);
    }

    public BarcodeDataMatrix(String code, String encoding) {
        this.encoding = encoding;
        this.setCode(code);
    }

    @Override
    public Rectangle getBarcodeSize() {
        return new Rectangle(0.0f, 0.0f, (float)(this.width + 2 * this.ws), (float)(this.height + 2 * this.ws));
    }

    @Override
    public Rectangle placeBarcode(PdfCanvas canvas, com.itextpdf.kernel.colors.Color foreground) {
        return this.placeBarcode(canvas, foreground, 1.0f);
    }

    @Override
    public PdfFormXObject createFormXObject(com.itextpdf.kernel.colors.Color foreground, PdfDocument document) {
        return this.createFormXObject(foreground, 1.0f, document);
    }

    public PdfFormXObject createFormXObject(com.itextpdf.kernel.colors.Color foreground, float moduleSide, PdfDocument document) {
        PdfFormXObject xObject = new PdfFormXObject((Rectangle)null);
        Rectangle rect = this.placeBarcode(new PdfCanvas(xObject, document), foreground, moduleSide);
        xObject.setBBox(new PdfArray(rect));
        return xObject;
    }

    public Rectangle placeBarcode(PdfCanvas canvas, com.itextpdf.kernel.colors.Color foreground, float moduleSide) {
        if (this.image == null) {
            return null;
        }
        if (foreground != null) {
            canvas.setFillColor(foreground);
        }
        int w = this.width + 2 * this.ws;
        int h = this.height + 2 * this.ws;
        int stride = (w + 7) / 8;
        for (int k = 0; k < h; ++k) {
            int p = k * stride;
            for (int j = 0; j < w; ++j) {
                int b = this.image[p + j / 8] & 0xFF;
                if (((b <<= j % 8) & 0x80) == 0) continue;
                canvas.rectangle((double)((float)j * moduleSide), (double)((float)(h - k - 1) * moduleSide), (double)moduleSide, (double)moduleSide);
            }
        }
        canvas.fill();
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color foreground, Color background) {
        if (this.image == null) {
            return null;
        }
        int f = foreground.getRGB();
        int g = background.getRGB();
        Canvas canvas = new Canvas();
        int w = this.width + 2 * this.ws;
        int h = this.height + 2 * this.ws;
        int[] pix = new int[w * h];
        int stride = (w + 7) / 8;
        int ptr = 0;
        for (int k = 0; k < h; ++k) {
            int p = k * stride;
            for (int j = 0; j < w; ++j) {
                int b = this.image[p + j / 8] & 0xFF;
                pix[ptr++] = ((b <<= j % 8) & 0x80) == 0 ? g : f;
            }
        }
        Image img = canvas.createImage(new MemoryImageSource(w, h, pix, 0, w));
        return img;
    }

    public Rectangle getBarcodeSize(float moduleHeight, float moduleWidth) {
        return new Rectangle(0.0f, 0.0f, (float)(this.width + 2 * this.ws) * moduleHeight, (float)(this.height + 2 * this.ws) * moduleWidth);
    }

    public int setCode(String text) {
        byte[] t;
        try {
            t = text.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException exc) {
            throw new IllegalArgumentException("text has to be encoded in iso-8859-1", exc);
        }
        return this.setCode(t, 0, t.length);
    }

    public int setCode(byte[] text, int textOffset, int textSize) {
        DmParams dm;
        if (textOffset < 0) {
            throw new IndexOutOfBoundsException("" + textOffset);
        }
        if (textOffset + textSize > text.length || textSize < 0) {
            throw new IndexOutOfBoundsException("" + textSize);
        }
        byte[] data = new byte[2500];
        this.extOut = 0;
        int extCount = this.processExtensions(text, textOffset, textSize, data);
        if (extCount < 0) {
            return 5;
        }
        int e = -1;
        this.f = new int[6][textSize - this.extOut];
        this.switchMode = new int[6][textSize - this.extOut];
        if (this.height == 0 || this.width == 0) {
            int k;
            DmParams last = dmSizes[dmSizes.length - 1];
            e = this.getEncodation(text, textOffset + this.extOut, textSize - this.extOut, data, extCount, last.getDataSize() - extCount, this.options, false);
            if (e < 0) {
                return 1;
            }
            e += extCount;
            for (k = 0; k < dmSizes.length && dmSizes[k].getDataSize() < e; ++k) {
            }
            dm = dmSizes[k];
            this.height = dm.getHeight();
            this.width = dm.getWidth();
        } else {
            int k;
            for (k = 0; k < dmSizes.length && (this.height != dmSizes[k].getHeight() || this.width != dmSizes[k].getWidth()); ++k) {
            }
            if (k == dmSizes.length) {
                return 3;
            }
            dm = dmSizes[k];
            e = this.getEncodation(text, textOffset + this.extOut, textSize - this.extOut, data, extCount, dm.getDataSize() - extCount, this.options, true);
            if (e < 0) {
                return 1;
            }
            e += extCount;
        }
        if ((this.options & 0x40) != 0) {
            return 0;
        }
        this.image = new byte[(dm.getWidth() + 2 * this.ws + 7) / 8 * (dm.getHeight() + 2 * this.ws)];
        BarcodeDataMatrix.makePadding(data, e, dm.getDataSize() - e);
        this.place = Placement.doPlacement(dm.getHeight() - dm.getHeight() / dm.getHeightSection() * 2, dm.getWidth() - dm.getWidth() / dm.getWidthSection() * 2);
        int full = dm.getDataSize() + (dm.getDataSize() + 2) / dm.getDataBlock() * dm.getErrorBlock();
        ReedSolomon.generateECC(data, dm.getDataSize(), dm.getDataBlock(), dm.getErrorBlock());
        this.draw(data, full, dm);
        return 0;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWs() {
        return this.ws;
    }

    public void setWs(int ws) {
        this.ws = ws;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private static void makePadding(byte[] data, int position, int count) {
        if (count <= 0) {
            return;
        }
        data[position++] = -127;
        while (--count > 0) {
            int t = 129 + (position + 1) * 149 % 253 + 1;
            if (t > 254) {
                t -= 254;
            }
            data[position++] = (byte)t;
        }
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private int asciiEncodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength, int symbolIndex, int prevEnc, int origDataOffset) {
        int ptrIn = textOffset;
        int ptrOut = dataOffset;
        textLength += textOffset;
        dataLength += dataOffset;
        while (ptrIn < textLength) {
            int c;
            if (BarcodeDataMatrix.isDigit(c = text[ptrIn++] & 0xFF) && symbolIndex > 0 && prevEnc == 1 && BarcodeDataMatrix.isDigit(text[ptrIn - 2] & 0xFF) && data[dataOffset - 1] > 48 && data[dataOffset - 1] < 59) {
                data[ptrOut - 1] = (byte)(((text[ptrIn - 2] & 0xFF) - 48) * 10 + c - 48 + 130);
                return ptrOut - origDataOffset;
            }
            if (ptrOut >= dataLength) {
                return -1;
            }
            if (BarcodeDataMatrix.isDigit(c) && symbolIndex < 0 && ptrIn < textLength && BarcodeDataMatrix.isDigit(text[ptrIn] & 0xFF)) {
                data[ptrOut++] = (byte)((c - 48) * 10 + (text[ptrIn++] & 0xFF) - 48 + 130);
                continue;
            }
            if (c > 127) {
                if (ptrOut + 1 >= dataLength) {
                    return -1;
                }
                data[ptrOut++] = -21;
                data[ptrOut++] = (byte)(c - 128 + 1);
                continue;
            }
            data[ptrOut++] = (byte)(c + 1);
        }
        return ptrOut - origDataOffset;
    }

    private int b256Encodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength, int symbolIndex, int prevEnc, int origDataOffset) {
        int j;
        int minRequiredDataIncrement;
        if (textLength == 0) {
            return 0;
        }
        int simulatedDataOffset = dataOffset;
        if (prevEnc != 4) {
            if (textLength < 250 && textLength + 2 > dataLength) {
                return -1;
            }
            if (textLength >= 250 && textLength + 3 > dataLength) {
                return -1;
            }
            data[dataOffset] = -25;
        } else {
            int latestModeEntry;
            for (latestModeEntry = symbolIndex - 1; latestModeEntry > 0 && this.switchMode[3][latestModeEntry] == 4; --latestModeEntry) {
            }
            textLength = symbolIndex - latestModeEntry + 1;
            if (textLength != 250 && 1 > dataLength) {
                return -1;
            }
            if (textLength == 250 && 2 > dataLength) {
                return -1;
            }
            simulatedDataOffset -= textLength - 1 + (textLength < 250 ? 2 : 3);
        }
        if (textLength < 250) {
            data[simulatedDataOffset + 1] = (byte)textLength;
            minRequiredDataIncrement = prevEnc != 4 ? 2 : 0;
        } else if (textLength == 250 && prevEnc == 4) {
            data[simulatedDataOffset + 1] = (byte)(textLength / 250 + 249);
            for (int i = dataOffset + 1; i > simulatedDataOffset + 2; --i) {
                data[i] = data[i - 1];
            }
            data[simulatedDataOffset + 2] = (byte)(textLength % 250);
            minRequiredDataIncrement = 1;
        } else {
            data[simulatedDataOffset + 1] = (byte)(textLength / 250 + 249);
            data[simulatedDataOffset + 2] = (byte)(textLength % 250);
            int n = minRequiredDataIncrement = prevEnc != 4 ? 3 : 0;
        }
        if (prevEnc == 4) {
            textLength = 1;
        }
        System.arraycopy(text, textOffset, data, minRequiredDataIncrement + dataOffset, textLength);
        int n = j = prevEnc != 4 ? dataOffset + 1 : dataOffset;
        while (j < minRequiredDataIncrement + textLength + dataOffset) {
            this.randomizationAlgorithm255(data, j);
            ++j;
        }
        if (prevEnc == 4) {
            this.randomizationAlgorithm255(data, simulatedDataOffset + 1);
        }
        return textLength + dataOffset + minRequiredDataIncrement - origDataOffset;
    }

    private void randomizationAlgorithm255(byte[] data, int j) {
        int c = data[j] & 0xFF;
        int prn = 149 * (j + 1) % 255 + 1;
        int tv = c + prn;
        if (tv > 255) {
            tv -= 256;
        }
        data[j] = (byte)tv;
    }

    private int X12Encodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength, int symbolIndex, int prevEnc, int origDataOffset) {
        int k;
        int ptrIn;
        boolean latch = true;
        if (textLength == 0) {
            return 0;
        }
        int ptrOut = 0;
        byte[] x = new byte[textLength];
        int count = 0;
        for (ptrIn = 0; ptrIn < textLength; ++ptrIn) {
            int i = X12.indexOf((char)text[ptrIn + textOffset]);
            if (i >= 0) {
                x[ptrIn] = (byte)i;
                ++count;
                continue;
            }
            x[ptrIn] = 100;
            if (count >= 6) {
                count -= count / 3 * 3;
            }
            for (k = 0; k < count; ++k) {
                x[ptrIn - k - 1] = 100;
            }
            count = 0;
        }
        if (count >= 6) {
            count -= count / 3 * 3;
        }
        for (k = 0; k < count; ++k) {
            x[ptrIn - k - 1] = 100;
        }
        int c = 0;
        for (ptrIn = 0; ptrIn < textLength; ++ptrIn) {
            c = x[ptrIn];
            if (ptrOut > dataLength) break;
            if (c < 40) {
                if (ptrIn == 0 && latch || ptrIn > 0 && x[ptrIn - 1] > 40) {
                    data[dataOffset + ptrOut++] = -18;
                }
                if (ptrOut + 2 > dataLength) break;
                int n = 1600 * x[ptrIn] + 40 * x[ptrIn + 1] + x[ptrIn + 2] + 1;
                data[dataOffset + ptrOut++] = (byte)(n / 256);
                data[dataOffset + ptrOut++] = (byte)n;
                ptrIn += 2;
                continue;
            }
            boolean enterASCII = true;
            if (symbolIndex <= 0) {
                if (ptrIn > 0 && x[ptrIn - 1] < 40) {
                    data[dataOffset + ptrOut++] = -2;
                }
            } else if (symbolIndex > 4 && prevEnc == 5 && X12.indexOf((char)text[textOffset]) >= 0 && X12.indexOf((char)text[textOffset - 1]) >= 0) {
                int latestModeEntry;
                for (latestModeEntry = symbolIndex - 1; latestModeEntry > 0 && this.switchMode[4][latestModeEntry] == 5 && X12.indexOf((char)text[textOffset - (symbolIndex - latestModeEntry + 1)]) >= 0; --latestModeEntry) {
                }
                int unlatch = -1;
                if (symbolIndex - latestModeEntry >= 5) {
                    int amountOfEncodedWithASCII;
                    for (int i = 1; i <= symbolIndex - latestModeEntry; ++i) {
                        if (data[dataOffset - i] != -2) continue;
                        unlatch = dataOffset - i;
                        break;
                    }
                    int n = amountOfEncodedWithASCII = unlatch >= 0 ? dataOffset - unlatch - 1 : symbolIndex - latestModeEntry;
                    if (amountOfEncodedWithASCII % 3 == 2) {
                        enterASCII = false;
                        textLength = amountOfEncodedWithASCII + 1;
                        textOffset -= amountOfEncodedWithASCII;
                        dataLength += unlatch < 0 ? amountOfEncodedWithASCII : amountOfEncodedWithASCII + 1;
                        int n2 = unlatch < 0 ? amountOfEncodedWithASCII : amountOfEncodedWithASCII + 1;
                        ptrIn = -1;
                        latch = unlatch != (dataOffset -= n2);
                        x = new byte[amountOfEncodedWithASCII + 1];
                        for (int i = 0; i <= amountOfEncodedWithASCII; ++i) {
                            x[i] = (byte)X12.indexOf((char)text[textOffset + i]);
                        }
                    } else {
                        x = new byte[]{100};
                    }
                }
            }
            if (!enterASCII) continue;
            int i = this.asciiEncodation(text, textOffset + ptrIn, 1, data, dataOffset + ptrOut, dataLength, -1, -1, origDataOffset);
            if (i < 0) {
                return -1;
            }
            if (data[dataOffset + ptrOut] == -21) {
                ++ptrOut;
            }
            ++ptrOut;
        }
        c = 100;
        if (textLength > 0) {
            c = x[textLength - 1];
        }
        if (ptrIn != textLength) {
            return -1;
        }
        if (c < 40) {
            data[dataOffset + ptrOut++] = -2;
        }
        if (ptrOut > dataLength) {
            return -1;
        }
        return ptrOut + dataOffset - origDataOffset;
    }

    private int EdifactEncodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength, int symbolIndex, int prevEnc, int origDataOffset, boolean sizeFixed) {
        int i;
        int c;
        if (textLength == 0) {
            return 0;
        }
        int ptrIn = 0;
        int ptrOut = 0;
        int edi = 0;
        int pedi = 18;
        boolean ascii = true;
        int latestModeEntryActual = -1;
        int latestModeEntryC40orX12 = -1;
        int prevMode = -1;
        if (!(prevEnc != 6 || (text[textOffset] & 0xFF & 0xE0) != 64 && (text[textOffset] & 0xFF & 0xE0) != 32 || (text[textOffset] & 0xFF) == 95 || (text[textOffset - 1] & 0xFF & 0xE0) != 64 && (text[textOffset - 1] & 0xFF & 0xE0) != 32 || (text[textOffset - 1] & 0xFF) == 95)) {
            for (latestModeEntryActual = symbolIndex - 1; latestModeEntryActual > 0 && this.switchMode[5][latestModeEntryActual] == 6 && (((c = text[textOffset - (symbolIndex - latestModeEntryActual + 1)] & 0xFF) & 0xE0) == 64 || (c & 0xE0) == 32) && c != 95; --latestModeEntryActual) {
            }
            int n = prevMode = this.switchMode[5][latestModeEntryActual] == 2 || this.switchMode[5][latestModeEntryActual] == 5 ? this.switchMode[5][latestModeEntryActual] : -1;
            if (prevMode > 0) {
                latestModeEntryC40orX12 = latestModeEntryActual;
            }
            while (prevMode > 0 && latestModeEntryC40orX12 > 0 && this.switchMode[prevMode - 1][latestModeEntryC40orX12] == prevMode) {
                c = text[textOffset - (symbolIndex - latestModeEntryC40orX12 + 1)] & 0xFF;
                if (((c & 0xE0) == 64 || (c & 0xE0) == 32) && c != 95) {
                    --latestModeEntryC40orX12;
                    continue;
                }
                latestModeEntryC40orX12 = -1;
                break;
            }
        }
        int dataSize = dataOffset + dataLength;
        boolean asciiOneSymbol = false;
        if (symbolIndex != -1) {
            asciiOneSymbol = true;
        }
        int dataTaken = 0;
        int dataRequired = 0;
        if (latestModeEntryC40orX12 >= 0 && symbolIndex - latestModeEntryC40orX12 + 1 > 9) {
            textLength = symbolIndex - latestModeEntryC40orX12 + 1;
            dataTaken = 0;
            dataRequired = 0;
            dataRequired += 1 + textLength / 4 * 3;
            if (!(sizeFixed || symbolIndex != text.length - 1 && symbolIndex >= 0 || textLength % 4 >= 3)) {
                dataSize = Integer.MAX_VALUE;
                for (i = 0; i < dmSizes.length; ++i) {
                    if (dmSizes[i].getDataSize() < dataRequired + textLength % 4) continue;
                    dataSize = dmSizes[i].getDataSize();
                    break;
                }
            }
            if (dataSize - dataOffset - dataRequired <= 2 && textLength % 4 <= 2) {
                dataRequired += textLength % 4;
            } else {
                dataRequired += textLength % 4 + 1;
                if (textLength % 4 == 3) {
                    --dataRequired;
                }
            }
            for (i = dataOffset - 1; i >= 0; --i) {
                ++dataTaken;
                if (data[i] == (prevMode == 2 ? (byte)-26 : -18)) break;
            }
            if (dataRequired <= dataTaken) {
                asciiOneSymbol = false;
                textOffset -= textLength - 1;
                dataOffset -= dataTaken;
                dataLength += dataTaken;
            }
        } else if (latestModeEntryActual >= 0 && symbolIndex - latestModeEntryActual + 1 > 9) {
            textLength = symbolIndex - latestModeEntryActual + 1;
            if (dataSize - dataOffset - (dataRequired += 1 + textLength / 4 * 3) <= 2 && textLength % 4 <= 2) {
                dataRequired += textLength % 4;
            } else {
                dataRequired += textLength % 4 + 1;
                if (textLength % 4 == 3) {
                    --dataRequired;
                }
            }
            int dataNewOffset = 0;
            int latchEdi = -1;
            for (int i2 = origDataOffset; i2 < dataOffset; ++i2) {
                if (data[i2] != -16 || dataOffset - i2 > dataRequired) continue;
                latchEdi = i2;
                break;
            }
            if (latchEdi != -1) {
                dataTaken += dataOffset - latchEdi;
                if ((text[textOffset] & 0xFF) > 127) {
                    dataTaken += 2;
                } else {
                    if (BarcodeDataMatrix.isDigit(text[textOffset] & 0xFF) && BarcodeDataMatrix.isDigit(text[textOffset - 1] & 0xFF) && data[dataOffset - 1] >= 49 && data[dataOffset - 1] <= 58) {
                        --dataTaken;
                    }
                    ++dataTaken;
                }
                dataNewOffset = dataOffset - latchEdi;
            } else {
                for (int j = symbolIndex - latestModeEntryActual; j >= 0; --j) {
                    if ((text[textOffset - j] & 0xFF) > 127) {
                        dataTaken += 2;
                    } else {
                        if (j > 0 && BarcodeDataMatrix.isDigit(text[textOffset - j] & 0xFF) && BarcodeDataMatrix.isDigit(text[textOffset - j + 1] & 0xFF)) {
                            if (j == 1) {
                                dataNewOffset = dataTaken;
                            }
                            --j;
                        }
                        ++dataTaken;
                    }
                    if (j != 1) continue;
                    dataNewOffset = dataTaken;
                }
            }
            if (dataRequired <= dataTaken) {
                asciiOneSymbol = false;
                textOffset -= textLength - 1;
                dataOffset -= dataNewOffset;
                dataLength += dataNewOffset;
            }
        }
        if (asciiOneSymbol) {
            c = text[textOffset] & 0xFF;
            if (BarcodeDataMatrix.isDigit(c) && textOffset + ptrIn > 0 && BarcodeDataMatrix.isDigit(text[textOffset - 1] & 0xFF) && prevEnc == 6 && data[dataOffset - 1] >= 49 && data[dataOffset - 1] <= 58) {
                data[dataOffset + ptrOut - 1] = (byte)(((text[textOffset - 1] & 0xFF) - 48) * 10 + c - 48 + 130);
                return dataOffset - origDataOffset;
            }
            return this.asciiEncodation(text, textOffset + ptrIn, 1, data, dataOffset + ptrOut, dataLength, -1, -1, origDataOffset);
        }
        while (ptrIn < textLength) {
            c = text[ptrIn + textOffset] & 0xFF;
            if (((c & 0xE0) == 64 || (c & 0xE0) == 32) && c != 95) {
                if (ascii) {
                    if (ptrOut + 1 > dataLength) break;
                    data[dataOffset + ptrOut++] = -16;
                    ascii = false;
                }
                edi |= (c &= 0x3F) << pedi;
                if (pedi == 0) {
                    if (ptrOut + 3 > dataLength) break;
                    data[dataOffset + ptrOut++] = (byte)(edi >> 16);
                    data[dataOffset + ptrOut++] = (byte)(edi >> 8);
                    data[dataOffset + ptrOut++] = (byte)edi;
                    edi = 0;
                    pedi = 18;
                } else {
                    pedi -= 6;
                }
            } else {
                if (!ascii) {
                    edi |= 31 << pedi;
                    if (ptrOut + 3 - pedi / 8 > dataLength) break;
                    data[dataOffset + ptrOut++] = (byte)(edi >> 16);
                    if (pedi <= 12) {
                        data[dataOffset + ptrOut++] = (byte)(edi >> 8);
                    }
                    if (pedi <= 6) {
                        data[dataOffset + ptrOut++] = (byte)edi;
                    }
                    ascii = true;
                    pedi = 18;
                    edi = 0;
                }
                if (BarcodeDataMatrix.isDigit(c) && textOffset + ptrIn > 0 && BarcodeDataMatrix.isDigit(text[textOffset + ptrIn - 1] & 0xFF) && prevEnc == 6 && data[dataOffset - 1] >= 49 && data[dataOffset - 1] <= 58) {
                    data[dataOffset + ptrOut - 1] = (byte)(((text[textOffset - 1] & 0xFF) - 48) * 10 + c - 48 + 130);
                    --ptrOut;
                } else {
                    i = this.asciiEncodation(text, textOffset + ptrIn, 1, data, dataOffset + ptrOut, dataLength, -1, -1, origDataOffset);
                    if (i < 0) {
                        return -1;
                    }
                    if (data[dataOffset + ptrOut] == -21) {
                        ++ptrOut;
                    }
                    ++ptrOut;
                }
            }
            ++ptrIn;
        }
        if (ptrIn != textLength) {
            return -1;
        }
        if (!(sizeFixed || symbolIndex != text.length - 1 && symbolIndex >= 0)) {
            dataSize = Integer.MAX_VALUE;
            for (i = 0; i < dmSizes.length; ++i) {
                if (dmSizes[i].getDataSize() < dataOffset + ptrOut + (3 - pedi / 6)) continue;
                dataSize = dmSizes[i].getDataSize();
                break;
            }
        }
        if (dataSize - dataOffset - ptrOut <= 2 && pedi >= 6) {
            byte val;
            if (pedi != 18 && ptrOut + 2 - pedi / 8 > dataLength) {
                return -1;
            }
            if (pedi <= 12) {
                val = (byte)(edi >> 18 & 0x3F);
                if ((val & 0x20) == 0) {
                    val = (byte)(val | 0x40);
                }
                data[dataOffset + ptrOut++] = (byte)(val + 1);
            }
            if (pedi <= 6) {
                val = (byte)(edi >> 12 & 0x3F);
                if ((val & 0x20) == 0) {
                    val = (byte)(val | 0x40);
                }
                data[dataOffset + ptrOut++] = (byte)(val + 1);
            }
        } else if (!ascii) {
            edi |= 31 << pedi;
            if (ptrOut + 3 - pedi / 8 > dataLength) {
                return -1;
            }
            data[dataOffset + ptrOut++] = (byte)(edi >> 16);
            if (pedi <= 12) {
                data[dataOffset + ptrOut++] = (byte)(edi >> 8);
            }
            if (pedi <= 6) {
                data[dataOffset + ptrOut++] = (byte)edi;
            }
        }
        return ptrOut + dataOffset - origDataOffset;
    }

    private int C40OrTextEncodation(byte[] text, int textOffset, int textLength, byte[] data, int dataOffset, int dataLength, boolean c40, int symbolIndex, int prevEnc, int origDataOffset) {
        int c;
        int i;
        int mode;
        String shift3;
        String basic;
        if (textLength == 0) {
            return 0;
        }
        int ptrIn = 0;
        int ptrOut = 0;
        String shift2 = "!\"#$%&'()*+,-./:;<=>?@[\\]^_";
        if (c40) {
            basic = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            shift3 = "`abcdefghijklmnopqrstuvwxyz{|}~\u007f";
        } else {
            basic = " 0123456789abcdefghijklmnopqrstuvwxyz";
            shift3 = "`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~\u007f";
        }
        boolean addLatch = true;
        boolean usingASCII = false;
        int n = mode = c40 ? 2 : 3;
        if (prevEnc == mode) {
            int latestModeEntry;
            usingASCII = true;
            for (latestModeEntry = symbolIndex - 1; latestModeEntry > 0 && this.switchMode[mode - 1][latestModeEntry] == mode; --latestModeEntry) {
            }
            int unlatch = -1;
            int dataAmountOfEncodedWithASCII = 0;
            if (symbolIndex - latestModeEntry >= 5) {
                for (i = symbolIndex - latestModeEntry; i > 0; --i) {
                    c = text[textOffset - i] & 0xFF;
                    if (c > 127) {
                        dataAmountOfEncodedWithASCII += 2;
                        continue;
                    }
                    ++dataAmountOfEncodedWithASCII;
                }
                for (i = 1; i <= dataAmountOfEncodedWithASCII && i <= dataOffset; ++i) {
                    if (data[dataOffset - i] != -2) continue;
                    unlatch = dataOffset - i;
                    break;
                }
                int amountOfEncodedWithASCII = 0;
                if (unlatch >= 0) {
                    for (i = unlatch + 1; i < dataOffset; ++i) {
                        if (data[i] == -21) {
                            ++i;
                        }
                        if (data[i] >= -127 && data[i] <= -27) {
                            ++amountOfEncodedWithASCII;
                        }
                        ++amountOfEncodedWithASCII;
                    }
                } else {
                    amountOfEncodedWithASCII = symbolIndex - latestModeEntry;
                }
                int dataOffsetNew = 0;
                for (i = amountOfEncodedWithASCII; i > 0; --i) {
                    int requiredCapacityForASCII = 0;
                    int requiredCapacityForC40orText = 0;
                    for (int j = i; j >= 0; --j) {
                        c = text[textOffset - j] & 0xFF;
                        if (c > 127) {
                            c -= 128;
                            requiredCapacityForC40orText += 2;
                        }
                        requiredCapacityForC40orText += basic.indexOf((char)c) >= 0 ? 1 : 2;
                        if (j > 0 && BarcodeDataMatrix.isDigit(c) && BarcodeDataMatrix.isDigit(text[textOffset - j + 1] & 0xFF)) {
                            requiredCapacityForC40orText += basic.indexOf((char)text[textOffset - j + 1]) >= 0 ? 1 : 2;
                            --j;
                            dataOffsetNew = requiredCapacityForASCII + 1;
                        }
                        ++requiredCapacityForASCII;
                        if (j != 1) continue;
                        dataOffsetNew = requiredCapacityForASCII;
                    }
                    boolean bl = addLatch = unlatch < 0 || dataOffset - requiredCapacityForASCII != unlatch;
                    if (requiredCapacityForC40orText % 3 == 0 && requiredCapacityForC40orText / 3 * 2 + (addLatch ? 2 : 0) < requiredCapacityForASCII) {
                        usingASCII = false;
                        textLength = i + 1;
                        textOffset -= i;
                        dataOffset -= addLatch ? dataOffsetNew : dataOffsetNew + 1;
                        dataLength += addLatch ? dataOffsetNew : dataOffsetNew + 1;
                        break;
                    }
                    if (!BarcodeDataMatrix.isDigit(text[textOffset - i] & 0xFF) || !BarcodeDataMatrix.isDigit(text[textOffset - i + 1] & 0xFF)) continue;
                    --i;
                }
            }
        } else if (symbolIndex != -1) {
            usingASCII = true;
        }
        if (dataOffset < 0) {
            return -1;
        }
        if (usingASCII) {
            return this.asciiEncodation(text, textOffset, 1, data, dataOffset, dataLength, prevEnc == mode ? 1 : -1, 1, origDataOffset);
        }
        if (addLatch) {
            data[dataOffset + ptrOut++] = c40 ? -26 : -17;
        }
        int[] enc = new int[textLength * 4 + 10];
        int encPtr = 0;
        int last0 = 0;
        int last1 = 0;
        while (ptrIn < textLength) {
            int idx;
            if (encPtr % 3 == 0) {
                last0 = ptrIn;
                last1 = encPtr;
            }
            if ((c = text[textOffset + ptrIn++] & 0xFF) > 127) {
                c -= 128;
                enc[encPtr++] = 1;
                enc[encPtr++] = 30;
            }
            if ((idx = basic.indexOf((char)c)) >= 0) {
                enc[encPtr++] = idx + 3;
                continue;
            }
            if (c < 32) {
                enc[encPtr++] = 0;
                enc[encPtr++] = c;
                continue;
            }
            idx = shift2.indexOf((char)c);
            if (idx >= 0) {
                enc[encPtr++] = 1;
                enc[encPtr++] = idx;
                continue;
            }
            idx = shift3.indexOf((char)c);
            if (idx < 0) continue;
            enc[encPtr++] = 2;
            enc[encPtr++] = idx;
        }
        if (encPtr % 3 != 0) {
            ptrIn = last0;
            encPtr = last1;
        }
        if (encPtr / 3 * 2 > dataLength - 2) {
            return -1;
        }
        for (i = 0; i < encPtr; i += 3) {
            int a = 1600 * enc[i] + 40 * enc[i + 1] + enc[i + 2] + 1;
            data[dataOffset + ptrOut++] = (byte)(a / 256);
            data[dataOffset + ptrOut++] = (byte)a;
        }
        if (dataLength - ptrOut > 2) {
            data[dataOffset + ptrOut++] = -2;
        }
        if (symbolIndex < 0 && textLength > ptrIn) {
            i = this.asciiEncodation(text, textOffset + ptrIn, textLength - ptrIn, data, dataOffset + ptrOut, dataLength - ptrOut, -1, -1, origDataOffset);
            return i;
        }
        return ptrOut + dataOffset - origDataOffset;
    }

    private void setBit(int x, int y, int xByte) {
        int n = y * xByte + x / 8;
        this.image[n] = (byte)(this.image[n] | (byte)(128 >> (x & 7)));
    }

    private void draw(byte[] data, int dataSize, DmParams dm) {
        int j;
        int i;
        int xByte = (dm.getWidth() + this.ws * 2 + 7) / 8;
        Arrays.fill(this.image, (byte)0);
        for (i = this.ws; i < dm.getHeight() + this.ws; i += dm.getHeightSection()) {
            for (j = this.ws; j < dm.getWidth() + this.ws; j += 2) {
                this.setBit(j, i, xByte);
            }
        }
        for (i = dm.getHeightSection() - 1 + this.ws; i < dm.getHeight() + this.ws; i += dm.getHeightSection()) {
            for (j = this.ws; j < dm.getWidth() + this.ws; ++j) {
                this.setBit(j, i, xByte);
            }
        }
        for (i = this.ws; i < dm.getWidth() + this.ws; i += dm.getWidthSection()) {
            for (j = this.ws; j < dm.getHeight() + this.ws; ++j) {
                this.setBit(i, j, xByte);
            }
        }
        for (i = dm.getWidthSection() - 1 + this.ws; i < dm.getWidth() + this.ws; i += dm.getWidthSection()) {
            for (j = 1 + this.ws; j < dm.getHeight() + this.ws; j += 2) {
                this.setBit(i, j, xByte);
            }
        }
        int p = 0;
        for (int ys = 0; ys < dm.getHeight(); ys += dm.getHeightSection()) {
            for (int y = 1; y < dm.getHeightSection() - 1; ++y) {
                for (int xs = 0; xs < dm.getWidth(); xs += dm.getWidthSection()) {
                    for (int x = 1; x < dm.getWidthSection() - 1; ++x) {
                        short z;
                        if ((z = this.place[p++]) != 1 && (z <= 1 || (data[z / 8 - 1] & 0xFF & 128 >> z % 8) == 0)) continue;
                        this.setBit(x + xs + this.ws, y + ys + this.ws, xByte);
                    }
                }
            }
        }
    }

    private static int minValueInColumn(int[][] array, int column) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < 6; ++i) {
            if (array[i][column] >= min || array[i][column] < 0) continue;
            min = array[i][column];
        }
        return min != Integer.MAX_VALUE ? min : -1;
    }

    private static int valuePositionInColumn(int[][] array, int column, int value) {
        for (int i = 0; i < 6; ++i) {
            if (array[i][column] != value) continue;
            return i;
        }
        return -1;
    }

    private void solveFAndSwitchMode(int[] forMin, int mode, int currIndex) {
        if (forMin[mode] >= 0 && this.f[mode][currIndex - 1] >= 0) {
            this.f[mode][currIndex] = forMin[mode];
            this.switchMode[mode][currIndex] = mode + 1;
        } else {
            this.f[mode][currIndex] = Integer.MAX_VALUE;
        }
        for (int i = 0; i < 6; ++i) {
            if (forMin[i] >= this.f[mode][currIndex] || forMin[i] < 0 || this.f[i][currIndex - 1] < 0) continue;
            this.f[mode][currIndex] = forMin[i];
            this.switchMode[mode][currIndex] = i + 1;
        }
        if (this.f[mode][currIndex] == Integer.MAX_VALUE) {
            this.f[mode][currIndex] = -1;
        }
    }

    private int getEncodation(byte[] text, int textOffset, int textSize, byte[] data, int dataOffset, int dataSize, int options, boolean sizeFixed) {
        if (dataSize < 0) {
            return -1;
        }
        if ((options &= 7) == 0) {
            int i;
            if (textSize == 0) {
                return 0;
            }
            byte[][] dataDynamic = new byte[6][data.length];
            for (i = 0; i < 6; ++i) {
                System.arraycopy(data, 0, dataDynamic[i], 0, data.length);
                this.switchMode[i][0] = i + 1;
            }
            this.f[0][0] = this.asciiEncodation(text, textOffset, 1, dataDynamic[0], dataOffset, dataSize, 0, -1, dataOffset);
            this.f[1][0] = this.C40OrTextEncodation(text, textOffset, 1, dataDynamic[1], dataOffset, dataSize, true, 0, -1, dataOffset);
            this.f[2][0] = this.C40OrTextEncodation(text, textOffset, 1, dataDynamic[2], dataOffset, dataSize, false, 0, -1, dataOffset);
            this.f[3][0] = this.b256Encodation(text, textOffset, 1, dataDynamic[3], dataOffset, dataSize, 0, -1, dataOffset);
            this.f[4][0] = this.X12Encodation(text, textOffset, 1, dataDynamic[4], dataOffset, dataSize, 0, -1, dataOffset);
            this.f[5][0] = this.EdifactEncodation(text, textOffset, 1, dataDynamic[5], dataOffset, dataSize, 0, -1, dataOffset, sizeFixed);
            for (i = 1; i < textSize; ++i) {
                int[] tempForMin = new int[6];
                for (int currEnc = 0; currEnc < 6; ++currEnc) {
                    byte[][] dataDynamicInner = new byte[6][data.length];
                    for (int prevEnc = 0; prevEnc < 6; ++prevEnc) {
                        System.arraycopy(dataDynamic[prevEnc], 0, dataDynamicInner[prevEnc], 0, data.length);
                        if (this.f[prevEnc][i - 1] < 0) {
                            tempForMin[prevEnc] = -1;
                            continue;
                        }
                        if (currEnc == 0) {
                            tempForMin[prevEnc] = this.asciiEncodation(text, textOffset + i, 1, dataDynamicInner[prevEnc], this.f[prevEnc][i - 1] + dataOffset, dataSize - this.f[prevEnc][i - 1], i, prevEnc + 1, dataOffset);
                        }
                        if (currEnc == 1) {
                            tempForMin[prevEnc] = this.C40OrTextEncodation(text, textOffset + i, 1, dataDynamicInner[prevEnc], this.f[prevEnc][i - 1] + dataOffset, dataSize - this.f[prevEnc][i - 1], true, i, prevEnc + 1, dataOffset);
                        }
                        if (currEnc == 2) {
                            tempForMin[prevEnc] = this.C40OrTextEncodation(text, textOffset + i, 1, dataDynamicInner[prevEnc], this.f[prevEnc][i - 1] + dataOffset, dataSize - this.f[prevEnc][i - 1], false, i, prevEnc + 1, dataOffset);
                        }
                        if (currEnc == 3) {
                            tempForMin[prevEnc] = this.b256Encodation(text, textOffset + i, 1, dataDynamicInner[prevEnc], this.f[prevEnc][i - 1] + dataOffset, dataSize - this.f[prevEnc][i - 1], i, prevEnc + 1, dataOffset);
                        }
                        if (currEnc == 4) {
                            tempForMin[prevEnc] = this.X12Encodation(text, textOffset + i, 1, dataDynamicInner[prevEnc], this.f[prevEnc][i - 1] + dataOffset, dataSize - this.f[prevEnc][i - 1], i, prevEnc + 1, dataOffset);
                        }
                        if (currEnc != 5) continue;
                        tempForMin[prevEnc] = this.EdifactEncodation(text, textOffset + i, 1, dataDynamicInner[prevEnc], this.f[prevEnc][i - 1] + dataOffset, dataSize - this.f[prevEnc][i - 1], i, prevEnc + 1, dataOffset, sizeFixed);
                    }
                    this.solveFAndSwitchMode(tempForMin, currEnc, i);
                    if (this.switchMode[currEnc][i] == 0) continue;
                    System.arraycopy(dataDynamicInner[this.switchMode[currEnc][i] - 1], 0, dataDynamic[currEnc], 0, data.length);
                }
            }
            int e = BarcodeDataMatrix.minValueInColumn(this.f, textSize - 1);
            if (e > dataSize || e < 0) {
                return -1;
            }
            int bestDataDynamicResultIndex = BarcodeDataMatrix.valuePositionInColumn(this.f, textSize - 1, e);
            System.arraycopy(dataDynamic[bestDataDynamicResultIndex], 0, data, 0, data.length);
            return e;
        }
        switch (options) {
            case 1: {
                return this.asciiEncodation(text, textOffset, textSize, data, dataOffset, dataSize, -1, -1, dataOffset);
            }
            case 2: {
                return this.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, true, -1, -1, dataOffset);
            }
            case 3: {
                return this.C40OrTextEncodation(text, textOffset, textSize, data, dataOffset, dataSize, false, -1, -1, dataOffset);
            }
            case 4: {
                return this.b256Encodation(text, textOffset, textSize, data, dataOffset, dataSize, -1, -1, dataOffset);
            }
            case 5: {
                return this.X12Encodation(text, textOffset, textSize, data, dataOffset, dataSize, -1, -1, dataOffset);
            }
            case 6: {
                return this.EdifactEncodation(text, textOffset, textSize, data, dataOffset, dataSize, -1, -1, dataOffset, sizeFixed);
            }
            case 7: {
                if (textSize > dataSize) {
                    return -1;
                }
                System.arraycopy(text, textOffset, data, dataOffset, textSize);
                return textSize;
            }
        }
        return -1;
    }

    private static int getNumber(byte[] text, int ptrIn, int n) {
        int v = 0;
        for (int j = 0; j < n; ++j) {
            int c;
            if ((c = text[ptrIn++] & 0xFF) < 48 || c > 57) {
                return -1;
            }
            v = v * 10 + c - 48;
        }
        return v;
    }

    private int processExtensions(byte[] text, int textOffset, int textSize, byte[] data) {
        if ((this.options & 0x20) == 0) {
            return 0;
        }
        int order = 0;
        int ptrIn = 0;
        int ptrOut = 0;
        while (ptrIn < textSize) {
            if (order > 20) {
                return -1;
            }
            int c = text[textOffset + ptrIn++] & 0xFF;
            ++order;
            switch (c) {
                case 46: {
                    this.extOut = ptrIn;
                    return ptrOut;
                }
                case 101: {
                    if (ptrIn + 6 > textSize) {
                        return -1;
                    }
                    int eci = BarcodeDataMatrix.getNumber(text, textOffset + ptrIn, 6);
                    if (eci < 0) {
                        return -1;
                    }
                    ptrIn += 6;
                    data[ptrOut++] = -15;
                    if (eci < 127) {
                        data[ptrOut++] = (byte)(eci + 1);
                        break;
                    }
                    if (eci < 16383) {
                        data[ptrOut++] = (byte)((eci - 127) / 254 + 128);
                        data[ptrOut++] = (byte)((eci - 127) % 254 + 1);
                        break;
                    }
                    data[ptrOut++] = (byte)((eci - 16383) / 64516 + 192);
                    data[ptrOut++] = (byte)((eci - 16383) / 254 % 254 + 1);
                    data[ptrOut++] = (byte)((eci - 16383) % 254 + 1);
                    break;
                }
                case 115: {
                    if (order != 1) {
                        return -1;
                    }
                    if (ptrIn + 9 > textSize) {
                        return -1;
                    }
                    int fn = BarcodeDataMatrix.getNumber(text, textOffset + ptrIn, 2);
                    if (fn <= 0 || fn > 16) {
                        return -1;
                    }
                    int ft = BarcodeDataMatrix.getNumber(text, textOffset + (ptrIn += 2), 2);
                    if (ft <= 1 || ft > 16) {
                        return -1;
                    }
                    int fi = BarcodeDataMatrix.getNumber(text, textOffset + (ptrIn += 2), 5);
                    if (fi < 0 || fn >= 64516) {
                        return -1;
                    }
                    ptrIn += 5;
                    data[ptrOut++] = -23;
                    data[ptrOut++] = (byte)(fn - 1 << 4 | 17 - ft);
                    data[ptrOut++] = (byte)(fi / 254 + 1);
                    data[ptrOut++] = (byte)(fi % 254 + 1);
                    break;
                }
                case 112: {
                    if (order != 1) {
                        return -1;
                    }
                    data[ptrOut++] = -22;
                    break;
                }
                case 109: {
                    if (order != 1) {
                        return -1;
                    }
                    if (ptrIn + 1 > textSize) {
                        return -1;
                    }
                    if ((c = text[textOffset + ptrIn++] & 0xFF) != 53) {
                        return -1;
                    }
                    data[ptrOut++] = -22;
                    data[ptrOut++] = -20;
                    break;
                }
                case 102: {
                    if (order != 1 && (order != 2 || text[textOffset] != 115 && text[textOffset] != 109)) {
                        return -1;
                    }
                    data[ptrOut++] = -24;
                }
            }
        }
        return -1;
    }
}

