/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.ContextThemeWrapper;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatResourcesException;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManagerService;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SplitCompatResourcesLoader {
    private static final String TAG = "SplitCompatResourcesLoader";
    private static final Object sLock = new Object();

    public static void loadResources(Context context, Resources resources) throws Throwable {
        SplitCompatResourcesLoader.checkOrUpdateResources(context, resources);
    }

    static void loadResources(Context context, Resources preResources, String splitApkPath) throws Throwable {
        List<String> loadedResDirs = SplitCompatResourcesLoader.getLoadedResourcesDirs(preResources.getAssets());
        if (!loadedResDirs.contains(splitApkPath)) {
            SplitCompatResourcesLoader.installSplitResDirs(context, preResources, Collections.singletonList(splitApkPath));
            SplitLog.d((String)TAG, (String)"Install split %s resources for application.", (Object[])new Object[]{splitApkPath});
        }
    }

    private static void checkOrUpdateResources(Context context, Resources resources) throws SplitCompatResourcesException {
        List<String> loadedResDirsInAsset;
        try {
            loadedResDirsInAsset = SplitCompatResourcesLoader.getLoadedResourcesDirs(resources.getAssets());
        }
        catch (Throwable e) {
            throw new SplitCompatResourcesException("Failed to get all loaded split resources for " + context.getClass().getName(), e);
        }
        Collection<String> loadedSplitPaths = SplitCompatResourcesLoader.getLoadedSplitPaths();
        if (loadedSplitPaths != null && !loadedSplitPaths.isEmpty() && !loadedResDirsInAsset.containsAll(loadedSplitPaths)) {
            ArrayList<String> unloadedSplitPaths = new ArrayList<String>();
            for (String splitPath : loadedSplitPaths) {
                if (loadedResDirsInAsset.contains(splitPath)) continue;
                unloadedSplitPaths.add(splitPath);
            }
            try {
                SplitCompatResourcesLoader.installSplitResDirs(context, resources, unloadedSplitPaths);
            }
            catch (Throwable e) {
                throw new SplitCompatResourcesException("Failed to install resources " + ((Object)unloadedSplitPaths).toString() + " for " + context.getClass().getName(), e);
            }
        }
    }

    private static Collection<String> getLoadedSplitPaths() {
        SplitLoadManager loadManager = SplitLoadManagerService.getInstance();
        if (loadManager != null) {
            return loadManager.getLoadedSplitApkPaths();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installSplitResDirs(final Context context, final Resources resources, final List<String> splitResPaths) throws Throwable {
        if (Build.VERSION.SDK_INT >= 21) {
            V21.installSplitResDirs(resources, splitResPaths);
        } else if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            SplitLog.i((String)TAG, (String)"Install res on main thread", (Object[])new Object[0]);
            V14.installSplitResDirs(context, resources, splitResPaths);
        } else {
            Object object = sLock;
            synchronized (object) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = sLock;
                        synchronized (object) {
                            try {
                                V14.installSplitResDirs(context, resources, splitResPaths);
                            }
                            catch (Throwable throwable) {
                                throw new RuntimeException(throwable);
                            }
                            sLock.notify();
                        }
                    }
                });
                sLock.wait();
            }
        }
    }

    private static List<String> getLoadedResourcesDirs(AssetManager asset) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        ArrayList<String> existedAppResDirList;
        block7: {
            block6: {
                existedAppResDirList = new ArrayList<String>();
                if (Build.VERSION.SDK_INT < 28) break block6;
                Object[] apkAssets = (Object[])VersionCompat.getGetApkAssetsMethod().invoke((Object)asset, new Object[0]);
                if (apkAssets == null) break block7;
                for (Object apkAsset : apkAssets) {
                    String path = (String)VersionCompat.getGetAssetPathMethod().invoke(apkAsset, new Object[0]);
                    existedAppResDirList.add(path);
                }
                break block7;
            }
            Object[] appStringBlocks = (Object[])VersionCompat.mStringBlocksInAssetManager().get(asset);
            if (appStringBlocks != null && appStringBlocks.length > 0) {
                int totalResCount = appStringBlocks.length;
                SplitLog.i((String)TAG, (String)("Total resources count: " + totalResCount), (Object[])new Object[0]);
                for (int appResIndex = 1; appResIndex <= totalResCount; ++appResIndex) {
                    try {
                        String inApp = (String)VersionCompat.getGetCookieNameMethod().invoke((Object)asset, appResIndex);
                        existedAppResDirList.add(inApp);
                        continue;
                    }
                    catch (IndexOutOfBoundsException inApp) {
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        SplitLog.w((String)TAG, (String)("Unable to get cookie name for resources index " + appResIndex), (Throwable)e);
                    }
                }
            }
        }
        return existedAppResDirList;
    }

    private static abstract class VersionCompat {
        private static Field mStringBlocksField;
        private static Method addAssetPathMethod;
        private static Method getCookieNameMethod;
        private static Method getAssetPathMethod;
        private static Method getApkAssetsMethod;
        private static Field mActivitiesInActivityThread;
        private static Object activityThread;
        private static Class<?> activityThreadClass;
        private static Class<?> contextImplClass;
        private static Field mResourcesInContextImpl;
        private static Field mThemeInContentImpl;
        private static Field mPackagesInActivityThread;
        private static Field mResourcePackagesInActivityThread;
        private static Field mActiveResourcesInActivityThread;
        private static Field mActiveResourcesInResourcesManager;
        private static Class<?> resourcesManagerClass;
        private static Object resourcesManager;
        private static Field mResourcesInContextThemeWrapper;
        private static Field mThemeInContextThemeWrapper;
        private static Class<?> loadedApkClass;
        private static Field mResourcesInLoadedApk;

        private VersionCompat() {
        }

        @SuppressLint(value={"PrivateApi"})
        static Object getActivityThread() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            if (activityThread == null) {
                activityThread = HiddenApiReflection.findMethod(VersionCompat.getActivityThreadClass(), "currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            }
            return activityThread;
        }

        @SuppressLint(value={"PrivateApi"})
        static Object getResourcesManager() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            if (resourcesManager == null) {
                resourcesManager = HiddenApiReflection.findMethod(VersionCompat.getResourcesManagerClass(), "getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            return resourcesManager;
        }

        @SuppressLint(value={"PrivateApi"})
        static Class<?> getActivityThreadClass() throws ClassNotFoundException {
            if (activityThreadClass == null) {
                activityThreadClass = Class.forName("android.app.ActivityThread");
            }
            return activityThreadClass;
        }

        @SuppressLint(value={"PrivateApi"})
        static Class<?> getResourcesManagerClass() throws ClassNotFoundException {
            if (resourcesManagerClass == null) {
                resourcesManagerClass = Class.forName("android.app.ResourcesManager");
            }
            return resourcesManagerClass;
        }

        @SuppressLint(value={"PrivateApi"})
        static Class<?> getLoadedApkClass() throws ClassNotFoundException {
            if (loadedApkClass == null) {
                loadedApkClass = Class.forName("android.app.LoadedApk");
            }
            return loadedApkClass;
        }

        @SuppressLint(value={"PrivateApi"})
        static Class<?> getContextImplClass() throws ClassNotFoundException {
            if (contextImplClass == null) {
                contextImplClass = Class.forName("android.app.ContextImpl");
            }
            return contextImplClass;
        }

        static Field mResourcesInLoadedApk() throws ClassNotFoundException, NoSuchFieldException {
            if (mResourcesInLoadedApk == null) {
                mResourcesInLoadedApk = HiddenApiReflection.findField(VersionCompat.getLoadedApkClass(), "mResources");
            }
            return mResourcesInLoadedApk;
        }

        static Field mResourcesInContextImpl() throws ClassNotFoundException, NoSuchFieldException {
            if (mResourcesInContextImpl == null) {
                mResourcesInContextImpl = HiddenApiReflection.findField(VersionCompat.getContextImplClass(), "mResources");
            }
            return mResourcesInContextImpl;
        }

        static Field mResourcesInContextThemeWrapper() throws NoSuchFieldException {
            if (mResourcesInContextThemeWrapper == null) {
                mResourcesInContextThemeWrapper = HiddenApiReflection.findField(ContextThemeWrapper.class, "mResources");
            }
            return mResourcesInContextThemeWrapper;
        }

        static Field mThemeInContextThemeWrapper() throws NoSuchFieldException {
            if (mThemeInContextThemeWrapper == null) {
                mThemeInContextThemeWrapper = HiddenApiReflection.findField(ContextThemeWrapper.class, "mTheme");
            }
            return mThemeInContextThemeWrapper;
        }

        static Field mThemeInContentImpl() throws ClassNotFoundException, NoSuchFieldException {
            if (mThemeInContentImpl == null) {
                mThemeInContentImpl = HiddenApiReflection.findField(VersionCompat.getContextImplClass(), "mTheme");
            }
            return mThemeInContentImpl;
        }

        static Field mPackagesInActivityThread() throws ClassNotFoundException, NoSuchFieldException {
            if (mPackagesInActivityThread == null) {
                mPackagesInActivityThread = HiddenApiReflection.findField(VersionCompat.getActivityThreadClass(), "mPackages");
            }
            return mPackagesInActivityThread;
        }

        static Field mActiveResourcesInActivityThread() throws ClassNotFoundException, NoSuchFieldException {
            if (mActiveResourcesInActivityThread == null) {
                mActiveResourcesInActivityThread = HiddenApiReflection.findField(VersionCompat.getActivityThreadClass(), "mActiveResources");
            }
            return mActiveResourcesInActivityThread;
        }

        static Field mActiveResourcesInResourcesManager() throws ClassNotFoundException, NoSuchFieldException {
            if (mActiveResourcesInResourcesManager == null) {
                mActiveResourcesInResourcesManager = HiddenApiReflection.findField(VersionCompat.getResourcesManagerClass(), "mActiveResources");
            }
            return mActiveResourcesInResourcesManager;
        }

        static Field mResourcePackagesInActivityThread() throws ClassNotFoundException, NoSuchFieldException {
            if (mResourcePackagesInActivityThread == null) {
                mResourcePackagesInActivityThread = HiddenApiReflection.findField(VersionCompat.getActivityThreadClass(), "mResourcePackages");
            }
            return mResourcePackagesInActivityThread;
        }

        static Field mActivitiesInActivityThread() throws NoSuchFieldException, ClassNotFoundException {
            if (mActivitiesInActivityThread == null) {
                mActivitiesInActivityThread = HiddenApiReflection.findField(VersionCompat.getActivityThreadClass(), "mActivities");
            }
            return mActivitiesInActivityThread;
        }

        static Field mStringBlocksInAssetManager() throws NoSuchFieldException {
            if (mStringBlocksField == null) {
                mStringBlocksField = HiddenApiReflection.findField(AssetManager.class, "mStringBlocks");
            }
            return mStringBlocksField;
        }

        static Method getAddAssetPathMethod() throws NoSuchMethodException {
            if (addAssetPathMethod == null) {
                addAssetPathMethod = HiddenApiReflection.findMethod(AssetManager.class, "addAssetPath", String.class);
            }
            return addAssetPathMethod;
        }

        static Method getGetCookieNameMethod() throws NoSuchMethodException {
            if (getCookieNameMethod == null) {
                getCookieNameMethod = HiddenApiReflection.findMethod(AssetManager.class, "getCookieName", Integer.TYPE);
            }
            return getCookieNameMethod;
        }

        @SuppressLint(value={"PrivateApi"})
        @RequiresApi(value=28)
        static Method getGetAssetPathMethod() throws ClassNotFoundException, NoSuchMethodException {
            if (getAssetPathMethod == null) {
                Class<?> clazz = Class.forName("android.content.res.ApkAssets");
                getAssetPathMethod = HiddenApiReflection.findMethod(clazz, "getAssetPath", new Class[0]);
            }
            return getAssetPathMethod;
        }

        @RequiresApi(value=28)
        static Method getGetApkAssetsMethod() throws NoSuchMethodException {
            if (getApkAssetsMethod == null) {
                getApkAssetsMethod = HiddenApiReflection.findMethod(AssetManager.class, "getApkAssets", new Class[0]);
            }
            return getApkAssetsMethod;
        }
    }

    private static class V14
    extends VersionCompat {
        private V14() {
        }

        private static Context getBaseContext(Context context) {
            Context ctx = context;
            while (ctx instanceof ContextWrapper) {
                ctx = ((ContextWrapper)ctx).getBaseContext();
            }
            return ctx;
        }

        private static void checkOrUpdateResourcesForContext(Context context, Resources preResources, Resources newResources) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
            Context baseContext;
            Resources themeWrapperResources;
            if (context instanceof ContextThemeWrapper && Build.VERSION.SDK_INT >= 17 && (themeWrapperResources = (Resources)V14.mResourcesInContextThemeWrapper().get(context)) == preResources) {
                SplitLog.i((String)SplitCompatResourcesLoader.TAG, (String)"context %s type is @ContextThemeWrapper, and it has its own resources instance!", (Object[])new Object[]{context.getClass().getSimpleName()});
                V14.mResourcesInContextThemeWrapper().set(context, newResources);
                V14.mThemeInContextThemeWrapper().set(context, null);
            }
            if ((baseContext = V14.getBaseContext(context)).getClass().getName().equals("android.app.ContextImpl")) {
                Resources baseContextRes = (Resources)V14.mResourcesInContextImpl().get(baseContext);
                if (baseContextRes == preResources) {
                    V14.mResourcesInContextImpl().set(baseContext, newResources);
                    V14.mThemeInContentImpl().set(baseContext, null);
                }
            } else {
                Resources baseContextRes;
                try {
                    baseContextRes = (Resources)HiddenApiReflection.findField(baseContext, "mResources").get(baseContext);
                    if (baseContextRes == preResources) {
                        HiddenApiReflection.findField(baseContext, "mResources").set(baseContext, newResources);
                        HiddenApiReflection.findField(baseContext, "mTheme").set(baseContext, null);
                    }
                }
                catch (NoSuchFieldException e) {
                    SplitLog.w((String)SplitCompatResourcesLoader.TAG, (String)("Can not find mResources in " + baseContext.getClass().getName()), (Throwable)e);
                }
                baseContextRes = (Resources)V14.mResourcesInContextImpl().get(baseContext);
                if (baseContextRes == preResources) {
                    V14.mResourcesInContextImpl().set(baseContext, newResources);
                    V14.mThemeInContentImpl().set(baseContext, null);
                }
            }
        }

        @SuppressLint(value={"PrivateApi"})
        private static void installSplitResDirs(Context context, Resources preResources, List<String> splitResPaths) throws Throwable {
            Map activeResources;
            Resources newResources = V14.createResources(context, preResources, splitResPaths);
            V14.checkOrUpdateResourcesForContext(context, preResources, newResources);
            Object activityThread = V14.getActivityThread();
            Map activities = (Map)V14.mActivitiesInActivityThread().get(activityThread);
            for (Map.Entry entry : activities.entrySet()) {
                Object activityClientRecord = entry.getValue();
                Activity activity = (Activity)HiddenApiReflection.findField(activityClientRecord, "activity").get(activityClientRecord);
                if (context == activity) continue;
                SplitLog.i((String)SplitCompatResourcesLoader.TAG, (String)"pre-resources found in @mActivities", (Object[])new Object[0]);
                V14.checkOrUpdateResourcesForContext((Context)activity, preResources, newResources);
            }
            if (Build.VERSION.SDK_INT < 19) {
                activeResources = (Map)V14.mActiveResourcesInActivityThread().get(activityThread);
            } else {
                Iterator resourcesManager = V14.getResourcesManager();
                activeResources = (Map)V14.mActiveResourcesInResourcesManager().get(resourcesManager);
            }
            for (Map.Entry entry : activeResources.entrySet()) {
                Resources resources = (Resources)((WeakReference)entry.getValue()).get();
                if (resources == null || resources != preResources) continue;
                activeResources.put(entry.getKey(), new WeakReference<Resources>(newResources));
                SplitLog.i((String)SplitCompatResourcesLoader.TAG, (String)"pre-resources found in @mActiveResources", (Object[])new Object[0]);
                break;
            }
            Map instance_mPackages = (Map)V14.mPackagesInActivityThread().get(activityThread);
            for (Map.Entry entry : instance_mPackages.entrySet()) {
                Resources resources;
                Object packageInfo = ((WeakReference)entry.getValue()).get();
                if (packageInfo == null || (resources = (Resources)V14.mResourcesInLoadedApk().get(packageInfo)) != preResources) continue;
                SplitLog.i((String)SplitCompatResourcesLoader.TAG, (String)"pre-resources found in @mPackages", (Object[])new Object[0]);
                V14.mResourcesInLoadedApk().set(packageInfo, newResources);
            }
            Map instance_mResourcePackages = (Map)V14.mResourcePackagesInActivityThread().get(activityThread);
            for (Map.Entry entry : instance_mResourcePackages.entrySet()) {
                Resources resources;
                Object packageInfo = ((WeakReference)entry.getValue()).get();
                if (packageInfo == null || (resources = (Resources)V14.mResourcesInLoadedApk().get(packageInfo)) != preResources) continue;
                SplitLog.i((String)SplitCompatResourcesLoader.TAG, (String)"pre-resources found in @mResourcePackages", (Object[])new Object[0]);
                V14.mResourcesInLoadedApk().set(packageInfo, newResources);
            }
        }

        private static List<String> getAppResDirs(String appResDir, AssetManager asset) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
            AssetManager sysAsset = Resources.getSystem().getAssets();
            Object[] sysStringBlocks = (Object[])V14.mStringBlocksInAssetManager().get(sysAsset);
            Object[] appStringBlocks = (Object[])V14.mStringBlocksInAssetManager().get(asset);
            int totalResCount = appStringBlocks.length;
            int sysResCount = sysStringBlocks.length;
            ArrayList<String> existedAppResDirList = new ArrayList<String>(totalResCount - sysResCount);
            for (int appResIndex = sysResCount + 1; appResIndex <= totalResCount; ++appResIndex) {
                String inApp = (String)V14.getGetCookieNameMethod().invoke((Object)asset, appResIndex);
                existedAppResDirList.add(inApp);
            }
            if (!existedAppResDirList.contains(appResDir)) {
                boolean inSystem = false;
                for (int i = 1; i <= sysResCount; ++i) {
                    String cookieNameSys = (String)V14.getGetCookieNameMethod().invoke((Object)sysAsset, i);
                    if (!appResDir.equals(cookieNameSys)) continue;
                    inSystem = true;
                    break;
                }
                if (!inSystem) {
                    existedAppResDirList.add(0, appResDir);
                }
            }
            return existedAppResDirList;
        }

        private static Resources createResources(Context context, Resources oldRes, List<String> splitResPaths) throws NoSuchFieldException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
            String appResDir = context.getPackageResourcePath();
            AssetManager oldAsset = oldRes.getAssets();
            List<String> resDirs = V14.getAppResDirs(appResDir, oldAsset);
            resDirs.addAll(0, splitResPaths);
            AssetManager newAsset = V14.createAssetManager();
            for (String recent : resDirs) {
                int ret = (Integer)V14.getAddAssetPathMethod().invoke((Object)newAsset, recent);
                if (ret != 0) continue;
                SplitLog.e((String)SplitCompatResourcesLoader.TAG, (String)("Split Apk res path : " + recent), (Object[])new Object[0]);
                throw new RuntimeException("invoke addAssetPath failure! apk format maybe incorrect");
            }
            return V14.newResources(oldRes, newAsset);
        }

        private static Resources newResources(Resources originRes, AssetManager asset) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
            return (Resources)HiddenApiReflection.findConstructor(originRes, AssetManager.class, DisplayMetrics.class, Configuration.class).newInstance(asset, originRes.getDisplayMetrics(), originRes.getConfiguration());
        }

        private static AssetManager createAssetManager() throws IllegalAccessException, InstantiationException {
            return (AssetManager)AssetManager.class.newInstance();
        }
    }

    private static class V21
    extends VersionCompat {
        private V21() {
        }

        private static void installSplitResDirs(Resources preResources, List<String> splitResPaths) throws Throwable {
            Method method = VersionCompat.getAddAssetPathMethod();
            for (String splitResPath : splitResPaths) {
                method.invoke((Object)preResources.getAssets(), splitResPath);
            }
        }
    }
}

