/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import java.io.File;
import java.util.List;

abstract class SplitInstaller {
    SplitInstaller() {
    }

    public abstract InstallResult install(boolean var1, @NonNull SplitInfo var2) throws InstallException;

    protected abstract void verifySignature(File var1) throws InstallException;

    protected abstract void checkSplitMD5(File var1, String var2) throws InstallException;

    protected abstract List<String> extractMultiDex(File var1, File var2, @NonNull SplitInfo var3) throws InstallException;

    protected abstract void extractLib(File var1, File var2, @NonNull SplitInfo.LibData var3) throws InstallException;

    protected abstract boolean createInstalledMark(File var1) throws InstallException;

    protected abstract boolean createInstalledMarkLock(File var1, File var2) throws InstallException;

    static final class InstallException
    extends Exception {
        private final int errorCode;

        InstallException(int errorCode, Throwable e) {
            super(new StringBuilder(32).append("Split Install Error: ").append(errorCode).toString(), e);
            this.errorCode = errorCode;
        }

        int getErrorCode() {
            return this.errorCode;
        }
    }

    static class InstallResult {
        final String splitName;
        final File apkFile;
        final File splitDexOptDir;
        final File splitLibDir;
        final List<String> addedDexPaths;
        final boolean firstInstalled;

        InstallResult(@NonNull String splitName, @NonNull File apkFile, @Nullable File splitDexOptDir, @Nullable File splitLibDir, @Nullable List<String> addedDexPaths, boolean firstInstalled) {
            this.splitName = splitName;
            this.apkFile = apkFile;
            this.splitDexOptDir = splitDexOptDir;
            this.splitLibDir = splitLibDir;
            this.addedDexPaths = addedDexPaths;
            this.firstInstalled = firstInstalled;
        }
    }
}

