/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import java.util.Enumeration;

public final class CertificateValidity
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.validity";
    public static final String NAME = "validity";
    public static final String NOT_BEFORE = "notBefore";
    public static final String NOT_AFTER = "notAfter";
    private static final long YR_2050 = 2524636800000L;
    private Date notBefore;
    private Date notAfter;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateValidity";

    private Date getNotBefore() {
        if (debug != null) {
            debug.entry(8192L, className, "getNotBefore");
            debug.exit(8192L, (Object)className, "getNotBefore", new Date(this.notBefore.getTime()));
        }
        return new Date(this.notBefore.getTime());
    }

    private Date getNotAfter() {
        if (debug != null) {
            debug.entry(8192L, className, "getNotAfter");
            debug.exit(8192L, (Object)className, "getNotAfter", new Date(this.notAfter.getTime()));
        }
        return new Date(this.notAfter.getTime());
    }

    private void construct(DerValue derVal) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "construct", derVal);
        }
        if (derVal.getTag() != 48) {
            if (debug != null) {
                debug.text(8192L, className, "construct", "Invalid encoded CertificateValidity, starting sequence tag missing.");
            }
            throw new IOException("Invalid encoded CertificateValidity, starting sequence tag missing.");
        }
        if (derVal.getData().available() == 0) {
            if (debug != null) {
                debug.text(8192L, className, "construct", "No data encoded for CertificateValidity");
            }
            throw new IOException("No data encoded for CertificateValidity");
        }
        DerInputStream derIn = new DerInputStream(derVal.toByteArray());
        DerValue[] seq = derIn.getSequence(2);
        if (seq.length != 2) {
            if (debug != null) {
                debug.text(8192L, className, "construct", "Invalid encoding for CertificateValidity");
            }
            throw new IOException("Invalid encoding for CertificateValidity");
        }
        if (seq[0].getTag() == 23) {
            this.notBefore = derVal.getData().getUTCTime();
        } else if (seq[0].getTag() == 24) {
            this.notBefore = derVal.getData().getGeneralizedTime();
        } else {
            if (debug != null) {
                debug.text(8192L, className, "construct", "Invalid encoding for CertificateValidity");
            }
            throw new IOException("Invalid encoding for CertificateValidity");
        }
        if (seq[1].getTag() == 23) {
            this.notAfter = derVal.getData().getUTCTime();
        } else if (seq[1].getTag() == 24) {
            this.notAfter = derVal.getData().getGeneralizedTime();
        } else {
            if (debug != null) {
                debug.text(8192L, className, "construct", "Invalid encoding for CertificateValidity");
            }
            throw new IOException("Invalid encoding for CertificateValidity");
        }
        if (debug != null) {
            debug.exit(8192L, className, "construct");
        }
    }

    public CertificateValidity() {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateValidity");
            debug.exit(16384L, className, "CertificateValidity");
        }
    }

    public CertificateValidity(Date notBefore, Date notAfter) {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateValidity", notBefore, notAfter);
        }
        this.notBefore = notBefore != null ? new Date(notBefore.getTime()) : notBefore;
        this.notAfter = notAfter != null ? new Date(notAfter.getTime()) : notAfter;
        if (debug != null) {
            debug.exit(16384L, className, "CertificateValidity");
        }
    }

    public CertificateValidity(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateValidity", in);
        }
        DerValue derVal = in.getDerValue();
        this.construct(derVal);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateValidity");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.notBefore == null || this.notAfter == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", "Validity: [From: " + this.notBefore.toString() + ",\n               To: " + this.notAfter.toString() + "]");
        }
        return "Validity: [From: " + this.notBefore.toString() + ",\n               To: " + this.notAfter.toString() + "]";
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.notBefore == null || this.notAfter == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "CertAttrSet:CertificateValidity: null values to encode.\n");
            }
            throw new IOException("CertAttrSet:CertificateValidity: null values to encode.\n");
        }
        DerOutputStream pair = new DerOutputStream();
        if (this.notBefore.getTime() < 2524636800000L) {
            pair.putUTCTime(this.notBefore);
        } else {
            pair.putGeneralizedTime(this.notBefore);
        }
        if (this.notAfter.getTime() < 2524636800000L) {
            pair.putUTCTime(this.notAfter);
        } else {
            pair.putGeneralizedTime(this.notAfter);
        }
        DerOutputStream seq = new DerOutputStream();
        seq.write((byte)48, pair);
        out.write(seq.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!(obj instanceof Date)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Date.");
            }
            throw new IOException("Attribute must be of type Date.");
        }
        if (name.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = obj != null ? new Date(((Date)obj).getTime()) : (Date)obj;
        } else if (name.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = obj != null ? new Date(((Date)obj).getTime()) : (Date)obj;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet: CertificateValidity.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateValidity.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(NOT_BEFORE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", this.getNotBefore());
            }
            return this.getNotBefore();
        }
        if (name.equalsIgnoreCase(NOT_AFTER)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.getNotAfter());
            }
            return this.getNotAfter();
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet: CertificateValidity.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateValidity.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (name.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = null;
        } else if (name.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet: CertificateValidity.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateValidity.");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "delete", "Attribute name not recognized by CertAttrSet: CertificateValidity.");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(NOT_BEFORE);
        elements.addElement(NOT_AFTER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public void valid() throws CertificateNotYetValidException, CertificateExpiredException {
        if (debug != null) {
            debug.entry(16384L, className, "valid");
        }
        Date now = new Date();
        this.valid(now);
        if (debug != null) {
            debug.exit(16384L, className, "valid");
        }
    }

    public void valid(Date now) throws CertificateNotYetValidException, CertificateExpiredException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "valid", now);
        }
        if (this.notBefore.after(now)) {
            if (debug != null) {
                debug.text(16384L, className, "valid", "NotBefore: " + this.notBefore.toString());
            }
            throw new CertificateNotYetValidException("NotBefore: " + this.notBefore.toString());
        }
        if (this.notAfter.before(now)) {
            if (debug != null) {
                debug.text(16384L, className, "valid", "NotAfter: " + this.notAfter.toString());
            }
            throw new CertificateExpiredException("NotAfter: " + this.notAfter.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "valid");
        }
    }
}

