/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.tools.dumpASN1;
import com.ibm.security.tools.dumpASN1OidListItem;
import java.io.IOException;
import java.util.Hashtable;

public final class dumpASN1Atom {
    static final byte CLASS_MASK = -64;
    static final int INT_CLASS_MASK = 192;
    static final byte UNIVERSAL = 0;
    static final byte APPLICATION = 64;
    static final byte CONTEXT = -128;
    static final byte PRIVATE = -64;
    static final byte FORM_MASK = 32;
    static final byte PRIMITIVE = 0;
    static final byte CONSTRUCTED = 32;
    static final byte TAG_MASK = 31;
    static final byte EOC = 0;
    static final byte BOOLEAN = 1;
    static final byte INTEGER = 2;
    static final byte BITSTRING = 3;
    static final byte OCTETSTRING = 4;
    static final byte NULLTAG = 5;
    static final byte OID = 6;
    static final byte OBJDESCRIPTOR = 7;
    static final byte EXTERNAL = 8;
    static final byte REAL = 9;
    static final byte ENUMERATED = 10;
    static final byte EMBEDDED_PDV = 11;
    static final byte UTF8STRING = 12;
    static final byte SEQUENCE = 16;
    static final byte SET = 17;
    static final byte NUMERICSTR = 18;
    static final byte PRINTABLESTR = 19;
    static final byte T61STR = 20;
    static final byte VIDEOTEXSTR = 21;
    static final byte IA5STR = 22;
    static final byte UTCTIME = 23;
    static final byte GENERALIZEDTIME = 24;
    static final byte GRAPHICSTR = 25;
    static final byte VISIBLESTR = 26;
    static final byte GENERALSTR = 27;
    static final byte UNIVERSALSTR = 28;
    static final byte BMPSTR = 30;
    static final byte LEN_XTND = -128;
    static final byte LEN_MASK = 127;
    static final byte STR_NONE = 1;
    static final byte STR_UTCTIME = 2;
    static final byte STR_PRINTABLE = 3;
    static final byte STR_IA5 = 4;
    static Hashtable enumAlgoTable = null;
    static Hashtable enumModeTable = null;
    public byte idOctet1;
    public byte id;
    public int tag;
    public long length;
    public boolean indefinite;
    public int headerSize;
    public int[] header = new int[16];
    private int bInd;
    private int hInd;
    private byte[] bytes;
    static final byte P = 1;
    static final byte I = 2;
    static final byte PI = 3;
    static byte[] charFlags = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 3, 2, 2, 2, 2, 2, 3, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 3, 2, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 0};

    public dumpASN1Atom(byte[] callerBytes) {
        this(callerBytes, 0);
    }

    public dumpASN1Atom(byte[] callerBytes, int callerBInd) {
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n->Inside dumpASN1Atom constructor.  callerBInd:" + callerBInd);
        }
        int tempLen = 0;
        int hInd = 0;
        this.indefinite = false;
        this.bytes = callerBytes;
        this.bInd = callerBInd;
        this.idOctet1 = this.bytes[this.bInd++];
        this.header[hInd++] = this.idOctet1;
        this.id = (byte)(this.idOctet1 & 0xFFFFFFE0);
        this.tag = this.idOctet1 & 0x1F;
        if (this.tag == 31) {
            int value;
            this.tag = 0;
            do {
                value = this.bytes[this.bInd++];
                this.tag = this.tag << 7 | value & 0x7F;
                this.header[hInd++] = value;
            } while ((value & 0xFFFFFF80) != 0 && this.bytes.length - this.bInd != 0);
        }
        this.header[hInd] = this.bytes[this.bInd] & 0xFF;
        ++this.bInd;
        this.headerSize = ++hInd;
        if (((tempLen |= this.header[hInd]) & 0xFFFFFF80) != 0) {
            if ((tempLen &= 0x7F) > 4) {
                dumpASN1.ps.print("\nError: Object length field " + tempLen + " too large.\n");
            }
            this.headerSize += tempLen;
            this.length = 0L;
            if (tempLen == 0) {
                this.indefinite = true;
            }
            for (int i2 = 0; i2 < tempLen; ++i2) {
                int temp = this.bytes[this.bInd++] & 0xFF;
                this.length = this.length << 8 | (long)temp;
                this.header[i2 + hInd] = temp;
            }
        } else {
            this.length = tempLen;
        }
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n<-Exiting dumpASN1Atom constructor.  idOctet1:" + this.idOctet1 + " id:" + this.id + " tag:" + this.tag);
            dumpASN1.ps.print("\n                                 length is " + this.length + " bInd:" + this.bInd);
        }
    }

    private long getValue(long gvLen) {
        int sign = 1;
        int temp = this.bytes[this.bInd++];
        if (((temp &= 0xFF) & 0x80) != 0) {
            sign = -1;
            temp &= 0x7F;
        }
        long value = temp;
        int i2 = 0;
        while ((long)i2 < gvLen - 1L) {
            temp = this.bytes[this.bInd++] & 0xFF;
            value = value << 8 | (long)temp;
            ++i2;
        }
        return value * (long)sign;
    }

    public void printConstructed(int level) throws IOException {
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n-> printConstructed (Item).  level:" + level);
        }
        if (this.length == 0L && !this.indefinite) {
            dumpASN1.ps.print(" {}\n");
            if (dumpASN1.pd) {
                dumpASN1.ps.print("\n<- printConstructed (Item) zero len object.  level:" + level);
            }
            return;
        }
        dumpASN1.ps.print(" {\n");
        dumpASN1 asn1s = new dumpASN1(this.bytes, this.bInd);
        int result = asn1s.printASN1(level + 1, this.length, this.indefinite);
        this.bInd = asn1s.getByteIndex();
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\ndumpASN1Atom printConstructed.  Back from asn1s.printASN1(" + (level + 1) + ", " + this.length + ", " + this.indefinite + ")");
        }
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\ndumpASN1Atom printConstructed.  Our bInd:" + this.bInd);
        }
        if (result != 0) {
            dumpASN1.ps.println("Error: Inconsistent object length, " + result + " byte" + (result > 1 ? "s" : "") + " difference.");
            ++dumpASN1.noErrors;
        }
        if (!dumpASN1.doPure) {
            dumpASN1.ps.print("            : ");
        }
        dumpASN1.ps.print(dumpASN1.printDots ? ". " : "  ");
        dumpASN1Atom.doIndent(level);
        dumpASN1.ps.print("}\n");
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n<- printConstructed (Item).  level:" + level);
        }
    }

    public void printASN1Object(int level, int seenEnum) throws IOException {
        byte[] buffer = new byte[64];
        String[] classtext = new String[]{"UNIVERSAL ", "APPLICATION ", "", "PRIVATE "};
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n-> Entering Item's printASN1Object.  Level:" + level);
        }
        if ((this.id & 0xFFFFFFC0) != 0) {
            dumpASN1.ps.print("[" + classtext[(this.id & 0xC0) >> 6] + this.tag + "]");
            if (this.tag != 5 && this.length < 0L) {
                dumpASN1.ps.print("\nError: Object has bad length.\n");
                throw new IOException("Error: Object has bad length");
            }
            if (this.length == 0L && !this.indefinite) {
                dumpASN1.ps.print("\n");
                this.complain("Object has zero length", level);
                return;
            }
            if ((this.id & 0x20) == 32) {
                if (dumpASN1.pd) {
                    dumpASN1.ps.print("\n  Item's printASN1Object calling printConstructed.  Level:" + level);
                }
                this.printConstructed(level);
                if (dumpASN1.pd) {
                    dumpASN1.ps.print("\n  Item's printASN1Object back from printConstructed.  Level:" + level);
                }
                if (dumpASN1.pd) {
                    dumpASN1.ps.print("\n<- Item's printASN1Object returning");
                }
                return;
            }
            if (!dumpASN1.useStdin && this.length >= 4L) {
                int i2;
                int len = this.length <= 16L ? (int)this.length : 16;
                System.arraycopy(this.bytes, this.bInd, buffer, 0, len);
                for (i2 = 0; i2 < len && ((i2 & 1) == 0 && buffer[i2] == 0 || buffer[i2] >= 32 && buffer[i2] <= 126); ++i2) {
                }
                if (i2 == len) {
                    this.displayString(this.length, level, (byte)1);
                    if (dumpASN1.pd) {
                        dumpASN1.ps.print("\n<- Item's printASN1Object returning: i==len");
                    }
                    return;
                }
            }
            this.dumpHex(this.length, level, false);
            if (dumpASN1.pd) {
                dumpASN1.ps.print("\n<- Item's printASN1Object returning.  End of if not universal");
            }
            return;
        }
        dumpASN1.ps.print(this.idstr(this.tag));
        if (this.tag != 5 && this.length < 0L) {
            dumpASN1.ps.print("\nError: Object has bad length field.\n");
        }
        if ((this.id & 0x20) == 32) {
            if (dumpASN1.pd) {
                dumpASN1.ps.print("\nItem's printASN1Object calling printConstructed");
            }
            this.printConstructed(level);
            if (dumpASN1.pd) {
                dumpASN1.ps.print("\nItem's printASN1Object back from printConstructed");
            }
            if (dumpASN1.pd) {
                dumpASN1.ps.print("\n<- Item's printASN1Object returning.  Universal");
            }
            return;
        }
        if (this.length == 0L && this.tag != 5 && this.tag != 0) {
            dumpASN1.ps.println("");
            this.complain("Object has zero length", level);
            return;
        }
        switch (this.tag) {
            case 1: {
                int temp = this.bytes[this.bInd++] & 0xFF;
                dumpASN1.ps.println(temp != 0 ? " TRUE" : " FALSE");
                if (temp == 0 || temp == 255) break;
                this.complain("BOOLEAN has non-DER encoding", level);
                break;
            }
            case 2: {
                if (this.length > 4L) {
                    this.dumpHex(this.length, level, true);
                    break;
                }
                long value = this.getValue(this.length);
                dumpASN1.ps.println(" " + value);
                if (value >= 0L) break;
                dumpASN1.ps.println(" ");
                this.complain("Integer has a negative value", level);
                break;
            }
            case 10: {
                if (seenEnum == 0) {
                    dumpASN1.ps.println(" " + dumpASN1Atom.enumAlgo((int)this.getValue(this.length)));
                    break;
                }
                dumpASN1.ps.println(" " + dumpASN1Atom.enumMode((int)this.getValue(this.length)));
                break;
            }
            case 3: {
                byte x2 = this.bytes[this.bInd++];
                dumpASN1.ps.print(" " + x2 + " unused bits");
                --this.length;
                if (this.length <= 2L) {
                    this.dumpBitString((int)this.length, x2, level);
                    break;
                }
                this.dumpHex(this.length, level, false);
                break;
            }
            case 4: {
                if (this.checkEncapsulate(this.tag)) {
                    dumpASN1.ps.print(", encapsulates");
                    this.printConstructed(level + 1);
                    break;
                }
                this.dumpHex(this.length, level, false);
                break;
            }
            case 6: {
                if (this.length > 64L) {
                    dumpASN1.ps.println("\nError: Object identifier length " + this.length + " too large.");
                    throw new IOException("Error: Object identifier length " + this.length + " too large.");
                }
                System.arraycopy(this.bytes, this.bInd, buffer, 0, (int)this.length);
                this.bInd = (int)((long)this.bInd + this.length);
                dumpASN1OidListItem oidInfo = dumpASN1.oidList.getOIDinfo(buffer, (int)this.length);
                if (oidInfo != null) {
                    int lhsSize;
                    int n2 = lhsSize = dumpASN1.doPure ? 0 : 14;
                    if (lhsSize + level * 2 + 18 + oidInfo.description.length() >= 80) {
                        dumpASN1.ps.println("");
                        if (!dumpASN1.doPure) {
                            dumpASN1.ps.print("            : ");
                        }
                        dumpASN1Atom.doIndent(level + 1);
                    } else {
                        dumpASN1.ps.print(" ");
                    }
                    dumpASN1.ps.print(oidInfo.description + "\n");
                    if (dumpASN1.extraOIDinfo && oidInfo.comment != null) {
                        if (!dumpASN1.doPure) {
                            dumpASN1.ps.print("            : ");
                        }
                        dumpASN1Atom.doIndent(level + 1);
                        dumpASN1.ps.print("(" + oidInfo.comment + ")\n");
                    }
                    if (!oidInfo.warning) break;
                    ++dumpASN1.noWarnings;
                    break;
                }
                int x2 = buffer[0] / 40;
                int y2 = buffer[0] % 40;
                if (x2 > 2) {
                    y2 += (x2 - 2) * 40;
                    x2 = 2;
                }
                dumpASN1.ps.print(" '" + x2 + " " + y2);
                long value = 0L;
                x2 = 1;
                while ((long)x2 < this.length) {
                    value = value << 7 | (long)(buffer[x2] & 0x7F);
                    if ((buffer[x2] & 0x80) == 0) {
                        dumpASN1.ps.print(" " + value);
                        value = 0L;
                    }
                    ++x2;
                }
                dumpASN1.ps.println("'");
                break;
            }
            case 0: 
            case 5: {
                dumpASN1.ps.println("");
                break;
            }
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                this.displayString(this.length, level, (byte)1);
                break;
            }
            case 19: {
                this.displayString(this.length, level, (byte)3);
                break;
            }
            case 23: {
                this.displayString(this.length, level, (byte)2);
                break;
            }
            case 22: {
                this.displayString(this.length, level, (byte)4);
                break;
            }
            default: {
                dumpASN1.ps.println("");
                if (!dumpASN1.doPure) {
                    dumpASN1.ps.print("            : ");
                }
                dumpASN1Atom.doIndent(level + 1);
                dumpASN1.ps.print("Unrecognised primitive, hex value is:");
                this.dumpHex(this.length, level, false);
                ++dumpASN1.noErrors;
            }
        }
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n<-Returning from Item's printASN1Object");
        }
    }

    private boolean checkEncapsulate(int tag) {
        int level;
        int n2 = level = tag == 3 ? dumpASN1.tryBSConstructed : dumpASN1.tryOSConstructed;
        if (level == 0) {
            return false;
        }
        byte ch = this.bytes[this.bInd];
        if (ch == 2 || ch == 48) {
            return true;
        }
        if (tag == 4 && ch == 3) {
            return true;
        }
        return level > 1 && ch == 22;
    }

    private String idstr(int tagID) {
        switch (tagID) {
            case 0: {
                return "End-of-contents octets";
            }
            case 1: {
                return "BOOLEAN";
            }
            case 2: {
                return "INTEGER";
            }
            case 3: {
                return "BIT STRING";
            }
            case 4: {
                return "OCTET STRING";
            }
            case 5: {
                return "NULL";
            }
            case 6: {
                return "OBJECT IDENTIFIER";
            }
            case 7: {
                return "ObjectDescriptor";
            }
            case 8: {
                return "EXTERNAL";
            }
            case 9: {
                return "REAL";
            }
            case 10: {
                return "ENUMERATED";
            }
            case 11: {
                return "EMBEDDED PDV (1993)";
            }
            case 12: {
                return "UTF8String (1997)";
            }
            case 16: {
                return "SEQUENCE";
            }
            case 17: {
                return "SET";
            }
            case 18: {
                return "NumericString";
            }
            case 19: {
                return "PrintableString";
            }
            case 20: {
                return "TeletexString";
            }
            case 21: {
                return "VideotexString";
            }
            case 22: {
                return "IA5String";
            }
            case 23: {
                return "UTCTime";
            }
            case 24: {
                return "GeneralizedTime";
            }
            case 25: {
                return "GraphicString";
            }
            case 26: {
                return "VisibleString";
            }
            case 27: {
                return "GeneralString";
            }
            case 28: {
                return "UniversalString (1993)";
            }
            case 30: {
                return "BMPString (1993)";
            }
        }
        return "Unknown (Reserved)";
    }

    private static String enumAlgo(int enumLen) {
        String algo;
        String[] enumInfo = new String[]{"  0 CRYPT_ALGO_NONE", "  1 CRYPT_ALGO_DES", "  2 CRYPT_ALGO_3DES", "  3 CRYPT_ALGO_IDEA", "  4 CRYPT_ALGO_CAST", "  5 CRYPT_ALGO_RC2", "  6 CRYPT_ALGO_RC4", "  7 CRYPT_ALGO_RC5", "  8 CRYPT_ALGO_SAFER", "  9 CRYPT_ALGO_BLOWFISH", " 10 CRYPT_ALGO_GOST", " 11 CRYPT_ALGO_SKIPJACK", "100 CRYPT_ALGO_DH", "101 CRYPT_ALGO_RSA", "102 CRYPT_ALGO_DSS", "200 CRYPT_ALGO_MD2", "201 CRYPT_ALGO_MD4", "202 CRYPT_ALGO_MD5", "203 CRYPT_ALGO_SHA", "205 CRYPT_ALGO_RIPEMD160"};
        if (enumAlgoTable == null) {
            enumAlgoTable = new Hashtable();
            enumAlgoTable.put(new Integer(0), "CRYPT_ALGO_NONE");
            enumAlgoTable.put(new Integer(1), "CRYPT_ALGO_DES");
            enumAlgoTable.put(new Integer(2), "CRYPT_ALGO_3DES");
            enumAlgoTable.put(new Integer(3), "CRYPT_ALGO_IDEA");
            enumAlgoTable.put(new Integer(4), "CRYPT_ALGO_CAST");
            enumAlgoTable.put(new Integer(5), "CRYPT_ALGO_RC2");
            enumAlgoTable.put(new Integer(6), "CRYPT_ALGO_RC4");
            enumAlgoTable.put(new Integer(7), "CRYPT_ALGO_RC5");
            enumAlgoTable.put(new Integer(8), "CRYPT_ALGO_SAFER");
            enumAlgoTable.put(new Integer(9), "CRYPT_ALGO_BLOWFISH");
            enumAlgoTable.put(new Integer(10), "CRYPT_ALGO_GOST");
            enumAlgoTable.put(new Integer(11), "CRYPT_ALGO_SKIPJACK");
            enumAlgoTable.put(new Integer(100), "CRYPT_ALGO_DH");
            enumAlgoTable.put(new Integer(101), "CRYPT_ALGO_RSA");
            enumAlgoTable.put(new Integer(102), "CRYPT_ALGO_DSS");
            enumAlgoTable.put(new Integer(200), "CRYPT_ALGO_MD2");
            enumAlgoTable.put(new Integer(201), "CRYPT_ALGO_MD4");
            enumAlgoTable.put(new Integer(202), "CRYPT_ALGO_MD5");
            enumAlgoTable.put(new Integer(203), "CRYPT_ALGO_SHA");
            enumAlgoTable.put(new Integer(205), "CRYPT_ALGO_RIPEMD160");
        }
        if ((algo = (String)enumAlgoTable.get(new Integer(enumLen))) == null) {
            algo = "CRYPT_ALGO_UNKNOWN";
        }
        return algo + " (" + enumLen + ")";
    }

    private static String enumMode(int enumLen) {
        String mode;
        if (enumModeTable == null) {
            enumModeTable = new Hashtable();
            enumModeTable.put(new Integer(0), "CRYPT_MODE_NONE");
            enumModeTable.put(new Integer(1), "CRYPT_MODE_STREAM");
            enumModeTable.put(new Integer(2), "CRYPT_MODE_ECB");
            enumModeTable.put(new Integer(3), "CRYPT_MODE_CBC");
            enumModeTable.put(new Integer(4), "CRYPT_MODE_CFB");
            enumModeTable.put(new Integer(5), "CRYPT_MODE_OFB");
            enumModeTable.put(new Integer(100), "CRYPT_MODE_PKC");
        }
        if ((mode = (String)enumModeTable.get(new Integer(enumLen))) == null) {
            mode = "CRYPT_MODE_UNKNOWN";
        }
        return mode + " (" + enumLen + ")";
    }

    public static void doIndent(int level) {
        for (int i2 = 0; i2 < level; ++i2) {
            dumpASN1.ps.print(dumpASN1.printDots ? ". " : "  ");
        }
    }

    private void complain(String message, int level) {
        if (!dumpASN1.doPure) {
            dumpASN1.ps.print("            : ");
        }
        dumpASN1Atom.doIndent(level + 1);
        dumpASN1.ps.println("Error: " + message + ".");
        ++dumpASN1.noErrors;
    }

    private void dumpHex(long dhLen, int level, boolean isInteger) {
        int maxLevel;
        long numBytes = dhLen;
        boolean zeroPadded = false;
        boolean warnPadding = false;
        boolean warnNegative = isInteger;
        int n2 = maxLevel = dumpASN1.doPure ? 15 : 8;
        if (numBytes > 128L) {
            numBytes = 128L;
        }
        if (level > maxLevel) {
            level = maxLevel;
        }
        int i2 = 0;
        while ((long)i2 < numBytes) {
            if (i2 % 16 == 0) {
                dumpASN1.ps.println("");
                if (!dumpASN1.doPure) {
                    dumpASN1.ps.print("            : ");
                }
                dumpASN1Atom.doIndent(level + 1);
            }
            byte digit = this.bytes[this.bInd++];
            int iDigit = digit & 0xFF;
            dumpASN1.ps.print((i2 % 16 != 0 ? " " : "") + dumpASN1Atom.hexDigit(digit));
            if (i2 == 0) {
                if (digit == 0) {
                    zeroPadded = true;
                }
                if ((iDigit & 0x80) == 0) {
                    warnNegative = false;
                }
            }
            if (i2 == 1 && zeroPadded && iDigit < 128) {
                warnPadding = true;
            }
            ++i2;
        }
        if (dhLen > 128L) {
            dhLen -= 128L;
            dumpASN1.ps.println("");
            if (!dumpASN1.doPure) {
                dumpASN1.ps.print("            : ");
            }
            dumpASN1Atom.doIndent(level + 5);
            dumpASN1.ps.print("[ Another " + dhLen + " bytes skipped ]");
            this.bInd = (int)((long)this.bInd + dhLen);
        }
        dumpASN1.ps.println("");
        if (isInteger) {
            if (warnPadding) {
                this.complain("Integer has non-DER encoding", level);
            }
            if (warnNegative) {
                this.complain("Integer has a negative value", level);
            }
        }
    }

    public static String hexDigit(byte x2) {
        String s2 = "";
        char c2 = (char)(x2 >> 4 & 0xF);
        c2 = c2 > '\t' ? (char)(c2 - 10 + 65) : (char)(c2 + 48);
        s2 = String.valueOf(c2);
        c2 = (char)(x2 & 0xF);
        c2 = c2 > '\t' ? (char)(c2 - 10 + 65) : (char)(c2 + 48);
        s2 = s2 + String.valueOf(c2);
        return s2;
    }

    private void dumpBitString(int dbsLen, int unused, int level) {
        int i2;
        int bitString = 0;
        int currentBitMask = 128;
        int remainderMask = 255;
        int value = 0;
        String errorStr = "";
        if (unused < 0 || unused > 7) {
            this.complain("Invalid number of unused bits", level);
        }
        int noBits = dbsLen * 8 - unused;
        if (dbsLen != 0) {
            bitString = this.bytes[this.bInd++];
        }
        if (noBits > 8) {
            bitString = bitString << 8 | this.bytes[this.bInd++];
            currentBitMask = 32768;
            remainderMask = 65535;
        }
        int bitFlag = 1;
        for (i2 = 0; i2 < noBits; ++i2) {
            if ((bitString & currentBitMask) != 0) {
                value |= bitFlag;
            }
            if ((bitString & remainderMask) == 0) {
                errorStr = "Spurious zero bits in bitstring";
            }
            bitFlag <<= 1;
            bitString <<= 1;
        }
        if ((65535 << noBits & value) != 0) {
            errorStr = "Spurious one bits in bitstring";
        }
        dumpASN1.ps.println("");
        if (!dumpASN1.doPure) {
            dumpASN1.ps.print("            : ");
        }
        dumpASN1Atom.doIndent(level + 1);
        dumpASN1.ps.print("'");
        currentBitMask = 1 << noBits - 1;
        for (i2 = 0; i2 < noBits; ++i2) {
            dumpASN1.ps.print((value & currentBitMask) != 0 ? "1" : "0");
            currentBitMask >>= 1;
        }
        dumpASN1.ps.println("'B");
        if (errorStr != "") {
            this.complain(errorStr, level);
        }
    }

    private void displayString(long dsLen, int level, byte checkOption) {
        char ch;
        long noBytes = dsLen > 384L ? 384L : dsLen;
        int maxLevel = dumpASN1.doPure ? 15 : 8;
        boolean firstTime = true;
        boolean warnIA5 = false;
        boolean warnPrintable = false;
        boolean warnUTC = false;
        if (checkOption == 2 && dsLen != 13L) {
            warnUTC = true;
        }
        if (dsLen <= 40L) {
            dumpASN1.ps.print(" '");
        }
        if (level > maxLevel) {
            level = maxLevel;
        }
        int i2 = 0;
        while ((long)i2 < noBytes) {
            if (dsLen > 40L && i2 % 48 == 0) {
                if (!firstTime) {
                    dumpASN1.ps.print("'");
                }
                dumpASN1.ps.println("");
                if (!dumpASN1.doPure) {
                    dumpASN1.ps.print("            : ");
                }
                dumpASN1Atom.doIndent(level + 1);
                dumpASN1.ps.print("'");
                firstTime = false;
            }
            ch = (char)this.bytes[this.bInd++];
            if (checkOption == 3 || checkOption == 4) {
                if (checkOption == 3 && !dumpASN1Atom.isPrintable(ch)) {
                    warnPrintable = true;
                }
                if (checkOption == 4 && !dumpASN1Atom.isIA5(ch)) {
                    warnIA5 = true;
                }
                if (ch < ' ' || ch >= '\u007f') {
                    ch = '.';
                }
            } else if (checkOption == 2) {
                if ("0123456789".indexOf(ch) == -1 && ch != 'Z') {
                    warnUTC = true;
                    ch = '.';
                }
            } else if ((ch & 0x7F) < 32 || ch == '\u00ff') {
                ch = '.';
            }
            dumpASN1.ps.print(ch);
            ++i2;
        }
        if (dsLen > 384L) {
            dsLen -= 384L;
            dumpASN1.ps.println("'");
            if (!dumpASN1.doPure) {
                dumpASN1.ps.print("            : ");
            }
            dumpASN1Atom.doIndent(level + 5);
            dumpASN1.ps.print("[ Another " + dsLen + " characters skipped ]");
            while (dsLen-- != 0L) {
                ch = (char)this.bytes[this.bInd++];
                if (checkOption == 3 && !dumpASN1Atom.isPrintable(ch)) {
                    warnPrintable = true;
                }
                if (checkOption != 4 || dumpASN1Atom.isIA5(ch)) continue;
                warnIA5 = true;
            }
        } else {
            dumpASN1.ps.print("'");
        }
        dumpASN1.ps.println("");
        if (warnPrintable) {
            this.complain("PrintableString contains illegal character(s)", level);
        }
        if (warnIA5) {
            this.complain("IA5String contains illegal character(s)", level);
        }
        if (warnUTC) {
            this.complain("UTCTime is encoded incorrectly", level);
        }
    }

    static boolean isPrintable(char inCh) {
        byte ch = (byte)inCh;
        return ch < 128 && (charFlags[ch] & 1) != 0;
    }

    static boolean isIA5(char inCh) {
        byte ch = (byte)inCh;
        return ch < 128 && (charFlags[ch] & 2) != 0;
    }

    public int getByteIndex() {
        return this.bInd;
    }

    public static String format(String inStr, int before, char fillChar) {
        String fill = "                    ";
        if (fillChar != ' ') {
            fill = fill.replace(' ', fillChar);
        }
        int numBeforeFill = before - inStr.length();
        String outStr = fill.substring(0, numBeforeFill) + inStr;
        return outStr;
    }

    public static String format(String inStr, int before) {
        return dumpASN1Atom.format(inStr, before, ' ');
    }

    public static String format(int num, int before) {
        String temp = String.valueOf(num);
        return dumpASN1Atom.format(temp, before);
    }

    public static String format(long num, int before) {
        String temp = String.valueOf(num);
        return dumpASN1Atom.format(temp, before);
    }
}

