/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public final class FormUtils {
    public static final String FORM_PARAMS_FROM_HTTP_PARAMS = "set.form.parameters.from.http.parameters";
    public static final String FORM_PARAM_MAP = "org.apache.cxf.form_data";
    private static final Logger LOG = LogUtils.getL7dLogger(FormUtils.class);
    private static final String MULTIPART_FORM_DATA_TYPE = "form-data";
    private static final String MAX_FORM_PARAM_COUNT = "maxFormParameterCount";
    private static final String CONTENT_DISPOSITION_FILES_PARAM = "files";
    static final long serialVersionUID = 905816105180058734L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private FormUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "<init>", this);
        }
    }

    /*
     * Loose catch block
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String formToString(Form form) {
        String string;
        ByteArrayOutputStream bos;
        block9: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "formToString", new Object[]{form});
            }
            bos = new ByteArrayOutputStream();
            FormUtils.writeMapToOutputStream((Map<String, List<String>>)form.asMap(), bos, StandardCharsets.UTF_8.name(), false);
            String string2 = bos.toString(StandardCharsets.UTF_8.name());
            bos.close();
            string = string2;
            if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "formToString", string);
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.jaxrs.utils.FormUtils", (String)"71", null, (Object[])new Object[]{form});
                    try {
                        bos.close();
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"org.apache.cxf.jaxrs.utils.FormUtils", (String)"71", null, (Object[])new Object[]{form});
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.jaxrs.utils.FormUtils", (String)"74", null, (Object[])new Object[]{form});
                    String string3 = "";
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        string3 = string3;
                        LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "formToString", string3);
                    }
                    return string3;
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void restoreForm(FormEncodingProvider<Form> provider, Form form, Message message) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "restoreForm", new Object[]{provider, form, message});
        }
        CachedOutputStream os = new CachedOutputStream();
        FormUtils.writeForm(provider, form, (OutputStream)os);
        message.setContent(InputStream.class, (Object)os.getInputStream());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "restoreForm");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void writeForm(FormEncodingProvider<Form> provider, Form form, OutputStream os) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "writeForm", new Object[]{provider, form, os});
        }
        provider.writeTo(form, Form.class, (Type)((Object)Form.class), new Annotation[0], MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MultivaluedMap<String, Object>)new MetadataMap<String, Object>(), os);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "writeForm");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Form readForm(FormEncodingProvider<Form> provider, Message message) throws Exception {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "readForm", new Object[]{provider, message});
        }
        Form form = provider.readFrom(Form.class, (Type)((Object)Form.class), new Annotation[0], MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MultivaluedMap<String, String>)new MetadataMap<String, String>(), (InputStream)message.getContent(InputStream.class));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            form = form;
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "readForm", form);
        }
        return form;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void addPropertyToForm(MultivaluedMap<String, String> map, String name, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "addPropertyToForm", new Object[]{map, name, value});
        }
        if (!"".equals(name)) {
            map.add((Object)name, (Object)value.toString());
        } else {
            MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(value, "");
            for (Map.Entry entry : values.entrySet()) {
                for (Object v : (List)entry.getValue()) {
                    map.add((Object)((String)entry.getKey()), (Object)v.toString());
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "addPropertyToForm");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Exception.class})
    public static String readBody(InputStream is, String encoding) {
        String string;
        block3: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "readBody", new Object[]{is, encoding});
            }
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)is, (OutputStream)bos, (int)1024);
                string = new String(bos.toByteArray(), encoding);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block3;
            }
            catch (Exception ex) {
                throw ExceptionUtils.toInternalServerErrorException(ex, null);
            }
            string = string;
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "readBody", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void populateMapFromString(MultivaluedMap<String, String> params, Message m, String postBody, String enc, boolean decode) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "populateMapFromString", new Object[]{params, m, postBody, enc, decode});
        }
        if (StringUtils.isEmpty((String)postBody)) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "populateMapFromString");
            }
            return;
        }
        String[] parts = postBody.split("&");
        FormUtils.checkNumberOfParts(m, parts.length);
        for (String part : parts) {
            String[] keyValue = new String[2];
            int index = part.indexOf(61);
            if (index != -1) {
                keyValue[0] = part.substring(0, index);
                keyValue[1] = index + 1 < part.length() ? part.substring(index + 1) : "";
            } else {
                keyValue[0] = part;
                keyValue[1] = "";
            }
            String name = HttpUtils.urlDecode(keyValue[0], enc);
            if (decode) {
                params.add((Object)name, (Object)HttpUtils.urlDecode(keyValue[1], enc));
                continue;
            }
            params.add((Object)name, (Object)keyValue[1]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "populateMapFromString");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void populateMapFromStringOrHttpRequest(MultivaluedMap<String, String> params, Message m, String postBody, String enc, boolean decode) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "populateMapFromStringOrHttpRequest", new Object[]{params, m, postBody, enc, decode});
        }
        HttpServletRequest request = (HttpServletRequest)m.get((Object)"HTTP.REQUEST");
        FormUtils.populateMapFromString(params, m, postBody, enc, decode, request);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "populateMapFromStringOrHttpRequest");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void populateMapFromString(MultivaluedMap<String, String> params, Message m, String postBody, String enc, boolean decode, HttpServletRequest request) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "populateMapFromString", new Object[]{params, m, postBody, enc, decode, request});
        }
        if (!StringUtils.isEmpty((String)postBody)) {
            FormUtils.populateMapFromString(params, m, postBody, enc, decode);
        } else if (request != null && MessageUtils.getContextualBoolean((Message)m, (String)FORM_PARAMS_FROM_HTTP_PARAMS, (boolean)true)) {
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String paramName = (String)en.nextElement();
                String[] values = request.getParameterValues(paramName);
                params.put((Object)HttpUtils.urlDecode(paramName), Arrays.asList(values));
            }
            FormUtils.logRequestParametersIfNeeded(params, enc);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "populateMapFromString");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={IOException.class})
    public static void logRequestParametersIfNeeded(Map<String, List<String>> params, String enc) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "logRequestParametersIfNeeded", new Object[]{params, enc});
        }
        if (PhaseInterceptorChain.getCurrentMessage() == null || PhaseInterceptorChain.getCurrentMessage().getInterceptorChain() == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "logRequestParametersIfNeeded");
            }
            return;
        }
        String chain = PhaseInterceptorChain.getCurrentMessage().getInterceptorChain().toString();
        if (chain.contains("LoggingInInterceptor")) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                FormUtils.writeMapToOutputStream(params, bos, enc, false);
                LOG.info(bos.toString(enc));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "logRequestParametersIfNeeded");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void writeMapToOutputStream(Map<String, List<String>> map, OutputStream os, String enc, boolean encoded) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "writeMapToOutputStream", new Object[]{map, os, enc, encoded});
        }
        Iterator<Map.Entry<String, List<String>>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> entry = it.next();
            String key = entry.getKey();
            if (!encoded) {
                key = HttpUtils.urlEncode(key, enc);
            }
            Iterator<String> entryIterator = entry.getValue().iterator();
            while (entryIterator.hasNext()) {
                os.write(key.getBytes(enc));
                os.write(61);
                String value = entryIterator.next();
                if (!encoded) {
                    value = HttpUtils.urlEncode(value, enc);
                }
                os.write(value.getBytes(enc));
                if (!entryIterator.hasNext()) continue;
                os.write(38);
            }
            if (!it.hasNext()) continue;
            os.write(38);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "writeMapToOutputStream");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={IllegalArgumentException.class, IOException.class})
    public static void populateMapFromMultipart(MultivaluedMap<String, String> params, MultipartBody body, Message m, boolean decode) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "populateMapFromMultipart", new Object[]{params, body, m, decode});
        }
        List<Attachment> atts = body.getAllAttachments();
        FormUtils.checkNumberOfParts(m, atts.size());
        for (Attachment a : atts) {
            String name;
            ContentDisposition cd = a.getContentDisposition();
            if (cd != null && !MULTIPART_FORM_DATA_TYPE.equalsIgnoreCase(cd.getType())) continue;
            String cdName = cd == null ? null : cd.getParameter("name");
            String contentId = a.getContentId();
            String string = name = StringUtils.isEmpty((String)cdName) ? contentId : cdName.replace("\"", "").replace("'", "");
            if (StringUtils.isEmpty((String)name)) {
                throw ExceptionUtils.toBadRequestException(null, null);
            }
            if (CONTENT_DISPOSITION_FILES_PARAM.equals(name)) continue;
            try {
                String value = IOUtils.toString((InputStream)a.getDataHandler().getInputStream());
                params.add((Object)HttpUtils.urlDecode(name), (Object)(decode ? HttpUtils.urlDecode(value) : value));
            }
            catch (IllegalArgumentException ex) {
                LOG.warning("Illegal URL-encoded characters, make sure that no @FormParam and @Multipart annotations are mixed up");
                throw ExceptionUtils.toInternalServerErrorException(ex, null);
            }
            catch (IOException ex) {
                throw ExceptionUtils.toBadRequestException(null, null);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "populateMapFromMultipart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={NumberFormatException.class})
    private static void checkNumberOfParts(Message m, int numberOfParts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "checkNumberOfParts", new Object[]{m, numberOfParts});
        }
        if (m == null || m.getExchange() == null || m.getExchange().getInMessage() == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "checkNumberOfParts");
            }
            return;
        }
        String maxPartsCountProp = (String)m.getExchange().getInMessage().getContextualProperty(MAX_FORM_PARAM_COUNT);
        if (maxPartsCountProp == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "checkNumberOfParts");
            }
            return;
        }
        try {
            int maxPartsCount = Integer.parseInt(maxPartsCountProp);
            if (maxPartsCount != -1 && numberOfParts >= maxPartsCount) {
                throw new WebApplicationException(413);
            }
        }
        catch (NumberFormatException ex) {
            throw ExceptionUtils.toInternalServerErrorException(ex, null);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "checkNumberOfParts");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isFormPostRequest(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.utils.FormUtils", "isFormPostRequest", new Object[]{m});
        }
        String contentType = (String)m.get((Object)"Content-Type");
        boolean bl = contentType != null && contentType.toLowerCase().startsWith("application/x-www-form-urlencoded") && "POST".equals(m.get((Object)"org.apache.cxf.request.method"));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.utils.FormUtils", "isFormPostRequest", bl);
        }
        return bl;
    }
}

