/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.info.License;

public class LicenseValidator
extends TypeValidator<License> {
    private static final TraceComponent tc = Tr.register(LicenseValidator.class);
    private static final LicenseValidator INSTANCE = new LicenseValidator();

    public static LicenseValidator getInstance() {
        return INSTANCE;
    }

    private LicenseValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, License t) {
        if (t != null) {
            ValidatorUtils.validateRequiredField(t.getName(), context, "name").ifPresent(helper::addValidationEvent);
            if (t.getUrl() != null && !ValidatorUtils.isValidURI(t.getUrl())) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"licenseInvalidURL", (Object[])new Object[]{t.getUrl()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
    }
}

