/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class ThreadContextAccessor {
    private static final TraceComponent tc;
    static final boolean PRINT_STACK_ON_SET_CTX_CLASSLOADER;
    private static final PrivilegedAction<ThreadContextAccessor> PRIVILEGED_ACTION;
    public static final Object UNCHANGED;
    private static final ThreadContextAccessor threadContextAccessor;

    public abstract boolean isPrivileged();

    public abstract ClassLoader getContextClassLoader(Thread var1);

    public abstract ClassLoader getContextClassLoaderForUnprivileged(Thread var1);

    public abstract void setContextClassLoader(Thread var1, ClassLoader var2);

    public abstract void setContextClassLoaderForUnprivileged(Thread var1, ClassLoader var2);

    public abstract Object pushContextClassLoader(ClassLoader var1);

    public abstract Object pushContextClassLoaderForUnprivileged(ClassLoader var1);

    public Object repushContextClassLoader(Object origLoader, ClassLoader loader) {
        if (origLoader == UNCHANGED) {
            return this.pushContextClassLoader(loader);
        }
        this.setContextClassLoader(Thread.currentThread(), loader);
        return origLoader;
    }

    public Object repushContextClassLoaderForUnprivileged(Object origLoader, ClassLoader loader) {
        if (origLoader == UNCHANGED) {
            return this.pushContextClassLoaderForUnprivileged(loader);
        }
        this.setContextClassLoaderForUnprivileged(Thread.currentThread(), loader);
        return origLoader;
    }

    public void popContextClassLoader(Object origLoader) {
        if (origLoader != UNCHANGED) {
            this.setContextClassLoader(Thread.currentThread(), (ClassLoader)origLoader);
        }
    }

    public void popContextClassLoaderForUnprivileged(Object origLoader) {
        if (origLoader != UNCHANGED) {
            this.setContextClassLoaderForUnprivileged(Thread.currentThread(), (ClassLoader)origLoader);
        }
    }

    public static ThreadContextAccessor getThreadContextAccessor() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
            sm.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        return threadContextAccessor;
    }

    public static PrivilegedAction<ThreadContextAccessor> getPrivilegedAction() {
        return PRIVILEGED_ACTION;
    }

    static {
        ThreadContextAccessor myThreadContextAccessor;
        tc = Tr.register(ThreadContextAccessor.class, (String)"Runtime", null);
        PRINT_STACK_ON_SET_CTX_CLASSLOADER = Boolean.getBoolean("com.ibm.ws.util.threadpool.PrintStackOnSetContextClassLoader");
        PRIVILEGED_ACTION = new PrivilegedAction<ThreadContextAccessor>(){

            @Override
            public ThreadContextAccessor run() {
                return ThreadContextAccessor.getThreadContextAccessor();
            }
        };
        UNCHANGED = new Unchanged();
        if (PRINT_STACK_ON_SET_CTX_CLASSLOADER) {
            myThreadContextAccessor = new ThreadContextAccessorImpl();
        } else {
            try {
                Field field = Thread.class.getDeclaredField("contextClassLoader");
                field.setAccessible(true);
                myThreadContextAccessor = new ReflectionThreadContextAccessorImpl(field);
            }
            catch (Exception ex) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"exception", (Object)ex);
                }
                myThreadContextAccessor = new ThreadContextAccessorImpl();
            }
        }
        threadContextAccessor = myThreadContextAccessor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("using " + threadContextAccessor));
        }
    }

    static class ReflectionThreadContextAccessorImpl
    extends ThreadContextAccessor {
        private final Field field;

        public ReflectionThreadContextAccessorImpl(Field field) {
            this.field = field;
        }

        @Override
        public boolean isPrivileged() {
            return true;
        }

        @Override
        public ClassLoader getContextClassLoader(Thread thread) {
            return this.getContextClassLoaderForUnprivileged(thread);
        }

        @Override
        public ClassLoader getContextClassLoaderForUnprivileged(Thread thread) {
            if (System.getSecurityManager() == null) {
                return thread.getContextClassLoader();
            }
            try {
                return (ClassLoader)this.field.get(thread);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public void setContextClassLoader(Thread thread, ClassLoader loader) {
            this.setContextClassLoaderForUnprivileged(thread, loader);
        }

        @Override
        public void setContextClassLoaderForUnprivileged(Thread thread, ClassLoader loader) {
            if (System.getSecurityManager() == null) {
                thread.setContextClassLoader(loader);
            } else {
                try {
                    this.field.set(thread, loader);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }

        @Override
        public Object pushContextClassLoader(ClassLoader loader) {
            return this.pushContextClassLoaderForUnprivileged(loader);
        }

        @Override
        public Object pushContextClassLoaderForUnprivileged(ClassLoader loader) {
            Thread thread = Thread.currentThread();
            if (System.getSecurityManager() == null) {
                ClassLoader current = thread.getContextClassLoader();
                if (current == loader) {
                    return UNCHANGED;
                }
                thread.setContextClassLoader(loader);
                return current;
            }
            try {
                Object current = this.field.get(thread);
                if (current == loader) {
                    return UNCHANGED;
                }
                this.field.set(thread, loader);
                return current;
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    static class ThreadContextAccessorImpl
    extends ThreadContextAccessor {
        ThreadContextAccessorImpl() {
        }

        @Override
        public boolean isPrivileged() {
            return System.getSecurityManager() == null;
        }

        @Override
        public ClassLoader getContextClassLoader(Thread thread) {
            return thread.getContextClassLoader();
        }

        @Override
        public ClassLoader getContextClassLoaderForUnprivileged(final Thread thread) {
            if (this.isPrivileged()) {
                return this.getContextClassLoader(thread);
            }
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return thread.getContextClassLoader();
                }
            });
        }

        @Override
        public void setContextClassLoader(Thread thread, ClassLoader loader) {
            thread.setContextClassLoader(loader);
        }

        @Override
        public void setContextClassLoaderForUnprivileged(final Thread thread, final ClassLoader loader) {
            if (this.isPrivileged()) {
                thread.setContextClassLoader(loader);
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        thread.setContextClassLoader(loader);
                        return null;
                    }
                });
            }
        }

        @Override
        public Object pushContextClassLoader(ClassLoader loader) {
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            if (current == loader) {
                return UNCHANGED;
            }
            thread.setContextClassLoader(loader);
            return current;
        }

        @Override
        public Object pushContextClassLoaderForUnprivileged(final ClassLoader loader) {
            if (this.isPrivileged()) {
                return this.pushContextClassLoader(loader);
            }
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return this.pushContextClassLoader(loader);
                }
            });
        }
    }

    private static class Unchanged {
        private Unchanged() {
        }
    }
}

