/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.util.am.Alarm;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.CommsServerByteBuffer;
import com.ibm.ws.sib.comms.server.CommsServerByteBufferPool;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.IdToTransactionTable;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.CATMainConsumer;
import com.ibm.ws.sib.comms.server.clientsupport.StaticCATHelper;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.processor.MPConsumerSession;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class CATSyncAsynchReader
implements AsynchConsumerCallback,
SICoreConnectionListener {
    private static String CLASS_NAME = CATSyncAsynchReader.class.getName();
    private int requestNumber;
    private boolean completed = false;
    private Alarm alarm = null;
    private int transaction = 0;
    private static CommsServerByteBufferPool poolManager = CommsServerByteBufferPool.getInstance();
    private Conversation conversation = null;
    private CATMainConsumer mainConsumer = null;
    private boolean currentlyDoingReceiveWithWait = false;
    private static final TraceComponent tc = SibTr.register(CATSyncAsynchReader.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    public CATSyncAsynchReader(int transaction, Conversation conversation, CATMainConsumer mainConsumer, int initialRequestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{transaction, conversation, mainConsumer, initialRequestNumber});
        }
        this.transaction = transaction;
        this.conversation = conversation;
        this.mainConsumer = mainConsumer;
        this.requestNumber = initialRequestNumber;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public void setCurrentlyDoingReceiveWithWait(boolean d) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCurrentlyDoingReceiveWithWait", (Object)d);
        }
        this.currentlyDoingReceiveWithWait = d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCurrentlyDoingReceiveWithWait");
        }
    }

    public boolean isCurrentlyDoingReceiveWithWait() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isCurrentlyDoingReceiveWithWait");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isCurrentlyDoingReceiveWithWait", (Object)this.currentlyDoingReceiveWithWait);
        }
        return this.currentlyDoingReceiveWithWait;
    }

    public void setRequestNumber(int requestNumber) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRequestNumber", (Object)requestNumber);
        }
        this.requestNumber = requestNumber;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRequestNumber");
        }
    }

    public synchronized boolean isComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isComplete");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isComplete", (Object)this.completed);
        }
        return this.completed;
    }

    public synchronized void setComplete(boolean completed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setComplete", (Object)completed);
        }
        this.completed = completed;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setComplete");
        }
    }

    public void setCATTimer(Alarm alarm) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCATTimer", (Object)alarm);
        }
        this.alarm = alarm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCATTimer");
        }
    }

    public void stopSession() throws SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stopSession");
        }
        this.mainConsumer.getConsumerSession().stop();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stopSession");
        }
    }

    public void setTransaction(int tran) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTransaction", (Object)tran);
        }
        this.transaction = tran;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeMessages(LockedMessageEnumeration lme) {
        block34: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"consumeMessages", (Object)lme);
            }
            if (this.alarm != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Cancelling the alarm: " + this.alarm.toString()));
                }
                this.alarm.cancel();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Alarm cancelled");
                }
            }
            if (this.isComplete()) {
                block33: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"This session has already consumed a message - not processing");
                    }
                    try {
                        lme.nextLocked();
                        lme.unlockCurrent();
                    }
                    catch (SIException si) {
                        if (!((ConversationState)this.mainConsumer.getConversation().getAttachment()).hasMETerminated()) {
                            FFDCFilter.processException((Throwable)si, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-016-0003", (Object)this);
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block33;
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)si.getMessage(), (Object)((Object)si));
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"consumeMessages");
                }
                return;
            }
            this.setComplete(true);
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Stopping the session");
                }
                this.stopSession();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Session stopped");
                }
            }
            catch (SIException si) {
                if (!((ConversationState)this.mainConsumer.getConversation().getAttachment()).hasMETerminated()) {
                    FFDCFilter.processException((Throwable)si, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-016-0001", (Object)this);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block34;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)si.getMessage(), (Object)((Object)si));
            }
        }
        try {
            SITransaction siTran;
            JsMessage message = (JsMessage)lme.nextLocked();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received message", (Object)message);
            }
            if ((siTran = ((ServerLinkLevelState)this.conversation.getLinkLevelAttachment()).getTransactionTable().get(this.transaction)) != IdToTransactionTable.INVALID_TRANSACTION) {
                lme.deleteCurrent(siTran);
            } else {
                lme.unlockCurrent();
            }
            this.sendMessageToClient(message);
            this.mainConsumer.setLowestPriority(JFapChannelConstants.getJFAPPriority((Integer)message.getPriority()));
        }
        catch (SIException si) {
            if (!((ConversationState)this.conversation.getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)si, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-016-0002", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)si.getMessage(), (Object)((Object)si));
            }
            StaticCATHelper.sendExceptionToClient(si, "3-016-0002", this.conversation, this.requestNumber);
        }
        finally {
            block36: {
                try {
                    MPConsumerSession mpSession = (MPConsumerSession)this.mainConsumer.getConsumerSession();
                    mpSession.getConnection().removeConnectionListener((SICoreConnectionListener)this);
                }
                catch (SIException e) {
                    if (!((ConversationState)this.conversation.getAttachment()).hasMETerminated()) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".consumeMessages"), (String)"3-016-0013", (Object)this);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block36;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"consumeMessages");
        }
    }

    private void sendMessageToClient(JsMessage jsMessage) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendMessageToClient", (Object)jsMessage);
        }
        this.setCurrentlyDoingReceiveWithWait(false);
        try {
            HandshakeProperties props = this.conversation.getHandshakeProperties();
            if (props.getFapLevel() >= 9) {
                this.sendChunkedMessage(jsMessage);
            } else {
                this.sendEntireMessage(jsMessage, null);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendMessageToClient"), (String)"3-016-0012", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Encode failed: " + e.getMessage()), (Object)e);
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendMessageToClient");
        }
    }

    private void sendChunkedMessage(JsMessage jsMessage) throws UnsupportedEncodingException, MessageEncodeFailedException, IncorrectMessageTypeException, MessageCopyFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage", (Object)jsMessage);
        }
        int msgLen = 0;
        CommsServerByteBuffer buffer = poolManager.allocate();
        ConversationState convState = (ConversationState)this.conversation.getAttachment();
        try {
            List messageSlices = buffer.encodeFast((AbstractMessage)jsMessage, convState.getCommsConnection(), this.conversation);
            for (DataSlice slice : messageSlices) {
                msgLen += slice.getLength();
            }
            if (msgLen < 1024000) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message is smaller than 1024000");
                }
                this.sendEntireMessage(jsMessage, messageSlices);
            } else {
                short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)jsMessage.getPriority());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
                }
                for (int x = 0; x < messageSlices.size(); ++x) {
                    DataSlice slice = (DataSlice)messageSlices.get(x);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sending slice:", (Object)slice);
                    }
                    boolean first = x == 0;
                    boolean last = x == messageSlices.size() - 1;
                    byte flags = 0;
                    if (first) {
                        flags = (byte)(flags | 1);
                    }
                    if (last) {
                        flags = (byte)(flags | 4);
                    } else if (!first) {
                        flags = (byte)(flags | 2);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Flags: " + flags));
                    }
                    if (!first) {
                        buffer = poolManager.allocate();
                    }
                    buffer.putShort(convState.getConnectionObjectId());
                    if (!this.mainConsumer.getUsingConnectionReceive()) {
                        buffer.putShort(this.mainConsumer.getConsumerSessionId());
                    }
                    buffer.put(flags);
                    buffer.putDataSlice(slice);
                    int seg = 0;
                    seg = this.mainConsumer.getUsingConnectionReceive() ? (last ? 199 : 250) : (last ? 206 : 251);
                    this.conversation.send((JFapByteBuffer)buffer, seg, last ? this.requestNumber : 0, (int)jfapPriority, false, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
                }
                ++this.mainConsumer.messagesSent;
            }
        }
        catch (SIException e) {
            if (!((ConversationState)this.mainConsumer.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendChunkedMessage"), (String)"3-016-0005", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2015", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage");
        }
    }

    private void sendEntireMessage(JsMessage jsMessage, List<DataSlice> messageSlices) throws UnsupportedEncodingException, MessageCopyFailedException, IncorrectMessageTypeException, MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendEntireMessage", (Object)new Object[]{jsMessage, messageSlices});
        }
        int msgLen = 0;
        try {
            CommsServerByteBuffer buffer = poolManager.allocate();
            ConversationState convState = (ConversationState)this.conversation.getAttachment();
            buffer.putShort(convState.getConnectionObjectId());
            if (!this.mainConsumer.getUsingConnectionReceive()) {
                buffer.putShort(this.mainConsumer.getConsumerSessionId());
            }
            msgLen = messageSlices == null ? buffer.putMessage(jsMessage, convState.getCommsConnection(), this.conversation) : buffer.putMessgeWithoutEncode(messageSlices);
            int seg = 206;
            if (this.mainConsumer.getUsingConnectionReceive()) {
                seg = 199;
            }
            short jfapPriority = JFapChannelConstants.getJFAPPriority((Integer)jsMessage.getPriority());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
            }
            this.conversation.send((JFapByteBuffer)buffer, seg, this.requestNumber, (int)jfapPriority, false, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
            ++this.mainConsumer.messagesSent;
        }
        catch (SIException e) {
            if (!((ConversationState)this.mainConsumer.getConversation().getAttachment()).hasMETerminated()) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendEntireMessage"), (String)"3-016-0004", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)e.getMessage(), (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2015", (Object)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendEntireMessage");
        }
    }

    protected void sendNoMessageToClient() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendNoMessageToClient");
        }
        this.setCurrentlyDoingReceiveWithWait(false);
        this.setComplete(true);
        CommsServerByteBuffer buffer = poolManager.allocate();
        int msgLen = -1;
        ConversationState convState = (ConversationState)this.conversation.getAttachment();
        buffer.putShort(convState.getConnectionObjectId());
        if (!this.mainConsumer.getUsingConnectionReceive()) {
            buffer.putShort(this.mainConsumer.getConsumerSessionId());
        }
        buffer.putLong(msgLen);
        int seg = 206;
        if (this.mainConsumer.getUsingConnectionReceive()) {
            seg = 199;
        }
        try {
            this.conversation.send((JFapByteBuffer)buffer, seg, this.requestNumber, 7, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, null);
        }
        catch (SIException c) {
            FFDCFilter.processException((Throwable)c, (String)(CLASS_NAME + ".sendNoMessageToClient"), (String)"3-016-0007", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)c.getMessage(), (Object)((Object)c));
            }
            SibTr.error((TraceComponent)tc, (String)"COMMUNICATION_ERROR_SICO2015", (Object)((Object)c));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendNoMessageToClient");
        }
    }

    protected void sendErrorToClient(Throwable e, String probeId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendErrorToClient", (Object)new Object[]{e, probeId});
        }
        this.setComplete(true);
        this.setCurrentlyDoingReceiveWithWait(false);
        StaticCATHelper.sendExceptionToClient(e, probeId, this.conversation, this.requestNumber);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendErrorToClient");
        }
    }

    protected boolean isConversationClosed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isConversationClosed");
        }
        boolean isClosed = this.conversation.isClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isConversationClosed", (Object)isClosed);
        }
        return isClosed;
    }

    public String toString() {
        return "currentlyDoingReceiveWithWait: " + this.currentlyDoingReceiveWithWait;
    }

    private void deliverAsynchExceptionToClient(Throwable throwable, String probeId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deliverAsynchExceptionToClient", (Object)throwable);
        }
        if (!this.isComplete()) {
            if (this.alarm != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Cancelling the alarm: " + this.alarm.toString()));
                }
                this.alarm.cancel();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Alarm cancelled");
                }
            }
            if (!this.isComplete()) {
                block9: {
                    try {
                        MPConsumerSession mpSession = (MPConsumerSession)this.mainConsumer.getConsumerSession();
                        mpSession.getConnection().removeConnectionListener((SICoreConnectionListener)this);
                    }
                    catch (SIException s) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)s.getMessage(), (Object)((Object)s));
                    }
                }
                this.sendErrorToClient(throwable, probeId);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deliverAsynchExceptionToClient");
        }
    }

    public void asynchronousException(ConsumerSession consumer, Throwable exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"asynchronousException", (Object)new Object[]{consumer, exception});
        }
        this.deliverAsynchExceptionToClient(exception, "3-016-0009");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"asynchronousException");
        }
    }

    public void meQuiescing(SICoreConnection conn) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"meQuiescing", (Object)conn);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"meQuiescing", (Object)conn);
        }
    }

    public void commsFailure(SICoreConnection conn, SIConnectionLostException exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commsFailure", (Object)new Object[]{conn, exception});
        }
        this.deliverAsynchExceptionToClient((Throwable)exception, "3-016-0010");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commsFailure");
        }
    }

    public void meTerminated(SICoreConnection conn) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"meTerminated", (Object)conn);
        }
        this.deliverAsynchExceptionToClient((Throwable)new SIErrorException(), "3-016-0011");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"meTerminated");
        }
    }

    public boolean hasMETerminated() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasMETerminated");
        }
        boolean hasMETerminated = ((ConversationState)this.mainConsumer.getConversation().getAttachment()).hasMETerminated();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasMETerminated", (Object)hasMETerminated);
        }
        return hasMETerminated;
    }

    CATMainConsumer getCATMainConsumer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCATMainConsumer");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCATMainConsumer", (Object)this.mainConsumer);
        }
        return this.mainConsumer;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/CATSyncAsynchReader.java, SIB.comms, WASX.SIB, aa1225.01 1.57");
        }
    }
}

