/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.objectManager;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.utils.ras.SibTr;

public class MEStartupTimeouts {
    private static TraceComponent tc = SibTr.register(MEStartupTimeouts.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _retryTimeLimit;
    private long _retryWaitTime;

    public MEStartupTimeouts(MessageStoreImpl MS) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("MS=" + (Object)((Object)MS)));
        }
        try {
            if (MS != null) {
                String retryTimeLimit = MS.getProperty("omStartupRetryTimeLimit", "900000");
                this._retryTimeLimit = Long.parseLong(retryTimeLimit);
                String retryWaitTime = MS.getProperty("omStartupRetryWaitTime", "5000");
                this._retryWaitTime = Long.parseLong(retryWaitTime);
            } else {
                this._retryTimeLimit = Long.parseLong("900000");
                this._retryWaitTime = Long.parseLong("5000");
            }
        }
        catch (NumberFormatException nfe) {
            FFDCFilter.processException((Throwable)nfe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.MEStartupTimeouts.<init>", (String)"1:72:1.3", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"NumberFormatException caught parsing properties! Using safe defaults.", (Object)nfe);
            }
            this._retryTimeLimit = 900000L;
            this._retryWaitTime = 5000L;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("omStartupRetryTimeLimit=" + this._retryTimeLimit));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("omStartupRetryWaitTime=" + this._retryWaitTime));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public long getRetryTimeLimit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRetryTimeLimit");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRetryTimeLimit", (Object)this._retryTimeLimit);
        }
        return this._retryTimeLimit;
    }

    public long getRetryWaitTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRetryWaitTime");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRetryWaitTime", (Object)this._retryWaitTime);
        }
        return this._retryWaitTime;
    }
}

