/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.client.jaas.modules;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.clientcontainer.metadata.CallbackHandlerProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.client.internal.jaas.JAASClientService;
import com.ibm.ws.security.jaas.common.modules.CommonLoginModule;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSClientLoginModuleImpl
extends CommonLoginModule {
    private static final TraceComponent tc = Tr.register(WSClientLoginModuleImpl.class, (String)"security", (String)"com.ibm.ws.security.client.internal.resources.SecurityClientMessages");
    static final long serialVersionUID = 4413931770293507412L;

    public void initialize(Subject subject, CallbackHandler callbackHandlerFromLoginContextEntry, Map<String, ?> sharedState, Map<String, ?> options) {
        CallbackHandler callbackHandlerFromDD = null;
        CallbackHandler callbackHandler = null;
        Boolean ignoreCallbackFromDD = false;
        if (options != null) {
            ignoreCallbackFromDD = (Boolean)options.get("was.ignoreClientContainerDD");
        }
        if (ignoreCallbackFromDD != null && ignoreCallbackFromDD.booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CallbackHandler passed from LoginContext constructor is used because ignore option is set on the login module.", (Object[])new Object[0]);
            }
            callbackHandler = callbackHandlerFromLoginContextEntry;
        } else {
            CallbackHandlerProvider cbhProvider = JAASClientService.getCallbackHandlerProvider();
            if (cbhProvider != null) {
                callbackHandlerFromDD = cbhProvider.getCallbackHandler();
            }
            if (callbackHandlerFromDD != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Client Container Deployment Descriptor's CallbackHandler is used: " + callbackHandlerFromDD), (Object[])new Object[0]);
                }
                callbackHandler = callbackHandlerFromDD;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CallbackHandler passed from LoginContext constructor is used because no CallbackHanlder was specified in the Client Container Deployment Descriptor.", (Object[])new Object[0]);
                }
                callbackHandler = callbackHandlerFromLoginContextEntry;
            }
        }
        super.initialize(subject, callbackHandler, sharedState, options);
    }

    public boolean login() throws LoginException {
        Subject basicAuthSubject = JAASClientService.getClientAuthenticationService().authenticate(this.callbackHandler, this.subject);
        this.setUpSubject(basicAuthSubject);
        this.setAlreadyProcessed();
        return true;
    }
}

