/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.utility.ICollectiveValidationMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Map;

public class TestConnectionTask
extends BaseCommandTask {
    private static final String className = TestConnectionTask.class.getName();
    private static final String TASK_NAME = "testConnection";
    private final ICollectiveValidationMBeanConnection validationMBeanConn;

    public TestConnectionTask(String scriptName, IFileUtility fileUtility, ICollectiveValidationMBeanConnection validationMBeanConn) {
        super(scriptName, fileUtility);
        this.validationMBeanConn = validationMBeanConn;
        this.reqConnectArgs.add("--host");
        this.reqConnectArgs.add("--port");
        this.reqConnectArgs.add("--user");
        this.reqConnectArgs.add("--password");
        this.flagArgs.add("--trace");
        this.flagArgs.add("--controller");
        this.knownArgs.addAll(this.reqConnectArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return TASK_NAME;
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("testConnection.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept");
        return this.getTaskHelp("testConnection.desc", "testConnection.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("testConnection.desc", new Object[0]);
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, false);
        String controllerHostName = this.getControllerHost(args);
        int controllerPort = Integer.valueOf(this.getControllerPort(args));
        String controllerUserName = this.getControllerUser(args);
        String controllerPassword = this.getControllerPassword(args);
        this.handleAutoAcceptArgument(args);
        String[] targetParm = this.validateTargetParm(args[1]);
        Trlog.debug(className, methodName, "Input parameters: ", new Object[]{targetParm[0], controllerHostName, controllerPort, controllerUserName, controllerPassword.replaceAll(".", "*")});
        switch (targetParm.length) {
            case 1: {
                this.testConnection(targetParm[0], controllerHostName, controllerPort, controllerUserName, controllerPassword);
                break;
            }
            case 3: {
                String targetWlpUsrDir = RepositoryPathUtility.normalizePath((String)targetParm[1]);
                this.testConnection(targetParm[0], targetWlpUsrDir, targetParm[2], controllerHostName, controllerPort, controllerUserName, controllerPassword);
                break;
            }
            default: {
                this.abort(this.getMessage("testConnection.parm.tuple.error", args[1]), methodName);
            }
        }
        Trlog.exit(className, methodName);
    }

    private void testConnection(String targetHostName, String controllerHostName, int controllerPort, String controllerUserName, String controllerPassword) throws TaskErrorException {
        String methodName = TASK_NAME;
        Trlog.enter(className, methodName, new Object[]{controllerHostName, controllerPort, controllerUserName, controllerPassword.replaceAll(".", "*")});
        Map<String, Object> response = null;
        String hostRespMsg = null;
        try {
            response = this.validationMBeanConn.testConnection(targetHostName, controllerHostName, controllerPort, controllerUserName, controllerPassword);
            Trlog.debug(className, methodName, "Successfully test connection with CollectiveValidation mbean.");
        }
        catch (ConnectException ce) {
            this.abort(this.getMessage("testConnection.controller.connect.error", controllerHostName, controllerPort, controllerUserName, ce.getMessage()), methodName);
        }
        catch (UnknownHostException uhe) {
            this.abort(this.getMessage("testConnection.controller.host.error", controllerHostName, uhe.getMessage()), methodName);
        }
        catch (IOException ioe) {
            this.abort(this.getMessage("testConnection.controller.connect.error", controllerHostName, controllerPort, controllerUserName, ioe.getMessage()), methodName);
        }
        catch (Exception e) {
            this.abort(this.getMessage("testConnection.controller.error", controllerHostName, controllerPort, controllerUserName, e.getMessage()), methodName);
        }
        hostRespMsg = (String)response.get("HOST_RESULT");
        String hostMsg = hostRespMsg == null ? this.getMessage("testConnection.host.error", targetHostName) : (hostRespMsg.equals("success") ? this.getMessage("testConnection.rxa.host.successful", targetHostName) : hostRespMsg);
        Trlog.debug(className, methodName, "hostMsg = " + hostMsg);
        if (hostRespMsg != null && hostRespMsg.equals("success")) {
            this.stdout.println(hostMsg);
            this.stdout.println();
        } else {
            this.abort(hostMsg, methodName);
        }
        Trlog.exit(className, methodName, "testing connection is done successfully");
    }

    private void testConnection(String targetHostName, String targetWlpUsrDir, String targetServerName, String controllerHostName, int controllerPort, String controllerUserName, String controllerPassword) throws TaskErrorException {
        String methodName = TASK_NAME;
        Trlog.enter(className, methodName, new Object[]{targetHostName, targetWlpUsrDir, targetServerName, controllerHostName, controllerPort, controllerUserName, controllerPassword.replaceAll(".", "*")});
        Map<String, Object> response = null;
        try {
            response = this.validationMBeanConn.testConnection(targetHostName, targetWlpUsrDir, targetServerName, controllerHostName, controllerPort, controllerUserName, controllerPassword);
            Trlog.debug(className, methodName, "Successfully test connection with CollectiveValidation mbean.");
        }
        catch (ConnectException ce) {
            this.abort(this.getMessage("testConnection.controller.connect.error", controllerHostName, controllerPort, controllerUserName, ce.getMessage()), methodName);
        }
        catch (UnknownHostException uhe) {
            this.abort(this.getMessage("testConnection.controller.host.error", controllerHostName, uhe.getMessage()), methodName);
        }
        catch (IOException ioe) {
            this.abort(this.getMessage("testConnection.controller.connect.error", controllerHostName, controllerPort, controllerUserName, ioe.getMessage()), methodName);
        }
        catch (Exception e) {
            this.abort(this.getMessage("testConnection.controller.error", controllerHostName, controllerPort, controllerUserName, e.getMessage()), methodName);
        }
        String tuple = targetHostName + "," + targetWlpUsrDir + "," + targetServerName;
        String hostRespMsg = (String)response.get("HOST_RESULT");
        String hostMsg = hostRespMsg == null ? this.getMessage("testConnection.host.error", tuple) : (hostRespMsg.equals("success") ? this.getMessage("testConnection.rxa.server.successful", tuple) : hostRespMsg);
        Trlog.debug(className, methodName, "hostMsg = " + hostMsg);
        String sslRespMsg = (String)response.get("SSL_RESULT");
        String sslMsg = sslRespMsg == null ? this.getMessage("testConnection.server.error", tuple) : (sslRespMsg.equals("success") ? this.getMessage("testConnection.ssl.server.successful", tuple) : sslRespMsg);
        Trlog.debug(className, methodName, "sslMsg = " + sslMsg);
        if (sslRespMsg != null && hostRespMsg != null) {
            if (!hostRespMsg.equals("success") && sslRespMsg.equals("success")) {
                this.stdout.println(sslMsg);
                this.abort(hostMsg, methodName);
            } else if (!sslRespMsg.equals("success") && hostRespMsg.equals("success")) {
                this.stdout.println(hostMsg);
                this.abort(sslMsg, methodName);
            } else if (hostRespMsg.equals("success") && sslRespMsg.equals("success")) {
                Trlog.debug(className, methodName, "Test connection is done successfully! hostMsg = " + hostMsg + ", sslMsg = " + sslMsg);
                this.stdout.println(hostMsg);
                this.stdout.println();
                this.stdout.println(sslMsg);
                this.stdout.println();
            } else {
                this.abort(hostMsg + "\n\n" + sslMsg, methodName);
            }
        } else if (sslRespMsg == null && hostRespMsg != null && hostRespMsg.equals("success")) {
            this.stdout.println(hostMsg);
            this.abort(sslMsg, methodName);
        } else if (hostRespMsg == null && sslRespMsg != null && sslRespMsg.equals("success")) {
            this.stdout.println(sslRespMsg);
            this.abort(hostMsg, methodName);
        } else {
            this.abort(hostMsg + "\n\n" + sslMsg, methodName);
        }
        Trlog.exit(className, methodName);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("testConnection.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    private void abort(String message, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        this.stdout.println(this.getMessage("testConnection.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File cleanupRoot) throws TaskErrorException {
        this.stdout.println(this.getMessage("testConnection.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    private String[] validateTargetParm(String targetArg) throws TaskErrorException {
        String[] target = targetArg.split(",");
        for (int i = 0; i < target.length; ++i) {
            if (target[i] != null && !target[i].isEmpty()) continue;
            Trlog.debug(className, "validateTargetParm", "The specified connection target tuple: " + targetArg + " is invalid.");
            this.abort(this.getMessage("testConnection.parm.tuple.error", targetArg));
        }
        return target;
    }
}

