/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import java.io.Serializable;

public class ConfigValidationException
extends Exception {
    private static final long serialVersionUID = -2637730579475070264L;
    private final Problem[] problems;

    public ConfigValidationException(Problem[] problems) {
        super(ConfigValidationException.list("Configuration validation failed", problems));
        this.problems = problems;
    }

    private static String list(String msg, Problem[] problems) {
        StringBuilder b = new StringBuilder();
        b.append(msg).append(':');
        for (int i = 0; i < problems.length; ++i) {
            Problem problem = problems[i];
            Assert.checkNotNullArrayParam((String)"problems", (int)i, (Object)problem);
            b.append(System.lineSeparator());
            b.append("\t");
            b.append(problem.getMessage());
        }
        return b.toString();
    }

    public int getProblemCount() {
        return this.problems.length;
    }

    public Problem getProblem(int index) {
        return this.problems[index];
    }

    public static final class Problem
    implements Serializable {
        public static final Problem[] NO_PROBLEMS = new Problem[0];
        private static final long serialVersionUID = 5984436393578154541L;
        private final String message;

        public Problem(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

