/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.extension;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.config.internal.serverxml.AppPropertyConfigSource;
import io.openliberty.microprofile.config.internal.serverxml.ServerXMLDefaultVariableConfigSource;
import io.openliberty.microprofile.config.internal.serverxml.ServerXMLVariableConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OLSmallRyeConfigBuilder
extends SmallRyeConfigBuilder {
    private static final TraceComponent tc = Tr.register(OLSmallRyeConfigBuilder.class, (String)"APPCONFIG", null);
    static final long serialVersionUID = -7271352535960418103L;

    @Override
    protected List<ConfigSource> getDefaultSources() {
        List<ConfigSource> defaultSources = super.getDefaultSources();
        defaultSources.add((ConfigSource)new AppPropertyConfigSource());
        defaultSources.add((ConfigSource)new ServerXMLVariableConfigSource());
        defaultSources.add((ConfigSource)new ServerXMLDefaultVariableConfigSource());
        return defaultSources;
    }

    @Override
    @Trivial
    public SmallRyeConfig build() {
        SmallRyeConfig config = super.build();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            String profileName = config.getRawValue("smallrye.config.profile");
            Tr.event((Object)this, (TraceComponent)tc, (String)("Config created with profile: " + profileName), (Object[])new Object[]{config});
        }
        return config;
    }
}

