/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XSIntegerUtil {
    public static final long UNSIGNED_INT_MAX_VALUE = 0xFFFFFFFFL;
    public static final int UNSIGNED_SHORT_MAX_VALUE = 65535;
    public static final int UNSIGNED_BYTE_MAX_VALUE = 255;
    private static final int SIGNED_INT_MULTMIN = -214748364;
    private static final long SIGNED_LONG_MULTMIN = -922337203685477580L;

    public static long parseLong(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0L;
        }
        if (xMLString.bytes != null) {
            return XSIntegerUtil.parseLongUnbuffered(xMLString, nArray);
        }
        return XSIntegerUtil.parseLongBuffered(xMLString, nArray);
    }

    public static int parseInt(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0;
        }
        if (xMLString.bytes != null) {
            return XSIntegerUtil.parseIntUnbuffered(xMLString, nArray);
        }
        return XSIntegerUtil.parseIntBuffered(xMLString, nArray);
    }

    public static long parseUInt(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0L;
        }
        if (xMLString.bytes != null) {
            return XSIntegerUtil.parseUIntUnbuffered(xMLString, nArray);
        }
        return XSIntegerUtil.parseUIntBuffered(xMLString, nArray);
    }

    public static short parseShort(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0;
        }
        if (xMLString.bytes != null) {
            return (short)XSIntegerUtil.parseSignedUnbuffered(xMLString, Short.MAX_VALUE, Short.MIN_VALUE, nArray);
        }
        return (short)XSIntegerUtil.parseSignedBuffered(xMLString, Short.MAX_VALUE, Short.MIN_VALUE, nArray);
    }

    public static int parseUShort(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0;
        }
        if (xMLString.bytes != null) {
            return XSIntegerUtil.parseUSignedUnbuffered(xMLString, 65535, nArray);
        }
        return XSIntegerUtil.parseUSignedBuffered(xMLString, 65535, nArray);
    }

    public static byte parseByte(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0;
        }
        if (xMLString.bytes != null) {
            return (byte)XSIntegerUtil.parseSignedUnbuffered(xMLString, 127, -128, nArray);
        }
        return (byte)XSIntegerUtil.parseSignedBuffered(xMLString, 127, -128, nArray);
    }

    public static short parseUByte(XMLString xMLString, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return 0;
        }
        if (xMLString.bytes != null) {
            return (short)XSIntegerUtil.parseUSignedUnbuffered(xMLString, 255, nArray);
        }
        return (short)XSIntegerUtil.parseUSignedBuffered(xMLString, 255, nArray);
    }

    private static long parseLongUnbuffered(XMLString xMLString, int[] nArray) {
        byte by;
        boolean bl = false;
        long l = -9223372036854775807L;
        long l2 = -922337203685477580L;
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by = xMLString.bytes[n++]) <= 32) {
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n < n2) {
                    by = xMLString.bytes[n++];
                    continue;
                }
                nArray[0] = 1;
                return 0L;
            }
        }
        if (by == 45) {
            bl = true;
            l = Long.MIN_VALUE;
            if (n < n2) {
                by = xMLString.bytes[n++];
            }
        } else if (by == 43 && n < n2) {
            by = xMLString.bytes[n++];
        }
        if (by >= 48 && by <= 57) {
            long l3 = 48 - by;
            while (n < n2) {
                if ((by = xMLString.bytes[n++]) >= 48 && by <= 57) {
                    int n3;
                    if (l3 >= l2 && (l3 *= 10L) >= l + (long)(n3 = by - 48)) {
                        l3 -= (long)n3;
                        continue;
                    }
                } else if (by <= 32) {
                    while (by == 32 || by == 10 || by == 9 || by == 13) {
                        if (n < n2) {
                            by = xMLString.bytes[n++];
                            continue;
                        }
                        return bl ? l3 : -l3;
                    }
                }
                nArray[0] = 1;
                return 0L;
            }
            return bl ? l3 : -l3;
        }
        nArray[0] = 1;
        return 0L;
    }

    private static long parseLongBuffered(XMLString xMLString, int[] nArray) {
        byte by;
        boolean bl = false;
        long l = -9223372036854775807L;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by = dataBuffer.bytes[n++]) <= 32) {
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n < n2) {
                    by = dataBuffer.bytes[n++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0L;
                }
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n++];
            }
        }
        if (by == 45) {
            bl = true;
            l = Long.MIN_VALUE;
            while (true) {
                if (n < n2) {
                    by = dataBuffer.bytes[n++];
                } else if (dataBuffer != dataBuffer2) {
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    continue;
                }
                break;
            }
        } else if (by == 43) {
            while (true) {
                if (n < n2) {
                    by = dataBuffer.bytes[n++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by >= 48 && by <= 57) {
            long l2 = 48 - by;
            while (true) {
                if (n < n2) {
                    if ((by = dataBuffer.bytes[n++]) >= 48 && by <= 57) {
                        int n3 = by - 48;
                        if (l2 >= -922337203685477580L && (l2 *= 10L) >= l + (long)n3) {
                            l2 -= (long)n3;
                            continue;
                        }
                    } else if (by <= 32) {
                        while (by == 32 || by == 10 || by == 9 || by == 13) {
                            if (n < n2) {
                                by = dataBuffer.bytes[n++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return bl ? l2 : -l2;
                            }
                            dataBuffer = dataBuffer.next;
                            n = dataBuffer.startOffset;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by = dataBuffer.bytes[n++];
                        }
                    }
                    nArray[0] = 1;
                    return 0L;
                }
                if (dataBuffer == dataBuffer2) {
                    return bl ? l2 : -l2;
                }
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0L;
    }

    private static int parseIntUnbuffered(XMLString xMLString, int[] nArray) {
        byte by;
        boolean bl = false;
        int n = -2147483647;
        int n2 = -214748364;
        int n3 = xMLString.startOffset;
        int n4 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by = xMLString.bytes[n3++]) <= 32) {
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n3 < n4) {
                    by = xMLString.bytes[n3++];
                    continue;
                }
                nArray[0] = 1;
                return 0;
            }
        }
        if (by == 45) {
            bl = true;
            n = Integer.MIN_VALUE;
            if (n3 < n4) {
                by = xMLString.bytes[n3++];
            }
        } else if (by == 43 && n3 < n4) {
            by = xMLString.bytes[n3++];
        }
        if (by >= 48 && by <= 57) {
            int n5 = 48 - by;
            while (n3 < n4) {
                if ((by = xMLString.bytes[n3++]) >= 48 && by <= 57) {
                    int n6;
                    if (n5 >= n2 && (n5 *= 10) >= n + (n6 = by - 48)) {
                        n5 -= n6;
                        continue;
                    }
                } else if (by <= 32) {
                    while (by == 32 || by == 10 || by == 9 || by == 13) {
                        if (n3 < n4) {
                            by = xMLString.bytes[n3++];
                            continue;
                        }
                        return bl ? n5 : -n5;
                    }
                }
                nArray[0] = 1;
                return 0;
            }
            return bl ? n5 : -n5;
        }
        nArray[0] = 1;
        return 0;
    }

    private static int parseIntBuffered(XMLString xMLString, int[] nArray) {
        byte by;
        boolean bl = false;
        int n = -2147483647;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by = dataBuffer.bytes[n2++]) <= 32) {
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n2 < n3) {
                    by = dataBuffer.bytes[n2++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n2++];
            }
        }
        if (by == 45) {
            bl = true;
            n = Integer.MIN_VALUE;
            while (true) {
                if (n2 < n3) {
                    by = dataBuffer.bytes[n2++];
                } else if (dataBuffer != dataBuffer2) {
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    continue;
                }
                break;
            }
        } else if (by == 43) {
            while (true) {
                if (n2 < n3) {
                    by = dataBuffer.bytes[n2++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by >= 48 && by <= 57) {
            int n4 = 48 - by;
            while (true) {
                if (n2 < n3) {
                    if ((by = dataBuffer.bytes[n2++]) >= 48 && by <= 57) {
                        int n5 = by - 48;
                        if (n4 >= -214748364 && (n4 *= 10) >= n + n5) {
                            n4 -= n5;
                            continue;
                        }
                    } else if (by <= 32) {
                        while (by == 32 || by == 10 || by == 9 || by == 13) {
                            if (n2 < n3) {
                                by = dataBuffer.bytes[n2++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return bl ? n4 : -n4;
                            }
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by = dataBuffer.bytes[n2++];
                        }
                    }
                    nArray[0] = 1;
                    return 0;
                }
                if (dataBuffer == dataBuffer2) {
                    return bl ? n4 : -n4;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0;
    }

    private static long parseUIntUnbuffered(XMLString xMLString, int[] nArray) {
        byte by;
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by = xMLString.bytes[n++]) <= 32) {
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n < n2) {
                    by = xMLString.bytes[n++];
                    continue;
                }
                nArray[0] = 1;
                return 0L;
            }
        }
        if (by == 43 && n < n2) {
            by = xMLString.bytes[n++];
        }
        if (by >= 48 && by <= 57) {
            long l = by - 48;
            while (n < n2) {
                if ((by = xMLString.bytes[n++]) >= 48 && by <= 57) {
                    if ((l = l * 10L + (long)(by - 48)) <= 0xFFFFFFFFL) {
                        continue;
                    }
                } else if (by <= 32) {
                    while (by == 32 || by == 10 || by == 9 || by == 13) {
                        if (n < n2) {
                            by = xMLString.bytes[n++];
                            continue;
                        }
                        return l;
                    }
                }
                nArray[0] = 1;
                return 0L;
            }
            return l;
        }
        nArray[0] = 1;
        return 0L;
    }

    private static long parseUIntBuffered(XMLString xMLString, int[] nArray) {
        byte by;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by = dataBuffer.bytes[n++]) <= 32) {
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n < n2) {
                    by = dataBuffer.bytes[n++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0L;
                }
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n++];
            }
        }
        if (by == 43) {
            while (true) {
                if (n < n2) {
                    by = dataBuffer.bytes[n++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by >= 48 && by <= 57) {
            long l = by - 48;
            while (true) {
                if (n < n2) {
                    if ((by = dataBuffer.bytes[n++]) >= 48 && by <= 57) {
                        if ((l = l * 10L + (long)(by - 48)) <= 0xFFFFFFFFL) {
                            continue;
                        }
                    } else if (by <= 32) {
                        while (by == 32 || by == 10 || by == 9 || by == 13) {
                            if (n < n2) {
                                by = dataBuffer.bytes[n++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return l;
                            }
                            dataBuffer = dataBuffer.next;
                            n = dataBuffer.startOffset;
                            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by = dataBuffer.bytes[n++];
                        }
                    }
                    nArray[0] = 1;
                    return 0L;
                }
                if (dataBuffer == dataBuffer2) {
                    return l;
                }
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0L;
    }

    private static int parseSignedUnbuffered(XMLString xMLString, int n, int n2, int[] nArray) {
        byte by;
        boolean bl = false;
        int n3 = n;
        int n4 = xMLString.startOffset;
        int n5 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by = xMLString.bytes[n4++]) <= 32) {
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n4 < n5) {
                    by = xMLString.bytes[n4++];
                    continue;
                }
                nArray[0] = 1;
                return 0;
            }
        }
        if (by == 45) {
            bl = true;
            n3 = -n2;
            if (n4 < n5) {
                by = xMLString.bytes[n4++];
            }
        } else if (by == 43 && n4 < n5) {
            by = xMLString.bytes[n4++];
        }
        if (by >= 48 && by <= 57) {
            int n6 = by - 48;
            while (n4 < n5) {
                if ((by = xMLString.bytes[n4++]) >= 48 && by <= 57) {
                    if ((n6 = n6 * 10 + (by - 48)) <= n3) {
                        continue;
                    }
                } else if (by <= 32) {
                    while (by == 32 || by == 10 || by == 9 || by == 13) {
                        if (n4 < n5) {
                            by = xMLString.bytes[n4++];
                            continue;
                        }
                        return bl ? -n6 : n6;
                    }
                }
                nArray[0] = 1;
                return 0;
            }
            return bl ? -n6 : n6;
        }
        nArray[0] = 1;
        return 0;
    }

    private static int parseSignedBuffered(XMLString xMLString, int n, int n2, int[] nArray) {
        byte by;
        boolean bl = false;
        int n3 = n;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n4 = xMLString.startOffset;
        int n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by = dataBuffer.bytes[n4++]) <= 32) {
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n4 < n5) {
                    by = dataBuffer.bytes[n4++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0;
                }
                dataBuffer = dataBuffer.next;
                n4 = dataBuffer.startOffset;
                n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n4++];
            }
        }
        if (by == 45) {
            bl = true;
            n3 = -n2;
            while (true) {
                if (n4 < n5) {
                    by = dataBuffer.bytes[n4++];
                } else if (dataBuffer != dataBuffer2) {
                    dataBuffer = dataBuffer.next;
                    n4 = dataBuffer.startOffset;
                    n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    continue;
                }
                break;
            }
        } else if (by == 43) {
            while (true) {
                if (n4 < n5) {
                    by = dataBuffer.bytes[n4++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n4 = dataBuffer.startOffset;
                n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by >= 48 && by <= 57) {
            int n6 = by - 48;
            while (true) {
                if (n4 < n5) {
                    if ((by = dataBuffer.bytes[n4++]) >= 48 && by <= 57) {
                        if ((n6 = n6 * 10 + (by - 48)) <= n3) {
                            continue;
                        }
                    } else if (by <= 32) {
                        while (by == 32 || by == 10 || by == 9 || by == 13) {
                            if (n4 < n5) {
                                by = dataBuffer.bytes[n4++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return bl ? -n6 : n6;
                            }
                            dataBuffer = dataBuffer.next;
                            n4 = dataBuffer.startOffset;
                            n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by = dataBuffer.bytes[n4++];
                        }
                    }
                    nArray[0] = 1;
                    return 0;
                }
                if (dataBuffer == dataBuffer2) {
                    return bl ? -n6 : n6;
                }
                dataBuffer = dataBuffer.next;
                n4 = dataBuffer.startOffset;
                n5 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0;
    }

    private static int parseUSignedUnbuffered(XMLString xMLString, int n, int[] nArray) {
        byte by;
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        nArray[0] = 0;
        if ((by = xMLString.bytes[n2++]) <= 32) {
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n2 < n3) {
                    by = xMLString.bytes[n2++];
                    continue;
                }
                nArray[0] = 1;
                return 0;
            }
        }
        if (by == 43 && n2 < n3) {
            by = xMLString.bytes[n2++];
        }
        if (by >= 48 && by <= 57) {
            int n4 = by - 48;
            while (n2 < n3) {
                if ((by = xMLString.bytes[n2++]) >= 48 && by <= 57) {
                    if ((n4 = n4 * 10 + (by - 48)) <= n) {
                        continue;
                    }
                } else if (by <= 32) {
                    while (by == 32 || by == 10 || by == 9 || by == 13) {
                        if (n2 < n3) {
                            by = xMLString.bytes[n2++];
                            continue;
                        }
                        return n4;
                    }
                }
                nArray[0] = 1;
                return 0;
            }
            return n4;
        }
        nArray[0] = 1;
        return 0;
    }

    private static int parseUSignedBuffered(XMLString xMLString, int n, int[] nArray) {
        byte by;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        nArray[0] = 0;
        if ((by = dataBuffer.bytes[n2++]) <= 32) {
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                if (n2 < n3) {
                    by = dataBuffer.bytes[n2++];
                    continue;
                }
                if (dataBuffer == dataBuffer2) {
                    nArray[0] = 1;
                    return 0;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n2++];
            }
        }
        if (by == 43) {
            while (true) {
                if (n2 < n3) {
                    by = dataBuffer.bytes[n2++];
                    break;
                }
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        if (by >= 48 && by <= 57) {
            int n4 = by - 48;
            while (true) {
                if (n2 < n3) {
                    if ((by = dataBuffer.bytes[n2++]) >= 48 && by <= 57) {
                        if ((n4 = n4 * 10 + (by - 48)) <= n) {
                            continue;
                        }
                    } else if (by <= 32) {
                        while (by == 32 || by == 10 || by == 9 || by == 13) {
                            if (n2 < n3) {
                                by = dataBuffer.bytes[n2++];
                                continue;
                            }
                            if (dataBuffer == dataBuffer2) {
                                return n4;
                            }
                            dataBuffer = dataBuffer.next;
                            n2 = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                            by = dataBuffer.bytes[n2++];
                        }
                    }
                    nArray[0] = 1;
                    return 0;
                }
                if (dataBuffer == dataBuffer2) {
                    return n4;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
        }
        nArray[0] = 1;
        return 0;
    }

    public static int getTotalDigits(XMLString xMLString) {
        return xMLString.bytes != null ? XSIntegerUtil.getTotalDigitsUnbuffered(xMLString) : XSIntegerUtil.getTotalDigitsBuffered(xMLString);
    }

    private static int getTotalDigitsUnbuffered(XMLString xMLString) {
        byte by;
        byte[] byArray = xMLString.bytes;
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        int n3 = xMLString.length;
        while (n < n2 && ((by = byArray[n++]) < 49 || by > 57)) {
            --n3;
        }
        while (n < n2 && ((by = byArray[--n2]) < 48 || by > 57)) {
            --n3;
        }
        return n3;
    }

    private static int getTotalDigitsBuffered(XMLString xMLString) {
        byte by;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        int n3 = xMLString.length;
        while (true) {
            if (n < n2) {
                if ((by = dataBuffer.bytes[n++]) >= 49 && by <= 57) break;
                --n3;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                return n3;
            }
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        while (true) {
            if (n < n2) {
                if ((by = dataBuffer.bytes[n++]) >= 48 && by <= 57) continue;
                n3 -= n2 - n + 1;
                break;
            }
            if (dataBuffer == dataBuffer2) {
                return n3;
            }
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        while (dataBuffer != dataBuffer2) {
            dataBuffer = dataBuffer.next;
            n3 -= (dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset) - dataBuffer.startOffset;
        }
        return n3;
    }

    private XSIntegerUtil() {
    }
}

