/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import com.ibm.xml.xlxp2.scan.util.XMLStringBuffer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XSAnyURIUtil {
    private static final byte[] fgLookupTable = ArrayAllocator.newByteArray(128);
    private static final int RESERVED_CHARACTERS = 1;
    private static final int MARK_CHARACTERS = 2;
    private static final int SCHEME_CHARACTERS = 4;
    private static final int USERINFO_CHARACTERS = 8;
    private static final int ASCII_ALPHA_CHARACTERS = 16;
    private static final int ASCII_DIGIT_CHARACTERS = 32;
    private static final int ASCII_HEX_CHARACTERS = 64;
    private static final int PATH_CHARACTERS = 128;
    private static final int MASK_ALPHA_NUMERIC = 48;
    private static final int MASK_UNRESERVED_MASK = 50;
    private static final int MASK_URI_CHARACTER = 51;
    private static final int MASK_SCHEME_CHARACTER = 52;
    private static final int MASK_USERINFO_CHARACTER = 58;
    private static final int MASK_PATH_CHARACTER = 178;
    private static boolean[] gNeedEscaping;

    private XSAnyURIUtil() {
    }

    public static boolean isSchemeCharacter(int n) {
        return n <= 122 && (fgLookupTable[n] & 0x34) != 0;
    }

    private static boolean isUserinfoCharacter(int n) {
        return n <= 122 && (fgLookupTable[n] & 0x3A) != 0;
    }

    public static boolean isAlpha(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90;
    }

    private static boolean isAlphanum(int n) {
        return n <= 122 && (fgLookupTable[n] & 0x30) != 0;
    }

    private static boolean isPathCharacter(int n) {
        return n <= 126 && (fgLookupTable[n] & 0xB2) != 0;
    }

    private static boolean isHex(int n) {
        return n <= 102 && (fgLookupTable[n] & 0x40) != 0;
    }

    private static boolean isURICharacter(int n) {
        return n <= 126 && (fgLookupTable[n] & 0x33) != 0;
    }

    public static boolean parsePath(XMLString xMLString, XMLStringBuffer xMLStringBuffer, int n, boolean bl) {
        int n2 = xMLString.endOffset;
        int n3 = 0;
        byte[] byArray = xMLString.bytes;
        boolean bl2 = false;
        if (n < n2) {
            if (!bl || byArray[n] == 47) {
                while (n < n2) {
                    n3 = byArray[n];
                    if (n3 == 37) {
                        if (n + 2 >= n2 || !XSAnyURIUtil.isHex(byArray[n + 1]) || !XSAnyURIUtil.isHex(byArray[n + 2])) {
                            return false;
                        }
                        if (bl2) {
                            xMLStringBuffer.appendChar(32);
                            bl2 = false;
                        }
                        xMLStringBuffer.appendChar(n3);
                        xMLStringBuffer.appendChar(byArray[n + 1]);
                        xMLStringBuffer.appendChar(byArray[n + 2]);
                        n += 2;
                    } else if (n3 == 32 || n3 == 10 || n3 == 9 || n3 == 13) {
                        bl2 = true;
                    } else if (n3 < 128 && n3 >= 0 && !gNeedEscaping[n3]) {
                        if (!XSAnyURIUtil.isPathCharacter(n3)) {
                            if (n3 == 63 || n3 == 35) {
                                if (bl2) {
                                    xMLStringBuffer.appendChar(32);
                                    bl2 = false;
                                }
                                xMLStringBuffer.appendChar(n3);
                                break;
                            }
                            return false;
                        }
                        if (bl2) {
                            xMLStringBuffer.appendChar(32);
                            bl2 = false;
                        }
                        xMLStringBuffer.appendChar(n3);
                    }
                    ++n;
                }
            } else {
                bl2 = false;
                while (n < n2) {
                    n3 = byArray[n];
                    if (n3 == 63 || n3 == 35) {
                        if (bl2) {
                            xMLStringBuffer.appendChar(32);
                            bl2 = false;
                        }
                        xMLStringBuffer.appendChar(n3);
                        break;
                    }
                    if (n3 == 37) {
                        if (n + 2 >= n2 || !XSAnyURIUtil.isHex(byArray[n + 1]) || !XSAnyURIUtil.isHex(byArray[n + 2])) {
                            return false;
                        }
                        if (bl2) {
                            xMLStringBuffer.appendChar(32);
                            bl2 = false;
                        }
                        xMLStringBuffer.appendChar(n3);
                        xMLStringBuffer.appendChar(byArray[n + 1]);
                        xMLStringBuffer.appendChar(byArray[n + 2]);
                        n += 2;
                    } else if (n3 == 32 || n3 == 10 || n3 == 9 || n3 == 13) {
                        bl2 = true;
                    } else if (n3 < 128 && n3 >= 0 && !gNeedEscaping[n3]) {
                        if (!XSAnyURIUtil.isURICharacter(n3)) {
                            return false;
                        }
                        if (bl2) {
                            xMLStringBuffer.appendChar(32);
                            bl2 = false;
                        }
                        xMLStringBuffer.appendChar(n3);
                    }
                    ++n;
                }
            }
        }
        if (n3 == 63) {
            ++n;
            bl2 = false;
            while (n < n2) {
                n3 = byArray[n];
                if (n3 == 35) {
                    if (bl2) {
                        xMLStringBuffer.appendChar(32);
                        bl2 = false;
                    }
                    xMLStringBuffer.appendChar(n3);
                    break;
                }
                if (n3 == 37) {
                    if (n + 2 >= n2 || !XSAnyURIUtil.isHex(byArray[n + 1]) || !XSAnyURIUtil.isHex(byArray[n + 2])) {
                        return false;
                    }
                    if (bl2) {
                        xMLStringBuffer.appendChar(32);
                        bl2 = false;
                    }
                    xMLStringBuffer.appendChar(n3);
                    xMLStringBuffer.appendChar(byArray[n + 1]);
                    xMLStringBuffer.appendChar(byArray[n + 2]);
                    n += 2;
                } else if (n3 == 32 || n3 == 10 || n3 == 9 || n3 == 13) {
                    bl2 = true;
                } else if (n3 < 128 && n3 >= 0 && !gNeedEscaping[n3]) {
                    if (!XSAnyURIUtil.isURICharacter(n3)) {
                        return false;
                    }
                    if (bl2) {
                        xMLStringBuffer.appendChar(32);
                        bl2 = false;
                    }
                    xMLStringBuffer.appendChar(n3);
                }
                ++n;
            }
        }
        if (n3 == 35) {
            ++n;
            bl2 = false;
            while (n < n2) {
                n3 = byArray[n];
                if (n3 == 37) {
                    if (n + 2 >= n2 || !XSAnyURIUtil.isHex(byArray[n + 1]) || !XSAnyURIUtil.isHex(byArray[n + 2])) {
                        return false;
                    }
                    if (bl2) {
                        xMLStringBuffer.appendChar(32);
                        bl2 = false;
                    }
                    xMLStringBuffer.appendChar(n3);
                    xMLStringBuffer.appendChar(byArray[n + 1]);
                    xMLStringBuffer.appendChar(byArray[n + 2]);
                    n += 2;
                } else if (n3 == 32 || n3 == 10 || n3 == 9 || n3 == 13) {
                    bl2 = true;
                } else if (n3 < 128 && n3 >= 0 && !gNeedEscaping[n3]) {
                    if (!XSAnyURIUtil.isURICharacter(n3)) {
                        xMLStringBuffer.appendChar(n3);
                        return false;
                    }
                    if (bl2) {
                        xMLStringBuffer.appendChar(32);
                        bl2 = false;
                    }
                    xMLStringBuffer.appendChar(n3);
                }
                ++n;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean parsePath(XMLString var0, XMLStringBuffer var1_1, int var2_2, DataBuffer var3_3, boolean var4_4) {
        block63: {
            block64: {
                var5_5 = 0;
                var6_6 = var0.lastBuffer == null ? var3_3 : var0.lastBuffer;
                var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
                var8_8 = false;
                while (true) {
                    if (var2_2 < var7_7) break;
                    if (var3_3 == var6_6) {
                        return true;
                    }
                    var3_3 = var3_3.next;
                    var2_2 = var3_3.startOffset;
                    var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
                }
                var5_5 = var3_3.bytes[var2_2];
                if (var4_4 && var5_5 != 47) break block64;
                while (true) {
                    block66: {
                        block65: {
                            if (var2_2 >= var7_7) ** GOTO lbl68
                            var5_5 = var3_3.bytes[var2_2];
                            if (var5_5 != 37) break block65;
                            if (var8_8) {
                                var1_1.appendChar(32);
                                var8_8 = false;
                            }
                            var1_1.appendChar(var5_5);
                            while (true) {
                                if (++var2_2 < var7_7) break;
                                if (var3_3 == var6_6) {
                                    return false;
                                }
                                var3_3 = var3_3.next;
                                var2_2 = var3_3.startOffset - 1;
                                var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
                            }
                            var5_5 = var3_3.bytes[var2_2];
                            if (!XSAnyURIUtil.isHex(var5_5)) {
                                return false;
                            }
                            var1_1.appendChar(var5_5);
                            while (true) {
                                if (++var2_2 < var7_7) break;
                                if (var3_3 == var6_6) {
                                    return false;
                                }
                                var3_3 = var3_3.next;
                                var2_2 = var3_3.startOffset - 1;
                                var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
                            }
                            var5_5 = var3_3.bytes[var2_2];
                            if (!XSAnyURIUtil.isHex(var5_5)) {
                                return false;
                            }
                            var1_1.appendChar(var5_5);
                            ** GOTO lbl66
                        }
                        if (var5_5 != 32 && var5_5 != 10 && var5_5 != 9 && var5_5 != 13) break block66;
                        var8_8 = true;
                        ** GOTO lbl66
                    }
                    if (var5_5 >= 128 || var5_5 < 0 || XSAnyURIUtil.gNeedEscaping[var5_5]) ** GOTO lbl66
                    if (XSAnyURIUtil.isPathCharacter(var5_5)) ** GOTO lbl62
                    if (var5_5 == 63 || var5_5 == 35) {
                        if (var8_8) {
                            var1_1.appendChar(32);
                            var8_8 = false;
                        }
                        var1_1.appendChar(var5_5);
                    } else {
                        return false;
lbl62:
                        // 1 sources

                        if (var8_8) {
                            var1_1.appendChar(32);
                            var8_8 = false;
                        }
                        var1_1.appendChar(var5_5);
lbl66:
                        // 4 sources

                        ++var2_2;
                        continue;
lbl68:
                        // 1 sources

                        if (var3_3 != var6_6) {
                            var3_3 = var3_3.next;
                            var2_2 = var3_3.startOffset;
                            var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
                            continue;
                        }
                    }
                    break block63;
                    break;
                }
            }
            var8_8 = false;
            while (true) {
                if (var2_2 < var7_7) {
                    var5_5 = var3_3.bytes[var2_2];
                    if (var5_5 == 63 || var5_5 == 35) {
                        if (var8_8) {
                            var1_1.appendChar(32);
                            var8_8 = false;
                        }
                        var1_1.appendChar(var5_5);
                        break;
                    }
                    if (var5_5 == 37) {
                        if (var8_8) {
                            var1_1.appendChar(32);
                            var8_8 = false;
                        }
                        var1_1.appendChar(var5_5);
                        while (true) {
                            if (++var2_2 < var7_7) break;
                            if (var3_3 == var6_6) {
                                return false;
                            }
                            var3_3 = var3_3.next;
                            var2_2 = var3_3.startOffset - 1;
                            var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
                        }
                        var5_5 = var3_3.bytes[var2_2];
                        if (!XSAnyURIUtil.isHex(var5_5)) {
                            return false;
                        }
                        var1_1.appendChar(var5_5);
                        while (true) {
                            if (++var2_2 < var7_7) break;
                            if (var3_3 == var6_6) {
                                return false;
                            }
                            var3_3 = var3_3.next;
                            var2_2 = var3_3.startOffset - 1;
                            var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
                        }
                        var5_5 = var3_3.bytes[var2_2];
                        if (!XSAnyURIUtil.isHex(var5_5)) {
                            return false;
                        }
                        var1_1.appendChar(var5_5);
                    } else if (var5_5 == 32 || var5_5 == 10 || var5_5 == 9 || var5_5 == 13) {
                        var8_8 = true;
                    } else if (var5_5 < 128 && var5_5 >= 0 && !XSAnyURIUtil.gNeedEscaping[var5_5]) {
                        if (!XSAnyURIUtil.isURICharacter(var5_5)) {
                            return false;
                        }
                        if (var8_8) {
                            var1_1.appendChar(32);
                            var8_8 = false;
                        }
                        var1_1.appendChar(var5_5);
                    }
                    ++var2_2;
                    continue;
                }
                if (var3_3 == var6_6) break;
                var3_3 = var3_3.next;
                var2_2 = var3_3.startOffset;
                var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
            }
        }
        if (var5_5 == 63) {
            var8_8 = false;
            while (true) {
                if (++var2_2 < var7_7) {
                    var5_5 = var3_3.bytes[var2_2];
                    if (var5_5 == 35) {
                        if (var8_8) {
                            var1_1.appendChar(32);
                            var8_8 = false;
                        }
                        var1_1.appendChar(var5_5);
                        break;
                    }
                    if (var5_5 == 37) {
                        if (var8_8) {
                            var1_1.appendChar(32);
                            var8_8 = false;
                        }
                        var1_1.appendChar(var5_5);
                        while (true) {
                            if (++var2_2 < var7_7) break;
                            if (var3_3 == var6_6) {
                                return false;
                            }
                            var3_3 = var3_3.next;
                            var2_2 = var3_3.startOffset - 1;
                            var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
                        }
                        var5_5 = var3_3.bytes[var2_2];
                        if (!XSAnyURIUtil.isHex(var5_5)) {
                            return false;
                        }
                        var1_1.appendChar(var5_5);
                        while (true) {
                            if (++var2_2 < var7_7) break;
                            if (var3_3 == var6_6) {
                                return false;
                            }
                            var3_3 = var3_3.next;
                            var2_2 = var3_3.startOffset - 1;
                            var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
                        }
                        var5_5 = var3_3.bytes[var2_2];
                        if (!XSAnyURIUtil.isHex(var5_5)) {
                            return false;
                        }
                        var1_1.appendChar(var5_5);
                        continue;
                    }
                    if (var5_5 == 32 || var5_5 == 10 || var5_5 == 9 || var5_5 == 13) {
                        var8_8 = true;
                        continue;
                    }
                    if (var5_5 >= 128 || var5_5 < 0 || XSAnyURIUtil.gNeedEscaping[var5_5]) continue;
                    if (!XSAnyURIUtil.isURICharacter(var5_5)) {
                        return false;
                    }
                    if (var8_8) {
                        var1_1.appendChar(32);
                        var8_8 = false;
                    }
                    var1_1.appendChar(var5_5);
                    continue;
                }
                if (var3_3 == var6_6) break;
                var3_3 = var3_3.next;
                var2_2 = var3_3.startOffset - 1;
                var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
            }
        }
        if (var5_5 == 35) {
            var8_8 = false;
            while (true) {
                if (++var2_2 < var7_7) {
                    var5_5 = var3_3.bytes[var2_2];
                    if (var5_5 == 37) {
                        if (var8_8) {
                            var1_1.appendChar(32);
                            var8_8 = false;
                        }
                        var1_1.appendChar(var5_5);
                        while (true) {
                            if (++var2_2 < var7_7) break;
                            if (var3_3 == var6_6) {
                                return false;
                            }
                            var3_3 = var3_3.next;
                            var2_2 = var3_3.startOffset - 1;
                            var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
                        }
                        var5_5 = var3_3.bytes[var2_2];
                        if (!XSAnyURIUtil.isHex(var5_5)) {
                            return false;
                        }
                        var1_1.appendChar(var5_5);
                        while (true) {
                            if (++var2_2 < var7_7) break;
                            if (var3_3 == var6_6) {
                                return false;
                            }
                            var3_3 = var3_3.next;
                            var2_2 = var3_3.startOffset - 1;
                            var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
                        }
                        var5_5 = var3_3.bytes[var2_2];
                        if (!XSAnyURIUtil.isHex(var5_5)) {
                            return false;
                        }
                        var1_1.appendChar(var5_5);
                        continue;
                    }
                    if (var5_5 == 32 || var5_5 == 10 || var5_5 == 9 || var5_5 == 13) {
                        var8_8 = true;
                        continue;
                    }
                    if (var5_5 >= 128 || var5_5 < 0 || XSAnyURIUtil.gNeedEscaping[var5_5]) continue;
                    if (!XSAnyURIUtil.isURICharacter(var5_5)) {
                        var1_1.appendChar(var5_5);
                        return false;
                    }
                    if (var8_8) {
                        var1_1.appendChar(32);
                        var8_8 = false;
                    }
                    var1_1.appendChar(var5_5);
                    continue;
                }
                if (var3_3 == var6_6) break;
                var3_3 = var3_3.next;
                var2_2 = var3_3.startOffset - 1;
                var7_7 = var3_3 == var6_6 ? var0.endOffset : var3_3.endOffset;
            }
        }
        return true;
    }

    public static boolean parseAuthority(XMLString xMLString, DataBuffer[] dataBufferArray, int[] nArray) {
        DataBuffer dataBuffer = dataBufferArray[0];
        DataBuffer dataBuffer2 = dataBufferArray[1];
        int n = nArray[0];
        int n2 = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
        byte by = 0;
        int n3 = 0;
        block0: while (true) {
            for (n3 = n; n3 < n2; ++n3) {
                by = dataBuffer.bytes[n3];
                if (by == 64) break block0;
                if (by == 37) {
                    while (true) {
                        if (++n3 < n2) break;
                        if (dataBuffer == dataBuffer2) {
                            return false;
                        }
                        dataBuffer = dataBuffer.next;
                        n3 = dataBuffer.startOffset - 1;
                        n2 = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
                    }
                    by = dataBuffer.bytes[n3];
                    if (!XSAnyURIUtil.isHex(by)) {
                        return false;
                    }
                    while (true) {
                        if (++n3 < n2) break;
                        if (dataBuffer == dataBuffer2) {
                            return false;
                        }
                        dataBuffer = dataBuffer.next;
                        n3 = dataBuffer.startOffset - 1;
                        n2 = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
                    }
                    by = dataBuffer.bytes[n3];
                    if (XSAnyURIUtil.isHex(by)) continue;
                    return false;
                }
                if (by != 32 && by != 10 && by != 9 && by != 13 && !XSAnyURIUtil.isUserinfoCharacter(by)) break block0;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
        }
        if (by == 64) {
            if (n3 == n2 - 1 && dataBuffer == dataBuffer2) {
                return false;
            }
            if (n3 == n2 - 1) {
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
            } else {
                n = n3 + 1;
            }
        } else {
            dataBuffer = dataBufferArray[0];
            n = nArray[0] - 1;
        }
        dataBufferArray[0] = dataBuffer;
        nArray[0] = n;
        if (!XSAnyURIUtil.isValidServerBasedAuthority(xMLString, dataBufferArray, nArray)) {
            return XSAnyURIUtil.isValidRegistryBasedAuthority(xMLString, dataBufferArray, nArray);
        }
        if (nArray[0] < nArray[1] && dataBufferArray[0].bytes[nArray[0]] == 58) {
            int n4 = 0;
            int n5 = nArray[1];
            while (true) {
                if ((nArray[0] = nArray[0] + 1) < nArray[1]) {
                    by = dataBufferArray[0].bytes[nArray[0]];
                    if (by >= 48 && by <= 57) {
                        n4 *= 10;
                        n4 += by - 48;
                        continue;
                    }
                    return false;
                }
                if (dataBufferArray[0] == dataBufferArray[1]) break;
                dataBufferArray[0] = dataBufferArray[0].next;
                nArray[0] = dataBufferArray[0].startOffset - 1;
                nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n5 : dataBufferArray[0].endOffset;
            }
            if (n4 > 65535) {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidRegistryBasedAuthority(XMLString xMLString, DataBuffer[] dataBufferArray, int[] nArray) {
        byte by = 0;
        int n = nArray[1];
        int n2 = nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n : dataBufferArray[0].endOffset;
        while (true) {
            if (nArray[0] < nArray[1]) {
                by = dataBufferArray[0].bytes[nArray[0]];
                if (by == 37) {
                    while (true) {
                        if ((nArray[0] = nArray[0] + 1) < nArray[1]) break;
                        if (dataBufferArray[0] == dataBufferArray[1]) {
                            return false;
                        }
                        dataBufferArray[0] = dataBufferArray[0].next;
                        nArray[0] = dataBufferArray[0].startOffset - 1;
                        nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n : dataBufferArray[0].endOffset;
                    }
                    by = dataBufferArray[0].bytes[nArray[0]];
                    if (!XSAnyURIUtil.isHex(by)) {
                        return false;
                    }
                    while (true) {
                        if ((nArray[0] = nArray[0] + 1) < nArray[1]) break;
                        if (dataBufferArray[0] == dataBufferArray[1]) {
                            return false;
                        }
                        dataBufferArray[0] = dataBufferArray[0].next;
                        nArray[0] = dataBufferArray[0].startOffset - 1;
                        nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n : dataBufferArray[0].endOffset;
                    }
                    by = dataBufferArray[0].bytes[nArray[0]];
                    if (!XSAnyURIUtil.isHex(by)) {
                        return false;
                    }
                } else if (by < 128 && by >= 0 && !gNeedEscaping[by] && by != 32 && by != 10 && by != 9 && by != 13 && !XSAnyURIUtil.isPathCharacter(by)) {
                    return false;
                }
                nArray[0] = nArray[0] + 1;
                continue;
            }
            if (dataBufferArray[0] == dataBufferArray[1]) {
                return true;
            }
            dataBufferArray[0] = dataBufferArray[0].next;
            nArray[0] = dataBufferArray[0].startOffset;
            nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n : dataBufferArray[0].endOffset;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValidServerBasedAuthority(XMLString xMLString, DataBuffer[] dataBufferArray, int[] nArray) {
        byte by = 0;
        DataBuffer dataBuffer = dataBufferArray[0];
        DataBuffer dataBuffer2 = dataBufferArray[1];
        int n = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
        int n2 = nArray[0];
        while (true) {
            if (++n2 < n) break;
            if (dataBuffer == dataBuffer2) {
                return false;
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset - 1;
            n = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
        }
        by = dataBuffer.bytes[n2];
        DataBuffer[] dataBufferArray2 = new DataBuffer[]{dataBuffer, dataBuffer2};
        int[] nArray2 = new int[]{n2, nArray[1]};
        if (by == 91) {
            int[] nArray3 = ArrayAllocator.newIntArray(1);
            boolean bl = XSAnyURIUtil.scanHexSequence(xMLString, dataBufferArray2, nArray2, nArray3);
            if (!bl) {
                return false;
            }
            dataBuffer = dataBufferArray2[0];
            dataBuffer2 = dataBufferArray2[1];
            n2 = nArray2[0];
            n = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
            if (n2 < n && dataBuffer.bytes[n2] == 93) {
                if (nArray3[0] != 8) return false;
                dataBufferArray[0] = dataBuffer;
                dataBufferArray[1] = dataBuffer2;
                nArray[0] = n2;
                return true;
            }
            if (n2 >= n || dataBuffer.bytes[n2] != 58) return false;
            while (true) {
                if (++n2 < n) break;
                if (dataBuffer == dataBuffer2) {
                    return false;
                }
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset - 1;
                n = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
            }
            by = dataBuffer.bytes[n2];
            if (by == 58) {
                nArray3[0] = nArray3[0] + 1;
                if (nArray3[0] > 8) {
                    return false;
                }
                while (true) {
                    if (++n2 < n) break;
                    if (dataBuffer == dataBuffer2) {
                        return false;
                    }
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
                }
                by = dataBuffer.bytes[n2];
                if (by == 93) {
                    if (nArray3[0] != 8) return false;
                    dataBufferArray[0] = dataBuffer;
                    dataBufferArray[1] = dataBuffer2;
                    nArray[0] = n2;
                    return true;
                }
            } else {
                dataBufferArray2[0] = dataBuffer;
                dataBufferArray2[1] = dataBuffer2;
                nArray2[0] = n2;
                nArray2[1] = nArray[1];
                boolean bl2 = XSAnyURIUtil.isWellFormedIPv4Address(xMLString, dataBufferArray2, nArray2);
                if (!bl2) return false;
                dataBuffer = dataBufferArray2[0];
                dataBuffer2 = dataBufferArray2[1];
                n2 = nArray2[0];
                int n3 = n = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
                if (nArray3[0] != 6 || n2 >= n || dataBuffer.bytes[n2] != 93) return false;
                dataBufferArray[0] = dataBuffer;
                dataBufferArray[1] = dataBuffer2;
                nArray[0] = n2;
                return true;
            }
            int n4 = nArray3[0];
            dataBufferArray2[0] = dataBuffer;
            dataBufferArray2[1] = dataBuffer2;
            nArray2[0] = n2;
            nArray2[1] = nArray[1];
            bl = XSAnyURIUtil.scanHexSequence(xMLString, dataBufferArray2, nArray2, nArray3);
            if (!bl) {
                return false;
            }
            dataBuffer = dataBufferArray2[0];
            dataBuffer2 = dataBufferArray2[1];
            n2 = nArray2[0];
            n = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
            if (n2 < n && dataBuffer.bytes[n2] == 93) {
                if (nArray3[0] != 8) return false;
                dataBufferArray[0] = dataBuffer;
                dataBufferArray[1] = dataBuffer2;
                nArray[0] = n2;
                return true;
            }
            if (nArray3[0] > n4) {
                while (++n2 >= n) {
                    if (dataBuffer == dataBuffer2) {
                        return false;
                    }
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
                }
            }
            dataBufferArray2[0] = dataBuffer;
            dataBufferArray2[1] = dataBuffer2;
            nArray2[0] = n2;
            nArray2[1] = nArray[1];
            boolean bl3 = XSAnyURIUtil.isWellFormedIPv4Address(xMLString, dataBufferArray2, nArray2);
            if (!bl3) return false;
            dataBuffer = dataBufferArray2[0];
            dataBuffer2 = dataBufferArray2[1];
            n2 = nArray2[0];
            int n5 = n = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
            if (n2 >= n || xMLString.bytes[n2] != 93) return false;
            dataBufferArray[0] = dataBuffer;
            dataBufferArray[1] = dataBuffer2;
            nArray[0] = n2;
            return true;
        }
        if (by == 46 || by == 45) {
            return false;
        }
        boolean bl = XSAnyURIUtil.isWellFormedIPv4Address(xMLString, dataBufferArray2, nArray2);
        if (!bl) {
            dataBufferArray2[0] = dataBuffer;
            dataBufferArray2[1] = dataBuffer2;
            nArray2[0] = n2;
            nArray2[1] = nArray[1];
            bl = XSAnyURIUtil.checkHostname(xMLString, dataBufferArray2, nArray2);
        }
        if (!bl) return bl;
        dataBuffer = dataBufferArray2[0];
        dataBuffer2 = dataBufferArray2[1];
        n2 = nArray2[0];
        int n6 = n = dataBuffer == dataBuffer2 ? nArray[1] : dataBuffer.endOffset;
        if (n2 < n && dataBuffer.bytes[n2] != 58) {
            return false;
        }
        dataBufferArray[0] = dataBuffer;
        dataBufferArray[1] = dataBuffer2;
        nArray[0] = n2;
        return bl;
    }

    private static boolean checkHostname(XMLString xMLString, DataBuffer[] dataBufferArray, int[] nArray) {
        int n;
        byte by = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = nArray[1];
        int n5 = nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n4 : dataBufferArray[0].endOffset;
        while (true) {
            if ((n = dataBufferArray[0].bytes[nArray[0]]) == 46) {
                if (!XSAnyURIUtil.isAlphanum(n2)) {
                    return false;
                }
                while (true) {
                    if (nArray[0] + 1 < nArray[1]) break;
                    if (dataBufferArray[0] == dataBufferArray[1]) {
                        return false;
                    }
                    dataBufferArray[0] = dataBufferArray[0].next;
                    nArray[0] = dataBufferArray[0].startOffset - 1;
                    nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n4 : dataBufferArray[0].endOffset;
                }
                by = dataBufferArray[0].bytes[nArray[0] + 1];
                if (nArray[0] + 1 < nArray[1] && !XSAnyURIUtil.isAlphanum(by)) {
                    return false;
                }
                n3 = 0;
                n2 = n;
            } else {
                if (!XSAnyURIUtil.isAlphanum(n) && n != 45) {
                    return false;
                }
                if (++n3 > 63) {
                    return false;
                }
                n2 = n;
            }
            if ((nArray[0] = nArray[0] + 1) < nArray[1]) continue;
            if (dataBufferArray[0] == dataBufferArray[1]) break;
            dataBufferArray[0] = dataBufferArray[0].next;
            nArray[0] = dataBufferArray[0].startOffset;
            nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n4 : dataBufferArray[0].endOffset;
        }
        return n != 45 && XSAnyURIUtil.isAlpha(by);
    }

    private static boolean scanHexSequence(XMLString xMLString, DataBuffer[] dataBufferArray, int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = nArray[0];
        DataBuffer dataBuffer = dataBufferArray[0];
        int n3 = nArray[0];
        DataBuffer dataBuffer2 = dataBufferArray[0];
        int n4 = nArray[1];
        int n5 = nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n4 : dataBufferArray[0].endOffset;
        while (true) {
            if (nArray[0] < nArray[1]) {
                byte by = dataBufferArray[0].bytes[nArray[0]];
                if (by == 58) {
                    if (n > 0 && (nArray2[0] = nArray2[0] + 1) > 8) {
                        return false;
                    }
                    if (n == 0) {
                        return true;
                    }
                    if (nArray[0] + 1 < nArray[1] || dataBufferArray[0] != dataBufferArray[1]) {
                        while (true) {
                            if (nArray[0] + 1 < nArray[1]) break;
                            if (dataBufferArray[0] == dataBufferArray[1]) {
                                return false;
                            }
                            dataBufferArray[0] = dataBufferArray[0].next;
                            nArray[0] = dataBufferArray[0].startOffset - 1;
                            nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n4 : dataBufferArray[0].endOffset;
                        }
                        by = dataBufferArray[0].bytes[nArray[0] + 1];
                        if (by == 58) {
                            return true;
                        }
                    }
                    n3 = nArray[0];
                    dataBuffer2 = dataBufferArray[0];
                    n = 0;
                } else {
                    if (!XSAnyURIUtil.isHex(by)) {
                        if (by == 46 && n < 4 && n > 0 && nArray2[0] <= 6) {
                            nArray[0] = n3;
                            dataBufferArray[0] = dataBuffer2;
                            nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n4 : dataBufferArray[0].endOffset;
                            return true;
                        }
                        if (by == 93) break;
                        return false;
                    }
                    if (++n > 4) {
                        return false;
                    }
                }
                nArray[0] = nArray[0] + 1;
                continue;
            }
            if (dataBufferArray[0] == dataBufferArray[1]) break;
            dataBufferArray[0] = dataBufferArray[0].next;
            nArray[0] = dataBufferArray[0].startOffset - 1;
            nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n4 : dataBufferArray[0].endOffset;
        }
        return n > 0 && (nArray2[0] = nArray2[0] + 1) <= 8;
    }

    private static boolean isWellFormedIPv4Address(XMLString xMLString, DataBuffer[] dataBufferArray, int[] nArray) {
        byte by = 0;
        int n = 0;
        int n2 = 0;
        byte by2 = 0;
        byte by3 = 0;
        int n3 = nArray[1];
        int n4 = nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n3 : dataBufferArray[0].endOffset;
        while (true) {
            if (nArray[0] < nArray[1]) {
                by3 = by2;
                by2 = by;
                by = dataBufferArray[0].bytes[nArray[0]];
                if (by == 46) {
                    byte by4 = 0;
                    while (true) {
                        if (nArray[0] + 1 < nArray[1]) break;
                        if (dataBufferArray[0] == dataBufferArray[1]) {
                            return false;
                        }
                        dataBufferArray[0] = dataBufferArray[0].next;
                        nArray[0] = dataBufferArray[0].startOffset - 1;
                        nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n3 : dataBufferArray[0].endOffset;
                    }
                    by4 = dataBufferArray[0].bytes[nArray[0] + 1];
                    if (nArray[0] > 0 && !XSAnyURIUtil.isDigit(by2) || nArray[0] + 1 < nArray[1] && !XSAnyURIUtil.isDigit(by4)) {
                        return false;
                    }
                    n2 = 0;
                    ++n;
                } else {
                    if (!XSAnyURIUtil.isDigit(by)) {
                        return n == 3 && n2 > 0;
                    }
                    if (++n2 > 3) {
                        return false;
                    }
                    if (n2 == 3 && by3 >= 50 && (by3 != 50 || by2 >= 53 && (by2 != 53 || by > 53))) {
                        return false;
                    }
                }
                nArray[0] = nArray[0] + 1;
                continue;
            }
            if (dataBufferArray[0] == dataBufferArray[1]) break;
            dataBufferArray[0] = dataBufferArray[0].next;
            nArray[0] = dataBufferArray[0].startOffset;
            nArray[1] = dataBufferArray[0] == dataBufferArray[1] ? n3 : dataBufferArray[0].endOffset;
        }
        return n == 3;
    }

    public static boolean parseAuthority(XMLString xMLString, int n, int n2) {
        int[] nArray;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        for (n4 = n; n4 < n2 && (n3 = xMLString.bytes[n4]) != 64; ++n4) {
            if (n3 == 37) {
                if (n4 + 2 >= n2) {
                    return false;
                }
                n3 = xMLString.bytes[n4 + 1];
                if (!XSAnyURIUtil.isHex(n3)) {
                    return false;
                }
                n3 = xMLString.bytes[n4 + 1];
                if (!XSAnyURIUtil.isHex(n3)) {
                    return false;
                }
                n4 += 2;
                continue;
            }
            if (n3 != 32 && n3 != 10 && n3 != 9 && n3 != 13 && !XSAnyURIUtil.isUserinfoCharacter(n3)) break;
        }
        if (n3 == 64) {
            if (n4 == n2 - 1) {
                return false;
            }
            n = n4 + 1;
        }
        if (!XSAnyURIUtil.isValidServerBasedAuthority(xMLString, nArray = new int[]{n}, n2)) {
            return XSAnyURIUtil.isValidRegistryBasedAuthority(xMLString, n, n2);
        }
        if (nArray[0] < n2 && xMLString.bytes[nArray[0]] == 58) {
            int n5 = 0;
            while ((nArray[0] = nArray[0] + 1) < n2) {
                n3 = xMLString.bytes[nArray[0]];
                if (n3 >= 48 && n3 <= 57) {
                    n5 *= 10;
                    n5 += n3 - 48;
                    continue;
                }
                return false;
            }
            if (n5 > 65535) {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidRegistryBasedAuthority(XMLString xMLString, int n, int n2) {
        byte by = 0;
        while (n < n2) {
            by = xMLString.bytes[n];
            if (by == 37) {
                if (n + 2 >= n2 || !XSAnyURIUtil.isHex(xMLString.bytes[n + 1]) || !XSAnyURIUtil.isHex(xMLString.bytes[n + 2])) {
                    return false;
                }
                n += 2;
            } else if (by < 128 && by >= 0 && !gNeedEscaping[by] && by != 32 && by != 10 && by != 9 && by != 13 && !XSAnyURIUtil.isPathCharacter(by)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValidServerBasedAuthority(XMLString xMLString, int[] nArray, int n) {
        byte by = xMLString.bytes[nArray[0]];
        if (by == 91) {
            int[] nArray2 = ArrayAllocator.newIntArray(1);
            nArray[0] = XSAnyURIUtil.scanHexSequence(xMLString, nArray[0] + 1, n, nArray2);
            if (nArray[0] == -1) {
                return false;
            }
            if (xMLString.bytes[nArray[0]] == 93) {
                if (nArray2[0] != 8) return false;
                return true;
            }
            if (nArray[0] + 2 >= n) return false;
            if (xMLString.bytes[nArray[0]] != 58) return false;
            if (xMLString.bytes[nArray[0] + 1] == 58) {
                nArray2[0] = nArray2[0] + 1;
                if (nArray2[0] > 8) {
                    return false;
                }
                nArray[0] = nArray[0] + 2;
                if (xMLString.bytes[nArray[0]] == 93) {
                    if (nArray2[0] != 8) return false;
                    return true;
                }
            } else {
                nArray[0] = nArray[0] + 1;
                if (nArray2[0] != 6) return false;
                if (!XSAnyURIUtil.isWellFormedIPv4Address(xMLString, nArray, n)) return false;
                if (nArray[0] >= n) return false;
                if (xMLString.bytes[nArray[0]] != 93) return false;
                return true;
            }
            int n2 = nArray2[0];
            nArray[0] = XSAnyURIUtil.scanHexSequence(xMLString, nArray[0], n, nArray2);
            if (nArray[0] == -1) {
                return false;
            }
            if (xMLString.bytes[nArray[0]] == 93) {
                if (nArray2[0] != 8) return false;
                return true;
            }
            if (nArray2[0] > n2) {
                nArray[0] = nArray[0] + 1;
            }
            if (!XSAnyURIUtil.isWellFormedIPv4Address(xMLString, nArray, n)) return false;
            if (nArray[0] >= n) return false;
            if (xMLString.bytes[nArray[0]] != 93) return false;
            return true;
        }
        if (by == 46) return false;
        if (by == 45) {
            return false;
        }
        boolean bl = XSAnyURIUtil.isWellFormedIPv4Address(xMLString, nArray, n);
        if (!bl) {
            bl = XSAnyURIUtil.checkHostname(xMLString, nArray, n);
        }
        if (!bl) return bl;
        if (nArray[0] >= n) return bl;
        if (xMLString.bytes[nArray[0]] != 58) return bl;
        return true;
    }

    private static boolean checkHostname(XMLString xMLString, int[] nArray, int n) {
        byte by;
        int n2 = 0;
        int n3 = 0;
        do {
            if ((by = xMLString.bytes[nArray[0]]) == 46) {
                if (!XSAnyURIUtil.isAlphanum(xMLString.bytes[nArray[0] - 1])) {
                    return false;
                }
                if (nArray[0] + 1 < n && !XSAnyURIUtil.isAlphanum(n2 = xMLString.bytes[nArray[0] + 1])) {
                    return false;
                }
                n3 = 0;
                continue;
            }
            if (!XSAnyURIUtil.isAlphanum(by) && by != 45) {
                return false;
            }
            if (++n3 <= 63) continue;
            return false;
        } while ((nArray[0] = nArray[0] + 1) < n);
        return by != 45 && XSAnyURIUtil.isAlpha(n2);
    }

    private static boolean isWellFormedIPv4Address(XMLString xMLString, int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (nArray[0] < n) {
            byte by = xMLString.bytes[nArray[0]];
            if (by == 46) {
                if (nArray[0] > 0 && !XSAnyURIUtil.isDigit(xMLString.bytes[nArray[0] - 1]) || nArray[0] + 1 < n && !XSAnyURIUtil.isDigit(xMLString.bytes[nArray[0] + 1])) {
                    return false;
                }
                n3 = 0;
                ++n2;
            } else {
                if (!XSAnyURIUtil.isDigit(by)) {
                    return n2 == 3 && n3 > 0;
                }
                if (++n3 > 3) {
                    return false;
                }
                if (n3 == 3) {
                    byte by2 = xMLString.bytes[nArray[0] - 2];
                    byte by3 = xMLString.bytes[nArray[0] - 1];
                    if (by2 >= 50 && (by2 != 50 || by3 >= 53 && (by3 != 53 || by > 53))) {
                        return false;
                    }
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        return n2 == 3;
    }

    private static boolean isDigit(int n) {
        return n >= 48 && n <= 57;
    }

    private static int scanHexSequence(XMLString xMLString, int n, int n2, int[] nArray) {
        int n3 = 0;
        int n4 = n;
        while (n < n2) {
            byte by = xMLString.bytes[n];
            if (by == 58) {
                if (n3 > 0 && (nArray[0] = nArray[0] + 1) > 8) {
                    return -1;
                }
                if (n3 == 0 || n + 1 < n2 && xMLString.bytes[n + 1] == 58) {
                    return n;
                }
                n3 = 0;
            } else {
                if (!XSAnyURIUtil.isHex(by)) {
                    if (by == 46 && n3 < 4 && n3 > 0 && nArray[0] <= 6) {
                        int n5 = n - n3 - 1;
                        return n5 >= n4 ? n5 : n5 + 1;
                    }
                    if (by == 93) {
                        n2 = n;
                        break;
                    }
                    return -1;
                }
                if (++n3 > 4) {
                    return -1;
                }
            }
            ++n;
        }
        return n3 > 0 && (nArray[0] = nArray[0] + 1) <= 8 ? n2 : -1;
    }

    static {
        int n = 48;
        while (n <= 57) {
            int n2 = n++;
            fgLookupTable[n2] = (byte)(fgLookupTable[n2] | 0x60);
        }
        for (n = 65; n <= 70; ++n) {
            int n3 = n;
            fgLookupTable[n3] = (byte)(fgLookupTable[n3] | 0x50);
            int n4 = n + 32;
            fgLookupTable[n4] = (byte)(fgLookupTable[n4] | 0x50);
        }
        for (n = 71; n <= 90; ++n) {
            int n5 = n;
            fgLookupTable[n5] = (byte)(fgLookupTable[n5] | 0x10);
            int n6 = n + 32;
            fgLookupTable[n6] = (byte)(fgLookupTable[n6] | 0x10);
        }
        fgLookupTable[59] = (byte)(fgLookupTable[59] | 1);
        fgLookupTable[47] = (byte)(fgLookupTable[47] | 1);
        fgLookupTable[63] = (byte)(fgLookupTable[63] | 1);
        fgLookupTable[58] = (byte)(fgLookupTable[58] | 1);
        fgLookupTable[64] = (byte)(fgLookupTable[64] | 1);
        fgLookupTable[38] = (byte)(fgLookupTable[38] | 1);
        fgLookupTable[61] = (byte)(fgLookupTable[61] | 1);
        fgLookupTable[43] = (byte)(fgLookupTable[43] | 1);
        fgLookupTable[36] = (byte)(fgLookupTable[36] | 1);
        fgLookupTable[44] = (byte)(fgLookupTable[44] | 1);
        fgLookupTable[91] = (byte)(fgLookupTable[91] | 1);
        fgLookupTable[93] = (byte)(fgLookupTable[93] | 1);
        fgLookupTable[45] = (byte)(fgLookupTable[45] | 2);
        fgLookupTable[95] = (byte)(fgLookupTable[95] | 2);
        fgLookupTable[46] = (byte)(fgLookupTable[46] | 2);
        fgLookupTable[33] = (byte)(fgLookupTable[33] | 2);
        fgLookupTable[126] = (byte)(fgLookupTable[126] | 2);
        fgLookupTable[42] = (byte)(fgLookupTable[42] | 2);
        fgLookupTable[39] = (byte)(fgLookupTable[39] | 2);
        fgLookupTable[40] = (byte)(fgLookupTable[40] | 2);
        fgLookupTable[41] = (byte)(fgLookupTable[41] | 2);
        fgLookupTable[43] = (byte)(fgLookupTable[43] | 4);
        fgLookupTable[45] = (byte)(fgLookupTable[45] | 4);
        fgLookupTable[46] = (byte)(fgLookupTable[46] | 4);
        fgLookupTable[59] = (byte)(fgLookupTable[59] | 8);
        fgLookupTable[58] = (byte)(fgLookupTable[58] | 8);
        fgLookupTable[38] = (byte)(fgLookupTable[38] | 8);
        fgLookupTable[61] = (byte)(fgLookupTable[61] | 8);
        fgLookupTable[43] = (byte)(fgLookupTable[43] | 8);
        fgLookupTable[36] = (byte)(fgLookupTable[36] | 8);
        fgLookupTable[44] = (byte)(fgLookupTable[44] | 8);
        fgLookupTable[59] = (byte)(fgLookupTable[59] | 0x80);
        fgLookupTable[47] = (byte)(fgLookupTable[47] | 0x80);
        fgLookupTable[58] = (byte)(fgLookupTable[58] | 0x80);
        fgLookupTable[64] = (byte)(fgLookupTable[64] | 0x80);
        fgLookupTable[38] = (byte)(fgLookupTable[38] | 0x80);
        fgLookupTable[61] = (byte)(fgLookupTable[61] | 0x80);
        fgLookupTable[43] = (byte)(fgLookupTable[43] | 0x80);
        fgLookupTable[36] = (byte)(fgLookupTable[36] | 0x80);
        fgLookupTable[44] = (byte)(fgLookupTable[44] | 0x80);
        gNeedEscaping = ArrayAllocator.newBooleanArray(128);
        for (n = 0; n <= 31; ++n) {
            XSAnyURIUtil.gNeedEscaping[n] = true;
        }
        XSAnyURIUtil.gNeedEscaping[127] = true;
        for (char c : new char[]{'<', '>', '\"', '{', '}', '|', '\\', '^', '~', '`'}) {
            XSAnyURIUtil.gNeedEscaping[c] = true;
        }
    }
}

