/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.XDecimal;
import com.ibm.xml.xlxp2.datatype.XLong;
import com.ibm.xml.xlxp2.datatype.validation.Pattern;
import com.ibm.xml.xlxp2.datatype.validation.XSIntegerUtil;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class LongDV
extends TypeValidator {
    private static final long SIGNED_LONG_MULTMIN = -922337203685477580L;
    private final int totalDigits;
    private final long[] enumeration;
    private final long maxInclusive;
    private final long maxExclusive;
    private final long minInclusive;
    private final long minExclusive;

    public LongDV(String string, String string2, String string3, String[] stringArray, long[] lArray, long l, long l2, long l3, long l4, int n, int n2) {
        super(string, string2, string3, 33, 4, stringArray, LongDV.computeDefinedFacets(n2, l, l2, l3, l4), false);
        this.totalDigits = n;
        this.enumeration = lArray;
        this.maxInclusive = l3;
        this.maxExclusive = l4;
        this.minInclusive = l;
        this.minExclusive = l2;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XLong xLong = new XLong(LongDV.parse(xMLString));
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xLong;
            validatedInfo.errorCode = 0;
        }
        return xLong;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        long l = XSIntegerUtil.parseLong(xMLString, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            Object object = validatedInfo.actualValue;
            validatedInfo2.errorCode = object instanceof XLong ? (l == ((XLong)object).value ? 0 : 1) : (object instanceof XDecimal ? (((XDecimal)object).equals(l) ? 0 : 1) : 1);
            validatedInfo2.actualValue = object;
            return;
        }
        validatedInfo2.errorCode = this.preCheckFacets(l, xMLString);
        if (validatedInfo2.errorCode != 0) {
            return;
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = validationContext.getXLong(l);
    }

    public int preCheckFacets(long l, XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(l, xMLString);
        }
        return 0;
    }

    private int checkFacets(long l, XMLString xMLString) {
        if ((this.definedFacets & 0x200) != 0 && XSIntegerUtil.getTotalDigits(xMLString) > this.totalDigits) {
            return 1;
        }
        if ((this.definedFacets & 0x100) != 0 && l < this.minInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x80) != 0 && l <= this.minExclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x20) != 0 && l > this.maxInclusive) {
            return 1;
        }
        if ((this.definedFacets & 0x40) != 0 && l >= this.maxExclusive) {
            return 1;
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            boolean bl = false;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (this.enumeration[i] != l) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return 1;
            }
        }
        return 0;
    }

    private static int computeDefinedFacets(int n, long l, long l2, long l3, long l4) {
        if ((n & 0x100) != 0 && l <= Long.MIN_VALUE) {
            n &= 0xFFFFFEFF;
        }
        if ((n & 0x20) != 0 && l3 >= Long.MAX_VALUE) {
            n &= 0xFFFFFFDF;
        }
        if ((n & 0x80) != 0 && l2 < Long.MIN_VALUE) {
            n &= 0xFFFFFF7F;
        }
        if ((n & 0x40) != 0 && l4 > Long.MAX_VALUE) {
            n &= 0xFFFFFFBF;
        }
        return n;
    }

    protected Pattern createPattern(String[] stringArray, int n) {
        int n2;
        if ((n & 8) == 0 || stringArray.length == 1 && "[\\-+]?[0-9]+".equals(stringArray[0])) {
            return null;
        }
        int n3 = n2 = stringArray != null ? stringArray.length : 0;
        if (n2 == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[\\-+]?[0-9]+")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static long parse(XMLString xMLString) {
        return XSIntegerUtil.parseLong(xMLString, dummyOneElementArray);
    }

    private int parseLongUnbuffered(ParsedEntity parsedEntity, XLong xLong, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        boolean bl = false;
        long l = -9223372036854775807L;
        long l2 = -922337203685477580L;
        if ((n = LongDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        byte by = byArray[n];
        if (by == 45) {
            bl = true;
            l = Long.MIN_VALUE;
            if (++n < n2) {
                by = byArray[n];
            }
        } else if (by == 43 && ++n < n2) {
            by = byArray[n];
        }
        if (by >= 48 && by <= 57) {
            ++n;
            long l3 = 48 - by;
            while (n < n2 && (by = byArray[n]) >= 48 && by <= 57) {
                int n3;
                if (l3 >= l2 && (l3 *= 10L) >= l + (long)(n3 = by - 48)) {
                    l3 -= (long)n3;
                } else {
                    return -1;
                }
                ++n;
            }
            if ((n = LongDV.removeWhitespace(byArray, n, n2, blArray)) < n2) {
                xLong.value = bl ? l3 : -l3;
                return n;
            }
        }
        return -1;
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XLong xLong = vMContext.dvContext.getXLong(0L);
        int n = this.parseLongUnbuffered(parsedEntity, xLong, this.fNormalized);
        if (n == -1) {
            return null;
        }
        parsedEntity.offset = n;
        return xLong;
    }

    protected int preCheckFacets(Object object, XMLString xMLString) {
        return this.preCheckFacets(((XLong)object).value, xMLString);
    }
}

