/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.validation.Pattern;
import com.ibm.xml.xlxp2.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp2.datatype.validation.XSAnyURIUtil;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import com.ibm.xml.xlxp2.scan.util.XMLStringBuffer;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class LanguageDV
extends TypeValidator {
    private final int length;
    private final int minLength;
    private final int maxLength;
    private final XMLString[] enumeration;

    public LanguageDV(String string, String string2, String string3, String[] stringArray, XMLString[] xMLStringArray, int n, int n2, int n3, int n4) {
        super(string, string2, string3, 23, 2, stringArray, n4, false);
        this.length = n;
        this.minLength = n2;
        this.maxLength = n3;
        this.enumeration = xMLStringArray;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XMLString xMLString2 = LanguageDV.parse(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xMLString2;
            validatedInfo.errorCode = validatedInfo.actualValue != null ? 0 : 1;
        }
        return xMLString2;
    }

    public int preCheckFacets(XMLString xMLString) {
        if (this.definedFacets != 0) {
            return this.checkFacets(xMLString);
        }
        return 0;
    }

    private int checkFacets(XMLString xMLString) {
        int n = -1;
        if ((this.definedFacets & 2) != 0 && (n = XMLStringUtil.getUnicodeCharLength(xMLString)) < this.minLength) {
            return 1;
        }
        if ((this.definedFacets & 4) != 0) {
            if (n == -1) {
                n = XMLStringUtil.getUnicodeCharLength(xMLString);
            }
            if (n > this.maxLength) {
                return 1;
            }
        }
        if ((this.definedFacets & 1) != 0) {
            if (n == -1) {
                n = XMLStringUtil.getUnicodeCharLength(xMLString);
            }
            if (n != this.length) {
                return 1;
            }
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equalsXMLString(xMLString)) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        XMLString xMLString2 = LanguageDV.parse(xMLString, validationContext, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = xMLString2.equals(validatedInfo.actualValue) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xMLString2);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xMLString2;
    }

    private static XMLString parse(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        nArray[0] = 0;
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return null;
        }
        if (xMLString.bytes != null) {
            return LanguageDV.parseLanguageUnbuffered(xMLString, validationContext, nArray);
        }
        return LanguageDV.parseLanguageBuffered(xMLString, validationContext, nArray);
    }

    private static XMLString parseLanguageBuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n = xMLString.startOffset;
        int n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by = dataBuffer.bytes[n];
        if (by <= 32) {
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                    by = dataBuffer.bytes[n];
                    continue;
                }
                if (n != n2 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n];
            }
        }
        if (n == n2) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            NullDataBufferFactory.setEmptyStringValues(xMLString2);
            return xMLString2;
        }
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        int n3 = xMLStringBuffer.getOffset();
        int n4 = 0;
        while (true) {
            if (n < n2) {
                by = dataBuffer.bytes[n];
                xMLStringBuffer.appendChar(by);
                if (!XSAnyURIUtil.isAlpha(by)) break;
                if (n4 == 8) {
                    nArray[0] = 1;
                    return null;
                }
                ++n4;
                ++n;
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n = dataBuffer.startOffset;
            n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        if (n4 == 0) {
            nArray[0] = 1;
            return null;
        }
        if (n < n2) {
            if (by != 45) {
                nArray[0] = 1;
                return null;
            }
            block2: do {
                n4 = 0;
                while (true) {
                    if (++n < n2) {
                        by = dataBuffer.bytes[n];
                        xMLStringBuffer.appendChar(by);
                        if (!XSAnyURIUtil.isAlpha(by) && (by < 48 || by > 57)) break;
                        if (n4 == 8) {
                            nArray[0] = 1;
                            return null;
                        }
                        ++n4;
                        continue;
                    }
                    if (dataBuffer == dataBuffer2) break block2;
                    dataBuffer = dataBuffer.next;
                    n = dataBuffer.startOffset - 1;
                    n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                if (n4 != 0) continue;
                nArray[0] = 1;
                return null;
            } while (by == 45);
        }
        if (n < n2 && by <= 32) {
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n < n2) {
                    by = dataBuffer.bytes[n];
                    continue;
                }
                if (n != n2 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n2 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n];
            }
        }
        if (n < n2) {
            nArray[0] = 1;
            return null;
        }
        XMLString xMLString3 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        xMLStringBuffer.setStringValues(n3, xMLStringBuffer.getOffset(), xMLString3);
        return xMLString3;
    }

    private static XMLString parseLanguageUnbuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) == n2) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            NullDataBufferFactory.setEmptyStringValues(xMLString2);
            return xMLString2;
        }
        byte by = 0;
        int n3 = 0;
        int n4 = n;
        while (n < n2 && XSAnyURIUtil.isAlpha(by = xMLString.bytes[n])) {
            if (n3 == 8) {
                nArray[0] = 1;
                return null;
            }
            ++n3;
            ++n;
        }
        if (n3 == 0) {
            nArray[0] = 1;
            return null;
        }
        if (n < n2) {
            if (by != 45) {
                nArray[0] = 1;
                return null;
            }
            do {
                n3 = 0;
                while (++n < n2 && (XSAnyURIUtil.isAlpha(by = xMLString.bytes[n]) || by >= 48 && by <= 57)) {
                    if (n3 == 8) {
                        nArray[0] = 1;
                        return null;
                    }
                    ++n3;
                }
                if (n3 != 0) continue;
                nArray[0] = 1;
                return null;
            } while (n < n2 && by == 45);
        }
        int n5 = n;
        if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) < n2) {
            nArray[0] = 1;
            return null;
        }
        XMLString xMLString3 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        xMLString3.setValues(xMLString);
        xMLString3.startOffset = n4;
        xMLString3.endOffset = n5;
        return xMLString3;
    }

    private int parseLanguageUnbuffered(ParsedEntity parsedEntity, XMLString xMLString, boolean[] blArray) {
        byte[] byArray = parsedEntity.bytes;
        int n = parsedEntity.offset;
        int n2 = parsedEntity.endOffset;
        if ((n = LanguageDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        byte by = 0;
        int n3 = 0;
        int n4 = n;
        while (n < n2 && XSAnyURIUtil.isAlpha(by = byArray[n])) {
            ++n;
            ++n3;
        }
        if (n >= n2 || n3 == 0 || n3 >= 8) {
            return -1;
        }
        while (by == 45) {
            n3 = 0;
            while (++n < n2 && (XSAnyURIUtil.isAlpha(by = byArray[n]) || by >= 48 && by <= 57)) {
                ++n3;
            }
            if (n < n2 && n3 != 0 && n3 < 8) continue;
            return -1;
        }
        int n5 = n;
        if ((n = LanguageDV.removeWhitespace(byArray, n, n2, blArray)) >= n2) {
            return -1;
        }
        xMLString.setValues(parsedEntity.buffer, n4, n5);
        xMLString.flags = 1;
        return n;
    }

    protected Pattern createPattern(String[] stringArray, int n) {
        if ((n & 8) == 0 || stringArray.length == 1 && "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*".equals(stringArray[0])) {
            return null;
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return new Pattern(this.filterPatterns(stringArray));
    }

    private String[] filterPatterns(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(ArrayAllocator.newStringArray(arrayList.size()));
    }

    public static XMLString parse(XMLString xMLString) {
        return LanguageDV.parse(xMLString, null, dummyOneElementArray);
    }

    protected Object parseValue(ParsedEntity parsedEntity, ValidatedInfo validatedInfo, VMContext vMContext) {
        XMLString xMLString = vMContext.dvContext.getXMLString();
        int n = this.parseLanguageUnbuffered(parsedEntity, xMLString, this.fNormalized);
        if (n == -1) {
            return null;
        }
        parsedEntity.offset = n;
        return xMLString;
    }

    protected int preCheckFacets(Object object, XMLString xMLString) {
        return this.preCheckFacets((XMLString)object);
    }
}

