/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.datatype.validation;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.validation.XMLStringUtil;
import com.ibm.xml.xlxp2.datatype.validation.XSAnyURIUtil;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import com.ibm.xml.xlxp2.scan.util.XMLStringBuffer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class AnyURIDV
extends TypeValidator {
    private final XMLString[] enumeration;
    private final int length;
    private final int minLength;
    private final int maxLength;

    public AnyURIDV(String string, String string2, String string3, String[] stringArray, XMLString[] xMLStringArray, int n, int n2, int n3, int n4) {
        super(string, string2, string3, 18, 18, stringArray, n4, false);
        this.length = n;
        this.minLength = n2;
        this.maxLength = n3;
        this.enumeration = xMLStringArray;
    }

    public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
        XMLString xMLString2 = AnyURIDV.parse(xMLString);
        if (validatedInfo != null) {
            validatedInfo.typeValidator = this;
            validatedInfo.actualValue = xMLString2;
            validatedInfo.errorCode = validatedInfo.actualValue != null ? 0 : 1;
        }
        return xMLString2;
    }

    private static XMLString parse(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        if (xMLString.length == 0) {
            nArray[0] = 1;
            return null;
        }
        nArray[0] = 0;
        if (xMLString.bytes != null) {
            return AnyURIDV.parseURIUnbuffered(xMLString, validationContext, nArray);
        }
        return AnyURIDV.parseURIBuffered(xMLString, validationContext, nArray);
    }

    private static XMLString parseURIBuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        int n;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by = dataBuffer.bytes[n2];
        if (by <= 32) {
            while (true) {
                if ((by == 32 || by == 10 || by == 9 || by == 13) && ++n2 < n3) {
                    by = dataBuffer.bytes[n2];
                    continue;
                }
                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by = dataBuffer.bytes[n2];
            }
        }
        if (n2 == n3) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            NullDataBufferFactory.setEmptyStringValues(xMLString2);
            return xMLString2;
        }
        by = dataBuffer.bytes[n2];
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        int n4 = xMLStringBuffer.getOffset();
        boolean bl = false;
        boolean bl2 = false;
        if (XSAnyURIUtil.isAlpha(by)) {
            xMLStringBuffer.appendChar(by);
            n = n2;
            DataBuffer dataBuffer3 = dataBuffer;
            while (true) {
                if (++n < n3) {
                    by = dataBuffer3.bytes[n];
                    xMLStringBuffer.appendChar(by);
                    if (by != 58 && by != 47 && by != 63 && by != 35 && XSAnyURIUtil.isSchemeCharacter(by)) continue;
                    break;
                }
                if (dataBuffer3 == dataBuffer2) break;
                dataBuffer3 = dataBuffer3.next;
                n = dataBuffer3.startOffset - 1;
                n3 = dataBuffer3 == dataBuffer2 ? xMLString.endOffset : dataBuffer3.endOffset;
            }
            if (by == 58) {
                bl2 = true;
                while (true) {
                    if (n + 1 < n3) break;
                    if (dataBuffer3 == dataBuffer2) {
                        nArray[0] = 1;
                        return null;
                    }
                    dataBuffer3 = dataBuffer3.next;
                    n = dataBuffer3.startOffset - 1;
                    n3 = dataBuffer3 == dataBuffer2 ? xMLString.endOffset : dataBuffer3.endOffset;
                }
                by = dataBuffer3.bytes[n + 1];
                if (by == 35) {
                    nArray[0] = 1;
                    return null;
                }
                n2 = n + 1;
                dataBuffer = dataBuffer3;
                n3 = dataBuffer3 == dataBuffer2 ? xMLString.endOffset : dataBuffer3.endOffset;
                by = dataBuffer.bytes[n2];
            } else {
                xMLStringBuffer.reset(true);
                n4 = xMLStringBuffer.getOffset();
            }
        }
        if (by == 47) {
            int n5 = n = n2;
            DataBuffer dataBuffer4 = dataBuffer;
            while (true) {
                if (n + 1 < n3) {
                    by = dataBuffer4.bytes[n + 1];
                    break;
                }
                if (dataBuffer4 == dataBuffer2) break;
                dataBuffer4 = dataBuffer4.next;
                n = dataBuffer4.startOffset - 1;
                n3 = dataBuffer4 == dataBuffer2 ? xMLString.endOffset : dataBuffer4.endOffset;
            }
            if (n + 1 < n3 && by == 47) {
                n2 = n + 1;
                dataBuffer = dataBuffer4;
                n3 = dataBuffer4 == dataBuffer2 ? xMLString.endOffset : dataBuffer4.endOffset;
                XMLString xMLString3 = validationContext != null ? validationContext.getXMLString() : new XMLString();
                xMLStringBuffer.setStringValues(n4, xMLStringBuffer.getOffset(), xMLString3);
                xMLStringBuffer.appendChar(47);
                xMLStringBuffer.appendChar(47);
                int n6 = 0;
                while (true) {
                    if (++n2 < n3) {
                        by = dataBuffer.bytes[n2];
                        if (by == 47 || by == 35 || by == 63) break;
                        if (by == 32 || by == 10 || by == 9 || by == 13) {
                            bl = true;
                            continue;
                        }
                        if (bl) {
                            xMLStringBuffer.appendChar(32);
                            bl = false;
                        }
                        xMLStringBuffer.appendChar(by);
                        ++n6;
                        continue;
                    }
                    if (dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    n2 = dataBuffer.startOffset - 1;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                }
                if (bl) {
                    xMLStringBuffer.appendChar(32);
                    bl = false;
                }
                if (n6 > 0 && !XSAnyURIUtil.parseAuthority(xMLString, new DataBuffer[]{dataBuffer4, dataBuffer}, new int[]{n + 2, n2})) {
                    n2 = n5;
                    dataBuffer = dataBuffer4;
                    n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                    xMLStringBuffer.reset(true);
                    n4 = xMLStringBuffer.getOffset();
                    xMLStringBuffer.appendXMLString(xMLString3);
                }
                xMLString3.unregister();
            }
        }
        if (!XSAnyURIUtil.parsePath(xMLString, xMLStringBuffer, n2, dataBuffer, bl2)) {
            nArray[0] = 1;
            return null;
        }
        XMLString xMLString4 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        xMLStringBuffer.setStringValues(n4, xMLStringBuffer.getOffset(), xMLString4);
        return xMLString4;
    }

    private static XMLString parseURIUnbuffered(XMLString xMLString, ValidationContext validationContext, int[] nArray) {
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        if ((n = XMLStringUtil.removeWhitespace(xMLString.bytes, n, n2)) == n2) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            NullDataBufferFactory.setEmptyStringValues(xMLString2);
            return xMLString2;
        }
        byte by = xMLString.bytes[n];
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        int n3 = xMLStringBuffer.getOffset();
        boolean bl = false;
        boolean bl2 = false;
        if (XSAnyURIUtil.isAlpha(by)) {
            int n4 = 0;
            for (n4 = n; n4 < n2; ++n4) {
                by = xMLString.bytes[n4];
                xMLStringBuffer.appendChar(by);
                if (by == 58 || by == 47 || by == 63 || by == 35 || !XSAnyURIUtil.isSchemeCharacter(by)) break;
            }
            if (by == 58) {
                bl2 = true;
                if (n4 + 1 >= n2 || xMLString.bytes[n4 + 1] == 35) {
                    nArray[0] = 1;
                    return null;
                }
                n = n4 + 1;
                by = xMLString.bytes[n];
            } else {
                xMLStringBuffer.reset(true);
                n3 = xMLStringBuffer.getOffset();
            }
        }
        if (by == 47 && n + 1 < n2 && xMLString.bytes[n + 1] == 47) {
            n += 2;
            bl = false;
            XMLString xMLString3 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            xMLStringBuffer.setStringValues(n3, xMLStringBuffer.getOffset(), xMLString3);
            xMLStringBuffer.appendChar(47);
            xMLStringBuffer.appendChar(47);
            int n5 = n;
            while ((by = xMLString.bytes[n]) != 47 && by != 63 && by != 35) {
                if (by == 32 || by == 10 || by == 9 || by == 13) {
                    bl = true;
                } else {
                    if (bl) {
                        xMLStringBuffer.appendChar(32);
                        bl = false;
                    }
                    xMLStringBuffer.appendChar(by);
                }
                if (++n < n2) continue;
            }
            if (bl) {
                xMLStringBuffer.appendChar(32);
                bl = false;
            }
            if (n > n5 && !XSAnyURIUtil.parseAuthority(xMLString, n5, n)) {
                n = n5 - 2;
                xMLStringBuffer.reset(true);
                n3 = xMLStringBuffer.getOffset();
                xMLStringBuffer.appendXMLString(xMLString3);
            }
            xMLString3.unregister();
        }
        if (!XSAnyURIUtil.parsePath(xMLString, xMLStringBuffer, n, bl2)) {
            nArray[0] = 1;
            return null;
        }
        XMLString xMLString4 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        xMLStringBuffer.setStringValues(n3, xMLStringBuffer.getOffset(), xMLString4);
        return xMLString4;
    }

    public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
        validatedInfo2.typeValidator = this;
        int[] nArray = validationContext.tempErrorCode;
        XMLString xMLString2 = AnyURIDV.parse(xMLString, validationContext, nArray);
        if (nArray[0] != 0) {
            validatedInfo2.errorCode = nArray[0];
            return;
        }
        if (validatedInfo != null && validatedInfo.actualValue != null) {
            validatedInfo2.errorCode = xMLString2.equals(validatedInfo.actualValue) ? 0 : 1;
            validatedInfo2.actualValue = validatedInfo.actualValue;
            return;
        }
        if (this.definedFacets != 0) {
            validatedInfo2.errorCode = this.checkFacets(xMLString2);
            if (validatedInfo2.errorCode != 0) {
                return;
            }
        }
        validatedInfo2.errorCode = 0;
        validatedInfo2.actualValue = xMLString2;
    }

    private int checkFacets(XMLString xMLString) {
        int n = -1;
        if ((this.definedFacets & 2) != 0 && (n = XMLStringUtil.getUnicodeCharLength(xMLString)) < this.minLength) {
            return 1;
        }
        if ((this.definedFacets & 4) != 0) {
            if (n == -1) {
                n = XMLStringUtil.getUnicodeCharLength(xMLString);
            }
            if (n > this.maxLength) {
                return 1;
            }
        }
        if ((this.definedFacets & 1) != 0) {
            if (n == -1) {
                n = XMLStringUtil.getUnicodeCharLength(xMLString);
            }
            if (n != this.length) {
                return 1;
            }
        }
        if ((this.definedFacets & 8) != 0 && !this.pattern.matches(xMLString)) {
            return 1;
        }
        if ((this.definedFacets & 0x800) != 0) {
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equalsXMLString(xMLString)) continue;
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public static XMLString parse(XMLString xMLString) {
        return AnyURIDV.parse(xMLString, null, dummyOneElementArray);
    }
}

