/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.wssec;

import com.ibm.xml.xlxp2.api.wssec.WSInfo;
import com.ibm.xml.xlxp2.api.wssec.WSInfoImpl;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.DocumentScanner;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.SymbolTable;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XLXPWSInfoBuilder
extends DocumentScanner {
    private static final String NS_SOAP = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String NS_SOAP12 = "http://www.w3.org/2003/05/soap-envelope";
    private static final String NS_WSSE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String NS_ENC = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NS_DSIG = "http://www.w3.org/2000/09/xmldsig#";
    private static final int INIT_SIZE = 8;
    private static final int ID_INIT_SIZE = 2;
    private static final int CACHED_QNAME_INIT = 32;
    private static final int CACHED_QNAME_LIMIT = 256;
    private static final byte[] trueBytes = new byte[]{116, 114, 117, 101};
    private static final byte[] falseBytes = new byte[]{102, 97, 108, 115, 101};
    private final XMLString fSkippedContent = new XMLString();
    private String fSOAPNSURI;
    private String fActorOrRole;
    private boolean beforeBody;
    private boolean foundSecurityHeader = false;
    private int soapHeaderChildIndex = 0;
    private javax.xml.namespace.QName[] soapHeaderChildren = null;
    private String[] actorOrRole = null;
    private Boolean[] mustUnderstand = null;
    private WSInfo fWSInfo = null;
    private javax.xml.namespace.QName soapBodyFirstChild = null;
    private javax.xml.namespace.QName soapBodyEncryptedDataKeyInfoFirstChild = null;
    private javax.xml.namespace.QName soapBodyEncryptedDataKeyInfoSecurityTokenReferenceFirstChild = null;
    private int bodyIdIndex = 0;
    private javax.xml.namespace.QName[] bodyIdQName = null;
    private String[] bodyIdValue = null;
    private int soapBodyFirstChildIdIndex = 0;
    private javax.xml.namespace.QName[] soapBodyFirstChildIdQName = null;
    private String[] soapBodyFirstChildIdValue = null;
    private Object[] fQNameList = new Object[96];
    private int fQNameListIndex;
    private boolean fCachedQNamesReachLimit = false;

    public XLXPWSInfoBuilder() {
        this((DataBufferFactory)new SimpleDataBufferFactory(), null);
    }

    public XLXPWSInfoBuilder(DataBufferFactory dataBufferFactory, SymbolTable symbolTable) {
        super(dataBufferFactory, symbolTable);
    }

    void reset() {
        super.reset(true);
        this.soapHeaderChildIndex = 0;
        this.bodyIdIndex = 0;
        this.soapBodyFirstChildIdIndex = 0;
        this.foundSecurityHeader = false;
        this.fWSInfo = null;
    }

    public WSInfo getWSInfo(ParsedEntity parsedEntity) {
        parsedEntity.setMark();
        this.parseDocumentEntity(parsedEntity);
        if (this.fWSInfo == null && this.soapBodyFirstChild != null) {
            this.fWSInfo = this.createWSInfo();
        }
        parsedEntity.resetToMark();
        WSInfo wSInfo = this.fWSInfo;
        this.reset();
        return wSInfo;
    }

    private WSInfo createWSInfo() {
        WSInfoImpl wSInfoImpl = new WSInfoImpl();
        wSInfoImpl.length = this.soapHeaderChildIndex;
        wSInfoImpl.soapHeaderChildren = this.soapHeaderChildren;
        wSInfoImpl.actorOrRole = this.actorOrRole;
        wSInfoImpl.mustUnderstand = this.mustUnderstand;
        wSInfoImpl.firstSOAPBodyChild = this.soapBodyFirstChild;
        wSInfoImpl.bodyIdSize = this.bodyIdIndex;
        wSInfoImpl.bodyIdQName = this.bodyIdQName;
        wSInfoImpl.bodyIdValue = this.bodyIdValue;
        wSInfoImpl.firstSOAPBodyChildIdSize = this.soapBodyFirstChildIdIndex;
        wSInfoImpl.firstSOAPBodyChildIdQName = this.soapBodyFirstChildIdQName;
        wSInfoImpl.firstSOAPBodyChildIdValue = this.soapBodyFirstChildIdValue;
        wSInfoImpl.soapBodyEncryptedDataKeyInfoFirstChild = this.soapBodyEncryptedDataKeyInfoFirstChild;
        wSInfoImpl.soapBodyEncryptedDataKeyInfoSecurityTokenReferenceFirstChild = this.soapBodyEncryptedDataKeyInfoSecurityTokenReferenceFirstChild;
        this.soapHeaderChildren = null;
        this.actorOrRole = null;
        this.mustUnderstand = null;
        this.bodyIdQName = null;
        this.bodyIdValue = null;
        this.soapBodyFirstChildIdQName = null;
        this.soapBodyFirstChildIdValue = null;
        this.soapBodyEncryptedDataKeyInfoFirstChild = null;
        this.soapBodyEncryptedDataKeyInfoSecurityTokenReferenceFirstChild = null;
        return wSInfoImpl;
    }

    private javax.xml.namespace.QName findQName(String string, String string2) {
        for (int i = 0; i < this.fQNameListIndex; i += 3) {
            if (this.fQNameList[i] != string || this.fQNameList[i + 1] != string2) continue;
            return (javax.xml.namespace.QName)this.fQNameList[i + 2];
        }
        return this.createQName(string, string2);
    }

    private javax.xml.namespace.QName createQName(String string, String string2) {
        javax.xml.namespace.QName qName = new javax.xml.namespace.QName(string, string2);
        if (this.fCachedQNamesReachLimit) {
            return qName;
        }
        if (this.fQNameListIndex == this.fQNameList.length) {
            Object[] objectArray = new Object[this.fQNameListIndex << 1];
            System.arraycopy(this.fQNameList, 0, objectArray, 0, this.fQNameListIndex);
            this.fQNameList = objectArray;
            if (this.fQNameList.length == 768) {
                this.fCachedQNamesReachLimit = true;
            }
        }
        this.fQNameList[this.fQNameListIndex++] = string;
        this.fQNameList[this.fQNameListIndex++] = string2;
        this.fQNameList[this.fQNameListIndex++] = qName;
        return qName;
    }

    public boolean produceLeafElementEvent() {
        super.produceLeafElementEvent();
        return this.processStartElement(this.elementDepth + 1, true);
    }

    public boolean produceStartElementEvent() {
        super.produceStartElementEvent();
        return this.processStartElement(this.elementDepth + 1, false);
    }

    public boolean processStartElement(int n, boolean bl) {
        switch (n) {
            case 1: {
                if (this.elementType.localName == "Envelope") {
                    if (this.elementType.nsURI == NS_SOAP) {
                        this.fSOAPNSURI = NS_SOAP;
                        this.fActorOrRole = "actor";
                    } else if (this.elementType.nsURI == NS_SOAP12) {
                        this.fSOAPNSURI = NS_SOAP12;
                        this.fActorOrRole = "role";
                    } else {
                        return false;
                    }
                    this.beforeBody = true;
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.elementType.nsURI == this.fSOAPNSURI) {
                    if (this.elementType.localName == "Header") {
                        return true;
                    }
                    if (this.elementType.localName == "Body") {
                        this.beforeBody = false;
                        if (!this.foundSecurityHeader) {
                            return false;
                        }
                        for (int i = 0; i < this.attrCount; ++i) {
                            QName qName = this.fAttributeNames[i];
                            if (qName.localName != "Id") continue;
                            javax.xml.namespace.QName qName2 = this.findQName(qName.nsURI, qName.localName);
                            String string = this.attributeValue(i).toString();
                            if (this.bodyIdQName == null) {
                                this.bodyIdQName = new javax.xml.namespace.QName[2];
                                this.bodyIdValue = new String[2];
                            } else if (this.bodyIdIndex == this.bodyIdQName.length) {
                                this.expandArrayBodyId();
                            }
                            this.bodyIdQName[this.bodyIdIndex] = qName2;
                            this.bodyIdValue[this.bodyIdIndex] = string;
                            ++this.bodyIdIndex;
                        }
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                javax.xml.namespace.QName qName = this.findQName(this.elementType.nsURI, this.elementType.localName);
                if (this.beforeBody) {
                    if (this.soapHeaderChildren == null) {
                        this.soapHeaderChildren = new javax.xml.namespace.QName[8];
                    } else if (this.soapHeaderChildIndex == this.soapHeaderChildren.length) {
                        this.expandArray();
                    }
                    this.soapHeaderChildren[this.soapHeaderChildIndex] = qName;
                    if (!this.foundSecurityHeader && this.elementType.localName == "Security" && this.elementType.nsURI == NS_WSSE) {
                        this.foundSecurityHeader = true;
                    }
                    for (int i = 0; i < this.attrCount; ++i) {
                        QName qName3 = this.fAttributeNames[i];
                        if (qName3.nsURI != this.fSOAPNSURI) continue;
                        if (qName3.localName == "mustUnderstand") {
                            if (this.mustUnderstand == null) {
                                this.mustUnderstand = new Boolean[this.soapHeaderChildren.length];
                            }
                            XMLString xMLString = this.attributeValue(i);
                            switch (xMLString.length) {
                                case 1: {
                                    byte by = xMLString.firstBuffer.bytes[xMLString.startOffset];
                                    if (by == 49) {
                                        this.mustUnderstand[this.soapHeaderChildIndex] = Boolean.TRUE;
                                        break;
                                    }
                                    if (by != 48) break;
                                    this.mustUnderstand[this.soapHeaderChildIndex] = Boolean.FALSE;
                                    break;
                                }
                                case 4: {
                                    if (!xMLString.equalsString(trueBytes, 0, 4)) break;
                                    this.mustUnderstand[this.soapHeaderChildIndex] = Boolean.TRUE;
                                    break;
                                }
                                case 5: {
                                    if (!xMLString.equalsString(falseBytes, 0, 5)) break;
                                    this.mustUnderstand[this.soapHeaderChildIndex] = Boolean.FALSE;
                                }
                            }
                            continue;
                        }
                        if (qName3.localName != this.fActorOrRole) continue;
                        if (this.actorOrRole == null) {
                            this.actorOrRole = new String[this.soapHeaderChildren.length];
                        }
                        this.actorOrRole[this.soapHeaderChildIndex] = this.attributeValue(i).toString();
                    }
                    ++this.soapHeaderChildIndex;
                    if (bl) {
                        return true;
                    }
                    return this.skipContent(this.fSkippedContent);
                }
                if (this.soapBodyFirstChild != null) {
                    this.fWSInfo = this.createWSInfo();
                    return false;
                }
                this.soapBodyFirstChild = qName;
                for (int i = 0; i < this.attrCount; ++i) {
                    QName qName4 = this.fAttributeNames[i];
                    if (qName4.localName != "Id") continue;
                    javax.xml.namespace.QName qName5 = this.findQName(qName4.nsURI, qName4.localName);
                    String string = this.attributeValue(i).toString();
                    if (this.soapBodyFirstChildIdQName == null) {
                        this.soapBodyFirstChildIdQName = new javax.xml.namespace.QName[2];
                        this.soapBodyFirstChildIdValue = new String[2];
                    } else if (this.soapBodyFirstChildIdIndex == this.soapBodyFirstChildIdQName.length) {
                        this.expandArrayFirstBodyId();
                    }
                    this.soapBodyFirstChildIdQName[this.soapBodyFirstChildIdIndex] = qName5;
                    this.soapBodyFirstChildIdValue[this.soapBodyFirstChildIdIndex] = string;
                    ++this.soapBodyFirstChildIdIndex;
                }
                if (this.elementType.localName == "EncryptedData" && this.elementType.nsURI == NS_ENC) {
                    return true;
                }
                this.fWSInfo = this.createWSInfo();
                return false;
            }
            case 4: {
                if (this.elementType.localName == "KeyInfo" && this.elementType.nsURI == NS_DSIG) {
                    return true;
                }
                if (this.elementType.localName == "CipherData" && this.elementType.nsURI == NS_ENC) {
                    this.fWSInfo = this.createWSInfo();
                    return false;
                }
                if (bl) {
                    return true;
                }
                return this.skipContent(this.fSkippedContent);
            }
            case 5: {
                this.soapBodyEncryptedDataKeyInfoFirstChild = this.findQName(this.elementType.nsURI, this.elementType.localName);
                if (this.elementType.localName == "SecurityTokenReference" && this.elementType.nsURI == NS_WSSE) {
                    return true;
                }
                this.fWSInfo = this.createWSInfo();
                return false;
            }
            case 6: {
                this.soapBodyEncryptedDataKeyInfoSecurityTokenReferenceFirstChild = this.findQName(this.elementType.nsURI, this.elementType.localName);
                this.fWSInfo = this.createWSInfo();
                return false;
            }
        }
        return false;
    }

    private void expandArray() {
        Object[] objectArray;
        int n = this.soapHeaderChildren.length * 2;
        javax.xml.namespace.QName[] qNameArray = new javax.xml.namespace.QName[n];
        System.arraycopy(this.soapHeaderChildren, 0, qNameArray, 0, this.soapHeaderChildren.length);
        this.soapHeaderChildren = qNameArray;
        if (this.actorOrRole != null) {
            objectArray = new String[n];
            System.arraycopy(this.actorOrRole, 0, objectArray, 0, this.actorOrRole.length);
            this.actorOrRole = objectArray;
        }
        if (this.mustUnderstand != null) {
            objectArray = new Boolean[n];
            System.arraycopy(this.mustUnderstand, 0, objectArray, 0, this.mustUnderstand.length);
            this.mustUnderstand = objectArray;
        }
    }

    private void expandArrayBodyId() {
        int n = this.bodyIdQName.length * 2;
        javax.xml.namespace.QName[] qNameArray = new javax.xml.namespace.QName[n];
        String[] stringArray = new String[n];
        System.arraycopy(this.bodyIdQName, 0, qNameArray, 0, this.bodyIdQName.length);
        System.arraycopy(this.bodyIdValue, 0, stringArray, 0, this.bodyIdValue.length);
        this.bodyIdQName = qNameArray;
        this.bodyIdValue = stringArray;
    }

    private void expandArrayFirstBodyId() {
        int n = this.soapBodyFirstChildIdQName.length * 2;
        javax.xml.namespace.QName[] qNameArray = new javax.xml.namespace.QName[n];
        String[] stringArray = new String[n];
        System.arraycopy(this.soapBodyFirstChildIdQName, 0, qNameArray, 0, this.soapBodyFirstChildIdQName.length);
        System.arraycopy(this.soapBodyFirstChildIdValue, 0, stringArray, 0, this.soapBodyFirstChildIdValue.length);
        this.soapBodyFirstChildIdQName = qNameArray;
        this.soapBodyFirstChildIdValue = stringArray;
    }

    protected void releaseDocumentEntityDefault() {
    }

    protected boolean scanDoctypeDeclDefault() {
        return false;
    }
}

