/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.sax.impl;

import com.ibm.xml.xlxp2.api.sax.impl.SAXExceptionWrapper;
import com.ibm.xml.xlxp2.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp2.api.util.SimpleParsedEntityFactory;
import com.ibm.xml.xlxp2.api.util.URI;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.FilterInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class SAX2ParsedEntityFactory
extends SimpleParsedEntityFactory {
    private EntityResolver fResolver;

    public SAX2ParsedEntityFactory(DataBufferFactory dataBufferFactory) {
        super(dataBufferFactory);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.fResolver;
    }

    public ParsedEntity createParsedEntity(InputSource inputSource) {
        this.fInOutEncodingName[0] = null;
        ParsedEntity parsedEntity = this.createParsedEntity(inputSource, this.fInOutEncodingName);
        this.fInOutEncodingName[0] = null;
        return parsedEntity;
    }

    public ParsedEntity createParsedEntity(InputSource inputSource, String[] stringArray) {
        ParsedEntity parsedEntity = this.getFreeEntity();
        String string = inputSource.getSystemId();
        if (string != null) {
            parsedEntity.baseURI = string;
        }
        parsedEntity.isCoordinatesAware = this.fCoordinatesAware;
        this.readFromInputSource(parsedEntity, inputSource, stringArray);
        return parsedEntity;
    }

    protected boolean resolvedExternalID(ParsedEntity parsedEntity, XMLString xMLString, String string) {
        InputSource inputSource;
        if (this.fResolver != null && (inputSource = this.resolveExternalEntity(xMLString != null ? xMLString.toString() : null, parsedEntity.baseURI)) != null) {
            String string2 = inputSource.getSystemId();
            if (string2 != null) {
                parsedEntity.baseURI = string2;
                parsedEntity.baseURI = this.expandSystemID(parsedEntity.baseURI, string);
            } else {
                parsedEntity.baseURI = null;
            }
            this.readFromInputSource(parsedEntity, inputSource, null);
            return true;
        }
        return false;
    }

    private CharConversionError readFromInputSource(ParsedEntity parsedEntity, InputSource inputSource, String[] stringArray) {
        try {
            Reader reader = inputSource.getCharacterStream();
            if (reader == null) {
                InputStream inputStream = inputSource.getByteStream();
                String string = inputSource.getEncoding();
                if (inputStream == null) {
                    try {
                        inputStream = URI.openStream(parsedEntity.baseURI);
                    }
                    catch (IOException iOException) {
                        throw new IOExceptionWrapper(iOException);
                    }
                } else {
                    inputStream = new NeverCloseInputStream(inputStream);
                }
                return this.setByteStreamSource(parsedEntity, inputStream, string, stringArray);
            }
            reader = new NeverCloseReader(reader);
            return this.setCharacterStreamSource(parsedEntity, reader, stringArray != null);
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
    }

    private InputSource resolveExternalEntity(String string, String string2) {
        try {
            return this.fResolver.resolveEntity(string, string2);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class NeverCloseReader
    extends FilterReader {
        public NeverCloseReader(Reader reader) {
            super(reader);
        }

        public void close() {
            this.in = null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class NeverCloseInputStream
    extends FilterInputStream {
        public NeverCloseInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public void close() {
            this.in = null;
        }
    }
}

