/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.jaxp.impl;

import com.ibm.xml.xlxp2.api.sax.impl.parser.SAX2Parser;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class SAXParserImpl
extends SAXParser {
    public static final String SAX_NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String SAX_NAMESPACES_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String SAX_VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private XMLReader fXMLReader;
    private Parser fParser;

    public SAXParserImpl(SAXParserFactory sAXParserFactory, Hashtable<String, Object> hashtable) throws SAXException, SAXNotSupportedException, SAXNotRecognizedException {
        this(sAXParserFactory, hashtable, true);
    }

    protected SAXParserImpl(SAXParserFactory sAXParserFactory, Hashtable<String, Object> hashtable, boolean bl) throws SAXException, SAXNotSupportedException, SAXNotRecognizedException {
        if (bl) {
            this.initializeXMLReader(sAXParserFactory, hashtable, new SAX2Parser());
        }
    }

    protected void initializeXMLReader(SAXParserFactory sAXParserFactory, Hashtable<String, Object> hashtable, XMLReader xMLReader) throws SAXException, SAXNotSupportedException, SAXNotRecognizedException {
        this.fXMLReader = xMLReader;
        this.fXMLReader.setFeature(SAX_NAMESPACES_FEATURE, sAXParserFactory.isNamespaceAware());
        this.fXMLReader.setFeature(SAX_NAMESPACES_PREFIXES_FEATURE, !sAXParserFactory.isNamespaceAware());
        this.fXMLReader.setFeature(SAX_VALIDATION_FEATURE, sAXParserFactory.isValidating());
        if (hashtable != null) {
            Enumeration<String> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                boolean bl = (Boolean)hashtable.get(string);
                this.fXMLReader.setFeature(string, bl);
            }
        }
    }

    @Override
    public Parser getParser() throws SAXException {
        if (this.fParser == null) {
            this.fParser = new XMLReaderAdapter(this.fXMLReader);
        }
        return this.fParser;
    }

    @Override
    public XMLReader getXMLReader() throws SAXException {
        return this.fXMLReader;
    }

    @Override
    public boolean isNamespaceAware() {
        try {
            return this.fXMLReader.getFeature(SAX_NAMESPACES_FEATURE);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new IllegalStateException(sAXNotRecognizedException.getMessage());
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new IllegalStateException(sAXNotSupportedException.getMessage());
        }
    }

    @Override
    public boolean isValidating() {
        try {
            return this.fXMLReader.getFeature(SAX_VALIDATION_FEATURE);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new IllegalStateException(sAXNotRecognizedException.getMessage());
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new IllegalStateException(sAXNotSupportedException.getMessage());
        }
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fXMLReader.setProperty(string, object);
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fXMLReader.getProperty(string);
    }
}

