/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.adapter.WSConnectionManager;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnection;
import com.ibm.ws.sib.api.jmsra.JmsJcaSession;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionFactoryImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaSessionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;

final class JmsJcaConnectionImpl
implements JmsJcaConnection {
    private final JmsJcaConnectionFactoryImpl _connectionFactory;
    private SICoreConnection _coreConnection;
    private final Set _sessions = new HashSet();
    private final JmsJcaConnectionRequestInfo _requestInfo;
    private boolean firstSessionCached = false;
    private boolean connectionClosed = false;
    private Thread _connectionCreateThread = null;
    private Object _connectionCreateUOW = null;
    private static Boolean inWAS = null;
    private static TraceComponent TRACE = SibTr.register(JmsJcaConnectionImpl.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final String FFDC_PROBE_1 = "1";
    private static final String CLASS_NAME = JmsJcaConnectionImpl.class.getName();

    JmsJcaConnectionImpl(JmsJcaConnectionFactoryImpl connectionFactory, SICoreConnection coreConnection, JmsJcaSessionImpl firstSession, JmsJcaConnectionRequestInfo cri) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionImpl", (Object)new Object[]{connectionFactory, coreConnection, firstSession, cri});
        }
        this._connectionFactory = connectionFactory;
        this._coreConnection = coreConnection;
        if (JmsJcaConnectionImpl.isRunningInWAS()) {
            this._connectionCreateThread = Thread.currentThread();
            this._connectionCreateUOW = JmsJcaConnectionImpl.getCurrentUOWCoord();
            this._sessions.add(firstSession);
            firstSession.setParentConnection(this);
            this.firstSessionCached = true;
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)"first session cached.");
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)"Not in WAS, so not caching the first session.");
            }
            this.firstSessionCached = true;
            this._sessions.add(firstSession);
        }
        this._requestInfo = cri;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionImpl");
        }
    }

    JmsJcaConnectionImpl(JmsJcaConnectionFactoryImpl connectionFactory, SICoreConnection coreConnection, JmsJcaConnectionRequestInfo cri) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionImpl", (Object)new Object[]{connectionFactory, coreConnection, cri});
        }
        this._connectionFactory = connectionFactory;
        this._coreConnection = coreConnection;
        this._requestInfo = cri;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionImpl");
        }
    }

    @Override
    public synchronized JmsJcaSession createSession(boolean transacted) throws ResourceException, IllegalStateException, SIException, SIErrorException {
        JmsJcaSessionImpl session;
        Object object;
        Iterator iterator;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createSession", (Object)new Object[]{transacted});
        }
        if (this.connectionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1085", new Object[]{"createSession"}, null));
        }
        if (!(!this.firstSessionCached || Thread.currentThread().equals(this._connectionCreateThread) && JmsJcaConnectionImpl.isCurrentUOW(this._connectionCreateUOW) && JmsJcaConnectionImpl.isRunningInWAS())) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)"clearing first session");
            }
            this.firstSessionCached = false;
            this._connectionCreateUOW = null;
            this._connectionCreateThread = null;
            if (this._sessions.size() == 1) {
                iterator = this._sessions.iterator();
                object = iterator.next();
                if (!(object instanceof JmsJcaSessionImpl)) {
                    throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1083", new Object[]{"createSession", object.getClass().getName(), this.getClass().getName()}, null));
                }
                session = (JmsJcaSessionImpl)object;
                session.close(false);
                this._sessions.clear();
            } else {
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1082", new Object[]{"createSession", "" + this._sessions.size()}, null));
            }
        }
        if (this.firstSessionCached) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)"Using the first session that was created as part of the createConnection process");
            }
            if (this._sessions.size() != 1) {
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1082", new Object[]{"createSession", "" + this._sessions.size()}, null));
            }
            iterator = this._sessions.iterator();
            object = iterator.next();
            if (!(object instanceof JmsJcaSessionImpl)) {
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1083", new Object[]{"createSession", object.getClass().getName(), this.getClass().getName()}, null));
            }
            this.firstSessionCached = false;
            this._connectionCreateUOW = null;
            this._connectionCreateThread = null;
            session = (JmsJcaSessionImpl)object;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"We have already used the first session... creating a new one");
            }
            if (this._connectionFactory.isManaged()) {
                boolean containerAuth = false;
                String containerAlias = null;
                try {
                    Object object2;
                    ConnectionManager cm = this._connectionFactory.getConnectionManager();
                    if (JmsJcaConnectionImpl.isRunningInWAS() && cm instanceof WSConnectionManager) {
                        ResourceRefInfo info = ((WSConnectionManager)cm).getResourceRefInfo();
                        containerAuth = info.getAuth() == 0;
                        for (ResourceRefInfo.Property loginConfigProp : info.getLoginPropertyList()) {
                            if (!"DefaultPrincipalMapping".equals(loginConfigProp.getName())) continue;
                            containerAlias = loginConfigProp.getValue();
                        }
                    }
                    if (!((object2 = cm.allocateConnection((ManagedConnectionFactory)this._connectionFactory.getManagedConnectionFactory(), (ConnectionRequestInfo)this._requestInfo)) instanceof JmsJcaSessionImpl)) {
                        throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1084", new Object[]{"createSession", object2.getClass().getName(), JmsJcaSessionImpl.class.getName()}, null));
                    }
                    session = (JmsJcaSessionImpl)object2;
                }
                catch (ResourceException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".createSession"), (String)FFDC_PROBE_1, (Object)this);
                    Throwable cause = exception.getCause();
                    if (JmsJcaConnectionImpl.isRunningInWAS()) {
                        if (cause instanceof SIAuthenticationException) {
                            SIAuthenticationException authentEx = null;
                            authentEx = containerAuth ? (containerAlias != null && !containerAlias.isEmpty() ? new SIAuthenticationException(NLS.getFormattedMessage("CONTAINER_AUTHENTICATION_EXCEPTION_1073", new Object[]{containerAlias}, null)) : new SIAuthenticationException(NLS.getString("AUTHENTICATION_EXCEPTION_1077"))) : new SIAuthenticationException(NLS.getFormattedMessage("APPLICATION_AUTHENTICATION_EXCEPTION_1074", new Object[]{this._connectionFactory.getUserName()}, null));
                            throw authentEx;
                        }
                        if (cause instanceof SINotAuthorizedException) {
                            if (containerAuth) {
                                if (containerAlias == null) {
                                    throw new SINotAuthorizedException(NLS.getString("CONTAINER_AUTHORIZATION_EXCEPTION_1075"));
                                }
                            } else {
                                String userName = this._connectionFactory.getUserName();
                                if (userName == null || "".equals(userName)) {
                                    throw new SINotAuthorizedException(NLS.getString("CONTAINER_AUTHORIZATION_EXCEPTION_1076"));
                                }
                            }
                        }
                    }
                    if (cause instanceof SIException) {
                        throw (SIException)cause;
                    }
                    if (cause instanceof SIErrorException) {
                        throw (SIErrorException)cause;
                    }
                    throw exception;
                }
                SICoreConnection managedConnectionsCoreConnection = session.getManagedConnection().getCoreConnection();
                if (!managedConnectionsCoreConnection.isEquivalentTo(this._coreConnection)) {
                    block34: {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"New ManagedConnections coreConnection is not equivalent to our _coreConnection");
                        }
                        try {
                            this._coreConnection.close(false);
                        }
                        catch (Exception e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !TRACE.isDebugEnabled()) break block34;
                            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Exception caught while closing _coreConnection that we are replacing: " + e));
                        }
                    }
                    this._coreConnection = managedConnectionsCoreConnection.cloneConnection();
                    this._requestInfo.setSICoreConnection(this._coreConnection);
                }
            } else {
                session = new JmsJcaSessionImpl();
            }
            session.setParentConnection(this);
            this._sessions.add(session);
        }
        session.setTransacted(transacted);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createSession", (Object)session);
        }
        return session;
    }

    @Override
    public SICoreConnection getSICoreConnection() throws IllegalStateException {
        if (this.connectionClosed) {
            throw new IllegalStateException(NLS.getFormattedMessage("ILLEGAL_STATE_CWSJR1086", new Object[]{"getSICoreConnection"}, null));
        }
        return this._coreConnection;
    }

    @Override
    public synchronized void close() throws SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException, SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"close");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)("We have " + this._sessions.size() + " left open - closing them"));
        }
        Iterator iterator = this._sessions.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof JmsJcaSessionImpl) {
                JmsJcaSessionImpl session = (JmsJcaSessionImpl)object;
                session.close(false);
            }
            iterator.remove();
        }
        if (this._coreConnection != null) {
            this._coreConnection.close();
        }
        this.connectionClosed = true;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"close");
        }
    }

    void removeSession(JmsJcaSessionImpl session) {
        this._sessions.remove(session);
    }

    ConnectionManager getConnectionManager() {
        return this._connectionFactory.getConnectionManager();
    }

    JmsJcaConnectionFactoryImpl getConnectionFactory() {
        return this._connectionFactory;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.getClass().getName());
        sb.append("@");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" <connectionFactory=");
        sb.append(this._connectionFactory);
        sb.append("> <coreConnection=");
        sb.append(this._coreConnection);
        sb.append("> <firstSessionCached=");
        sb.append(this.firstSessionCached);
        sb.append("> <connectionClosed=");
        sb.append(this.connectionClosed);
        sb.append("> <sessions=");
        sb.append(this._sessions);
        sb.append(">]");
        return sb.toString();
    }

    private static boolean isRunningInWAS() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"isRunningInWAS");
        }
        if (inWAS == null) {
            inWAS = Boolean.TRUE;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"isRunningInWAS", (Object)inWAS);
        }
        return inWAS;
    }

    private static final Object getCurrentUOWCoord() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"getCurrentUOWCoord");
        }
        UOWCoordinator currentUOW = null;
        if (JmsJcaConnectionImpl.isRunningInWAS()) {
            currentUOW = EmbeddableTransactionManagerFactory.getUOWCurrent().getUOWCoord();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"getCurrentUOWCoord", (Object)currentUOW);
        }
        return currentUOW;
    }

    private static final boolean isCurrentUOW(Object uow) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"isCurrentUOW", (Object)uow);
        }
        boolean isSameUOW = false;
        if (JmsJcaConnectionImpl.isRunningInWAS()) {
            Object currentUOW = JmsJcaConnectionImpl.getCurrentUOWCoord();
            isSameUOW = uow == null ? currentUOW == null : uow.equals(currentUOW);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"isCurrentUOW", (Object)isSameUOW);
        }
        return isSameUOW;
    }
}

