/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.PortableInterceptor;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.apache.yoko.orb.OB.Assert;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;

public final class Current_impl
extends LocalObject
implements Current {
    static final Logger logger = Logger.getLogger(Current_impl.class.getName());
    private Map stateKey_ = Collections.synchronizedMap(new WeakHashMap());
    private ORB orb_;
    private int maxSlots_;

    private SlotDataHolder establishTSD(boolean partial) {
        Thread t = Thread.currentThread();
        SlotDataHolder holder_ = (SlotDataHolder)this.stateKey_.get(t);
        if (holder_ == null) {
            holder_ = new SlotDataHolder();
            this.stateKey_.put(t, holder_);
            Any[] slots = null;
            if (!partial) {
                slots = new Any[this.maxSlots_];
            }
            holder_.head = new SlotData(slots);
            holder_.head.next = null;
        }
        return holder_;
    }

    public Any get_slot(int id) throws InvalidSlot {
        if (id >= this.maxSlots_) {
            throw new InvalidSlot();
        }
        logger.fine("getting slot " + id);
        SlotDataHolder holder = this.establishTSD(false);
        Any slot = holder.head.slots[id];
        Object result = slot == null ? this.orb_.create_any() : new org.apache.yoko.orb.CORBA.Any(slot);
        return result;
    }

    public void set_slot(int id, Any any) throws InvalidSlot {
        if (id >= this.maxSlots_) {
            throw new InvalidSlot();
        }
        logger.fine("setting slot " + id);
        SlotDataHolder holder = this.establishTSD(false);
        holder.head.slots[id] = new org.apache.yoko.orb.CORBA.Any(any);
    }

    public Current_impl(ORB orb) {
        this.orb_ = orb;
    }

    Any[] _OB_currentSlotData() {
        SlotDataHolder holder = this.establishTSD(false);
        Any[] data = new Any[holder.head.slots.length];
        for (int i = 0; i < holder.head.slots.length; ++i) {
            Any slot = holder.head.slots[i];
            if (slot == null) continue;
            data[i] = new org.apache.yoko.orb.CORBA.Any(slot);
        }
        return data;
    }

    void _OB_pushSlotData(Any[] slots) {
        logger.fine("pushing slot data");
        SlotDataHolder holder = this.establishTSD(false);
        SlotData newSlots = new SlotData(slots);
        newSlots.next = holder.head;
        holder.head = newSlots;
    }

    void _OB_popSlotData() {
        logger.fine("popping slot data");
        SlotDataHolder holder = this.establishTSD(false);
        holder.head = holder.head.next;
        Assert.ensure(holder.head != null);
    }

    Any[] _OB_newSlotTable() {
        return new Any[this.maxSlots_];
    }

    public void _OB_setMaxSlots(int max) {
        this.maxSlots_ = max;
    }

    private class SlotDataHolder {
        SlotData head;

        private SlotDataHolder() {
        }
    }

    private class SlotData {
        Any[] slots;
        SlotData next;

        SlotData(Any[] s) {
            this.slots = s;
        }

        SlotData() {
            this.slots = new Any[0];
        }
    }
}

