/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.Connection;
import org.apache.yoko.orb.OB.GIOPConnection;
import org.apache.yoko.orb.OB.GIOPConnectionThreaded;
import org.apache.yoko.orb.OB.GIOPServerStarter;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.Transport;
import org.apache.yoko.orb.logging.VerboseLogging;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;

final class GIOPServerStarterThreaded
extends GIOPServerStarter {
    GIOPServerStarterThreaded(ORBInstance orbInstance, Acceptor acceptor, OAInterface oaInterface) {
        super(orbInstance, acceptor, oaInterface);
        logger.fine("GIOPServer thread started " + this + " using acceptor " + acceptor);
        try {
            this.orbInstance_.getServerPhaser().register();
            ExecutorService executor = this.orbInstance_.getServerExecutor();
            executor.submit(new Starter());
        }
        catch (OutOfMemoryError ex) {
            this.acceptor_.close();
            this.serverState = GIOPServerStarter.ServerState.CLOSED;
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
        }
    }

    @Override
    public synchronized void setState(GIOPServerStarter.ServerState state) {
        if (this.serverState == state) {
            return;
        }
        logger.fine("Setting server state to " + (Object)((Object)state));
        if (this.serverState.cannotTransitionTo(state)) {
            return;
        }
        switch (state) {
            case ACTIVE: {
                for (int i = 0; i < this.connections_.size(); ++i) {
                    GIOPConnection w = (GIOPConnection)this.connections_.elementAt(i);
                    w.setState(Connection.State.ACTIVE);
                }
                break;
            }
            case HOLDING: {
                for (int i = 0; i < this.connections_.size(); ++i) {
                    GIOPConnection w = (GIOPConnection)this.connections_.elementAt(i);
                    w.setState(Connection.State.HOLDING);
                }
                break;
            }
            case CLOSED: {
                for (int i = 0; i < this.connections_.size(); ++i) {
                    GIOPConnection w = (GIOPConnection)this.connections_.elementAt(i);
                    w.setState(Connection.State.CLOSING);
                }
                this.connections_.removeAllElements();
                try {
                    Transport tr = this.acceptor_.connect_self();
                    tr.close();
                    break;
                }
                catch (SystemException ignored) {
                    VerboseLogging.CONN_IN_LOG.log(Level.INFO, "Call to unblock accept() failed", ignored);
                }
            }
        }
        this.serverState = state;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void starterRun() {
        while (true) {
            Transport transport = null;
            try {
                transport = this.acceptor_.accept(true);
                Assert.ensure(transport != null);
            }
            catch (NO_PERMISSION nO_PERMISSION) {
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            GIOPServerStarterThreaded gIOPServerStarterThreaded = this;
            synchronized (gIOPServerStarterThreaded) {
                this.reapWorkers();
                while (this.serverState == GIOPServerStarter.ServerState.HOLDING) {
                    try {
                        logger.fine("Waiting on an inbound connection because the state is holding.  acceptor=" + this.acceptor_);
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                logger.fine("Processing an inbound connection with state=" + (Object)((Object)this.serverState));
                if (transport != null) {
                    try {
                        GIOPConnectionThreaded connection;
                        if (this.serverState == GIOPServerStarter.ServerState.ACTIVE) {
                            connection = new GIOPConnectionThreaded(this.orbInstance_, transport, this.oaInterface_);
                            this.connections_.addElement(connection);
                            connection.setState(Connection.State.ACTIVE);
                        } else {
                            logger.fine("Processing an inbound connection because state is closed");
                            Assert.ensure(this.serverState == GIOPServerStarter.ServerState.CLOSED);
                            logger.fine("Processing an inbound connection because state is closed");
                            connection = new GIOPConnectionThreaded(this.orbInstance_, transport, this.oaInterface_);
                            logger.fine("Created connection " + connection);
                            connection.setState(Connection.State.CLOSING);
                            logger.fine("set connection state to closing");
                        }
                    }
                    catch (SystemException ex) {
                        String msg = "can't accept connection\n" + ex.getMessage();
                        logger.log(Level.WARNING, msg, ex);
                    }
                }
                if (this.serverState == GIOPServerStarter.ServerState.CLOSED) {
                    logger.fine("Shutting down server thread");
                    break;
                }
            }
        }
    }

    protected final class Starter
    implements Runnable {
        protected Starter() {
        }

        @Override
        public void run() {
            try {
                GIOPServerStarterThreaded.this.starterRun();
            }
            catch (RuntimeException ex) {
                throw Assert.fail(ex);
            }
            GIOPServerStarter.logger.fine("Shutting down ORB server listener thread");
            GIOPServerStarterThreaded.this.logCloseAcceptor();
            GIOPServerStarterThreaded.this.acceptor_.shutdown();
            block4: while (true) {
                try {
                    while (true) {
                        Transport t;
                        if ((t = GIOPServerStarterThreaded.this.acceptor_.accept(false)) == null) {
                            GIOPServerStarter.logger.fine("Null transport received from a connect");
                            break block4;
                        }
                        GIOPConnectionThreaded connection = new GIOPConnectionThreaded(GIOPServerStarterThreaded.this.orbInstance_, t, GIOPServerStarterThreaded.this.oaInterface_);
                        connection.setState(Connection.State.CLOSING);
                    }
                }
                catch (SystemException systemException) {
                    continue;
                }
                break;
            }
            GIOPServerStarterThreaded.this.acceptor_.close();
            GIOPServerStarterThreaded.this.orbInstance_.getServerPhaser().arriveAndDeregister();
        }
    }
}

